/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.packaging;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.enterprise.internal.systemdefinition.client.packaging.PackagingClientExtension;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheFactory;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingFactory;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.Mcstype;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingDataset;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingDetail;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingExtension;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingFmidItem;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingItem;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingVersion;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.SubMonitor;

public class PackagingConfiguration {
    private final IDebugger dbg;
    private final String simpleName;
    private final IProjectArea projectArea;
    private final ITeamRepository repository;
    private final SubMonitor monitor;
    private final List<IZosLanguageDefinition> languages;
    private final IPackagingVersion packagingVersion;
    private final Map<String, String> datasetNameToKeyMap = new HashMap<String, String>();
    private final Map<String, IPackagingDataset> packagingDatasetMap = new HashMap<String, IPackagingDataset>();
    private final Map<String, IPackagingFmidItem> packagingFmidItemMap = new HashMap<String, IPackagingFmidItem>();
    private final Map<String, IPackagingItem> packagingLanguageMap = new HashMap<String, IPackagingItem>();
    private final Map<String, Map<String, Integer>> packagingRelfileMap = new HashMap<String, Map<String, Integer>>();
    private final Map<String, Map<String, IPackagingDataset>> packagingRelfileItemMap = new HashMap<String, Map<String, IPackagingDataset>>();
    private final Map<String, Map<String, Set<Mcstype>>> packagingRelfileTypeMap = new HashMap<String, Map<String, Set<Mcstype>>>();

    public PackagingConfiguration(ITeamRepository repository, IProjectArea projectArea, IVersionDefinition version, List<IZosLanguageDefinition> languages, SubMonitor monitor, IDebugger dbg) {
        this.repository = repository;
        this.projectArea = projectArea;
        this.packagingVersion = (IPackagingVersion)PackagingFactory.createVersionDefinition((IVersionDefinition)version, (IDebugger)dbg);
        this.languages = languages;
        this.monitor = monitor;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        if (dbg.isFlow()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public final void createPackagingDatasetMap() throws TeamRepositoryException {
        if (this.dbg.isFlow()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
        for (IResourceDefinition dataset : ItemCacheFactory.getDataset(this.repository, (IProjectAreaHandle)this.projectArea).getItemList()) {
            if (dataset.getUsageType() != 0 && dataset.getUsageType() != 1) continue;
            IPackagingDataset packagingDataset = (IPackagingDataset)PackagingFactory.createDatasetDefinition((IDataSetDefinition)((IDataSetDefinition)dataset), (IDebugger)this.dbg);
            this.datasetNameToKeyMap.put(packagingDataset.getName().toUpperCase(), packagingDataset.getUuid());
            this.packagingDatasetMap.put(packagingDataset.getUuid(), packagingDataset);
        }
        if (this.dbg.isFlow()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
    }

    public final void createPackagingFmidItemMap() throws TeamRepositoryException {
        if (this.dbg.isFlow()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
        for (IPackagingFmidItem fmid : this.packagingVersion.getFmidItems()) {
            if (fmid.hasJclinDistlib()) {
                if (this.packagingDatasetMap.containsKey(fmid.getJclinDistlib().getUuid())) {
                    fmid.setJclinDistlib((IDataSetDefinitionHandle)this.packagingDatasetMap.get(fmid.getJclinDistlib().getUuid()));
                } else {
                    fmid.setJclinDistlib((IDataSetDefinitionHandle)PackagingFactory.createDatasetDefinition((IDataSetDefinition)((IDataSetDefinition)fmid.getJclinDistlib())));
                    this.packagingDatasetMap.put(fmid.getJclinDistlib().getUuid(), (IPackagingDataset)fmid.getJclinDistlib());
                }
            }
            if (fmid.hasJclinLocation()) {
                if (this.packagingDatasetMap.containsKey(fmid.getJclinLocation().getUuid())) {
                    fmid.setJclinLocation((IDataSetDefinitionHandle)this.packagingDatasetMap.get(fmid.getJclinLocation().getUuid()));
                } else {
                    fmid.setJclinLocation((IDataSetDefinitionHandle)PackagingFactory.createDatasetDefinition((IDataSetDefinition)((IDataSetDefinition)fmid.getJclinLocation())));
                    this.packagingDatasetMap.put(fmid.getJclinLocation().getUuid(), (IPackagingDataset)fmid.getJclinLocation());
                }
            }
            if (fmid.hasMcscpyrtLocation()) {
                if (this.packagingDatasetMap.containsKey(fmid.getMcscpyrtLocation().getUuid())) {
                    fmid.setMcscpyrtLocation((IDataSetDefinitionHandle)this.packagingDatasetMap.get(fmid.getMcscpyrtLocation().getUuid()));
                } else {
                    fmid.setMcscpyrtLocation((IDataSetDefinitionHandle)PackagingFactory.createDatasetDefinition((IDataSetDefinition)((IDataSetDefinition)fmid.getMcscpyrtLocation())));
                    this.packagingDatasetMap.put(fmid.getMcscpyrtLocation().getUuid(), (IPackagingDataset)fmid.getMcscpyrtLocation());
                }
            }
            int i = 0;
            while (i < fmid.getRelfiles().size()) {
                IDataSetDefinition relfile = (IDataSetDefinition)fmid.getRelfiles().get(i);
                if (relfile != null) {
                    if (this.packagingDatasetMap.containsKey((relfile = PackagingFactory.createDatasetDefinition((IDataSetDefinition)relfile)).getUuid())) {
                        relfile = (IDataSetDefinition)this.packagingDatasetMap.get(relfile.getUuid());
                    } else {
                        relfile = PackagingFactory.createDatasetDefinition((IDataSetDefinition)relfile);
                        this.packagingDatasetMap.put(relfile.getUuid(), (IPackagingDataset)relfile);
                    }
                }
                fmid.getRelfiles().set(i, relfile);
                ++i;
            }
            this.packagingFmidItemMap.put(fmid.getFunction().getUuid(), fmid);
            this.packagingRelfileMap.put(fmid.getFunction().getUuid(), fmid.getRelfileMap());
            this.packagingRelfileItemMap.put(fmid.getFunction().getUuid(), fmid.getRelfileItemMap());
            this.packagingRelfileTypeMap.put(fmid.getFunction().getUuid(), fmid.getRelfileTypeMap());
        }
        if (this.dbg.isFlow()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
    }

    public final void createPackagingLanguageMap() throws TeamRepositoryException {
        if (this.dbg.isFlow()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
        for (IZosLanguageDefinition language : this.languages) {
            if (!language.hasSmpePackagingItem()) continue;
            IPackagingItem packagingItem = (IPackagingItem)PackagingFactory.createLanguagePackagingItemDefinition((IPackagingItemDefinition)((IPackagingItemDefinition)language.getSmpePackaging()), (IDebugger)this.dbg);
            if (!packagingItem.hasFmid()) {
                packagingItem.setFmid(this.packagingVersion.getDefaultFunction());
            }
            PackagingClientExtension packagingClientExtension = new PackagingClientExtension(this.dbg);
            packagingClientExtension.setTask(null);
            packagingClientExtension.setRepository(this.repository);
            packagingItem.setExtension((IPackagingExtension)packagingClientExtension);
            packagingItem.setLanguage((ILanguageDefinition)language);
            for (IPackagingDetail packagingDetail : packagingItem.getDetails()) {
                if (packagingDetail.hasDistlib()) {
                    if (this.packagingDatasetMap.containsKey(packagingDetail.getDistlib().getUuid())) {
                        packagingDetail.setDistlib((IDataSetDefinitionHandle)this.packagingDatasetMap.get(packagingDetail.getDistlib().getUuid()));
                    } else {
                        packagingDetail.setDistlib((IDataSetDefinitionHandle)PackagingFactory.createDatasetDefinition((IDataSetDefinition)((IDataSetDefinition)packagingDetail.getDistlib())));
                        this.packagingDatasetMap.put(packagingDetail.getDistlib().getUuid(), (IPackagingDataset)packagingDetail.getDistlib());
                    }
                }
                if (packagingDetail.hasLocation()) {
                    if (this.packagingDatasetMap.containsKey(packagingDetail.getLocation().getUuid())) {
                        packagingDetail.setLocation((IDataSetDefinitionHandle)this.packagingDatasetMap.get(packagingDetail.getLocation().getUuid()));
                    } else {
                        packagingDetail.setLocation((IDataSetDefinitionHandle)PackagingFactory.createDatasetDefinition((IDataSetDefinition)((IDataSetDefinition)packagingDetail.getLocation())));
                        this.packagingDatasetMap.put(packagingDetail.getLocation().getUuid(), (IPackagingDataset)packagingDetail.getLocation());
                    }
                }
                if (!packagingDetail.hasSyslib()) continue;
                if (this.packagingDatasetMap.containsKey(packagingDetail.getSyslib().getUuid())) {
                    packagingDetail.setSyslib((IDataSetDefinitionHandle)this.packagingDatasetMap.get(packagingDetail.getSyslib().getUuid()));
                    continue;
                }
                packagingDetail.setSyslib((IDataSetDefinitionHandle)PackagingFactory.createDatasetDefinition((IDataSetDefinition)((IDataSetDefinition)packagingDetail.getSyslib())));
                this.packagingDatasetMap.put(packagingDetail.getSyslib().getUuid(), (IPackagingDataset)packagingDetail.getSyslib());
            }
            if (language.getDefaultPatterns().size() > 0) {
                for (IStringHelper pattern : language.getDefaultPatterns()) {
                    this.packagingLanguageMap.put(pattern.getValue().toUpperCase(), packagingItem);
                }
            }
            this.packagingLanguageMap.put(this.getUuid((IItemHandle)language), packagingItem);
        }
        if (this.dbg.isFlow()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
    }

    public final Map<String, String> getDatasetNameToKeyMap() {
        return this.datasetNameToKeyMap;
    }

    public final Map<String, IPackagingDataset> getPackagingDatasetMap() {
        return this.packagingDatasetMap;
    }

    public final Map<String, IPackagingFmidItem> getPackagingFmidItemMap() {
        return this.packagingFmidItemMap;
    }

    public final List<String> getPackagingFmidItemKeys() {
        return new ArrayList<String>(this.packagingFmidItemMap.keySet());
    }

    public final List<String> getPackagingFmidItemSortedKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry entry : this.getPackagingFmidItemSortedSet()) {
            result.add((String)entry.getKey());
        }
        return result;
    }

    public final SortedSet<Map.Entry<String, IPackagingFmidItem>> getPackagingFmidItemSortedSet() {
        TreeSet<Map.Entry<String, IPackagingFmidItem>> result = new TreeSet<Map.Entry<String, IPackagingFmidItem>>(new Comparator<Map.Entry<String, IPackagingFmidItem>>(){

            @Override
            public int compare(Map.Entry<String, IPackagingFmidItem> e1, Map.Entry<String, IPackagingFmidItem> e2) {
                String e1Key = e1.getValue().getName();
                String e2Key = e2.getValue().getName();
                return e1Key.compareTo(e2Key);
            }
        });
        result.addAll(this.packagingFmidItemMap.entrySet());
        return result;
    }

    public final Map<String, IPackagingItem> getPackagingLanguageMap() {
        return this.packagingLanguageMap;
    }

    public final Map<String, Map<String, IPackagingDataset>> getPackagingRelfileItemMap() {
        return this.packagingRelfileItemMap;
    }

    public final Map<String, Map<String, Integer>> getPackagingRelfileMap() {
        return this.packagingRelfileMap;
    }

    public final Map<String, Map<String, Set<Mcstype>>> getPackagingRelfileTypeMap() {
        return this.packagingRelfileTypeMap;
    }

    public final IPackagingVersion getPackagingVersion() {
        return this.packagingVersion;
    }

    private final String getUuid(IItemHandle itemHandle) {
        return itemHandle.getItemId().getUuidValue();
    }
}

