/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.packaging;

import com.ibm.team.build.extensions.client.util.SCMComponent;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class PackagingComponent {
    private final IDebugger dbg;
    private final String simpleName;
    private final ITeamRepository repository;
    private final IWorkspaceConnection wsConnection;
    private final SubMonitor monitor;
    private final List<String> exclude;
    private final List<String> include;
    private final Map<String, List<String>> excludeProject;
    private final Map<String, List<String>> includeProject;
    private final List<IComponent> componentList = new ArrayList<IComponent>();
    private final List<IVersionable> fileList = new ArrayList<IVersionable>(32768);
    private final Map<String, IComponent> componentMap = new HashMap<String, IComponent>();
    private final Map<String, IVersionable> folderMap = new HashMap<String, IVersionable>(2048);
    private final Map<String, Map<String, IVersionable>> componentFolderMap = new HashMap<String, Map<String, IVersionable>>();

    public PackagingComponent(ITeamRepository repository, IWorkspaceConnection wsConnection, List<String> exclude, List<String> include, Map<String, List<String>> excludeProject, Map<String, List<String>> includeProject, SubMonitor monitor, IDebugger dbg) {
        this.repository = repository;
        this.wsConnection = wsConnection;
        this.exclude = exclude;
        this.include = include;
        this.excludeProject = excludeProject;
        this.includeProject = includeProject;
        this.monitor = monitor;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        if (dbg.isFlow()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public void createComponentList() throws TeamRepositoryException {
        ArrayList<IComponent> tempComponentList;
        String method = new MethodName(){}.getName();
        if (this.dbg.isFlow()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method});
        }
        ArrayList comHandleList = new ArrayList(SCMComponent.getComponentByWorkspace((ITeamRepository)this.repository, (IWorkspaceConnection)this.wsConnection, (IDebugger)this.dbg));
        ArrayList componentList = new ArrayList(SCMComponent.getComponentList((ITeamRepository)this.repository, comHandleList, (IProgressMonitor)this.monitor.newChild(1), (IDebugger)this.dbg));
        if (this.monitor.isCanceled()) {
            return;
        }
        if (Verification.isNonEmpty(this.exclude)) {
            tempComponentList = new ArrayList<IComponent>();
            for (IComponent component : componentList) {
                if (this.exclude.contains(component.getName()) && !this.excludeProjectContains(component)) continue;
                tempComponentList.add(component);
            }
            componentList.clear();
            componentList.addAll(tempComponentList);
        }
        if (Verification.isNonEmpty(this.include)) {
            tempComponentList = new ArrayList();
            for (IComponent component : componentList) {
                if (!this.include.contains(component.getName())) continue;
                tempComponentList.add(component);
            }
            componentList.clear();
            componentList.addAll(tempComponentList);
        }
        this.componentList.clear();
        this.componentList.addAll(componentList);
        for (IComponent component : componentList) {
            this.componentMap.put(this.getUuid((IItemHandle)component), component);
        }
        if (this.dbg.isDebug()) {
            Debug.debug((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method, "component", LogString.valueOf(componentList)});
        }
        if (this.dbg.isItems()) {
            for (IComponent component : componentList) {
                Debug.items((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method, "component", component.getName()});
            }
        }
        if (this.dbg.isFlow()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method});
        }
    }

    public void createComponentPartialList(List<IComponent> componentList) throws TeamRepositoryException {
        String method = new MethodName(){}.getName();
        if (this.dbg.isFlow()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method});
        }
        this.componentList.clear();
        this.componentList.addAll(componentList);
        for (IComponent component : componentList) {
            this.componentMap.put(this.getUuid((IItemHandle)component), component);
        }
        if (this.dbg.isDebug()) {
            Debug.debug((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method, "component", LogString.valueOf(componentList)});
        }
        if (this.dbg.isItems()) {
            for (IComponent component : componentList) {
                Debug.items((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method, "component", component.getName()});
            }
        }
        if (this.dbg.isFlow()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method});
        }
    }

    public void createVersionableList(String task, int work) throws TeamRepositoryException {
        String method = new MethodName(){}.getName();
        if (this.dbg.isFlow()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method});
        }
        HashMap<String, List> versionableMap = new HashMap<String, List>(this.componentList.size());
        int componentWork = work / this.componentList.size();
        for (IComponent component : this.componentList) {
            this.monitor.subTask(NLS.bind((String)task, (Object)component.getName(), (Object[])new Object[0]));
            if (!this.excludeProjectContains(component) && !this.includeProjectContains(component)) {
                versionableMap.put(this.getUuid((IItemHandle)component), SCMComponent.getComponentContent((ITeamRepository)this.repository, (IWorkspaceConnection)this.wsConnection, (IComponentHandle)component, (IProgressMonitor)this.monitor.newChild(componentWork), (IDebugger)this.dbg));
            } else {
                versionableMap.put(this.getUuid((IItemHandle)component), SCMComponent.getComponentContent((ITeamRepository)this.repository, (IWorkspaceConnection)this.wsConnection, (IComponentHandle)component, this.excludeProject() ? this.excludeProject.get(component.getName()) : null, this.includeProject() ? this.includeProject.get(component.getName()) : null, (IProgressMonitor)this.monitor.newChild(componentWork), (IDebugger)this.dbg));
            }
            if (!this.monitor.isCanceled()) continue;
            return;
        }
        for (String key : versionableMap.keySet()) {
            this.componentFolderMap.put(key, new HashMap());
            for (IVersionable versionable : (List)versionableMap.get(key)) {
                if (versionable instanceof IFileItem) {
                    this.fileList.add(versionable);
                    continue;
                }
                this.folderMap.put(this.getUuid((IItemHandle)versionable), versionable);
                this.componentFolderMap.get(key).put(this.getUuid((IItemHandle)versionable), versionable);
            }
        }
        if (this.dbg.isDebug()) {
            Debug.debug((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method, "folder", LogString.valueOf(this.folderMap)});
        }
        if (this.dbg.isItems()) {
            for (IVersionable versionable : this.folderMap.values()) {
                Debug.items((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method, "folder", versionable.getName()});
            }
        }
        if (this.dbg.isDebug()) {
            Debug.debug((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method, "file", LogString.valueOf(this.fileList)});
        }
        if (this.dbg.isItems()) {
            for (IVersionable versionable : this.fileList) {
                Debug.items((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method, "file", versionable.getName()});
            }
        }
        if (this.dbg.isFlow()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method});
        }
    }

    public void createVersionablePartialList(Map<String, IVersionable> folderMap, List<IVersionable> fileList) throws TeamRepositoryException {
        String method = new MethodName(){}.getName();
        if (this.dbg.isFlow()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method});
        }
        this.folderMap.clear();
        this.folderMap.putAll(folderMap);
        this.fileList.clear();
        this.fileList.addAll(fileList);
        if (this.dbg.isDebug()) {
            Debug.debug((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method, "folder", LogString.valueOf(folderMap)});
        }
        if (this.dbg.isItems()) {
            for (IVersionable versionable : folderMap.values()) {
                Debug.items((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method, "folder", versionable.getName()});
            }
        }
        if (this.dbg.isDebug()) {
            Debug.debug((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method, "file", LogString.valueOf(fileList)});
        }
        if (this.dbg.isItems()) {
            for (IVersionable versionable : fileList) {
                Debug.items((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method, "file", versionable.getName()});
            }
        }
        if (this.dbg.isFlow()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, method});
        }
    }

    private final boolean excludeProject() {
        return Verification.isNonEmpty(this.excludeProject);
    }

    private final boolean excludeProjectContains(IComponent component) {
        return Verification.isNonEmpty(this.excludeProject) && this.excludeProject.containsKey(component.getName());
    }

    private final boolean includeProject() {
        return Verification.isNonEmpty(this.includeProject);
    }

    private final boolean includeProjectContains(IComponent component) {
        return Verification.isNonEmpty(this.includeProject) && this.includeProject.containsKey(component.getName());
    }

    public final Map<String, Map<String, IVersionable>> getComponentFolderMap() {
        return this.componentFolderMap;
    }

    public final List<IComponent> getComponentList() {
        return this.componentList;
    }

    public final Map<String, IComponent> getComponentMap() {
        return this.componentMap;
    }

    public final List<IVersionable> getFileList() {
        return this.fileList;
    }

    public final Map<String, IVersionable> getFolderMap() {
        return this.folderMap;
    }

    private final String getUuid(IItemHandle itemHandle) {
        return itemHandle.getItemId().getUuidValue();
    }
}

