/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.packaging;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.extensions.client.util.EclipseWorkspace;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.StringParser;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.internal.systemdefinition.client.SystemDefinition;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterToken;
import com.ibm.team.enterprise.internal.systemdefinition.client.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.packaging.PackagingTemplateFactory;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import com.ibm.team.enterprise.systemdefinition.common.model.IConcatenation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingDataset;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingFmidItem;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingItem;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingVersion;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackgingBinderModule;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackgingSysoutClass;
import com.ibm.team.enterprise.systemdefinition.common.packaging.PackagingBinderHashMap;
import com.ibm.team.enterprise.systemdefinition.common.packaging.PackagingBinderOptions;
import com.ibm.team.enterprise.systemdefinition.common.packaging.PackagingItemTools;
import com.ibm.team.enterprise.systemdefinition.common.util.DatasetUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IVersionable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class PackagingArtifacts {
    private final IDebugger dbg;
    private final String simpleName;
    private final IBuildDefinition buildDefinition;
    private final IPackagingVersion version;
    private final ITeamRepository repository;
    private final SubMonitor monitor;
    private final IPackgingSysoutClass.SysoutClass sysoutClass;
    private final boolean sortContent;
    private final String jclinFolder;
    private final String wsPath;
    private final List<IPackagingItem> packagingItemList;
    private final List<String> packagingFmidItemKeys;
    private final List<IVersionable> fileList;
    private final Map<String, IVersionable> folderMap;
    private final Map<String, IPackagingDataset> packagingDatasetMap;
    private final Map<String, IPackagingFmidItem> packagingFmidItemMap;
    private final Map<String, IDataSetDefinition> translatorDatasetMap = new HashMap<String, IDataSetDefinition>();
    private final Map<String, IZosTranslator> translatorMap = new HashMap<String, IZosTranslator>();
    private final PackagingBinderHashMap<PackagingBinderOptions, IPackagingItem> binderOptionMap = new PackagingBinderHashMap();
    private int stepCounter;

    public PackagingArtifacts(ITeamRepository repository, IPackagingVersion version, IBuildDefinition buildDefinition, String jclinFolder, IPackgingSysoutClass.SysoutClass sysoutClass, boolean sortContent, List<IPackagingItem> packagingItemList, List<String> packagingFmidItemKeys, List<IVersionable> fileList, Map<String, IVersionable> folderMap, Map<String, IPackagingDataset> packagingDatasetMap, Map<String, IPackagingFmidItem> packagingFmidItemMap, SubMonitor monitor, IDebugger dbg) {
        this.repository = repository;
        this.version = version;
        this.buildDefinition = buildDefinition;
        this.jclinFolder = jclinFolder;
        this.sysoutClass = sysoutClass;
        this.sortContent = sortContent;
        this.wsPath = EclipseWorkspace.getWorkspacePath();
        this.packagingItemList = packagingItemList;
        this.packagingFmidItemKeys = packagingFmidItemKeys;
        this.fileList = fileList;
        this.folderMap = folderMap;
        this.packagingDatasetMap = packagingDatasetMap;
        this.packagingFmidItemMap = packagingFmidItemMap;
        this.monitor = monitor;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        if (dbg.isFlow()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void createJclin(int work) throws TeamRepositoryException {
        if (this.dbg.isFlow()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
        int jclinWork = work / this.packagingFmidItemKeys.size();
        for (String fmidKey : this.packagingFmidItemKeys) {
            IPackagingFmidItem fmid = this.packagingFmidItemMap.get(fmidKey);
            if (fmid.isIgnore()) continue;
            this.binderOptionMap.clear();
            this.createJclinBinderMap(fmid);
            if (this.binderOptionMap.size() == 0) continue;
            String jclinName = String.format("%s.jclin", fmid.getName());
            StringBuilder sb = new StringBuilder();
            this.stepCounter = 0;
            File jclinFile = new File(this.jclinFolder, jclinName);
            if (!jclinFile.exists()) {
                try {
                    if (!jclinFile.createNewFile()) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_FILE_CREATE, (Object)jclinName, (Object[])new Object[0]));
                    }
                }
                catch (IOException e) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_EXCEPTION_CREATE, (Object)jclinName, (Object[])new Object[0]), (Throwable)e);
                }
            }
            if (!jclinFile.canWrite()) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_FILE_WRITE, (Object)jclinName, (Object[])new Object[0]));
            }
            this.createJclinJobCard(fmid, sb);
            List<PackagingBinderOptions> binderOptionKeyList = this.sortContent ? this.getBinderOptionKeyListSorted() : this.getBinderOptionKeyList();
            for (PackagingBinderOptions packagingBinderOptions : binderOptionKeyList) {
                this.createJclinLinkStep(fmid, packagingBinderOptions, sb);
                this.createJclinLinkData(fmid, packagingBinderOptions, sb);
            }
            try {
                Throwable throwable = null;
                Iterator<PackagingBinderOptions> iterator = null;
                try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(jclinFile), "UTF-8"));){
                    bw.write(sb.toString());
                }
                catch (Throwable throwable2) {
                    void var10_16;
                    if (throwable == null) {
                        Throwable throwable3 = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw var10_16;
                }
            }
            catch (Exception exception) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_EXCEPTION_WRITE, (Object)jclinName, (Object[])new Object[0]), (Throwable)exception);
            }
            if (this.monitor.isCanceled()) {
                return;
            }
            this.monitor.worked(jclinWork);
        }
        if (this.dbg.isFlow()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
    }

    private final void createJclinBinderMap(IPackagingFmidItem fmid) throws TeamRepositoryException {
        if (this.dbg.isFlow()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
        for (IPackagingItem item : this.packagingItemList) {
            if (!fmid.getFunction().getUuid().equals(item.getFmid().getUuid()) || item.isIgnore()) continue;
            this.binderOptionMap.putValue(new PackagingBinderOptions(item), (Object)item);
        }
        if (this.dbg.isFlow()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
    }

    private final void createJclinJobCard(IPackagingFmidItem fmid, StringBuilder sb) throws TeamRepositoryException {
        StringBuilder copyright;
        ArrayList<IImporterToken> tokens;
        block24: {
            String copyrightLine;
            if (this.dbg.isFlow()) {
                Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
            }
            tokens = new ArrayList<IImporterToken>();
            ImporterToken jobToken = new ImporterToken("@JCLIN_JOB@", fmid.getName());
            tokens.add(jobToken);
            copyright = new StringBuilder();
            if (fmid.hasMcscpyrt()) {
                String[] stringArray = fmid.getMcscpyrt().split(System.lineSeparator());
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    copyrightLine = stringArray[n2];
                    copyright.append(String.format("//* %s", copyrightLine));
                    copyright.append("\n");
                    ++n2;
                }
            } else {
                if (fmid.hasMcscpyrtId()) {
                    IVersionable copyrightFile = PackagingItemTools.findMember(this.fileList, this.folderMap, (String)fmid.getMcscpyrtId(), (IDataSetDefinition)fmid.getMcscpyrtLocationItem());
                    if (copyrightFile == null) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_NOTFOUND_CPYRTFILE, (Object)fmid.getMcscpyrtId(), (Object[])new Object[0]));
                    }
                    File file = new File(String.valueOf(this.wsPath) + PackagingItemTools.getPath(this.folderMap, (IVersionable)copyrightFile));
                    if (!file.exists()) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_FILE_CPYRGT_EXISTS, (Object)copyrightFile.getName(), (Object[])new Object[0]));
                    }
                    if (!file.canRead()) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_FILE_CPYRGT_READ, (Object)copyrightFile.getName(), (Object[])new Object[0]));
                    }
                    try {
                        Throwable throwable = null;
                        Object var10_18 = null;
                        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
                            String line;
                            while ((line = br.readLine()) != null) {
                                if (line.trim().equals("/*") || line.trim().equals("*/")) continue;
                                copyright.append(String.format("//* %s", line.trim()));
                                copyright.append("\n");
                            }
                            break block24;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_EXCEPTION_CPYRGT_READ, (Object)copyrightFile.getName(), (Object[])new Object[0]));
                    }
                }
                if (this.version.hasCopyright()) {
                    String[] stringArray = this.version.getCopyright().split(System.lineSeparator());
                    int n = stringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        copyrightLine = stringArray[n3];
                        copyright.append(String.format("//* %s", copyrightLine));
                        copyright.append("\n");
                        ++n3;
                    }
                } else {
                    throw new TeamRepositoryException(Messages.zPackaging_ARTIFACTS_JCLIN_NOTFOUND_COPYRIGHT);
                }
            }
        }
        copyright.setLength(copyright.length() - System.lineSeparator().length());
        ImporterToken cpyrToken = new ImporterToken("@JCLIN_CPYR@", copyright.toString());
        tokens.add(cpyrToken);
        sb.append(PackagingTemplateFactory.getJclinJob(tokens));
        if (this.dbg.isFlow()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void createJclinLinkStep(IPackagingFmidItem fmid, PackagingBinderOptions pbo, StringBuilder sb) throws TeamRepositoryException {
        if (this.dbg.isFlow()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
        IZosLanguageDefinition language = (IZosLanguageDefinition)pbo.getLanguage();
        IZosTranslator binder = null;
        String binderPgm = null;
        for (ITranslatorEntry translatorEntry : language.getTranslators()) {
            IDataSetDefinition dataset;
            IZosTranslator translator;
            String translatorUuid;
            if (translatorEntry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.translator")) {
                translatorUuid = translatorEntry.getValue();
            } else {
                if (!translatorEntry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_NOTVALID_TRANSLATOR_KIND, (Object)language.getName(), (Object[])new Object[]{translatorEntry.getKind()}));
                if (!Verification.isNonNull((Object)this.buildDefinition)) throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_REQUIRED_BUILD_TRANSLATOR, (Object)language.getName(), (Object[])new Object[0]));
                String uuid = this.buildDefinition.getPropertyValue(StringParser.getPropertyName((String)translatorEntry.getValue()), null);
                if (uuid == null) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_NOTFOUND_TRANSLATOR_PROPERTY, (Object)language.getName(), (Object[])new Object[]{translatorEntry.getValue()}));
                }
                translatorUuid = uuid;
            }
            if (this.translatorMap.containsKey(translatorUuid)) {
                translator = this.translatorMap.get(translatorUuid);
            } else {
                translator = (IZosTranslator)SystemDefinition.getTranslator(this.repository, translatorUuid, (IProgressMonitor)this.monitor, this.dbg);
                if (translator != null) {
                    this.translatorMap.put(this.getUuid((IItemHandle)translator), translator);
                }
            }
            if (translator == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_NOTFOUND_TRANSLATOR, (Object)language.getName(), (Object[])new Object[]{translatorUuid}));
            }
            if (!Verification.isNonNull((Object)translator.getDataSetDefinition()) || !Verification.isNonBlank((String)(dataset = (IDataSetDefinition)translator.getDataSetDefinition()).getDsMember()) || !IPackgingBinderModule.BinderModule.isValid((String)dataset.getDsMember())) continue;
            binder = translator;
            binderPgm = dataset.getDsMember();
            break;
        }
        if (binder == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_NOTFOUND_TRANSLATOR_BINDER, (Object)language.getName(), (Object[])new Object[0]));
        }
        if (binderPgm == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_NOTFOUND_PROGRAM, (Object)language.getName(), (Object[])new Object[]{binder.getName()}));
        }
        ArrayList<IImporterToken> tokens = new ArrayList<IImporterToken>();
        ImporterToken stepToken = new ImporterToken("@JCLIN_STEP@", String.format("//STEP%1$04d EXEC PGM=%2$s,", this.stepCounter++, binderPgm));
        tokens.add(stepToken);
        ImporterToken parmToken = new ImporterToken("@JCLIN_PARM@", String.format("// PARM=(%s)", pbo.getBinderParm()));
        tokens.add(parmToken);
        StringBuilder ddsb = new StringBuilder();
        for (IConcatenation dd : binder.getConcatenations()) {
            String concatFormat = "//%1$-8s DD DISP=SHR,DSN=%2$s";
            for (IDataDefinitionEntry entry : dd.getDataDefinitionEntries()) {
                IDataSetDefinition dataset;
                String datasetUuid;
                if (entry.getKind().equals("com.ibm.teamz.langdef.entry.data_definition")) {
                    datasetUuid = entry.getValue();
                } else {
                    if (!entry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_NOTVALID_CONCAT_KIND, (Object)dd.getName(), (Object[])new Object[]{entry.getKind()}));
                    if (!Verification.isNonNull((Object)this.buildDefinition)) throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_REQUIRED_BUILD_DATASET, (Object)dd.getName(), (Object[])new Object[0]));
                    String uuid = this.buildDefinition.getPropertyValue(StringParser.getPropertyName((String)entry.getValue()), null);
                    if (uuid == null) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_NOTFOUND_DATASET_PROPERTY, (Object)dd.getName(), (Object[])new Object[]{entry.getValue()}));
                    }
                    datasetUuid = uuid;
                }
                if (this.packagingDatasetMap.containsKey(datasetUuid)) {
                    dataset = (IDataSetDefinition)this.packagingDatasetMap.get(datasetUuid);
                } else if (this.translatorDatasetMap.containsKey(datasetUuid)) {
                    dataset = this.translatorDatasetMap.get(datasetUuid);
                } else {
                    dataset = (IDataSetDefinition)SystemDefinition.getResource(this.repository, datasetUuid, (IProgressMonitor)this.monitor, this.dbg);
                    if (dataset != null) {
                        this.translatorDatasetMap.put(this.getUuid((IItemHandle)dataset), dataset);
                    }
                }
                if (dataset == null) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_NOTFOUND_DATASET, (Object)dd.getName(), (Object[])new Object[]{datasetUuid}));
                }
                if (dataset.getUsageType() == 2) throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_NOTVALID_CONCAT_USAGE, (Object)dd.getName(), (Object[])new Object[]{dataset.getName()}));
                ddsb.append(String.format(concatFormat, dd.getName(), this.getDsn(fmid, dataset.getDsName())));
                ddsb.append("\n");
                concatFormat = "//         DD DISP=SHR,DSN=%2$s";
            }
        }
        for (IConcatenation dd : binder.getDDAllocations()) {
            IDataSetDefinition dataset;
            String datasetUuid;
            if (dd.getName().equals("SYSLIN")) continue;
            if (dd.getName().equals("SYSPRINT")) {
                ddsb.append(String.format("//SYSPRINT DD SYSOUT=%s", this.sysoutClass.getLabel()));
                ddsb.append("\n");
                continue;
            }
            IDataDefinitionEntry entry = dd.getDataDefinitionEntry();
            if (entry.getKind().equals("com.ibm.teamz.langdef.entry.data_definition")) {
                datasetUuid = entry.getValue();
            } else {
                if (!entry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_NOTVALID_ALLOC_KIND, (Object)dd.getName(), (Object[])new Object[]{entry.getKind()}));
                if (!Verification.isNonNull((Object)this.buildDefinition)) throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_REQUIRED_BUILD_DATASET, (Object)dd.getName(), (Object[])new Object[0]));
                String uuid = this.buildDefinition.getPropertyValue(StringParser.getPropertyName((String)entry.getValue()), null);
                if (uuid == null) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_NOTFOUND_DATASET_PROPERTY, (Object)dd.getName(), (Object[])new Object[]{entry.getValue()}));
                }
                datasetUuid = uuid;
            }
            if (this.packagingDatasetMap.containsKey(datasetUuid)) {
                dataset = (IDataSetDefinition)this.packagingDatasetMap.get(datasetUuid);
            } else if (this.translatorDatasetMap.containsKey(datasetUuid)) {
                dataset = this.translatorDatasetMap.get(datasetUuid);
            } else {
                dataset = (IDataSetDefinition)SystemDefinition.getResource(this.repository, datasetUuid, (IProgressMonitor)this.monitor, this.dbg);
                if (dataset != null) {
                    this.translatorDatasetMap.put(this.getUuid((IItemHandle)dataset), dataset);
                }
            }
            if (dataset == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_NOTFOUND_DATASET, (Object)dd.getName(), (Object[])new Object[]{datasetUuid}));
            }
            if (dataset.getUsageType() != 2) {
                ddsb.append(String.format("//%1$-8s DD DISP=SHR,DSN=%2$s", dd.getName(), this.getDsn(fmid, dataset.getDsName())));
                ddsb.append("\n");
                continue;
            }
            ddsb.append(String.format("//%1$-8s DD UNIT=%2$s", dd.getName(), dataset.getGenericUnit()));
            if (Verification.isNonBlank((String)this.getSpaceUnits(dataset)) && Verification.isNonBlank((String)dataset.getDirectoryBlocks())) {
                ddsb.append(",");
                ddsb.append("\n");
                ddsb.append(String.format("//            %s", String.format("SPACE=(%1$s,(%2$s,%3$s,%4$s))", this.getSpaceUnits(dataset), dataset.getPrimaryQuantity(), dataset.getSecondaryQuantity(), dataset.getDirectoryBlocks())));
            } else if (Verification.isNonBlank((String)this.getSpaceUnits(dataset))) {
                ddsb.append(",");
                ddsb.append("\n");
                ddsb.append(String.format("//            %s", String.format("SPACE=(%1$s,(%2$s,%3$s))", this.getSpaceUnits(dataset), dataset.getPrimaryQuantity(), dataset.getSecondaryQuantity())));
            } else if (Verification.isNonBlank((String)dataset.getDirectoryBlocks())) {
                ddsb.append(",");
                ddsb.append("\n");
                ddsb.append(String.format("//            %s", String.format("SPACE=(%1$s,%2$s,%3$s)", dataset.getPrimaryQuantity(), dataset.getSecondaryQuantity(), dataset.getDirectoryBlocks())));
            } else {
                ddsb.append(",");
                ddsb.append("\n");
                ddsb.append(String.format("//            %s", String.format("SPACE=(%1$s,%2$s)", dataset.getPrimaryQuantity(), dataset.getPrimaryQuantity())));
            }
            StringBuilder dcb = new StringBuilder();
            if (dataset.getDsType() == 1) {
                dcb.append(String.format("DSORG=%s", "PS"));
            } else if (dataset.getDsType() == 3) {
                dcb.append(String.format("DSORG=%s", "PO"));
            } else if (dataset.getDsType() == 0) {
                dcb.append(String.format("DSORG=%s", "PO"));
            }
            if (Verification.isNonBlank((String)dataset.getRecordFormat())) {
                if (dcb.length() > 0) {
                    dcb.append(",");
                }
                dcb.append(String.format("RECFM=%s", dataset.getRecordFormat()));
            }
            if (Verification.isNonBlank((String)dataset.getRecordLength())) {
                if (dcb.length() > 0) {
                    dcb.append(",");
                }
                dcb.append(String.format("LRECL=%s", dataset.getRecordLength()));
            }
            if (Verification.isNonBlank((String)dataset.getBlockSize())) {
                if (dcb.length() > 0) {
                    dcb.append(",");
                }
                dcb.append(String.format("BLKSIZE=%s", dataset.getBlockSize()));
            }
            if (dcb.length() > 0) {
                ddsb.append(",");
                ddsb.append("\n");
                ddsb.append(String.format("//            %s", String.format("DCB=(%s)", dcb.toString())));
            }
            ddsb.append("\n");
        }
        ddsb.setLength(ddsb.length() - System.lineSeparator().length());
        ImporterToken ddToken = new ImporterToken("@JCLIN_DD@", ddsb.toString());
        tokens.add(ddToken);
        ImporterToken isToken = new ImporterToken("@JCLIN_IS@", "//SYSLIN   DD *");
        tokens.add(isToken);
        sb.append(PackagingTemplateFactory.getJclinStepLink(tokens));
        if (!this.dbg.isFlow()) return;
        Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
    }

    private final void createJclinLinkData(IPackagingFmidItem fmid, PackagingBinderOptions pbo, StringBuilder sb) throws TeamRepositoryException {
        if (this.dbg.isFlow()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
        for (IPackagingItem item : this.binderOptionMap.get((Object)pbo)) {
            File file = new File(String.valueOf(this.wsPath) + PackagingItemTools.getPath(this.folderMap, (IPackagingItem)item));
            if (!file.exists()) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_FILE_BINDER_EXISTS, (Object)item.getFileName(), (Object[])new Object[0]));
            }
            if (!file.canRead()) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_FILE_BINDER_READ, (Object)item.getFileName(), (Object[])new Object[0]));
            }
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        sb.append(line).append(System.lineSeparator());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.zPackaging_ARTIFACTS_JCLIN_EXCEPTION_BINDER_READ, (Object)item.getFileName(), (Object[])new Object[0]));
            }
        }
        sb.append("/*");
        sb.append(System.lineSeparator());
        if (this.dbg.isFlow()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
    }

    public final PackagingBinderHashMap<PackagingBinderOptions, IPackagingItem> getBinderOptionMap() {
        return this.binderOptionMap;
    }

    public final List<PackagingBinderOptions> getBinderOptionKeyList() {
        return new ArrayList<PackagingBinderOptions>(this.binderOptionMap.keySet());
    }

    public final List<PackagingBinderOptions> getBinderOptionKeyListSorted() {
        ArrayList<PackagingBinderOptions> result = new ArrayList<PackagingBinderOptions>(this.getBinderOptionKeyList());
        Collections.sort(result, new Comparator<PackagingBinderOptions>(){

            @Override
            public int compare(PackagingBinderOptions o1, PackagingBinderOptions o2) {
                String key1 = String.valueOf(String.format("%010d", o1.getFlags())) + "." + o1.getLanguage().getName();
                String key2 = String.valueOf(String.format("%010d", o2.getFlags())) + "." + o2.getLanguage().getName();
                return key1.compareTo(key2);
            }
        });
        return result;
    }

    private final String getDsn(IPackagingFmidItem fmid, String dataset) {
        return String.valueOf(fmid.getRfdsnpfx()) + "." + DatasetUtil.getLibrary((String)dataset);
    }

    private final String getSpaceUnits(IDataSetDefinition dataset) {
        if ("cyls".equals(dataset.getSpaceUnits())) {
            return "CYL";
        }
        if ("trks".equals(dataset.getSpaceUnits())) {
            return "TRK";
        }
        return "";
    }

    private final String getUuid(IItemHandle itemHandle) {
        return itemHandle.getItemId().getUuidValue();
    }
}

