/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.mapping;

import com.ibm.team.enterprise.systemdefinition.client.mapping.ISystemDefinitionMappingClient;
import com.ibm.team.enterprise.systemdefinition.common.mapping.ISystemDefinitionMapping;
import com.ibm.team.enterprise.systemdefinition.common.mapping.ISystemDefinitionMappingService;
import com.ibm.team.enterprise.systemdefinition.common.mapping.SystemDefinitionMappingParser;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;

public class SystemDefinitionMappingClient
implements ISystemDefinitionMappingClient {
    private final IClientLibraryContext context;

    public SystemDefinitionMappingClient(IClientLibraryContext context) {
        this.context = context;
    }

    @Override
    public ISystemDefinitionMapping getSystemDefinitionMapping(IItemType type, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getSystemDefinitionMapping(type.getName(), monitor);
    }

    @Override
    public ISystemDefinitionMapping getSystemDefinitionMapping(final String type, IProgressMonitor monitor) throws TeamRepositoryException {
        return (ISystemDefinitionMapping)this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public ISystemDefinitionMapping run(IProgressMonitor monitor) throws TeamRepositoryException {
                String xmlContent = SystemDefinitionMappingClient.this.getService(ISystemDefinitionMappingService.class).getMapping(type);
                SystemDefinitionMappingParser parser = new SystemDefinitionMappingParser();
                return parser.parse(xmlContent);
            }
        });
    }

    @Override
    public void save(final ISystemDefinitionMapping mappings, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String xmlContent = new SystemDefinitionMappingParser().toXML(mappings);
                SystemDefinitionMappingClient.this.getService(ISystemDefinitionMappingService.class).saveMapping(xmlContent, mappings.getType());
                return null;
            }
        });
    }

    @Override
    public boolean hasPermission() {
        return this.getService(ISystemDefinitionMappingService.class).hasPermission();
    }

    @Override
    public String getTargetUuid(String uuid, String type) throws TeamRepositoryException {
        return this.getService(ISystemDefinitionMappingService.class).getMappedUuid(uuid, type);
    }

    protected Object callCancelableService(IProgressMonitor progressMonitor, IClientLibraryContext.IServiceRunnable serviceRunnable) throws TeamRepositoryException {
        return this.context.callCancelableService(serviceRunnable, progressMonitor);
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)this.context.getServiceInterface(clazz);
    }

    @Override
    public void deleteMapping(final String type, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                SystemDefinitionMappingClient.this.getService(ISystemDefinitionMappingService.class).deleteMapping(type);
                return null;
            }
        });
    }
}

