/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.importer;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;

public class ImporterTemplate {
    private final String cls = this.getClass().getSimpleName();
    private final IDebugger dbg = new Debugger(this.getClass());
    private final String template;

    public ImporterTemplate(String template) {
        this.template = template;
        if (this.dbg.isDebug()) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{this.cls});
        }
    }

    public final String getTemplate() {
        return this.getTemplate(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String getTemplate(List<IImporterToken> tokens) {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        String ls = System.lineSeparator();
        String line = null;
        String result = null;
        StringBuilder sb = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var8_11 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(this.template), "UTF-8"));){
                if (tokens != null) {
                    block8: while ((line = br.readLine()) != null) {
                        Iterator<IImporterToken> iterator = tokens.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                sb.append(line).append(ls);
                                continue block8;
                            }
                            IImporterToken token = iterator.next();
                            if (mnm.getDbg().isItems()) {
                                mnm.items(new String[]{"name", token.getName()});
                                mnm.items(new String[]{"valu", token.getValue()});
                            }
                            line = line.replace(token.getName(), token.getValue());
                        }
                    }
                } else {
                    while ((line = br.readLine()) != null) {
                        sb.append(line).append(ls);
                    }
                }
                result = sb.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mnm.leave(new String[]{LogString.valueOf(result)});
        return result;
    }
}

