/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.importer;

import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterDataset;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterToken;
import com.ibm.team.enterprise.systemdefinition.common.export.util.ExportException;
import com.ibm.team.enterprise.systemdefinition.common.export.util.ZosExportSysDefs;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterDataset;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterOption;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParserStep;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStep;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterVariables;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ImporterStep
implements IImporterStep {
    protected IImporterBuildOptions buildOptions;
    protected String stepName;
    protected String id;

    public ImporterStep() {
    }

    public ImporterStep(IImporterLanguage imported) {
    }

    public abstract void init();

    public abstract void init(IImporterParserStep var1);

    public abstract void initDefault();

    public abstract String getId();

    public abstract String getName(String var1);

    public abstract void createDocumentStep(Document var1, Element var2);

    public abstract void createDocumentOptionsAdditional(Document var1, Element var2, IImporterBuildOptions var3);

    public abstract void createTokenListStepResource(IImporterLanguage var1, List<IImporterToken> var2, StringBuilder var3);

    public abstract void createTokenListStepTranslator(IImporterLanguage var1, List<IImporterToken> var2, StringBuilder var3);

    public abstract void createConditionAttributeAdditional(StringBuilder var1, IImporterBuildOptions var2);

    public abstract void createTranslatorSyslibElementAdditional(IImporterLanguage var1, List<IImporterToken> var2, List<IImporterDataset> var3);

    protected final void appendAttribute(StringBuilder attributes, String attribute) {
        if (attributes.length() > 0) {
            attributes.append("\n\t\t\t\t");
        }
        attributes.append(attribute.replaceAll("&", "&amp;").trim());
    }

    protected void addOptions(List<IImporterOption> options) {
        for (IImporterOption option : options) {
            if (option.getName().equals("compile")) {
                this.buildOptions.setCompile(option.getState());
                this.buildOptions.setCompileEnabled(option.getEnabled());
                continue;
            }
            if (option.getName().equals("initial")) {
                this.buildOptions.setInitial(option.getState());
                this.buildOptions.setInitialEnabled(option.getEnabled());
                continue;
            }
            if (option.getName().equals("library")) {
                this.buildOptions.setLibrary(option.getState());
                this.buildOptions.setLibraryEnabled(option.getEnabled());
                continue;
            }
            if (option.getName().equals("refresh")) {
                this.buildOptions.setRefresh(option.getState());
                this.buildOptions.setRefreshEnabled(option.getEnabled());
                continue;
            }
            if (option.getName().equals("service")) {
                this.buildOptions.setService(option.getState());
                this.buildOptions.setServiceEnabled(option.getEnabled());
                continue;
            }
            if (!option.getName().equals("testing")) continue;
            this.buildOptions.setTesting(option.getState());
            this.buildOptions.setTestingEnabled(option.getEnabled());
        }
    }

    public String createConditionAttribute(IImporterBuildOptions buildOptions) {
        StringBuilder sb = new StringBuilder();
        String result = "";
        if (!buildOptions.isCompile()) {
            sb.append(String.format("\n&#9;&lt;isfalse value=&quot;${%s}&quot;/&gt;", "isBuildTypeCompile"));
        }
        if (!buildOptions.isLibrary()) {
            sb.append(String.format("\n&#9;&lt;isfalse value=&quot;${%s}&quot;/&gt;", "isBuildTypeLibrary"));
        }
        if (!buildOptions.isInitial()) {
            sb.append(String.format("\n&#9;&lt;isfalse value=&quot;${%s}&quot;/&gt;", "isBuildTypeInitial"));
        }
        if (!buildOptions.isRefresh()) {
            sb.append(String.format("\n&#9;&lt;isfalse value=&quot;${%s}&quot;/&gt;", "isBuildTypeRefresh"));
        }
        if (!buildOptions.isService()) {
            sb.append(String.format("\n&#9;&lt;isfalse value=&quot;${%s}&quot;/&gt;", "isBuildTypeService"));
        }
        if (!buildOptions.isTesting()) {
            sb.append(String.format("\n&#9;&lt;isfalse value=&quot;${%s}&quot;/&gt;", "isBuildTypeTesting"));
        }
        this.createConditionAttributeAdditional(sb, buildOptions);
        if (sb.length() > 0) {
            sb.insert(0, "&lt;and&gt;");
            sb.append("\n&lt;/and&gt;");
            class Separator {
                private final String lineSeparator;

                Separator() {
                    StringBuilder sb = new StringBuilder();
                    byte[] b = System.lineSeparator().getBytes();
                    int i = 0;
                    while (i < b.length) {
                        sb.append(String.format("&#%d;", b[i]));
                        ++i;
                    }
                    this.lineSeparator = sb.toString();
                }

                public String getLineSeparator() {
                    return this.lineSeparator;
                }
            }
            result = sb.toString().replace("\n", new Separator().getLineSeparator());
        }
        return result;
    }

    protected void createDocumentOptions(Document document, Element translatorElement, IImporterBuildOptions buildOptions) {
        Element optionElement = null;
        optionElement = document.createElement("option");
        optionElement.setAttribute("enabled", Boolean.toString(buildOptions.isCompileEnabled()));
        optionElement.setAttribute("state", Boolean.toString(buildOptions.isCompile()));
        optionElement.setTextContent("compile");
        translatorElement.appendChild(optionElement);
        optionElement = document.createElement("option");
        optionElement.setAttribute("enabled", Boolean.toString(buildOptions.isInitialEnabled()));
        optionElement.setAttribute("state", Boolean.toString(buildOptions.isInitial()));
        optionElement.setTextContent("initial");
        translatorElement.appendChild(optionElement);
        optionElement = document.createElement("option");
        optionElement.setAttribute("enabled", Boolean.toString(buildOptions.isLibraryEnabled()));
        optionElement.setAttribute("state", Boolean.toString(buildOptions.isLibrary()));
        optionElement.setTextContent("library");
        translatorElement.appendChild(optionElement);
        optionElement = document.createElement("option");
        optionElement.setAttribute("enabled", Boolean.toString(buildOptions.isRefreshEnabled()));
        optionElement.setAttribute("state", Boolean.toString(buildOptions.isRefresh()));
        optionElement.setTextContent("refresh");
        translatorElement.appendChild(optionElement);
        optionElement = document.createElement("option");
        optionElement.setAttribute("enabled", Boolean.toString(buildOptions.isServiceEnabled()));
        optionElement.setAttribute("state", Boolean.toString(buildOptions.isService()));
        optionElement.setTextContent("service");
        translatorElement.appendChild(optionElement);
        optionElement = document.createElement("option");
        optionElement.setAttribute("enabled", Boolean.toString(buildOptions.isTestingEnabled()));
        optionElement.setAttribute("state", Boolean.toString(buildOptions.isTesting()));
        optionElement.setTextContent("testing");
        translatorElement.appendChild(optionElement);
        this.createDocumentOptionsAdditional(document, translatorElement, buildOptions);
    }

    protected final IImporterToken createResourceSyslibElement(IImporterLanguage language, String token, String elementStart, String elementEnd, List<IImporterDataset> datasets) {
        ImporterToken result = null;
        datasets = language.getCache().removeDupes(datasets);
        if (datasets.isEmpty()) {
            result = new ImporterToken(token, "");
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(elementStart);
            for (IImporterDataset dataset : datasets) {
                if (dataset.iszFolder() && dataset.isExisting()) {
                    sb.append("\n\t\t\t\t");
                    sb.append(String.format("<xt:syslibDsDef dsn=\"%s\" zFolder=\"true\"/>", dataset.getDataset()));
                    continue;
                }
                if (dataset.iszFolder()) {
                    sb.append("\n\t\t\t\t");
                    sb.append(String.format("<xt:syslibDsDef dsn=\"%s\" zFolder=\"true\" dsDefUsageType=\"0\" blockSize=\"32720\" directoryBlocks=\"0\" recordFormat=\"FB\" recordLength=\"80\" spaceUnits=\"cyls\"/>", dataset.getDataset()));
                    continue;
                }
                sb.append("\n\t\t\t\t");
                sb.append(String.format("<xt:syslibDsDef dsn=\"%s\"/>", dataset.getDataset()));
            }
            sb.append("\n\t\t\t").append(elementEnd);
            result = new ImporterToken(token, sb.toString());
        }
        return result;
    }

    protected final IImporterToken createResourceTasklibElement(IImporterLanguage language, String token, String elementStart, String elementEnd, List<IImporterDataset> datasets) {
        return this.createResourceTasklibElement(language, token, elementStart, elementEnd, datasets, null);
    }

    protected final IImporterToken createResourceTasklibElement(IImporterLanguage language, String token, String elementStart, String elementEnd, List<IImporterDataset> datasets, IImporterStep step) {
        ImporterToken result = null;
        datasets = language.getCache().removeDupes(datasets);
        if (datasets.isEmpty()) {
            result = new ImporterToken(token, "", step);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(elementStart);
            for (IImporterDataset dataset : datasets) {
                sb.append("\n\t\t\t\t");
                sb.append(String.format("<xt:tasklibDsDef dsn=\"%s\"/>", dataset.getDataset()));
            }
            sb.append("\n\t\t\t").append(elementEnd);
            result = new ImporterToken(token, sb.toString(), step);
        }
        return result;
    }

    protected final IImporterToken createResourceOtherDSElement(String token, String elementSta, String elementEnd, Set<IResourceDefinition> dsdefs, IImporterStep step) {
        ImporterToken result = null;
        if (dsdefs.isEmpty()) {
            result = new ImporterToken(token, "", step);
        } else {
            String exported;
            try {
                exported = ZosExportSysDefs.create().dataSetDefinitions(dsdefs).exportToString(false);
            }
            catch (ExportException | TeamRepositoryException | IllegalArgumentException | ParserConfigurationException e) {
                exported = e.getMessage();
                e.printStackTrace();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(elementSta);
            String[] stringArray = exported.split("/>");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String dsdef = stringArray[n2];
                sb.append("\n\t\t\t\t");
                sb.append(dsdef).append("/>");
                ++n2;
            }
            sb.append("\n\t\t\t").append(elementEnd);
            result = new ImporterToken(token, sb.toString(), step);
        }
        return result;
    }

    protected void createTranslatorSyslibElement(IImporterLanguage language, List<IImporterToken> tokens, List<IImporterDataset> datasets) {
        StringBuilder compileMaclibs = new StringBuilder();
        StringBuilder initialMaclibs = new StringBuilder();
        StringBuilder libraryMaclibs = new StringBuilder();
        StringBuilder refreshMaclibs = new StringBuilder();
        StringBuilder serviceMaclibs = new StringBuilder();
        StringBuilder testingMaclibs = new StringBuilder();
        StringBuilder generalMaclibs = new StringBuilder();
        String id = language.getId();
        String generalIndent = "";
        String zFolderIndent = "";
        int i = 0;
        while (i < datasets.size()) {
            String personalName;
            String standardName;
            IImporterDataset dataset = datasets.get(i);
            if (datasets.size() > 1) {
                standardName = String.format("%1$s.Resource.%3$s.SYSLIB.DSN%2$02d", id, i, this.getId(), this.getId());
                personalName = String.format("%1$s.Resource.%3$s.SYSLIB.DSN%2$02d.personal", id, i, this.getId(), this.getId());
            } else {
                standardName = String.format("%1$s.Resource.%3$s.SYSLIB", id, this.getId(), this.getId());
                personalName = String.format("%1$s.Resource.%3$s.SYSLIB.personal", id, this.getId(), this.getId());
            }
            String[] tokenNames = language.getCache().getTokensOrDefault(dataset.getDataset(), standardName, personalName).getTokens();
            standardName = tokenNames[0];
            personalName = tokenNames[1];
            if (dataset.iszFolder()) {
                compileMaclibs.append(zFolderIndent);
                compileMaclibs.append(String.format("<ld:allocation dataSetDefinition=\"%s\"/>", standardName));
                compileMaclibs.append("\n\t\t\t\t");
                compileMaclibs.append(String.format("<ld:allocation dataSetDefinition=\"%s\"/>", personalName));
                initialMaclibs.append(zFolderIndent);
                initialMaclibs.append(String.format("<ld:allocation dataSetDefinition=\"%s\"/>", standardName));
                libraryMaclibs.append(zFolderIndent);
                libraryMaclibs.append(String.format("<ld:allocation dataSetDefinition=\"%s\"/>", standardName));
                refreshMaclibs.append(zFolderIndent);
                refreshMaclibs.append(String.format("<ld:allocation dataSetDefinition=\"%s\"/>", standardName));
                serviceMaclibs.append(zFolderIndent);
                serviceMaclibs.append(String.format("<ld:allocation dataSetDefinition=\"%s\"/>", standardName));
                serviceMaclibs.append("\n\t\t\t\t");
                serviceMaclibs.append(String.format("<ld:allocation dataSetDefinition=\"%s\"/>", personalName));
                testingMaclibs.append(zFolderIndent);
                testingMaclibs.append(String.format("<ld:allocation dataSetDefinition=\"%s\"/>", standardName));
                testingMaclibs.append("\n\t\t\t\t");
                testingMaclibs.append(String.format("<ld:allocation dataSetDefinition=\"%s\"/>", personalName));
                zFolderIndent = "\n\t\t\t\t";
            } else {
                generalMaclibs.append(generalIndent);
                generalMaclibs.append(String.format("<ld:allocation dataSetDefinition=\"%s\"/>", standardName));
                generalIndent = "\n\t\t\t\t";
            }
            ++i;
        }
        tokens.add(new ImporterToken(String.format("@TRANSLATOR_%s_SYSLIB@", this.getId()), generalMaclibs.toString()));
        tokens.add(new ImporterToken(String.format("@TRANSLATOR_%s_SYSLIB_COMPILE@", this.getId()), compileMaclibs.toString()));
        tokens.add(new ImporterToken(String.format("@TRANSLATOR_%s_SYSLIB_INITIAL@", this.getId()), initialMaclibs.toString()));
        tokens.add(new ImporterToken(String.format("@TRANSLATOR_%s_SYSLIB_LIBRARY@", this.getId()), libraryMaclibs.toString()));
        tokens.add(new ImporterToken(String.format("@TRANSLATOR_%s_SYSLIB_REFRESH@", this.getId()), refreshMaclibs.toString()));
        tokens.add(new ImporterToken(String.format("@TRANSLATOR_%s_SYSLIB_SERVICE@", this.getId()), serviceMaclibs.toString()));
        tokens.add(new ImporterToken(String.format("@TRANSLATOR_%s_SYSLIB_TESTING@", this.getId()), testingMaclibs.toString()));
    }

    protected final void createTranslatorTasklibElement(IImporterLanguage language, List<IImporterToken> tokens, String tokenName, String elementStart, String elementEnd, String datasetPattern, String datasetsPattern, List<IImporterDataset> datasets) {
        this.createTranslatorTasklibElement(language, tokens, tokenName, elementStart, elementEnd, datasetPattern, datasetsPattern, datasets, null);
    }

    protected final void createTranslatorTasklibElement(IImporterLanguage language, List<IImporterToken> tokens, String tokenName, String elementStart, String elementEnd, String datasetPattern, String datasetsPattern, List<IImporterDataset> datasets, IImporterStep step) {
        if (datasets.isEmpty()) {
            tokens.add(new ImporterToken(tokenName, "", step));
        } else {
            StringBuilder sb = new StringBuilder();
            String id = language.getId();
            sb.append(elementStart);
            sb.append("\n\t\t\t\t");
            sb.append("<ld:concatenation name=\"TASKLIB\">");
            int i = 0;
            while (i < datasets.size()) {
                String datasetName = datasets.size() > 1 ? String.format(datasetsPattern, id, i, this.getId(), this.getStepName()) : String.format(datasetPattern, id, i, this.getId(), this.getStepName());
                String[] tokenNames = language.getCache().getTokenOrDefault(datasets.get(i).getDataset(), datasetName).getTokens();
                datasetName = tokenNames[0];
                sb.append("\n\t\t\t\t\t");
                sb.append(String.format("<ld:allocation dataSetDefinition=\"%s\"/>", datasetName));
                ++i;
            }
            sb.append("\n\t\t\t\t");
            sb.append("</ld:concatenation>");
            sb.append("\n\t\t\t");
            sb.append(elementEnd);
            tokens.add(new ImporterToken(tokenName, sb.toString(), step));
        }
    }

    protected final void createTranslatorOtherDDElement(IImporterLanguage language, List<IImporterToken> tokens, String tokenName, String elementStart, String elementEnd, String datasetPattern, List<String> dds, IImporterStep step) {
        if (dds.isEmpty()) {
            tokens.add(new ImporterToken(tokenName, "", step));
        } else {
            StringBuilder sb = new StringBuilder();
            String id = language.getId();
            sb.append(elementStart);
            for (String dd : dds) {
                String nm = String.format(datasetPattern, id, dd, this.getId(), this.getStepName());
                sb.append("\n\t\t\t\t");
                sb.append(String.format("<ld:allocation dataSetDefinition=\"%s\" name=\"%s\"/>", nm, dd));
            }
            sb.append("\n\t\t\t");
            sb.append(elementEnd);
            tokens.add(new ImporterToken(tokenName, sb.toString(), step));
        }
    }

    protected final String getDefaultDataset(List<IImporterDataset> datasets, String defaultValue) {
        if (datasets != null && datasets.size() > 0) {
            return datasets.get(0).getDataset();
        }
        return defaultValue;
    }

    protected final IImporterDataset getDefaultResource(List<IImporterDataset> datasets) {
        if (datasets != null && datasets.size() > 0) {
            return datasets.get(0);
        }
        return new ImporterDataset();
    }

    protected final void getDefaultDatasets(List<IImporterDataset> datasets, List<IImporterDataset> defaultValue) {
        if (datasets != null && datasets.size() > 0) {
            defaultValue.addAll(datasets);
        }
    }

    protected final Object getDefaultParameter(List<String> parms, IImporterVariables.Variable variable) {
        for (String parm : parms) {
            if (!variable.isValid(parm)) continue;
            return variable.get(parm);
        }
        return null;
    }

    protected final String getDefaultOtherParameters(List<String> parms, List<IImporterVariables.Variable> variables) {
        StringBuilder result = new StringBuilder();
        block0: for (String parm : parms) {
            for (IImporterVariables.Variable variable : variables) {
                if (variable.isValid(parm)) continue block0;
            }
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(parm);
        }
        return result.toString();
    }

    public final IImporterBuildOptions getBuildOptions() {
        return this.buildOptions;
    }

    public final void setBuildOptions(IImporterBuildOptions buildOptions) {
        this.buildOptions = buildOptions;
    }

    public String getStepName() {
        return this.stepName;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }
}

