/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.importer;

import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.internal.client.Password;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterToken;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterProperties;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import com.ibm.team.enterprise.systemdefinition.common.importer.ImporterFactoryException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

@DebugGroup(value={"zBuilder,zPackaging"})
public class ImporterProperties
implements IImporterProperties {
    private final IDebugger dbg = new Debugger(this.getClass());
    private String description;
    private String id;
    private String name;
    private String password;
    private String passwordFile;
    private String projectArea;
    private String repositoryAddress;
    private String userId;

    public ImporterProperties() {
    }

    public ImporterProperties(Properties properties) {
        this.setDescription(properties.getProperty("description", ""));
        this.setId(properties.getProperty("id", ""));
        this.setName(properties.getProperty("name", ""));
        this.setPasswordString(properties.getProperty("password", ""));
        this.setPasswordFile(properties.getProperty("passwordFile", ""));
        this.setProjectArea(properties.getProperty("projectArea", ""));
        this.setRepositoryAddress(properties.getProperty("repositoryAddress", ""));
        this.setUserId(properties.getProperty("userId", ""));
    }

    public IDebugger getDbg() {
        return this.dbg;
    }

    public final List<IImporterToken> addTokens(List<IImporterToken> tokens) {
        ImporterToken descriptionToken = new ImporterToken("@DESCRIPTION@", this.getDescription());
        ImporterToken idToken = new ImporterToken("@ID@", this.getId());
        ImporterToken nameToken = new ImporterToken("@NAME@", this.getName());
        ImporterToken passwordToken = new ImporterToken("@PASSWORD@", this.getPassword());
        ImporterToken passwordFileToken = new ImporterToken("@PASSWORD_FILE@", this.getPasswordFile());
        ImporterToken projectAreaToken = new ImporterToken("@PROJECT_AREA@", this.getProjectArea());
        ImporterToken repositoryAddressToken = new ImporterToken("@REPOSITORY_ADDRESS@", this.getRepositoryAddress());
        ImporterToken userIdToken = new ImporterToken("@USERID@", this.getUserId());
        tokens.add(descriptionToken);
        tokens.add(idToken);
        tokens.add(nameToken);
        tokens.add(passwordToken);
        tokens.add(passwordFileToken);
        tokens.add(projectAreaToken);
        tokens.add(repositoryAddressToken);
        tokens.add(userIdToken);
        return tokens;
    }

    public final List<IImporterToken> createTokenList() {
        return this.addTokens(new ArrayList<IImporterToken>());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) throws ImporterFactoryException {
        try {
            this.password = new Password().getEncryptedPassword(password);
        }
        catch (Exception e) {
            throw new ImporterFactoryException((Throwable)e);
        }
    }

    public void setPasswordString(String password) {
        this.password = password;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public boolean hasPasswordFile() {
        return this.passwordFile != null && this.passwordFile.length() > 0;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    public String getProjectArea() {
        return this.projectArea;
    }

    public void setProjectArea(String projectArea) {
        this.projectArea = projectArea;
    }

    public String getRepositoryAddress() {
        return this.repositoryAddress;
    }

    public void setRepositoryAddress(String repositoryAddress) {
        this.repositoryAddress = repositoryAddress;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

