/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.importer;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterDataset;
import com.ibm.team.enterprise.systemdefinition.client.importer.ImporterParserResult;
import com.ibm.team.enterprise.systemdefinition.client.importer.ImporterParserStep;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParser;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParserResult;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParserStep;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

public class ImporterParser
implements IImporterParser {
    public static final String Charset = "UTF8";
    public static final String JclBegin = "//";
    public static final String JclComment = "//*";
    public static final String JclParmParens = "PARM=(";
    public static final String JclParmQuoted = "PARM='";
    public static final String JclStatementDd = "DD";
    public static final String JclStatementExec = "EXEC";
    public static final String RegexDsn = "DSN=(.*?)(?:\\(|,|$)";
    public static final String RegexPgm = "PGM=(.*?)(?:\\,|$)";
    public static final String RegexPrm = "PARM=(.*?)(?:\\,|$)";
    public static final String RegexPrmCnStmt = "\\/\\/\\s+((.*)PARM='(.*)(?:'\\,|'$)(.*?))(?:\\s|$)";
    public static final String RegexPrmCn2End = "\\/\\/\\s+(.*)$";
    public static final String RegexPrmExStmt = "EXEC\\s((.*)PARM='(.*)(?:'\\,|'$)(.*?))(?:\\s|$)";
    public static final String RegexPrmEx2End = "EXEC\\s(.*)$";
    public static final String RegexPrmParens = "PARM=\\((.*)\\)";
    public static final String RegexPrmQuoted = "PARM='(.*)(?:'\\,|'$)";
    public static final String ReplaceAcutes = "``";
    public static final String ReplaceQuoted = "'";
    public static final String ReplaceQuotes = "''";
    public static final String ReportLineDsns = "    %1$-8s - %2$s";
    public static final String ReportLineParm = "    %1$s";
    private final IDebugger dbg;
    private final String cls = this.getClass().getSimpleName();

    public ImporterParser() {
        this.dbg = new Debugger(this.getClass());
        if (this.dbg.isDebug()) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{this.cls});
        }
    }

    public final IImporterParserResult parse(String filename) {
        return this.parse(filename, null);
    }

    /*
     * Unable to fully structure code
     */
    public final IImporterParserResult parse(String filename, String prefix) {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.cls, new Mnm(){}.get()});
        }
        result = new ImporterParserResult();
        steps = result.getSteps();
        file = new File(filename);
        try {
            var6_6 = null;
            var7_9 = null;
            try {
                fis = new FileInputStream(file);
                try {
                    isr = new InputStreamReader((InputStream)fis, "UTF8");
                    try {
                        br = new BufferedReader(isr);
                        try {
                            step = null;
                            line = null;
                            inProgress = null;
                            lastDdName = null;
                            while ((line = br.readLine()) != null) {
                                stmt = line.substring(0, Math.min(71, line.length())).trim();
                                words = stmt.split("\\s+");
                                if (words.length < 2 || words[0].startsWith("//*")) continue;
                                statement = words[1];
                                continued = words[1];
                                if ("EXEC".equals(statement)) {
                                    inProgress = statement;
                                    lastDdName = null;
                                    parameter = null;
                                    if (stmt.contains("PARM='")) {
                                        p = Pattern.compile("EXEC\\s((.*)PARM='(.*)(?:'\\,|'$)(.*?))(?:\\s|$)");
                                        m = p.matcher(stmt);
                                        if (m.find()) {
                                            parameter = m.group(1);
                                        } else {
                                            p = Pattern.compile("EXEC\\s(.*)$");
                                            m = p.matcher(stmt);
                                            if (m.find()) {
                                                parameter = m.group(1);
                                            }
                                        }
                                    } else {
                                        parameter = words[2];
                                    }
                                    p = Pattern.compile("PGM=(.*?)(?:\\,|$)");
                                    m = p.matcher(parameter);
                                    if (!m.find()) continue;
                                    step = new ImporterParserStep();
                                    step.setName(words[0].replace("/", ""));
                                    step.setPgmName(m.group(1));
                                    step.setParameterExec(new StringBuilder(parameter));
                                    step.setParameterDds(new HashMap<K, V>());
                                    steps.add(step);
                                    continue;
                                }
                                if ("DD".equals(statement)) {
                                    inProgress = statement;
                                    parameter = words[2];
                                    ddName = words[0].replace("//", "");
                                    if ("".equals(ddName)) {
                                        ((StringBuilder)step.getParameterDds().get(lastDdName)).append(",").append(parameter);
                                        continue;
                                    }
                                    lastDdName = ddName;
                                    step.getParameterDds().put(ddName, new StringBuilder(parameter));
                                    continue;
                                }
                                if ("EXEC".equals(inProgress)) {
                                    if (stmt.contains("PARM='")) {
                                        p = Pattern.compile("\\/\\/\\s+((.*)PARM='(.*)(?:'\\,|'$)(.*?))(?:\\s|$)");
                                        m = p.matcher(stmt);
                                        if (m.find()) {
                                            step.getParameterExec().append(m.group(1));
                                            continue;
                                        }
                                        p = Pattern.compile("\\/\\/\\s+(.*)$");
                                        m = p.matcher(stmt);
                                        if (!m.find()) continue;
                                        step.getParameterExec().append(m.group(1));
                                        continue;
                                    }
                                    step.getParameterExec().append(continued);
                                    continue;
                                }
                                if ("DD".equals(inProgress)) {
                                    ((StringBuilder)step.getParameterDds().get(lastDdName)).append(continued);
                                    continue;
                                }
                                inProgress = null;
                                lastDdName = null;
                            }
                        }
                        finally {
                            if (br != null) {
                                br.close();
                            }
                        }
                        ** if (isr == null) goto lbl-1000
                    }
                    catch (Throwable var7_10) {
                        if (var6_6 == null) {
                            var6_6 = var7_10;
                        } else if (var6_6 != var7_10) {
                            var6_6.addSuppressed(var7_10);
                        }
                        if (isr != null) {
                            isr.close();
                        }
                        throw var6_6;
                    }
lbl-1000:
                    // 1 sources

                    {
                        isr.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    ** if (fis == null) goto lbl-1000
                }
                catch (Throwable var7_11) {
                    if (var6_6 == null) {
                        var6_6 = var7_11;
                    } else if (var6_6 != var7_11) {
                        var6_6.addSuppressed(var7_11);
                    }
                    if (fis != null) {
                        fis.close();
                    }
                    throw var6_6;
                }
lbl-1000:
                // 1 sources

                {
                    fis.close();
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (Throwable var7_12) {
                if (var6_6 == null) {
                    var6_6 = var7_12;
                } else if (var6_6 != var7_12) {
                    var6_6.addSuppressed(var7_12);
                }
                throw var6_6;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (IImporterParserStep step : steps) {
            if (step.getParameterExec().toString().contains("PARM=(")) {
                p = Pattern.compile("PARM=\\((.*)\\)");
                m = p.matcher(step.getParameterExec().toString());
                sb = new StringBuilder();
                while (m.find()) {
                    sb.append(m.group(1));
                }
                step.getParmParameters().addAll(Arrays.asList(sb.toString().split(",")));
                continue;
            }
            if (step.getParameterExec().toString().contains("PARM='")) {
                p = Pattern.compile("PARM='(.*)(?:'\\,|'$)");
                m = p.matcher(step.getParameterExec().toString().replace("''", "``"));
                sb = new StringBuilder();
                while (m.find()) {
                    sb.append(m.group(1));
                }
                step.getParmParameters().addAll(Arrays.asList(sb.toString().replace("``", "'").split(",")));
                continue;
            }
            p = Pattern.compile("PARM=(.*?)(?:\\,|$)");
            m = p.matcher(step.getParameterExec().toString());
            sb = new StringBuilder();
            while (m.find()) {
                sb.append(m.group(1));
            }
            step.getParmParameters().addAll(Arrays.asList(sb.toString().split(",")));
        }
        for (IImporterParserStep step : steps) {
            for (String dd : step.getParameterDds().keySet()) {
                p = Pattern.compile("DSN=(.*?)(?:\\(|,|$)");
                m = p.matcher(((StringBuilder)step.getParameterDds().get(dd)).toString());
                datasets = new ArrayList<ImporterDataset>();
                while (m.find()) {
                    datasetName = m.group(1);
                    regexPrefix = null;
                    zFolder = false;
                    if (Verification.isNonBlank((String)prefix) && m.group(1).startsWith(prefix)) {
                        regexPrefix = prefix.replace(".", "\\.");
                        regexPrefix = String.valueOf(regexPrefix) + "\\.";
                        datasetName = datasetName.replaceFirst(regexPrefix, "");
                        zFolder = true;
                    }
                    dataset = new ImporterDataset();
                    dataset.setDataset(datasetName);
                    dataset.setzFolder(zFolder);
                    datasets.add(dataset);
                }
                step.getDatasets().put(dd, datasets);
            }
        }
        if (this.dbg.isDebug()) {
            for (IImporterParserStep step : steps) {
                System.out.println(String.valueOf(step.getName()) + "." + step.getPgmName());
                parmString = step.getParmParameters().toString();
                System.out.println(String.format("    %1$s", new Object[]{parmString}));
                for (String dd : step.getDatasets().keySet()) {
                    ddString = ((List)step.getDatasets().get(dd)).toString();
                    System.out.println(String.format("    %1$-8s - %2$s", new Object[]{dd, ddString}));
                }
            }
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.cls, new Mnm(){}.get(), LogString.valueOf((int)steps.size())});
        }
        return result;
    }
}

