/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.importer;

import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterToken;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterMetadata;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterProperties;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import java.util.ArrayList;
import java.util.List;

public class ImporterMetadata
implements IImporterMetadata {
    private IImporterProperties properties;
    private String projectName;
    private List<IImporterLanguage> languages;

    public final List<IImporterToken> createTokenList() {
        ArrayList<IImporterToken> tokens = new ArrayList<IImporterToken>();
        if (Verification.isNonEmpty(this.languages)) {
            StringBuilder sb = new StringBuilder();
            String pfx = "";
            for (IImporterLanguage language : this.languages) {
                if (!Verification.isNonBlank((String)language.getFolderPrimary()) || !Verification.isNonBlank((String)language.getZFolderName())) continue;
                sb.append(pfx);
                sb.append(String.format("@METADATA_DSDEFRULE@", language.getFolderPrimary(), language.getZFolderName()));
                pfx = "\n\t\t\t";
            }
            ImporterToken languagesToken = new ImporterToken("@METADATA_DSDEFRULE@", sb.toString());
            tokens.add(languagesToken);
        } else {
            ImporterToken languagesToken = new ImporterToken("@METADATA_DSDEFRULE@", "");
            tokens.add(languagesToken);
        }
        ImporterToken projectNameToken = new ImporterToken("@PROJECT@", this.getProjectName());
        tokens.add(projectNameToken);
        if (this.properties != null) {
            this.properties.addTokens(tokens);
        }
        return tokens;
    }

    public final List<IImporterLanguage> getLanguages() {
        return this.languages;
    }

    public final void setLanguages(List<IImporterLanguage> languages) {
        this.languages = languages;
    }

    public final String getProjectName() {
        return this.projectName;
    }

    public final void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public final IImporterProperties getProperties() {
        return this.properties;
    }

    public final void setProperties(IImporterProperties projectProperties) {
        this.properties = projectProperties;
    }
}

