/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.importer;

import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.common.common.parser.ParserException;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResult;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultCondition;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultDataDef;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultDataSet;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultStep;
import com.ibm.team.enterprise.common.common.parser.jcl.JclParse;
import com.ibm.team.enterprise.systemdefinition.client.importer.ImporterFactory;
import com.ibm.team.enterprise.systemdefinition.client.importer.ImporterParserResult;
import com.ibm.team.enterprise.systemdefinition.client.importer.ImporterParserStep;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterDataset;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParser;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParserResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@DebugGroup(value={"zBuilder,zPackaging"})
public class ImporterJclParser
implements IImporterParser {
    private final String cls = this.getClass().getSimpleName();
    private final IDebugger dbg = new Debugger(this.getClass());
    private final Map properties = new Properties();

    public final IImporterParserResult parse(String filename) throws ParserException {
        return this.parse(filename, null);
    }

    public final IImporterParserResult parse(String filename, String zPrefix) throws ParserException {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        JclParse parse = new JclParse(filename);
        String propertiesPath = String.valueOf(filename) + ".properties";
        File propertiesFile = new File(propertiesPath);
        if (propertiesFile.exists()) {
            try {
                Throwable throwable = null;
                Object var8_11 = null;
                try (InputStreamReader isr = new InputStreamReader(new FileInputStream(propertiesFile));){
                    ((Properties)this.properties).load(isr);
                    parse.setSymbols(this.properties);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                throw new ParserException((Throwable)e);
            }
            catch (IOException e) {
                throw new ParserException((Throwable)e);
            }
        }
        IJclResult jclResult = parse.parse();
        ImporterParserResult result = new ImporterParserResult();
        int i = 0;
        while (i < jclResult.getSteps().size()) {
            IJclResultStep step = (IJclResultStep)jclResult.getSteps().get(i);
            ImporterParserStep parserStep = new ImporterParserStep();
            parserStep.setName(step.getName());
            parserStep.setPgmName(step.getPgmName());
            parserStep.getParameters().putAll(step.getParameters());
            parserStep.getParmParameters().addAll(step.getParmParameters());
            parserStep.setMaxRc(this.computeMaxRc(step, i, jclResult.getSteps()));
            for (IJclResultDataDef dd : step.getDataDefs()) {
                ArrayList<IImporterDataset> iDatasets = new ArrayList<IImporterDataset>();
                ArrayList<IJclResultDataSet> jDatasets = new ArrayList<IJclResultDataSet>();
                jDatasets.add(dd.getDataset());
                jDatasets.addAll(dd.getDatasets());
                for (IJclResultDataSet jDataset : jDatasets) {
                    iDatasets.add(ImporterFactory.createDataset(dd, jDataset, zPrefix));
                }
                parserStep.getDatasets().put(dd.getName(), iDatasets);
            }
            result.getSteps().add(parserStep);
            ++i;
        }
        mnm.leave(new String[0]);
        return result;
    }

    private int computeMaxRc(IJclResultStep currentStep, int stepIndex, List<IJclResultStep> steps) {
        int maxRc = 4;
        int j = stepIndex + 1;
        while (j < steps.size()) {
            IJclResultStep laterStep = steps.get(j);
            IJclResultCondition condition = laterStep.getCondition();
            if (condition != null) {
                int c = 0;
                while (c < 2) {
                    String step;
                    String code = c == 0 ? condition.getCode1() : condition.getCode2();
                    String op = c == 0 ? condition.getOp1() : condition.getOp2();
                    String string = step = c == 0 ? condition.getStep1() : condition.getStep2();
                    if (op != null && (step == null || step.equals(currentStep.getName())) && ("GT".equalsIgnoreCase(op) || "GE".equalsIgnoreCase(op))) {
                        try {
                            int numericCode = Integer.valueOf(code);
                            if ("GT".equalsIgnoreCase(op)) {
                                ++numericCode;
                            }
                            if (maxRc == 0 || numericCode < maxRc) {
                                maxRc = numericCode;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    ++c;
                }
            }
            ++j;
        }
        return maxRc;
    }
}

