/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.builder;

import com.ibm.team.build.extensions.common.util.StringUtil;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterDataset;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterStep;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterToken;
import com.ibm.team.enterprise.systemdefinition.client.builder.BuilderBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterDataset;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLibrary;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterOption;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParameter;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParserStep;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterResource;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepSld;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterTranslator;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BuilderStepSld
extends ImporterStep
implements IImporterStepSld {
    protected String optionOther;
    protected String resourceSldlogic;
    protected String resourceSysadata;
    protected int maxRc;
    protected List<IImporterDataset> resourceTasklib;

    public BuilderStepSld() {
    }

    public BuilderStepSld(IImporterLanguage imported) {
        super(imported);
        for (IImporterTranslator translator : imported.getTranslators()) {
            if (!translator.getName().equals("SLD")) continue;
            this.buildOptions = new BuilderBuildOptions(StringUtil.toTitle((String)"SLD"));
            for (IImporterOption option : translator.getOptions()) {
                if (option.getName().equals("compile")) {
                    this.buildOptions.setCompile(option.getState());
                    this.buildOptions.setCompileEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("initial")) {
                    this.buildOptions.setInitial(option.getState());
                    this.buildOptions.setInitialEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("library")) {
                    this.buildOptions.setLibrary(option.getState());
                    this.buildOptions.setLibraryEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("refresh")) {
                    this.buildOptions.setRefresh(option.getState());
                    this.buildOptions.setRefreshEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("service")) {
                    this.buildOptions.setService(option.getState());
                    this.buildOptions.setServiceEnabled(option.getEnabled());
                    continue;
                }
                if (!option.getName().equals("testing")) continue;
                this.buildOptions.setTesting(option.getState());
                this.buildOptions.setTestingEnabled(option.getEnabled());
            }
            for (IImporterParameter parameter : translator.getParameters()) {
                if (!parameter.getName().equals("SLDOTHER")) continue;
                this.setOptionOther(parameter.getValue());
            }
            for (IImporterResource resource : translator.getResources()) {
                if (resource.getName().equals("SLDLOGIC")) {
                    this.setResourceSldlogic(resource.getValue());
                }
                if (!resource.getName().equals("SYSADATA")) continue;
                this.setResourceSysadata(resource.getValue());
            }
            for (IImporterLibrary library : translator.getLibraries()) {
                if (!library.getName().equals("TASKLIB")) continue;
                this.resourceTasklib = new ArrayList<IImporterDataset>();
                for (IImporterResource resource : library.getResources()) {
                    ImporterDataset dataset = new ImporterDataset(resource.getValue(), resource.iszFolder());
                    this.resourceTasklib.add(dataset);
                }
            }
        }
    }

    @Override
    public void init() {
        this.optionOther = "";
        this.resourceSldlogic = "";
        this.resourceSysadata = "";
        this.resourceTasklib = new ArrayList<IImporterDataset>();
        this.buildOptions = new BuilderBuildOptions("SldLogic");
        this.stepName = "SldLogic";
    }

    @Override
    public final void init(IImporterParserStep step) {
        this.init();
        this.setOptionOther(this.getDefaultOtherParameters(step.getParmParameters(), variables));
        this.setResourceSldlogic(this.getDefaultDataset((List)step.getDatasets().get("SLDLOGIC"), this.getResourceSldlogic()));
        this.setResourceSysadata(this.getDefaultDataset((List)step.getDatasets().get("SYSADATA"), this.getResourceSldlogic()));
        this.getDefaultDatasets((List)step.getDatasets().get("STEPLIB"), this.getResourceTasklib());
        this.getDefaultDatasets((List)step.getDatasets().get("TASKLIB"), this.getResourceTasklib());
        this.getBuildOptions().setId(StringUtil.toTitle((String)step.getName()));
        this.setStepName(step.getName());
    }

    @Override
    public void initDefault() {
        this.optionOther = "";
        this.resourceSldlogic = "SLD";
        this.resourceSysadata = "&&ADATA";
        this.resourceTasklib = new ArrayList<IImporterDataset>();
        this.resourceTasklib.add(new ImporterDataset("SLD.LOAD", false));
        this.buildOptions = new BuilderBuildOptions("SldLogic");
        this.stepName = "SldLogic";
    }

    @Override
    public final String getId() {
        return "SLD";
    }

    @Override
    public final String getName(String languageId) {
        return String.format("%1$s.Translator.SLD", languageId);
    }

    @Override
    public final void createDocumentStep(Document document, Element languageElement) {
        Element translatorElement = null;
        Element librariesElement = null;
        Element parameterElement = null;
        Element resourceElement = null;
        translatorElement = document.createElement("translator");
        translatorElement.setAttribute("name", "SLD");
        languageElement.appendChild(translatorElement);
        if (Verification.isNonNull((Object)this.buildOptions)) {
            this.createDocumentOptions(document, translatorElement, this.buildOptions);
        }
        if (Verification.isNonBlank((String)this.optionOther)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "SLDOTHER");
            parameterElement.setTextContent(this.optionOther);
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonBlank((String)this.resourceSldlogic)) {
            resourceElement = document.createElement("resource");
            resourceElement.setAttribute("name", "SLDLOGIC");
            resourceElement.setAttribute("zFolder", "true");
            resourceElement.setTextContent(this.resourceSldlogic);
            translatorElement.appendChild(resourceElement);
        }
        if (Verification.isNonBlank((String)this.resourceSysadata)) {
            resourceElement = document.createElement("resource");
            resourceElement.setAttribute("name", "SYSADATA");
            resourceElement.setTextContent(this.resourceSldlogic);
            translatorElement.appendChild(resourceElement);
        }
        if (Verification.isNonEmpty(this.resourceTasklib)) {
            librariesElement = document.createElement("libraries");
            librariesElement.setAttribute("name", "TASKLIB");
            translatorElement.appendChild(librariesElement);
            for (IImporterDataset dataset : this.resourceTasklib) {
                resourceElement = document.createElement("resource");
                resourceElement.setAttribute("zFolder", Boolean.toString(dataset.iszFolder()));
                resourceElement.setTextContent(dataset.getDataset());
                librariesElement.appendChild(resourceElement);
            }
        }
    }

    @Override
    public void createDocumentOptionsAdditional(Document document, Element translatorElement, IImporterBuildOptions buildOptions) {
    }

    public final void createTokenListStep(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder languageAttributes) {
    }

    @Override
    public void createConditionAttributeAdditional(StringBuilder conditionAttributes, IImporterBuildOptions buildOptions) {
    }

    @Override
    public final void createTokenListStepResource(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder resourceAttributes) {
        if (Verification.isNonBlank((String)this.resourceSldlogic)) {
            this.appendAttribute(resourceAttributes, String.format(" SLDLOGIC=\"%s\"", this.resourceSldlogic));
        }
        if (Verification.isNonBlank((String)this.resourceSysadata)) {
            this.appendAttribute(resourceAttributes, String.format(" SYSADATA=\"%s\"", this.resourceSysadata));
        }
        tokens.add(new ImporterToken("@ATTRIBUTES_SLD_RESOURCE@", resourceAttributes.toString()));
        tokens.add(this.createResourceTasklibElement(language, "@RESOURCE_SLD_TASKLIB@", "<dsn.tasklib>", "</dsn.tasklib>", this.resourceTasklib));
    }

    @Override
    public final void createTokenListStepTranslator(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder translatorAttributes) {
        if (Verification.isNonBlank((String)this.optionOther)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.SLDOTHER=\"%s\"", this.optionOther));
        }
        tokens.add(new ImporterToken("@ATTRIBUTES_SLD_TRANSLATOR@", translatorAttributes.toString()));
        this.createTranslatorTasklibElement(language, tokens, "@TRANSLATOR_SLD_TASKLIB@", "<alloc.tasklib>", "</alloc.tasklib>", "%1$s.Resource.%3$s.TASKLIB", "%1$s.Resource.%3$s.TASKLIB.DSN%2$02d", this.resourceTasklib);
    }

    @Override
    public void createTranslatorSyslibElementAdditional(IImporterLanguage language, List<IImporterToken> tokens, List<IImporterDataset> datasets) {
    }

    public final String getOptionOther() {
        return this.optionOther;
    }

    public final void setOptionOther(String optionOther) {
        this.optionOther = optionOther;
    }

    public final String getResourceSldlogic() {
        return this.resourceSldlogic;
    }

    public final void setResourceSldlogic(String resourceSldlogic) {
        this.resourceSldlogic = resourceSldlogic;
    }

    public final String getResourceSysadata() {
        return this.resourceSysadata;
    }

    public final void setResourceSysadata(String resourceSysadata) {
        this.resourceSysadata = resourceSysadata;
    }

    public final List<IImporterDataset> getResourceTasklib() {
        return this.resourceTasklib;
    }

    public final void setResourceTasklib(List<IImporterDataset> resourceTasklib) {
        this.resourceTasklib = resourceTasklib;
    }

    public int getMaxRc() {
        return this.maxRc;
    }

    public void setMaxRc(int maxRc) {
        this.maxRc = maxRc;
    }
}

