/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.builder;

import com.ibm.team.build.extensions.common.util.StringUtil;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterDataset;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterStep;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterToken;
import com.ibm.team.enterprise.systemdefinition.client.builder.BuilderBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterDataset;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLibrary;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterOption;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParameter;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParserStep;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterResource;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepLnk;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterTranslator;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterVariables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BuilderStepLnk
extends ImporterStep
implements IImporterStepLnk {
    protected IImporterVariables.BinderCall optionCall;
    protected IImporterVariables.BinderLet optionLet;
    protected IImporterVariables.BinderReus optionReus;
    protected IImporterVariables.BinderXref optionXref;
    protected String optionOther;
    protected String resourceSyslin;
    protected String resourceSyslmod;
    protected String resourceSysprint;
    protected int maxRc;
    protected List<IImporterDataset> resourceTasklib;

    public BuilderStepLnk() {
    }

    public BuilderStepLnk(IImporterLanguage imported) {
        super(imported);
        for (IImporterTranslator translator : imported.getTranslators()) {
            if (!translator.getName().equals("LNK")) continue;
            this.buildOptions = new BuilderBuildOptions(StringUtil.toTitle((String)"LNK"));
            for (IImporterOption option : translator.getOptions()) {
                if (option.getName().equals("compile")) {
                    this.buildOptions.setCompile(option.getState());
                    this.buildOptions.setCompileEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("initial")) {
                    this.buildOptions.setInitial(option.getState());
                    this.buildOptions.setInitialEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("library")) {
                    this.buildOptions.setLibrary(option.getState());
                    this.buildOptions.setLibraryEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("refresh")) {
                    this.buildOptions.setRefresh(option.getState());
                    this.buildOptions.setRefreshEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("service")) {
                    this.buildOptions.setService(option.getState());
                    this.buildOptions.setServiceEnabled(option.getEnabled());
                    continue;
                }
                if (!option.getName().equals("testing")) continue;
                this.buildOptions.setTesting(option.getState());
                this.buildOptions.setTestingEnabled(option.getEnabled());
            }
            for (IImporterParameter parameter : translator.getParameters()) {
                if (parameter.getName().equals("LNKCALL")) {
                    this.setOptionCall(IImporterVariables.BinderCall.get((String)parameter.getValue()));
                    continue;
                }
                if (parameter.getName().equals("LNKLET")) {
                    this.setOptionLet(IImporterVariables.BinderLet.get((String)parameter.getValue()));
                    continue;
                }
                if (parameter.getName().equals("LNKOTHER")) {
                    this.setOptionOther(parameter.getValue());
                    continue;
                }
                if (parameter.getName().equals("LNKREUS")) {
                    this.setOptionReus(IImporterVariables.BinderReus.get((String)parameter.getValue()));
                    continue;
                }
                if (!parameter.getName().equals("LNKXREF")) continue;
                this.setOptionXref(IImporterVariables.BinderXref.get((String)parameter.getValue()));
            }
            for (IImporterResource resource : translator.getResources()) {
                if (resource.getName().equals("SYSLIN")) {
                    this.setResourceSyslmod(resource.getValue());
                    continue;
                }
                if (resource.getName().equals("SYSLMOD")) {
                    this.setResourceSyslmod(resource.getValue());
                    continue;
                }
                if (!resource.getName().equals("SYSPRINT")) continue;
                this.setResourceSysprint(resource.getValue());
            }
            for (IImporterLibrary library : translator.getLibraries()) {
                if (!library.getName().equals("TASKLIB")) continue;
                this.resourceTasklib = new ArrayList<IImporterDataset>();
                for (IImporterResource resource : library.getResources()) {
                    ImporterDataset dataset = new ImporterDataset(resource.getValue(), resource.iszFolder());
                    this.resourceTasklib.add(dataset);
                }
            }
        }
    }

    @Override
    public void init() {
        this.optionCall = null;
        this.optionLet = null;
        this.optionReus = null;
        this.optionXref = null;
        this.optionOther = "";
        this.resourceSyslin = "";
        this.resourceSyslmod = "";
        this.resourceSysprint = "";
        this.resourceTasklib = new ArrayList<IImporterDataset>();
        this.buildOptions = new BuilderBuildOptions("Linkedit");
        this.stepName = "Linkedit";
    }

    @Override
    public final void init(IImporterParserStep step) {
        this.init();
        this.setOptionCall((IImporterVariables.BinderCall)this.getDefaultParameter(step.getParmParameters(), (IImporterVariables.Variable)new IImporterVariables.VariableBinderCall()));
        this.setOptionLet((IImporterVariables.BinderLet)this.getDefaultParameter(step.getParmParameters(), (IImporterVariables.Variable)new IImporterVariables.VariableBinderLet()));
        this.setOptionReus((IImporterVariables.BinderReus)this.getDefaultParameter(step.getParmParameters(), (IImporterVariables.Variable)new IImporterVariables.VariableBinderReus()));
        this.setOptionXref((IImporterVariables.BinderXref)this.getDefaultParameter(step.getParmParameters(), (IImporterVariables.Variable)new IImporterVariables.VariableBinderXref()));
        this.setOptionOther(this.getDefaultOtherParameters(step.getParmParameters(), variables));
        this.setResourceSyslin(this.getDefaultDataset((List)step.getDatasets().get("SYSLIN"), this.getResourceSyslin()));
        this.setResourceSyslmod(this.getDefaultDataset((List)step.getDatasets().get("SYSLMOD"), this.getResourceSyslmod()));
        this.setResourceSysprint(this.getDefaultDataset((List)step.getDatasets().get("SYSPRINT"), this.getResourceSysprint()));
        this.getDefaultDatasets((List)step.getDatasets().get("STEPLIB"), this.getResourceTasklib());
        this.getDefaultDatasets((List)step.getDatasets().get("TASKLIB"), this.getResourceTasklib());
        this.getBuildOptions().setId(StringUtil.toTitle((String)step.getName()));
        this.setStepName(step.getName());
    }

    @Override
    public void initDefault() {
        this.optionCall = IImporterVariables.BinderCall.NCAL;
        this.optionLet = IImporterVariables.BinderLet.LET;
        this.optionReus = IImporterVariables.BinderReus.NONE;
        this.optionXref = IImporterVariables.BinderXref.XREF;
        this.optionOther = "";
        this.resourceSyslin = "OBJ";
        this.resourceSyslmod = "LIB";
        this.resourceSysprint = "PRT.LNK";
        this.resourceTasklib = new ArrayList<IImporterDataset>();
        this.buildOptions = new BuilderBuildOptions("Linkedit");
        this.stepName = "Linkedit";
    }

    @Override
    public final String getId() {
        return "LNK";
    }

    @Override
    public final String getName(String languageId) {
        return String.format("%1$s.Translator.LNK", languageId);
    }

    @Override
    public final void createDocumentStep(Document document, Element languageElement) {
        Element translatorElement = null;
        Element librariesElement = null;
        Element parameterElement = null;
        Element resourceElement = null;
        translatorElement = document.createElement("translator");
        translatorElement.setAttribute("name", "LNK");
        languageElement.appendChild(translatorElement);
        if (Verification.isNonNull((Object)this.buildOptions)) {
            this.createDocumentOptions(document, translatorElement, this.buildOptions);
        }
        if (Verification.isNonNull((Object)this.optionCall)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "LNKCALL");
            parameterElement.setTextContent(this.optionCall.toString());
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonNull((Object)this.optionLet)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "LNKLET");
            parameterElement.setTextContent(this.optionLet.toString());
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonBlank((String)this.optionOther)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "LNKOTHER");
            parameterElement.setTextContent(this.optionOther);
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonNull((Object)this.optionReus)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "LNKREUS");
            parameterElement.setTextContent(this.optionReus.toString());
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonNull((Object)this.optionXref)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "LNKXREF");
            parameterElement.setTextContent(this.optionXref.toString());
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonBlank((String)this.resourceSyslin)) {
            resourceElement = document.createElement("resource");
            resourceElement.setAttribute("name", "SYSLIN");
            resourceElement.setAttribute("zFolder", "true");
            resourceElement.setTextContent(this.resourceSyslin);
            translatorElement.appendChild(resourceElement);
        }
        if (Verification.isNonBlank((String)this.resourceSyslmod)) {
            resourceElement = document.createElement("resource");
            resourceElement.setAttribute("name", "SYSLMOD");
            resourceElement.setAttribute("zFolder", "true");
            resourceElement.setTextContent(this.resourceSyslmod);
            translatorElement.appendChild(resourceElement);
        }
        if (Verification.isNonBlank((String)this.resourceSysprint)) {
            resourceElement = document.createElement("resource");
            resourceElement.setAttribute("name", "SYSPRINT");
            resourceElement.setAttribute("zFolder", "true");
            resourceElement.setTextContent(this.resourceSysprint);
            translatorElement.appendChild(resourceElement);
        }
        if (Verification.isNonEmpty(this.resourceTasklib)) {
            librariesElement = document.createElement("libraries");
            librariesElement.setAttribute("name", "TASKLIB");
            translatorElement.appendChild(librariesElement);
            for (IImporterDataset dataset : this.resourceTasklib) {
                resourceElement = document.createElement("resource");
                resourceElement.setAttribute("zFolder", Boolean.toString(dataset.iszFolder()));
                resourceElement.setTextContent(dataset.getDataset());
                librariesElement.appendChild(resourceElement);
            }
        }
    }

    @Override
    public void createDocumentOptionsAdditional(Document document, Element translatorElement, IImporterBuildOptions buildOptions) {
    }

    public final void createTokenListStep(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder languageAttributes) {
    }

    @Override
    public void createConditionAttributeAdditional(StringBuilder conditionAttributes, IImporterBuildOptions buildOptions) {
    }

    @Override
    public final void createTokenListStepResource(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder resourceAttributes) {
        if (Verification.isNonBlank((String)this.resourceSyslin)) {
            this.appendAttribute(resourceAttributes, String.format(" SYSLIN=\"%s\"", this.resourceSyslin));
        }
        if (Verification.isNonBlank((String)this.resourceSyslmod)) {
            this.appendAttribute(resourceAttributes, String.format(" SYSLMOD=\"%s\"", this.resourceSyslmod));
        }
        if (Verification.isNonBlank((String)this.resourceSysprint)) {
            this.appendAttribute(resourceAttributes, String.format(" SYSPRINT=\"%s\"", this.resourceSysprint));
        }
        tokens.add(new ImporterToken("@ATTRIBUTES_LNK_RESOURCE@", resourceAttributes.toString()));
        tokens.add(this.createResourceTasklibElement(language, "@RESOURCE_LNK_TASKLIB@", "<dsn.tasklib>", "</dsn.tasklib>", this.resourceTasklib));
    }

    @Override
    public final void createTokenListStepTranslator(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder translatorAttributes) {
        if (Verification.isNonNull((Object)this.optionCall)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.LNKCALL=\"%s\"", this.optionCall.toString()));
        }
        if (Verification.isNonNull((Object)this.optionLet)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.LNKLET=\"%s\"", this.optionLet.getText()));
        }
        if (Verification.isNonBlank((String)this.optionOther)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.LNKOTHER=\"%s\"", this.optionOther));
        }
        if (Verification.isNonNull((Object)this.optionReus)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.LNKREUS=\"%s\"", this.optionReus.toString()));
        }
        if (Verification.isNonNull((Object)this.optionXref)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.LNKXREF=\"%s\"", this.optionXref.toString()));
        }
        tokens.add(new ImporterToken("@ATTRIBUTES_LNK_TRANSLATOR@", translatorAttributes.toString()));
        this.createTranslatorTasklibElement(language, tokens, "@TRANSLATOR_LNK_TASKLIB@", "<alloc.tasklib>", "</alloc.tasklib>", "%1$s.Resource.%3$s.TASKLIB", "%1$s.Resource.%3$s.TASKLIB.DSN%2$02d", this.resourceTasklib);
    }

    @Override
    public void createTranslatorSyslibElementAdditional(IImporterLanguage language, List<IImporterToken> tokens, List<IImporterDataset> datasets) {
    }

    public final IImporterVariables.BinderCall getOptionCall() {
        return this.optionCall;
    }

    public final void setOptionCall(IImporterVariables.BinderCall optionCall) {
        this.optionCall = optionCall;
    }

    public final IImporterVariables.BinderLet getOptionLet() {
        return this.optionLet;
    }

    public final void setOptionLet(IImporterVariables.BinderLet optionLet) {
        this.optionLet = optionLet;
    }

    public final String getOptionOther() {
        return this.optionOther;
    }

    public final void setOptionOther(String optionOther) {
        this.optionOther = optionOther;
    }

    public final IImporterVariables.BinderReus getOptionReus() {
        return this.optionReus;
    }

    public final void setOptionReus(IImporterVariables.BinderReus optionReus) {
        this.optionReus = optionReus;
    }

    public final IImporterVariables.BinderXref getOptionXref() {
        return this.optionXref;
    }

    public final void setOptionXref(IImporterVariables.BinderXref optionXref) {
        this.optionXref = optionXref;
    }

    public final String getResourceSyslin() {
        return this.resourceSyslin;
    }

    public final void setResourceSyslin(String resourceSyslin) {
        this.resourceSyslin = resourceSyslin;
    }

    public final String getResourceSyslmod() {
        return this.resourceSyslmod;
    }

    public final void setResourceSyslmod(String resourceSyslmod) {
        this.resourceSyslmod = resourceSyslmod;
    }

    public final String getResourceSysprint() {
        return this.resourceSysprint;
    }

    public final void setResourceSysprint(String resourceSysprint) {
        this.resourceSysprint = resourceSysprint;
    }

    public final List<IImporterDataset> getResourceTasklib() {
        return this.resourceTasklib;
    }

    public final void setResourceTasklib(List<IImporterDataset> resourceTasklib) {
        this.resourceTasklib = resourceTasklib;
    }

    public int getMaxRc() {
        return this.maxRc;
    }

    public void setMaxRc(int maxRc) {
        this.maxRc = maxRc;
    }

    public Map<String, Function<IImporterStepLnk, IImporterVariables.VariableParam>> getAllParameters() {
        HashMap<String, Function<IImporterStepLnk, IImporterVariables.VariableParam>> functionsMap = new HashMap<String, Function<IImporterStepLnk, IImporterVariables.VariableParam>>();
        functionsMap.put(IImporterVariables.BinderCall.class.getSimpleName(), step -> {
            IImporterVariables.BinderCall option = step.getOptionCall();
            return new IImporterVariables.VariableParam(IImporterVariables.BinderCall.getLabels(), option == null ? null : Integer.valueOf(IImporterVariables.BinderCall.getIndex((IImporterVariables.BinderCall)option)));
        });
        functionsMap.put(IImporterVariables.BinderLet.class.getSimpleName(), step -> {
            IImporterVariables.BinderLet option = step.getOptionLet();
            return new IImporterVariables.VariableParam(IImporterVariables.BinderLet.getLabels(), option == null ? null : Integer.valueOf(IImporterVariables.BinderLet.getIndex((IImporterVariables.BinderLet)option)));
        });
        functionsMap.put(IImporterVariables.BinderReus.class.getSimpleName(), step -> {
            IImporterVariables.BinderReus option = step.getOptionReus();
            return new IImporterVariables.VariableParam(IImporterVariables.BinderReus.getLabels(), option == null ? null : Integer.valueOf(IImporterVariables.BinderReus.getIndex((IImporterVariables.BinderReus)option)));
        });
        functionsMap.put(IImporterVariables.BinderXref.class.getSimpleName(), step -> {
            IImporterVariables.BinderXref option = step.getOptionXref();
            return new IImporterVariables.VariableParam(IImporterVariables.BinderXref.getLabels(), option == null ? null : Integer.valueOf(IImporterVariables.BinderXref.getIndex((IImporterVariables.BinderXref)option)));
        });
        return functionsMap;
    }
}

