/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.builder;

import com.ibm.team.build.extensions.common.util.StringUtil;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterDataset;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterStep;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterToken;
import com.ibm.team.enterprise.systemdefinition.client.builder.BuilderBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterDataset;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLibrary;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterOption;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParameter;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParserStep;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterResource;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepIrx;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BuilderStepIrx
extends ImporterStep
implements IImporterStepIrx {
    private String optionOther;
    private String dsNameSysexec;
    private IImporterDataset resourceSysexec;
    private List<IImporterDataset> resourceTasklib;
    private IImporterParserStep step;
    private int maxRc;

    public BuilderStepIrx() {
    }

    public BuilderStepIrx(IImporterLanguage imported) {
        super(imported);
        for (IImporterTranslator translator : imported.getTranslators()) {
            if (!translator.getName().equals("IRX")) continue;
            this.buildOptions = new BuilderBuildOptions(StringUtil.toTitle((String)"IRX"));
            for (IImporterOption option : translator.getOptions()) {
                if (option.getName().equals("compile")) {
                    this.buildOptions.setCompile(option.getState());
                    this.buildOptions.setCompileEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("initial")) {
                    this.buildOptions.setInitial(option.getState());
                    this.buildOptions.setInitialEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("library")) {
                    this.buildOptions.setLibrary(option.getState());
                    this.buildOptions.setLibraryEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("refresh")) {
                    this.buildOptions.setRefresh(option.getState());
                    this.buildOptions.setRefreshEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("service")) {
                    this.buildOptions.setService(option.getState());
                    this.buildOptions.setServiceEnabled(option.getEnabled());
                    continue;
                }
                if (!option.getName().equals("testing")) continue;
                this.buildOptions.setTesting(option.getState());
                this.buildOptions.setTestingEnabled(option.getEnabled());
            }
            for (IImporterParameter parameter : translator.getParameters()) {
                if (!parameter.getName().equals("IRXOTHER")) continue;
                this.setOptionOther(parameter.getValue());
            }
            for (IImporterResource resource : translator.getResources()) {
                if (!resource.getName().equals("SYSEXEC")) continue;
                this.setDsNameSysexec(resource.getValue());
            }
            for (IImporterLibrary library : translator.getLibraries()) {
                if (!library.getName().equals("TASKLIB")) continue;
                this.resourceTasklib = new ArrayList<IImporterDataset>();
                for (IImporterResource resource : library.getResources()) {
                    ImporterDataset dataset = new ImporterDataset(resource.getValue(), resource.iszFolder());
                    this.resourceTasklib.add(dataset);
                }
            }
        }
    }

    @Override
    public void init() {
        this.optionOther = "";
        this.dsNameSysexec = "";
        this.resourceTasklib = new ArrayList<IImporterDataset>();
        this.buildOptions = new BuilderBuildOptions("RexxExec");
        this.stepName = "RexxExec";
    }

    @Override
    public final void init(IImporterParserStep step) {
        this.init();
        this.setOptionOther(this.getDefaultOtherParameters(step.getParmParameters(), variables));
        this.setDsNameSysexec(this.getDefaultDataset((List)step.getDatasets().get("SYSEXEC"), this.getDsNameSysexec()));
        this.setResourceSysexec(this.getDefaultResource((List)step.getDatasets().get("SYSEXEC")));
        this.getDefaultDatasets((List)step.getDatasets().get("STEPLIB"), this.getResourceTasklib());
        this.getDefaultDatasets((List)step.getDatasets().get("TASKLIB"), this.getResourceTasklib());
        this.getBuildOptions().setId(StringUtil.toTitle((String)step.getName()));
        this.setStepName(step.getName());
        this.step = step;
        if (this.getResourceSysexec().iszDataset()) {
            this.getResourceSysexec().setzFolder(true);
            this.getResourceSysexec().getDsdef().setUsageType(0);
        }
    }

    @Override
    public void initDefault() {
        this.optionOther = "";
        this.dsNameSysexec = "BLZ.SBLZEXEC";
        this.resourceTasklib = new ArrayList<IImporterDataset>();
        this.resourceTasklib.add(new ImporterDataset("SYS1.LPALIB", false));
        this.buildOptions = new BuilderBuildOptions("RexxExec");
        this.stepName = "RexxExec";
    }

    @Override
    public final String getId() {
        return "IRX";
    }

    @Override
    public final String getName(String languageId) {
        return String.format("%1$s.Translator.IRX.%2$s", languageId, this.getStepName());
    }

    @Override
    public final void createDocumentStep(Document document, Element languageElement) {
        Element translatorElement = null;
        Element librariesElement = null;
        Element parameterElement = null;
        Element resourceElement = null;
        translatorElement = document.createElement("translator");
        translatorElement.setAttribute("name", "IRX");
        languageElement.appendChild(translatorElement);
        if (Verification.isNonNull((Object)this.buildOptions)) {
            this.createDocumentOptions(document, translatorElement, this.buildOptions);
        }
        if (Verification.isNonBlank((String)this.optionOther)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "IRXOTHER");
            parameterElement.setTextContent(this.optionOther);
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonBlank((String)this.dsNameSysexec)) {
            resourceElement = document.createElement("resource");
            resourceElement.setAttribute("name", "SYSEXEC");
            resourceElement.setAttribute("zFolder", "false");
            resourceElement.setTextContent(this.dsNameSysexec);
            translatorElement.appendChild(resourceElement);
        }
        if (Verification.isNonEmpty(this.resourceTasklib)) {
            librariesElement = document.createElement("libraries");
            librariesElement.setAttribute("name", "TASKLIB");
            translatorElement.appendChild(librariesElement);
            for (IImporterDataset dataset : this.resourceTasklib) {
                resourceElement = document.createElement("resource");
                resourceElement.setAttribute("zFolder", Boolean.toString(dataset.iszFolder()));
                resourceElement.setTextContent(dataset.getDataset());
                librariesElement.appendChild(resourceElement);
            }
        }
    }

    @Override
    public void createDocumentOptionsAdditional(Document document, Element translatorElement, IImporterBuildOptions buildOptions) {
    }

    public final void createTokenListStep(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder languageAttributes) {
        tokens.add(new ImporterToken("@LANGUAGE_STEP@", this.getStepName(), this));
    }

    @Override
    public void createConditionAttributeAdditional(StringBuilder conditionAttributes, IImporterBuildOptions buildOptions) {
    }

    @Override
    public final void createTokenListStepResource(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder resourceAttributes) {
        if (Verification.isNonBlank((String)this.dsNameSysexec)) {
            this.appendAttribute(resourceAttributes, String.format(" SYSEXEC=\"%s\"", this.dsNameSysexec));
        }
        tokens.add(new ImporterToken("@ATTRIBUTES_IRX_RESOURCE@", resourceAttributes.toString(), this));
        if (this.step != null) {
            HashSet<IResourceDefinition> dsdefs = new HashSet<IResourceDefinition>();
            for (String dd : this.step.getDatasets().keySet()) {
                if (IImporterStepIrx.resources.contains(dd) || !this.step.hasDataset(dd)) continue;
                IDataSetDefinition dsdef = this.step.getDataset(dd).getDsdef();
                dsdef.setName(String.format("%1$s.Resource.%3$s.%4$s.%2$s", language.getId(), dd, this.getId(), this.getStepName()));
                dsdefs.add((IResourceDefinition)dsdef);
            }
            if (dsdefs.size() > 0) {
                tokens.add(this.createResourceOtherDSElement("@RESOURCE_IRX_OTHERDS@", "<dsn.otherds>", "</dsn.otherds>", dsdefs, this));
            }
        }
        tokens.add(this.createResourceTasklibElement(language, "@RESOURCE_IRX_TASKLIB@", "<dsn.tasklib>", "</dsn.tasklib>", this.resourceTasklib, this));
    }

    @Override
    public final void createTokenListStepTranslator(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder translatorAttributes) {
        if (Verification.isNonBlank((String)this.optionOther)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.IRXOTHER=\"%s\"", this.optionOther));
        }
        tokens.add(new ImporterToken("@ATTRIBUTES_IRX_TRANSLATOR@", translatorAttributes.toString(), this));
        if (this.step != null) {
            ArrayList<String> dds = new ArrayList<String>(this.step.getDatasets().keySet());
            for (String dd : this.step.getDatasets().keySet()) {
                if (!IImporterStepIrx.resources.contains(dd) && this.step.hasDataset(dd)) continue;
                dds.remove(dd);
            }
            if (dds.size() > 0) {
                this.createTranslatorOtherDDElement(language, tokens, "@TRANSLATOR_IRX_OTHERDD@", "<alloc.otherdd>", "</alloc.otherdd>", "%1$s.Resource.%3$s.%4$s.%2$s", dds, this);
            }
        }
        this.createTranslatorTasklibElement(language, tokens, "@TRANSLATOR_IRX_TASKLIB@", "<alloc.tasklib>", "</alloc.tasklib>", "%1$s.Resource.%3$s.%4$s.TASKLIB", "%1$s.Resource.%3$s.%4$s.TASKLIB.DSN%2$02d", this.resourceTasklib, this);
    }

    @Override
    public void createTranslatorSyslibElementAdditional(IImporterLanguage language, List<IImporterToken> tokens, List<IImporterDataset> datasets) {
    }

    public final String getOptionOther() {
        return this.optionOther;
    }

    public final void setOptionOther(String optionOther) {
        this.optionOther = optionOther;
    }

    public final String getDsNameSysexec() {
        return this.dsNameSysexec;
    }

    public final void setDsNameSysexec(String dsNameSysexec) {
        this.dsNameSysexec = dsNameSysexec;
    }

    public final IImporterDataset getResourceSysexec() {
        return this.resourceSysexec;
    }

    public final void setResourceSysexec(IImporterDataset resourceSysexec) {
        this.resourceSysexec = resourceSysexec;
    }

    public final List<IImporterDataset> getResourceTasklib() {
        return this.resourceTasklib;
    }

    public final void setResourceTasklib(List<IImporterDataset> resourceTasklib) {
        this.resourceTasklib = resourceTasklib;
    }

    public final IImporterParserStep getStep() {
        return this.step;
    }

    public int getMaxRc() {
        return this.maxRc;
    }

    public void setMaxRc(int maxRc) {
        this.maxRc = maxRc;
    }
}

