/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.builder;

import com.ibm.team.build.extensions.common.util.StringUtil;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterDataset;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterStep;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterToken;
import com.ibm.team.enterprise.systemdefinition.client.builder.BuilderBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterDataset;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLibrary;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParameter;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParserStep;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterResource;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepDef;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BuilderStepDef
extends ImporterStep
implements IImporterStepDef {
    private String optionOther;
    private List<IImporterDataset> resourceTasklib;
    private IImporterParserStep step;
    private int maxRc;

    public BuilderStepDef() {
    }

    public BuilderStepDef(IImporterLanguage imported) {
        super(imported);
        imported.getTranslators().stream().forEach(this::handleTranslator);
    }

    private void handleTranslator(IImporterTranslator translator) {
        this.addOptions(translator.getOptions());
        this.addParameters(translator.getParameters());
        this.addResources(translator.getResources());
        this.addLibraries(translator.getLibraries());
    }

    private void addParameters(List<IImporterParameter> parameters) {
        for (IImporterParameter parameter : parameters) {
            if (!parameter.getName().equals("DEFOTHER")) continue;
            this.setOptionOther(parameter.getValue());
        }
    }

    private void addResources(List<IImporterResource> resources) {
    }

    private void addLibraries(List<IImporterLibrary> libraries) {
        for (IImporterLibrary library : libraries) {
            if (!library.getName().equals("TASKLIB")) continue;
            this.resourceTasklib = new ArrayList<IImporterDataset>();
            for (IImporterResource resource : library.getResources()) {
                ImporterDataset dataset = new ImporterDataset(resource.getValue(), resource.iszFolder());
                this.resourceTasklib.add(dataset);
            }
        }
    }

    @Override
    public void init() {
        this.optionOther = "";
        this.resourceTasklib = new ArrayList<IImporterDataset>();
        this.buildOptions = new BuilderBuildOptions("Default");
        this.stepName = "Default";
    }

    @Override
    public final void init(IImporterParserStep step) {
        this.init();
        this.setOptionOther(this.getDefaultOtherParameters(step.getParmParameters(), variables));
        this.getDefaultDatasets((List)step.getDatasets().get("STEPLIB"), this.getResourceTasklib());
        this.getDefaultDatasets((List)step.getDatasets().get("TASKLIB"), this.getResourceTasklib());
        this.getBuildOptions().setId(StringUtil.toTitle((String)step.getName()));
        this.setStepName(step.getName());
        this.step = step;
    }

    @Override
    public void initDefault() {
        this.optionOther = "";
        this.resourceTasklib = new ArrayList<IImporterDataset>();
        this.buildOptions = new BuilderBuildOptions("Default");
        this.stepName = "Default";
    }

    @Override
    public final String getId() {
        return "DEF";
    }

    @Override
    public final String getName(String languageId) {
        return String.format("%1$s.Translator.DEF", languageId, this.getStepName());
    }

    @Override
    public final void createDocumentStep(Document document, Element languageElement) {
        Element translatorElement = null;
        Element librariesElement = null;
        Element parameterElement = null;
        Element resourceElement = null;
        translatorElement = document.createElement("translator");
        translatorElement.setAttribute("name", "DEF");
        languageElement.appendChild(translatorElement);
        if (Verification.isNonNull((Object)this.buildOptions)) {
            this.createDocumentOptions(document, translatorElement, this.buildOptions);
        }
        if (Verification.isNonBlank((String)this.optionOther)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "DEFOTHER");
            parameterElement.setTextContent(this.optionOther);
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonEmpty(this.resourceTasklib)) {
            librariesElement = document.createElement("libraries");
            librariesElement.setAttribute("name", "TASKLIB");
            translatorElement.appendChild(librariesElement);
            for (IImporterDataset dataset : this.resourceTasklib) {
                resourceElement = document.createElement("resource");
                resourceElement.setAttribute("zFolder", Boolean.toString(dataset.iszFolder()));
                resourceElement.setTextContent(dataset.getDataset());
                librariesElement.appendChild(resourceElement);
            }
        }
    }

    @Override
    public void createDocumentOptionsAdditional(Document document, Element translatorElement, IImporterBuildOptions buildOptions) {
    }

    public final void createTokenListStep(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder languageAttributes) {
        tokens.add(new ImporterToken("@LANGUAGE_STEP@", this.getStepName(), this));
    }

    @Override
    public void createConditionAttributeAdditional(StringBuilder conditionAttributes, IImporterBuildOptions buildOptions) {
    }

    @Override
    public final void createTokenListStepResource(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder resourceAttributes) {
        tokens.add(new ImporterToken("@ATTRIBUTES_DEF_RESOURCE@", resourceAttributes.toString(), this));
        if (this.step != null) {
            HashSet<IResourceDefinition> dsdefs = new HashSet<IResourceDefinition>();
            for (String dd : this.step.getDatasets().keySet()) {
                if (IImporterStepDef.resources.contains(dd) || !this.step.hasDataset(dd)) continue;
                IDataSetDefinition dsdef = this.step.getDataset(dd).getDsdef();
                dsdef.setName(String.format("%1$s.Resource.%3$s.%4$s.%2$s", language.getId(), dd, this.getId(), this.getStepName()));
                dsdefs.add((IResourceDefinition)dsdef);
            }
            if (dsdefs.size() > 0) {
                tokens.add(this.createResourceOtherDSElement("@RESOURCE_DEF_OTHERDS@", "<dsn.otherds>", "</dsn.otherds>", dsdefs, this));
            }
        }
        tokens.add(this.createResourceTasklibElement(language, "@RESOURCE_DEF_TASKLIB@", "<dsn.tasklib>", "</dsn.tasklib>", this.resourceTasklib, this));
    }

    @Override
    public final void createTokenListStepTranslator(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder translatorAttributes) {
        if (Verification.isNonBlank((String)this.optionOther)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.DEFOTHER=\"%s\"", this.optionOther));
        }
        tokens.add(new ImporterToken("@ATTRIBUTES_DEF_TRANSLATOR@", translatorAttributes.toString(), this));
        if (this.step != null) {
            ArrayList<String> dds = new ArrayList<String>(this.step.getDatasets().keySet());
            for (String dd : this.step.getDatasets().keySet()) {
                if (!IImporterStepDef.resources.contains(dd) && this.step.hasDataset(dd)) continue;
                dds.remove(dd);
            }
            if (dds.size() > 0) {
                this.createTranslatorOtherDDElement(language, tokens, "@TRANSLATOR_DEF_OTHERDD@", "<alloc.otherdd>", "</alloc.otherdd>", "%1$s.Resource.%3$s.%4$s.%2$s", dds, this);
            }
        }
        this.createTranslatorTasklibElement(language, tokens, "@TRANSLATOR_DEF_TASKLIB@", "<alloc.tasklib>", "</alloc.tasklib>", "%1$s.Resource.%3$s.TASKLIB", "%1$s.Resource.%3$s.TASKLIB.DSN%2$02d", this.resourceTasklib, this);
    }

    @Override
    public void createTranslatorSyslibElementAdditional(IImporterLanguage language, List<IImporterToken> tokens, List<IImporterDataset> datasets) {
    }

    public final String getOptionOther() {
        return this.optionOther;
    }

    public final void setOptionOther(String optionOther) {
        this.optionOther = optionOther;
    }

    public final List<IImporterDataset> getResourceTasklib() {
        return this.resourceTasklib;
    }

    public final void setResourceTasklib(List<IImporterDataset> resourceTasklib) {
        this.resourceTasklib = resourceTasklib;
    }

    public final IImporterParserStep getStep() {
        return this.step;
    }

    public int getMaxRc() {
        return this.maxRc;
    }

    public void setMaxRc(int maxRc) {
        this.maxRc = maxRc;
    }
}

