/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.builder;

import com.ibm.team.build.extensions.common.util.StringUtil;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterDataset;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterStep;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterToken;
import com.ibm.team.enterprise.systemdefinition.client.builder.BuilderBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterDataset;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLibrary;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParameter;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParserStep;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterResource;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepCob;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterTranslator;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterVariables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BuilderStepCob
extends ImporterStep
implements IImporterStepCob {
    private IImporterVariables.CobRent optionRent;
    private IImporterVariables.CobDynam optionDynam;
    private IImporterVariables.CobSql optionSql;
    private String optionOther;
    private String dsNameSysin;
    private String dsNameSyslin;
    private String dsNameSysprint;
    private IImporterDataset resourceSysin;
    private IImporterDataset resourceSyslin;
    private IImporterDataset resourceSysprint;
    private List<IImporterDataset> resourceSyslib;
    private List<IImporterDataset> resourceTasklib;
    private int maxRc;

    public BuilderStepCob() {
    }

    public BuilderStepCob(IImporterLanguage imported) {
        super(imported);
        imported.getTranslators().stream().filter(t -> t.getName().equals("COB")).forEach(this::handleTranslator);
    }

    private void handleTranslator(IImporterTranslator translator) {
        this.addOptions(translator.getOptions());
        this.addParameters(translator.getParameters());
        this.addResources(translator.getResources());
        this.addLibraries(translator.getLibraries());
    }

    private void addParameters(List<IImporterParameter> parameters) {
        for (IImporterParameter parameter : parameters) {
            if (parameter.getName().equals("COBRENT")) {
                this.setOptionRent((IImporterVariables.CobRent)IImporterVariables.CobRent.getProps().get(parameter.getValue()));
                continue;
            }
            if (parameter.getName().equals("COBOTHER")) {
                this.setOptionOther(parameter.getValue());
                continue;
            }
            if (parameter.getName().equals("COBADYNAM")) {
                this.setOptionDynam((IImporterVariables.CobDynam)IImporterVariables.CobDynam.getProps().get(parameter.getValue()));
                continue;
            }
            if (!parameter.getName().equals("COBSQL")) continue;
            this.setOptionSql((IImporterVariables.CobSql)IImporterVariables.CobSql.getProps().get(parameter.getValue()));
        }
    }

    private void addResources(List<IImporterResource> resources) {
        for (IImporterResource resource : resources) {
            if (resource.getName().equals("SYSIN")) {
                this.setDsNameSysin(resource.getValue());
                continue;
            }
            if (resource.getName().equals("SYSLIN")) {
                this.setDsNameSyslin(resource.getValue());
                continue;
            }
            if (!resource.getName().equals("SYSPRINT")) continue;
            this.setDsNameSysprint(resource.getValue());
        }
    }

    private void addLibraries(List<IImporterLibrary> libraries) {
        for (IImporterLibrary library : libraries) {
            ImporterDataset dataset;
            if (library.getName().equals("SYSLIB")) {
                this.resourceSyslib = new ArrayList<IImporterDataset>();
                for (IImporterResource resource : library.getResources()) {
                    dataset = new ImporterDataset(resource.getValue(), resource.iszFolder(), resource.isExisting());
                    this.resourceSyslib.add(dataset);
                }
                continue;
            }
            if (!library.getName().equals("TASKLIB")) continue;
            this.resourceTasklib = new ArrayList<IImporterDataset>();
            for (IImporterResource resource : library.getResources()) {
                dataset = new ImporterDataset(resource.getValue(), resource.iszFolder());
                this.resourceTasklib.add(dataset);
            }
        }
    }

    @Override
    public void init() {
        this.optionRent = null;
        this.optionDynam = null;
        this.optionSql = null;
        this.optionOther = "";
        this.dsNameSysin = "";
        this.dsNameSyslin = "";
        this.dsNameSysprint = "";
        this.resourceSyslib = new ArrayList<IImporterDataset>();
        this.resourceTasklib = new ArrayList<IImporterDataset>();
        this.buildOptions = new BuilderBuildOptions("COBOL");
        this.stepName = "COBOL";
    }

    @Override
    public final void init(IImporterParserStep step) {
        this.init();
        this.setOptionRent((IImporterVariables.CobRent)this.getDefaultParameter(step.getParmParameters(), (IImporterVariables.Variable)new IImporterVariables.VariableCobRent()));
        this.setOptionDynam((IImporterVariables.CobDynam)this.getDefaultParameter(step.getParmParameters(), (IImporterVariables.Variable)new IImporterVariables.VariableCobDynam()));
        this.setOptionSql((IImporterVariables.CobSql)this.getDefaultParameter(step.getParmParameters(), (IImporterVariables.Variable)new IImporterVariables.VariableCobSql()));
        this.setOptionOther(this.getDefaultOtherParameters(step.getParmParameters(), variables));
        this.setDsNameSysin(this.getDefaultDataset((List)step.getDatasets().get("SYSIN"), this.getDsNameSysin()));
        this.setDsNameSyslin(this.getDefaultDataset((List)step.getDatasets().get("SYSLIN"), this.getDsNameSyslin()));
        this.setDsNameSysprint(this.getDefaultDataset((List)step.getDatasets().get("SYSPRINT"), this.getDsNameSysprint()));
        this.setResourceSysin(this.getDefaultResource((List)step.getDatasets().get("SYSIN")));
        this.setResourceSyslin(this.getDefaultResource((List)step.getDatasets().get("SYSLIN")));
        this.setResourceSysprint(this.getDefaultResource((List)step.getDatasets().get("SYSPRINT")));
        this.getDefaultDatasets((List)step.getDatasets().get("SYSLIB"), this.getResourceSyslib());
        this.getDefaultDatasets((List)step.getDatasets().get("STEPLIB"), this.getResourceTasklib());
        this.getDefaultDatasets((List)step.getDatasets().get("TASKLIB"), this.getResourceTasklib());
        this.getBuildOptions().setId(StringUtil.toTitle((String)step.getName()));
        this.setStepName(step.getName());
        if (this.getResourceSysin().iszDataset()) {
            this.getResourceSysin().setzFolder(true);
            this.getResourceSysin().getDsdef().setUsageType(0);
        }
        if (this.getResourceSyslin().iszDataset()) {
            this.getResourceSyslin().setzFolder(true);
            this.getResourceSyslin().getDsdef().setUsageType(0);
        }
        for (IImporterDataset dataset : this.getResourceSyslib()) {
            if (dataset.iszDataset()) {
                dataset.setzFolder(true);
                dataset.getDsdef().setUsageType(0);
                continue;
            }
            dataset.setExisting(true);
            dataset.getDsdef().setUsageType(3);
        }
    }

    @Override
    public void initDefault() {
        this.optionRent = IImporterVariables.CobRent.NORENT;
        this.optionDynam = IImporterVariables.CobDynam.NODYNAM;
        this.optionSql = IImporterVariables.CobSql.NO;
        this.optionOther = "";
        this.dsNameSysin = "COB";
        this.dsNameSyslin = "OBJ";
        this.dsNameSysprint = "PRT.COB";
        this.resourceSyslib = new ArrayList<IImporterDataset>();
        this.resourceSyslib.add(new ImporterDataset("CICS.SDFHCOB", true));
        this.resourceTasklib = new ArrayList<IImporterDataset>();
        this.resourceTasklib.add(new ImporterDataset("COBOL.SIGYCOMP", false));
        this.resourceTasklib.add(new ImporterDataset("CICS.SDFHLOAD", false));
        this.buildOptions = new BuilderBuildOptions("COBOL");
        this.stepName = "COBOL";
    }

    @Override
    public final String getId() {
        return "COB";
    }

    @Override
    public final String getName(String languageId) {
        return String.format("%1$s.Translator.COB", languageId);
    }

    @Override
    public final void createDocumentStep(Document document, Element languageElement) {
        Element translatorElement = null;
        Element librariesElement = null;
        Element parameterElement = null;
        Element resourceElement = null;
        translatorElement = document.createElement("translator");
        translatorElement.setAttribute("name", "ASM");
        languageElement.appendChild(translatorElement);
        if (Verification.isNonNull((Object)this.buildOptions)) {
            this.createDocumentOptions(document, translatorElement, this.buildOptions);
        }
        if (Verification.isNonNull((Object)this.optionDynam)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "COBADYNAM");
            parameterElement.setTextContent(this.optionDynam.toString());
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonBlank((String)this.optionOther)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "COBOTHER");
            parameterElement.setTextContent(this.optionOther);
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonNull((Object)this.optionRent)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "COBRENT");
            parameterElement.setTextContent(this.optionRent.toString());
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonNull((Object)this.optionSql)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "COBSQL");
            parameterElement.setTextContent(this.optionSql.toString());
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonBlank((String)this.dsNameSysin)) {
            resourceElement = document.createElement("resource");
            resourceElement.setAttribute("name", "SYSIN");
            resourceElement.setAttribute("zFolder", "true");
            resourceElement.setTextContent(this.dsNameSysin);
            translatorElement.appendChild(resourceElement);
        }
        if (Verification.isNonBlank((String)this.dsNameSyslin)) {
            resourceElement = document.createElement("resource");
            resourceElement.setAttribute("name", "SYSLIN");
            resourceElement.setAttribute("zFolder", "true");
            resourceElement.setTextContent(this.dsNameSyslin);
            translatorElement.appendChild(resourceElement);
        }
        if (Verification.isNonBlank((String)this.dsNameSysprint)) {
            resourceElement = document.createElement("resource");
            resourceElement.setAttribute("name", "SYSPRINT");
            resourceElement.setAttribute("zFolder", "true");
            resourceElement.setTextContent(this.dsNameSysprint);
            translatorElement.appendChild(resourceElement);
        }
        if (Verification.isNonEmpty(this.resourceSyslib)) {
            librariesElement = document.createElement("libraries");
            librariesElement.setAttribute("name", "SYSLIB");
            translatorElement.appendChild(librariesElement);
            for (IImporterDataset dataset : this.resourceSyslib) {
                resourceElement = document.createElement("resource");
                resourceElement.setAttribute("zFolder", Boolean.toString(dataset.iszFolder()));
                resourceElement.setTextContent(dataset.getDataset());
                librariesElement.appendChild(resourceElement);
            }
        }
        if (Verification.isNonEmpty(this.resourceTasklib)) {
            librariesElement = document.createElement("libraries");
            librariesElement.setAttribute("name", "TASKLIB");
            translatorElement.appendChild(librariesElement);
            for (IImporterDataset dataset : this.resourceTasklib) {
                resourceElement = document.createElement("resource");
                resourceElement.setAttribute("zFolder", Boolean.toString(dataset.iszFolder()));
                resourceElement.setTextContent(dataset.getDataset());
                librariesElement.appendChild(resourceElement);
            }
        }
    }

    @Override
    public void createDocumentOptionsAdditional(Document document, Element translatorElement, IImporterBuildOptions buildOptions) {
    }

    public final void createTokenListStep(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder languageAttributes) {
    }

    @Override
    public void createConditionAttributeAdditional(StringBuilder conditionAttributes, IImporterBuildOptions buildOptions) {
    }

    @Override
    public final void createTokenListStepResource(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder resourceAttributes) {
        if (Verification.isNonBlank((String)this.dsNameSysin)) {
            this.appendAttribute(resourceAttributes, String.format(" SYSIN=\"%s\"", this.dsNameSysin));
        }
        if (Verification.isNonBlank((String)this.dsNameSyslin)) {
            this.appendAttribute(resourceAttributes, String.format(" SYSLIN=\"%s\"", this.dsNameSyslin));
        }
        if (Verification.isNonBlank((String)this.dsNameSysprint)) {
            this.appendAttribute(resourceAttributes, String.format(" SYSPRINT=\"%s\"", this.dsNameSysprint));
        }
        tokens.add(new ImporterToken("@ATTRIBUTES_COB_RESOURCE@", resourceAttributes.toString()));
        tokens.add(this.createResourceSyslibElement(language, "@RESOURCE_COB_SYSLIB@", "<dsn.syslib>", "</dsn.syslib>", this.resourceSyslib));
        tokens.add(this.createResourceTasklibElement(language, "@RESOURCE_COB_TASKLIB@", "<dsn.tasklib>", "</dsn.tasklib>", this.resourceTasklib));
    }

    @Override
    public final void createTokenListStepTranslator(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder translatorAttributes) {
        if (Verification.isNonNull((Object)this.optionDynam)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.COBDYNAM=\"%s\"", this.optionDynam.toString()));
        }
        if (Verification.isNonBlank((String)this.optionOther)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.COBOTHER=\"%s\"", this.optionOther));
        }
        if (Verification.isNonNull((Object)this.optionRent)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.COBRENT=\"%s\"", this.optionRent.toString()));
        }
        if (Verification.isNonNull((Object)this.optionSql)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.COBSQL=\"%s\"", this.optionSql.toString()));
        }
        tokens.add(new ImporterToken("@ATTRIBUTES_COB_TRANSLATOR@", translatorAttributes.toString()));
        this.createTranslatorSyslibElement(language, tokens, this.resourceSyslib);
        this.createTranslatorTasklibElement(language, tokens, "@TRANSLATOR_COB_TASKLIB@", "<alloc.tasklib>", "</alloc.tasklib>", "%1$s.Resource.%3$s.TASKLIB", "%1$s.Resource.%3$s.TASKLIB.DSN%2$02d", this.resourceTasklib);
    }

    @Override
    public void createTranslatorSyslibElementAdditional(IImporterLanguage language, List<IImporterToken> tokens, List<IImporterDataset> datasets) {
    }

    public final IImporterVariables.CobRent getOptionRent() {
        return this.optionRent;
    }

    public final void setOptionRent(IImporterVariables.CobRent optionRent) {
        this.optionRent = optionRent;
    }

    public final String getOptionOther() {
        return this.optionOther;
    }

    public final void setOptionOther(String optionOther) {
        this.optionOther = optionOther;
    }

    public final IImporterVariables.CobDynam getOptionDynam() {
        return this.optionDynam;
    }

    public final void setOptionDynam(IImporterVariables.CobDynam optionDynam) {
        this.optionDynam = optionDynam;
    }

    public final IImporterVariables.CobSql getOptionSql() {
        return this.optionSql;
    }

    public final void setOptionSql(IImporterVariables.CobSql optionSql) {
        this.optionSql = optionSql;
    }

    public final String getDsNameSysin() {
        return this.dsNameSysin;
    }

    public final void setDsNameSysin(String dsNameSysin) {
        this.dsNameSysin = dsNameSysin;
    }

    public final String getDsNameSyslin() {
        return this.dsNameSyslin;
    }

    public final void setDsNameSyslin(String dsNameSyslin) {
        this.dsNameSyslin = dsNameSyslin;
    }

    public final String getDsNameSysprint() {
        return this.dsNameSysprint;
    }

    public final void setDsNameSysprint(String dsNameSysprint) {
        this.dsNameSysprint = dsNameSysprint;
    }

    public final List<IImporterDataset> getResourceSyslib() {
        return this.resourceSyslib;
    }

    public final IImporterDataset getResourceSysin() {
        return this.resourceSysin;
    }

    public final void setResourceSysin(IImporterDataset resourceSysin) {
        this.resourceSysin = resourceSysin;
    }

    public final IImporterDataset getResourceSyslin() {
        return this.resourceSyslin;
    }

    public final void setResourceSyslin(IImporterDataset resourceSyslin) {
        this.resourceSyslin = resourceSyslin;
    }

    public final IImporterDataset getResourceSysprint() {
        return this.resourceSysprint;
    }

    public final void setResourceSysprint(IImporterDataset resourceSysprint) {
        this.resourceSysprint = resourceSysprint;
    }

    public final void setResourceSyslib(List<IImporterDataset> resourceSyslib) {
        this.resourceSyslib = resourceSyslib;
    }

    public final List<IImporterDataset> getResourceTasklib() {
        return this.resourceTasklib;
    }

    public final void setResourceTasklib(List<IImporterDataset> resourceTasklib) {
        this.resourceTasklib = resourceTasklib;
    }

    public final int getMaxRc() {
        return this.maxRc;
    }

    public final void setMaxRc(int maxRc) {
        this.maxRc = maxRc;
    }

    public final Map<String, Function<IImporterStepCob, IImporterVariables.VariableParam>> getAllParameters() {
        HashMap<String, Function<IImporterStepCob, IImporterVariables.VariableParam>> functionsMap = new HashMap<String, Function<IImporterStepCob, IImporterVariables.VariableParam>>();
        functionsMap.put(IImporterVariables.CobDynam.class.getSimpleName(), step -> {
            IImporterVariables.CobDynam option = step.getOptionDynam();
            return new IImporterVariables.VariableParam(IImporterVariables.CobDynam.getProps().getLabels(), option == null ? null : Integer.valueOf(IImporterVariables.CobDynam.getProps().getIndex((Enum)option)));
        });
        functionsMap.put(IImporterVariables.CobRent.class.getSimpleName(), step -> {
            IImporterVariables.CobRent option = step.getOptionRent();
            return new IImporterVariables.VariableParam(IImporterVariables.CobRent.getProps().getLabels(), option == null ? null : Integer.valueOf(IImporterVariables.CobRent.getProps().getIndex((Enum)option)));
        });
        functionsMap.put(IImporterVariables.CobSql.class.getSimpleName(), step -> {
            IImporterVariables.CobSql option = step.getOptionSql();
            return new IImporterVariables.VariableParam(IImporterVariables.CobSql.getProps().getLabels(), option == null ? null : Integer.valueOf(IImporterVariables.CobSql.getProps().getIndex((Enum)option)));
        });
        return functionsMap;
    }
}

