/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.builder;

import com.ibm.team.build.extensions.common.util.StringUtil;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterDataset;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterStep;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterToken;
import com.ibm.team.enterprise.systemdefinition.client.builder.BuilderBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterDataset;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLibrary;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterOption;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParameter;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParserStep;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterResource;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepAsm;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterTranslator;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterVariables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BuilderStepAsm
extends ImporterStep
implements IImporterStepAsm {
    private IImporterVariables.HlasmAdata optionAdata;
    private IImporterVariables.HlasmRent optionRent;
    private IImporterVariables.HlasmTerm optionTerm;
    private IImporterVariables.HlasmUsing optionUsing;
    private IImporterVariables.HlasmXref optionXref;
    private String optionOther;
    private String dsNameSysadata;
    private String dsNameSysin;
    private String dsNameSyslin;
    private String dsNameSysprint;
    private IImporterDataset resourceSysadata;
    private IImporterDataset resourceSysin;
    private IImporterDataset resourceSyslin;
    private IImporterDataset resourceSysprint;
    private List<IImporterDataset> resourceSyslib;
    private List<IImporterDataset> resourceTasklib;
    private int maxRc;

    public BuilderStepAsm() {
    }

    public BuilderStepAsm(IImporterLanguage imported) {
        super(imported);
        for (IImporterTranslator translator : imported.getTranslators()) {
            if (!translator.getName().equals("ASM")) continue;
            this.buildOptions = new BuilderBuildOptions(StringUtil.toTitle((String)"ASM"));
            for (IImporterOption option : translator.getOptions()) {
                if (option.getName().equals("compile")) {
                    this.buildOptions.setCompile(option.getState());
                    this.buildOptions.setCompileEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("initial")) {
                    this.buildOptions.setInitial(option.getState());
                    this.buildOptions.setInitialEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("library")) {
                    this.buildOptions.setLibrary(option.getState());
                    this.buildOptions.setLibraryEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("refresh")) {
                    this.buildOptions.setRefresh(option.getState());
                    this.buildOptions.setRefreshEnabled(option.getEnabled());
                    continue;
                }
                if (option.getName().equals("service")) {
                    this.buildOptions.setService(option.getState());
                    this.buildOptions.setServiceEnabled(option.getEnabled());
                    continue;
                }
                if (!option.getName().equals("testing")) continue;
                this.buildOptions.setTesting(option.getState());
                this.buildOptions.setTestingEnabled(option.getEnabled());
            }
            for (IImporterParameter parameter : translator.getParameters()) {
                if (parameter.getName().equals("ASMADATA")) {
                    this.setOptionAdata(IImporterVariables.HlasmAdata.get((String)parameter.getValue()));
                    continue;
                }
                if (parameter.getName().equals("ASMOTHER")) {
                    this.setOptionOther(parameter.getValue());
                    continue;
                }
                if (parameter.getName().equals("ASMRENT")) {
                    this.setOptionRent(IImporterVariables.HlasmRent.get((String)parameter.getValue()));
                    continue;
                }
                if (parameter.getName().equals("ASMTERM")) {
                    this.setOptionTerm(IImporterVariables.HlasmTerm.get((String)parameter.getValue()));
                    continue;
                }
                if (parameter.getName().equals("ASMUSING")) {
                    this.setOptionUsing(IImporterVariables.HlasmUsing.get((String)parameter.getValue()));
                    continue;
                }
                if (!parameter.getName().equals("ASMXREF")) continue;
                this.setOptionXref(IImporterVariables.HlasmXref.get((String)parameter.getValue()));
            }
            for (IImporterResource resource : translator.getResources()) {
                if (resource.getName().equals("SYSADATA")) {
                    this.setDsNameSysadata(resource.getValue());
                    continue;
                }
                if (resource.getName().equals("SYSIN")) {
                    this.setDsNameSysin(resource.getValue());
                    continue;
                }
                if (resource.getName().equals("SYSLIN")) {
                    this.setDsNameSyslin(resource.getValue());
                    continue;
                }
                if (!resource.getName().equals("SYSPRINT")) continue;
                this.setDsNameSysprint(resource.getValue());
            }
            for (IImporterLibrary library : translator.getLibraries()) {
                ImporterDataset dataset;
                if (library.getName().equals("SYSLIB")) {
                    this.resourceSyslib = new ArrayList<IImporterDataset>();
                    for (IImporterResource resource : library.getResources()) {
                        dataset = new ImporterDataset(resource.getValue(), resource.iszFolder());
                        this.resourceSyslib.add(dataset);
                    }
                    continue;
                }
                if (!library.getName().equals("TASKLIB")) continue;
                this.resourceTasklib = new ArrayList<IImporterDataset>();
                for (IImporterResource resource : library.getResources()) {
                    dataset = new ImporterDataset(resource.getValue(), resource.iszFolder());
                    this.resourceTasklib.add(dataset);
                }
            }
        }
    }

    @Override
    public void init() {
        this.optionAdata = null;
        this.optionRent = null;
        this.optionTerm = null;
        this.optionUsing = null;
        this.optionXref = null;
        this.optionOther = "";
        this.dsNameSysadata = "";
        this.dsNameSysin = "";
        this.dsNameSyslin = "";
        this.dsNameSysprint = "";
        this.resourceSyslib = new ArrayList<IImporterDataset>();
        this.resourceTasklib = new ArrayList<IImporterDataset>();
        this.buildOptions = new BuilderBuildOptions("Assemble");
        this.stepName = "Assemble";
    }

    @Override
    public final void init(IImporterParserStep step) {
        this.init();
        this.setOptionAdata((IImporterVariables.HlasmAdata)this.getDefaultParameter(step.getParmParameters(), (IImporterVariables.Variable)new IImporterVariables.VariableHlasmAdata()));
        this.setOptionRent((IImporterVariables.HlasmRent)this.getDefaultParameter(step.getParmParameters(), (IImporterVariables.Variable)new IImporterVariables.VariableHlasmRent()));
        this.setOptionTerm((IImporterVariables.HlasmTerm)this.getDefaultParameter(step.getParmParameters(), (IImporterVariables.Variable)new IImporterVariables.VariableHlasmTerm()));
        this.setOptionUsing((IImporterVariables.HlasmUsing)this.getDefaultParameter(step.getParmParameters(), (IImporterVariables.Variable)new IImporterVariables.VariableHlasmUsing()));
        this.setOptionXref((IImporterVariables.HlasmXref)this.getDefaultParameter(step.getParmParameters(), (IImporterVariables.Variable)new IImporterVariables.VariableHlasmXref()));
        this.setOptionOther(this.getDefaultOtherParameters(step.getParmParameters(), variables));
        this.setDsNameSysadata(this.getDefaultDataset((List)step.getDatasets().get("SYSADATA"), this.getDsNameSysin()));
        this.setDsNameSysin(this.getDefaultDataset((List)step.getDatasets().get("SYSIN"), this.getDsNameSysin()));
        this.setDsNameSyslin(this.getDefaultDataset((List)step.getDatasets().get("SYSLIN"), this.getDsNameSyslin()));
        this.setDsNameSysprint(this.getDefaultDataset((List)step.getDatasets().get("SYSPRINT"), this.getDsNameSysprint()));
        this.setResourceSysadata(this.getDefaultResource((List)step.getDatasets().get("SYSADATA")));
        this.setResourceSysin(this.getDefaultResource((List)step.getDatasets().get("SYSIN")));
        this.setResourceSyslin(this.getDefaultResource((List)step.getDatasets().get("SYSLIN")));
        this.setResourceSysprint(this.getDefaultResource((List)step.getDatasets().get("SYSPRINT")));
        this.getDefaultDatasets((List)step.getDatasets().get("SYSLIB"), this.getResourceSyslib());
        this.getDefaultDatasets((List)step.getDatasets().get("STEPLIB"), this.getResourceTasklib());
        this.getDefaultDatasets((List)step.getDatasets().get("TASKLIB"), this.getResourceTasklib());
        this.getBuildOptions().setId(StringUtil.toTitle((String)step.getName()));
        this.setStepName(step.getName());
        if (this.getResourceSysin().iszDataset()) {
            this.getResourceSysin().setzFolder(true);
            this.getResourceSysin().getDsdef().setUsageType(0);
        }
        if (this.getResourceSyslin().iszDataset()) {
            this.getResourceSyslin().setzFolder(true);
            this.getResourceSyslin().getDsdef().setUsageType(0);
        }
        for (IImporterDataset dataset : this.getResourceSyslib()) {
            if (dataset.iszDataset()) {
                dataset.setzFolder(true);
                dataset.getDsdef().setUsageType(0);
                continue;
            }
            dataset.setExisting(true);
            dataset.getDsdef().setUsageType(3);
        }
    }

    @Override
    public void initDefault() {
        this.optionAdata = IImporterVariables.HlasmAdata.ADATA;
        this.optionRent = IImporterVariables.HlasmRent.NORENT;
        this.optionTerm = IImporterVariables.HlasmTerm.TERM;
        this.optionUsing = IImporterVariables.HlasmUsing.NOUSING;
        this.optionXref = IImporterVariables.HlasmXref.XREFSHORT;
        this.optionOther = "";
        this.dsNameSysadata = "&&ADATA";
        this.dsNameSysin = "ASM";
        this.dsNameSyslin = "OBJ";
        this.dsNameSysprint = "PRT.ASM";
        this.resourceSyslib = new ArrayList<IImporterDataset>();
        this.resourceSyslib.add(new ImporterDataset("MAC", true));
        this.resourceSyslib.add(new ImporterDataset("SYS1.MACLIB", false));
        this.resourceSyslib.add(new ImporterDataset("SYS1.MODGEN", false));
        this.resourceSyslib.add(new ImporterDataset("SYS1.SASMMAC1", false));
        this.resourceSyslib.add(new ImporterDataset("SYS1.SASMMAC2", false));
        this.resourceTasklib = new ArrayList<IImporterDataset>();
        this.resourceTasklib.add(new ImporterDataset("SYS1.SASMMOD1", false));
        this.buildOptions = new BuilderBuildOptions("Assemble");
        this.stepName = "Assemble";
    }

    @Override
    public final String getId() {
        return "ASM";
    }

    @Override
    public final String getName(String languageId) {
        return String.format("%1$s.Translator.ASM", languageId);
    }

    @Override
    public final void createDocumentStep(Document document, Element languageElement) {
        Element translatorElement = null;
        Element librariesElement = null;
        Element parameterElement = null;
        Element resourceElement = null;
        translatorElement = document.createElement("translator");
        translatorElement.setAttribute("name", "ASM");
        languageElement.appendChild(translatorElement);
        if (Verification.isNonNull((Object)this.buildOptions)) {
            this.createDocumentOptions(document, translatorElement, this.buildOptions);
        }
        if (Verification.isNonNull((Object)this.optionAdata)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "ASMADATA");
            parameterElement.setTextContent(this.optionAdata.toString());
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonBlank((String)this.optionOther)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "ASMOTHER");
            parameterElement.setTextContent(this.optionOther);
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonNull((Object)this.optionRent)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "ASMRENT");
            parameterElement.setTextContent(this.optionRent.toString());
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonNull((Object)this.optionTerm)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "ASMTERM");
            parameterElement.setTextContent(this.optionTerm.toString());
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonNull((Object)this.optionUsing)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "ASMUSING");
            parameterElement.setTextContent(this.optionUsing.toString());
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonNull((Object)this.optionXref)) {
            parameterElement = document.createElement("parameter");
            parameterElement.setAttribute("name", "ASMXREF");
            parameterElement.setTextContent(this.optionXref.toString());
            translatorElement.appendChild(parameterElement);
        }
        if (Verification.isNonBlank((String)this.dsNameSysadata)) {
            resourceElement = document.createElement("resource");
            resourceElement.setAttribute("name", "SYSADATA");
            resourceElement.setTextContent(this.dsNameSysadata);
            translatorElement.appendChild(resourceElement);
        }
        if (Verification.isNonBlank((String)this.dsNameSysin)) {
            resourceElement = document.createElement("resource");
            resourceElement.setAttribute("name", "SYSIN");
            resourceElement.setAttribute("zFolder", "true");
            resourceElement.setTextContent(this.dsNameSysin);
            translatorElement.appendChild(resourceElement);
        }
        if (Verification.isNonBlank((String)this.dsNameSyslin)) {
            resourceElement = document.createElement("resource");
            resourceElement.setAttribute("name", "SYSLIN");
            resourceElement.setAttribute("zFolder", "true");
            resourceElement.setTextContent(this.dsNameSyslin);
            translatorElement.appendChild(resourceElement);
        }
        if (Verification.isNonBlank((String)this.dsNameSysprint)) {
            resourceElement = document.createElement("resource");
            resourceElement.setAttribute("name", "SYSPRINT");
            resourceElement.setAttribute("zFolder", "true");
            resourceElement.setTextContent(this.dsNameSysprint);
            translatorElement.appendChild(resourceElement);
        }
        if (Verification.isNonEmpty(this.resourceSyslib)) {
            librariesElement = document.createElement("libraries");
            librariesElement.setAttribute("name", "SYSLIB");
            translatorElement.appendChild(librariesElement);
            for (IImporterDataset dataset : this.resourceSyslib) {
                resourceElement = document.createElement("resource");
                resourceElement.setAttribute("zFolder", Boolean.toString(dataset.iszFolder()));
                resourceElement.setTextContent(dataset.getDataset());
                librariesElement.appendChild(resourceElement);
            }
        }
        if (Verification.isNonEmpty(this.resourceTasklib)) {
            librariesElement = document.createElement("libraries");
            librariesElement.setAttribute("name", "TASKLIB");
            translatorElement.appendChild(librariesElement);
            for (IImporterDataset dataset : this.resourceTasklib) {
                resourceElement = document.createElement("resource");
                resourceElement.setAttribute("zFolder", Boolean.toString(dataset.iszFolder()));
                resourceElement.setTextContent(dataset.getDataset());
                librariesElement.appendChild(resourceElement);
            }
        }
    }

    @Override
    public void createDocumentOptionsAdditional(Document document, Element translatorElement, IImporterBuildOptions buildOptions) {
    }

    public final void createTokenListStep(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder languageAttributes) {
    }

    @Override
    public void createConditionAttributeAdditional(StringBuilder conditionAttributes, IImporterBuildOptions buildOptions) {
    }

    @Override
    public final void createTokenListStepResource(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder resourceAttributes) {
        if (Verification.isNonBlank((String)this.dsNameSysadata)) {
            this.appendAttribute(resourceAttributes, String.format(" SYSADATA=\"%s\"", this.dsNameSysadata));
        }
        if (Verification.isNonBlank((String)this.dsNameSysin)) {
            this.appendAttribute(resourceAttributes, String.format(" SYSIN=\"%s\"", this.dsNameSysin));
        }
        if (Verification.isNonBlank((String)this.dsNameSyslin)) {
            this.appendAttribute(resourceAttributes, String.format(" SYSLIN=\"%s\"", this.dsNameSyslin));
        }
        if (Verification.isNonBlank((String)this.dsNameSysprint)) {
            this.appendAttribute(resourceAttributes, String.format(" SYSPRINT=\"%s\"", this.dsNameSysprint));
        }
        tokens.add(new ImporterToken("@ATTRIBUTES_ASM_RESOURCE@", resourceAttributes.toString()));
        tokens.add(this.createResourceSyslibElement(language, "@RESOURCE_ASM_SYSLIB@", "<dsn.syslib>", "</dsn.syslib>", this.resourceSyslib));
        tokens.add(this.createResourceTasklibElement(language, "@RESOURCE_ASM_TASKLIB@", "<dsn.tasklib>", "</dsn.tasklib>", this.resourceTasklib));
    }

    @Override
    public final void createTokenListStepTranslator(IImporterLanguage language, List<IImporterToken> tokens, StringBuilder translatorAttributes) {
        if (Verification.isNonNull((Object)this.optionAdata)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.ASMADATA=\"%s\"", this.optionAdata.toString()));
        }
        if (Verification.isNonBlank((String)this.optionOther)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.ASMOTHER=\"%s\"", this.optionOther));
        }
        if (Verification.isNonNull((Object)this.optionRent)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.ASMRENT=\"%s\"", this.optionRent.toString()));
        }
        if (Verification.isNonNull((Object)this.optionTerm)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.ASMTERM=\"%s\"", this.optionTerm.getText()));
        }
        if (Verification.isNonNull((Object)this.optionUsing)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.ASMUSING=\"%s\"", this.optionUsing.getText()));
        }
        if (Verification.isNonNull((Object)this.optionXref)) {
            this.appendAttribute(translatorAttributes, String.format(" variable.ASMXREF=\"%s\"", this.optionXref.getText()));
        }
        tokens.add(new ImporterToken("@ATTRIBUTES_ASM_TRANSLATOR@", translatorAttributes.toString()));
        this.createTranslatorSyslibElement(language, tokens, this.resourceSyslib);
        this.createTranslatorTasklibElement(language, tokens, "@TRANSLATOR_ASM_TASKLIB@", "<alloc.tasklib>", "</alloc.tasklib>", "%1$s.Resource.%3$s.TASKLIB", "%1$s.Resource.%3$s.TASKLIB.DSN%2$02d", this.resourceTasklib);
    }

    @Override
    public void createTranslatorSyslibElementAdditional(IImporterLanguage language, List<IImporterToken> tokens, List<IImporterDataset> datasets) {
    }

    public final IImporterVariables.HlasmAdata getOptionAdata() {
        return this.optionAdata;
    }

    public final void setOptionAdata(IImporterVariables.HlasmAdata optionAdata) {
        this.optionAdata = optionAdata;
    }

    public final String getOptionOther() {
        return this.optionOther;
    }

    public final void setOptionOther(String optionOther) {
        this.optionOther = optionOther;
    }

    public final IImporterVariables.HlasmRent getOptionRent() {
        return this.optionRent;
    }

    public final void setOptionRent(IImporterVariables.HlasmRent optionRent) {
        this.optionRent = optionRent;
    }

    public final IImporterVariables.HlasmTerm getOptionTerm() {
        return this.optionTerm;
    }

    public final void setOptionTerm(IImporterVariables.HlasmTerm optionTerm) {
        this.optionTerm = optionTerm;
    }

    public final IImporterVariables.HlasmUsing getOptionUsing() {
        return this.optionUsing;
    }

    public final void setOptionUsing(IImporterVariables.HlasmUsing optionUsing) {
        this.optionUsing = optionUsing;
    }

    public final IImporterVariables.HlasmXref getOptionXref() {
        return this.optionXref;
    }

    public final void setOptionXref(IImporterVariables.HlasmXref optionXref) {
        this.optionXref = optionXref;
    }

    public final String getDsNameSysadata() {
        return this.dsNameSysadata;
    }

    public final void setDsNameSysadata(String dsNameSysadata) {
        this.dsNameSysadata = dsNameSysadata;
    }

    public final String getDsNameSysin() {
        return this.dsNameSysin;
    }

    public final void setDsNameSysin(String dsNameSysin) {
        this.dsNameSysin = dsNameSysin;
    }

    public final String getDsNameSyslin() {
        return this.dsNameSyslin;
    }

    public final void setDsNameSyslin(String dsNameSyslin) {
        this.dsNameSyslin = dsNameSyslin;
    }

    public final String getDsNameSysprint() {
        return this.dsNameSysprint;
    }

    public final void setDsNameSysprint(String dsNameSysprint) {
        this.dsNameSysprint = dsNameSysprint;
    }

    public final List<IImporterDataset> getResourceSyslib() {
        return this.resourceSyslib;
    }

    public final IImporterDataset getResourceSysadata() {
        return this.resourceSysadata;
    }

    public final void setResourceSysadata(IImporterDataset resourceSysadata) {
        this.resourceSysadata = resourceSysadata;
    }

    public final IImporterDataset getResourceSysin() {
        return this.resourceSysin;
    }

    public final void setResourceSysin(IImporterDataset resourceSysin) {
        this.resourceSysin = resourceSysin;
    }

    public final IImporterDataset getResourceSyslin() {
        return this.resourceSyslin;
    }

    public final void setResourceSyslin(IImporterDataset resourceSyslin) {
        this.resourceSyslin = resourceSyslin;
    }

    public final IImporterDataset getResourceSysprint() {
        return this.resourceSysprint;
    }

    public final void setResourceSysprint(IImporterDataset resourceSysprint) {
        this.resourceSysprint = resourceSysprint;
    }

    public final void setResourceSyslib(List<IImporterDataset> resourceSyslib) {
        this.resourceSyslib = resourceSyslib;
    }

    public final List<IImporterDataset> getResourceTasklib() {
        return this.resourceTasklib;
    }

    public final void setResourceTasklib(List<IImporterDataset> resourceTasklib) {
        this.resourceTasklib = resourceTasklib;
    }

    public final int getMaxRc() {
        return this.maxRc;
    }

    public final void setMaxRc(int maxRc) {
        this.maxRc = maxRc;
    }

    public final Map<String, Function<IImporterStepAsm, IImporterVariables.VariableParam>> getAllParameters() {
        HashMap<String, Function<IImporterStepAsm, IImporterVariables.VariableParam>> functionsMap = new HashMap<String, Function<IImporterStepAsm, IImporterVariables.VariableParam>>();
        functionsMap.put(IImporterVariables.HlasmXref.class.getSimpleName(), step -> {
            IImporterVariables.HlasmXref option = step.getOptionXref();
            return new IImporterVariables.VariableParam(IImporterVariables.HlasmXref.getLabels(), option == null ? null : Integer.valueOf(IImporterVariables.HlasmXref.getIndex((IImporterVariables.HlasmXref)option)));
        });
        functionsMap.put(IImporterVariables.HlasmUsing.class.getSimpleName(), step -> {
            IImporterVariables.HlasmUsing option = step.getOptionUsing();
            return new IImporterVariables.VariableParam(IImporterVariables.HlasmUsing.getLabels(), option == null ? null : Integer.valueOf(IImporterVariables.HlasmUsing.getIndex((IImporterVariables.HlasmUsing)option)));
        });
        functionsMap.put(IImporterVariables.HlasmTerm.class.getSimpleName(), step -> {
            IImporterVariables.HlasmTerm option = step.getOptionTerm();
            return new IImporterVariables.VariableParam(IImporterVariables.HlasmTerm.getLabels(), option == null ? null : Integer.valueOf(IImporterVariables.HlasmTerm.getIndex((IImporterVariables.HlasmTerm)option)));
        });
        functionsMap.put(IImporterVariables.HlasmRent.class.getSimpleName(), step -> {
            IImporterVariables.HlasmRent option = step.getOptionRent();
            return new IImporterVariables.VariableParam(IImporterVariables.HlasmRent.getLabels(), option == null ? null : Integer.valueOf(IImporterVariables.HlasmRent.getIndex((IImporterVariables.HlasmRent)option)));
        });
        functionsMap.put(IImporterVariables.HlasmAdata.class.getSimpleName(), step -> {
            IImporterVariables.HlasmAdata option = step.getOptionAdata();
            return new IImporterVariables.VariableParam(IImporterVariables.HlasmAdata.getLabels(), option == null ? null : Integer.valueOf(IImporterVariables.HlasmAdata.getIndex((IImporterVariables.HlasmAdata)option)));
        });
        return functionsMap;
    }
}

