/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client.builder;

import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterToken;
import com.ibm.team.enterprise.internal.systemdefinition.client.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterAllocationSize;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterProperties;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStep;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterToken;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterTranslator;
import com.ibm.team.enterprise.systemdefinition.common.importer.ImporterException;
import com.ibm.team.enterprise.systemdefinition.common.model.LanguageCode;
import com.ibm.team.enterprise.systemdefinition.common.util.DatasetCache;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BuilderLanguage
implements IImporterLanguage {
    private String description;
    private String folderAdditional;
    private String folderPrimary;
    private String id;
    private String name;
    private String patternAdditional;
    private String patternPrimary;
    private String prefix;
    private String projectName;
    private String zFolderName;
    private DatasetCache datasetCache;
    private Enumerator type;
    private IImporterAllocationSize.AllocationSize size;
    private IImporterProperties properties;
    private final List<IImporterStep> steps = new ArrayList<IImporterStep>();
    private final List<IImporterTranslator> translators = new ArrayList<IImporterTranslator>();

    public BuilderLanguage() {
    }

    public BuilderLanguage(IImporterLanguage imported) {
        this.setDescription(imported.getDescription());
        this.setFolderAdditional(imported.getFolderAdditional());
        this.setFolderPrimary(imported.getFolderPrimary());
        this.setId(imported.getId());
        this.setName(imported.getName());
        this.setPatternAdditional(imported.getPatternAdditional());
        this.setPatternPrimary(imported.getPatternPrimary());
        this.setPrefix(imported.getPrefix());
        this.setProjectName(imported.getProjectName());
        this.setProperties(imported.getProperties());
        this.setSize(imported.getSize());
        this.setType(imported.getType());
        this.setZFolderName(imported.getZFolderName());
    }

    public Document createDocument() throws ImporterException {
        Document document = null;
        Element languageElement = null;
        Element projectElement = null;
        try {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            document = documentFactory.newDocumentBuilder().newDocument();
            Comment copyright = document.createComment("\n\tLicensed Materials - Property of IBM\n\t(c) Copyright IBM Corporation 2014, 2024. All Rights Reserved.\n\n\tNote to U.S. Government Users Restricted Rights:\n\tUse, duplication or disclosure restricted by GSA ADP Schedule\n\tContract with IBM Corp.\n");
            document.appendChild(copyright);
            Element zBuilderElement = document.createElement("zBuilder");
            zBuilderElement.setAttribute("xmlns", "com.ibm.team.enterprise.systemdefinition.client.builder.language");
            Attr xmlnsAttr = document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi");
            xmlnsAttr.setValue("http://www.w3.org/2001/XMLSchema-instance");
            zBuilderElement.setAttributeNode(xmlnsAttr);
            Attr xsiAttr = document.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation");
            xsiAttr.setValue("com.ibm.team.enterprise.systemdefinition.client.builder.language Importer.language.xsd");
            zBuilderElement.setAttributeNode(xsiAttr);
            document.appendChild(zBuilderElement);
            languageElement = document.createElement("language");
            if (Verification.isNonBlank((String)this.description)) {
                languageElement.setAttribute("description", this.description);
            }
            if (Verification.isNonBlank((String)this.folderAdditional)) {
                languageElement.setAttribute("folderAdditional", this.folderAdditional);
            }
            if (Verification.isNonBlank((String)this.folderPrimary)) {
                languageElement.setAttribute("folderPrimary", this.folderPrimary);
            }
            if (Verification.isNonBlank((String)this.id)) {
                languageElement.setAttribute("id", this.id);
            }
            if (Verification.isNonBlank((String)this.name)) {
                languageElement.setAttribute("name", this.name);
            }
            if (Verification.isNonBlank((String)this.patternAdditional)) {
                languageElement.setAttribute("patternAdditional", this.patternAdditional);
            }
            if (Verification.isNonBlank((String)this.patternPrimary)) {
                languageElement.setAttribute("patternPrimary", this.patternPrimary);
            }
            if (Verification.isNonBlank((String)this.prefix)) {
                languageElement.setAttribute("prefix", this.prefix);
            }
            if (Verification.isNonNull((Object)this.size)) {
                languageElement.setAttribute("size", this.size.toString());
            }
            if (Verification.isNonNull((Object)this.type)) {
                languageElement.setAttribute("type", this.type.toString());
            }
            if (Verification.isNonNull((Object)this.zFolderName)) {
                languageElement.setAttribute("zFolderName", this.zFolderName);
            }
            zBuilderElement.appendChild(languageElement);
            projectElement = document.createElement("project");
            projectElement.setAttribute("name", this.projectName);
            languageElement.appendChild(projectElement);
            if (Verification.isNonNull((Object)this.properties)) {
                Element propertyElement;
                if (Verification.isNonBlank((String)this.properties.getDescription())) {
                    propertyElement = document.createElement("property");
                    propertyElement.setAttribute("name", "description");
                    propertyElement.setTextContent(this.properties.getDescription());
                    projectElement.appendChild(propertyElement);
                }
                if (Verification.isNonBlank((String)this.properties.getId())) {
                    propertyElement = document.createElement("property");
                    propertyElement.setAttribute("name", "id");
                    propertyElement.setTextContent(this.properties.getId());
                    projectElement.appendChild(propertyElement);
                }
                if (Verification.isNonBlank((String)this.properties.getName())) {
                    propertyElement = document.createElement("property");
                    propertyElement.setAttribute("name", "name");
                    propertyElement.setTextContent(this.properties.getName());
                    projectElement.appendChild(propertyElement);
                }
                if (Verification.isNonBlank((String)this.properties.getPassword())) {
                    propertyElement = document.createElement("property");
                    propertyElement.setAttribute("name", "password");
                    propertyElement.setTextContent(this.properties.getPassword());
                    projectElement.appendChild(propertyElement);
                }
                if (Verification.isNonBlank((String)this.properties.getPasswordFile())) {
                    propertyElement = document.createElement("property");
                    propertyElement.setAttribute("name", "passwordFile");
                    propertyElement.setTextContent(this.properties.getPassword());
                    projectElement.appendChild(propertyElement);
                }
                if (Verification.isNonBlank((String)this.properties.getProjectArea())) {
                    propertyElement = document.createElement("property");
                    propertyElement.setAttribute("name", "projectArea");
                    propertyElement.setTextContent(this.properties.getProjectArea());
                    projectElement.appendChild(propertyElement);
                }
                if (Verification.isNonBlank((String)this.properties.getRepositoryAddress())) {
                    propertyElement = document.createElement("property");
                    propertyElement.setAttribute("name", "repositoryAddress");
                    propertyElement.setTextContent(this.properties.getRepositoryAddress());
                    projectElement.appendChild(propertyElement);
                }
                if (Verification.isNonBlank((String)this.properties.getUserId())) {
                    propertyElement = document.createElement("property");
                    propertyElement.setAttribute("name", "userId");
                    propertyElement.setTextContent(this.properties.getUserId());
                    projectElement.appendChild(propertyElement);
                }
            }
            for (IImporterStep step : this.steps) {
                step.createDocumentStep(document, languageElement);
            }
        }
        catch (ParserConfigurationException e) {
            throw new ImporterException(NLS.bind((String)Messages.zBuilder_LANGUAGE_EXCEPTION, (Object)LogString.valueOf((String)this.name)), (Throwable)e);
        }
        return document;
    }

    public final List<IImporterToken> createTokenList() throws ImporterException {
        ArrayList<IImporterToken> tokens = new ArrayList<IImporterToken>();
        StringBuilder languageAttributes = new StringBuilder("");
        if (Verification.isNonBlank((String)this.patternPrimary)) {
            String patterns = Verification.isNonBlank((String)this.patternAdditional) ? String.valueOf(this.patternPrimary) + "," + this.patternAdditional : this.patternPrimary;
            this.appendAttribute(languageAttributes, String.format(" defaultpatterns=\"%s\"", patterns));
        }
        if (Verification.isNonBlank((String)this.description)) {
            this.appendAttribute(languageAttributes, String.format(" description=\"%s\"", this.description.replace("\"", "&quot;")));
        }
        if (Verification.isNonBlank((String)this.id)) {
            this.appendAttribute(languageAttributes, String.format(" id=\"%s\"", this.id));
        }
        if (Verification.isNonBlank((String)this.name)) {
            this.appendAttribute(languageAttributes, String.format(" name=\"%s\"", this.name));
        }
        StringBuilder conditions = new StringBuilder("");
        for (IImporterStep step : this.steps) {
            conditions.append(step.createConditionAttribute(step.getBuildOptions())).append(",");
        }
        conditions.setLength(conditions.length() - 1);
        this.appendAttribute(languageAttributes, String.format(" conditions=\"%s\"", conditions.toString()));
        StringBuilder translators = new StringBuilder("");
        for (IImporterStep step : this.steps) {
            translators.append(step.getName(this.id)).append(",");
        }
        translators.setLength(translators.length() - 1);
        this.appendAttribute(languageAttributes, String.format(" translators=\"%s\"", translators.toString()));
        for (IImporterStep step : this.steps) {
            step.createTokenListStep((IImporterLanguage)this, tokens, languageAttributes);
        }
        ImporterToken languageAttributesToken = new ImporterToken("@ATTRIBUTES_LANGUAGE@", languageAttributes.toString());
        ImporterToken languageIdToken = new ImporterToken("@LANGUAGE_ID@", this.getId());
        ImporterToken projectNameToken = new ImporterToken("@PROJECT@", this.getProjectName());
        tokens.add(languageAttributesToken);
        tokens.add(languageIdToken);
        tokens.add(projectNameToken);
        StringBuilder resourceAttributes = new StringBuilder("");
        if (!Verification.isNonBlank((String)this.id)) {
            throw new ImporterException(Messages.zBuilder_LANGUAGE_REQ_ID);
        }
        this.appendAttribute(resourceAttributes, String.format(" id=\"%s\"", this.id));
        if (!Verification.isNonNull((Object)this.size)) {
            throw new ImporterException(Messages.zBuilder_LANGUAGE_REQ_SIZE);
        }
        this.appendAttribute(resourceAttributes, String.format(" size=\"%s\"", this.size.toString()));
        int commonAttributes = resourceAttributes.length();
        for (IImporterStep step : this.steps) {
            resourceAttributes.setLength(commonAttributes);
            if (!Verification.isNonNull((Object)step.getStepName())) {
                throw new ImporterException(Messages.zBuilder_LANGUAGE_REQ_STEP);
            }
            this.appendAttribute(resourceAttributes, String.format(" step=\"%s\"", step.getStepName()));
            step.createTokenListStepResource((IImporterLanguage)this, tokens, resourceAttributes);
        }
        StringBuilder translatorAttributes = new StringBuilder("");
        if (Verification.isNonBlank((String)this.id)) {
            this.appendAttribute(translatorAttributes, String.format(" id=\"%s\"", this.id));
        }
        commonAttributes = translatorAttributes.length();
        for (IImporterStep step : this.steps) {
            translatorAttributes.setLength(commonAttributes);
            this.appendAttribute(translatorAttributes, String.format(" maxRc=\"%s\"", step.getMaxRc()));
            if (!Verification.isNonNull((Object)step.getStepName())) {
                throw new ImporterException(Messages.zBuilder_LANGUAGE_REQ_STEP);
            }
            this.appendAttribute(translatorAttributes, String.format(" step=\"%s\"", step.getStepName()));
            step.createTokenListStepTranslator((IImporterLanguage)this, tokens, translatorAttributes);
        }
        if (this.properties != null) {
            this.properties.addTokens(tokens);
        }
        return tokens;
    }

    private boolean appendAttribute(StringBuilder attributes, String attribute) {
        if (attributes.length() > 0) {
            attributes.append("\n\t\t\t\t");
        }
        attributes.append(attribute.trim());
        return true;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final String getFolderAdditional() {
        return this.folderAdditional;
    }

    public final void setFolderAdditional(String folderAdditional) {
        this.folderAdditional = folderAdditional;
    }

    public final String getFolderPrimary() {
        return this.folderPrimary;
    }

    public final void setFolderPrimary(String folderPrimary) {
        this.folderPrimary = folderPrimary;
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getPatternAdditional() {
        return this.patternAdditional;
    }

    public final void setPatternAdditional(String patternAdditional) {
        this.patternAdditional = patternAdditional;
    }

    public final String getPatternPrimary() {
        return this.patternPrimary;
    }

    public final void setPatternPrimary(String patternPrimary) {
        this.patternPrimary = patternPrimary;
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public final void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public final IImporterAllocationSize.AllocationSize getSize() {
        return this.size;
    }

    public final void setSize(IImporterAllocationSize.AllocationSize size) {
        this.size = size;
    }

    public final Enumerator getType() {
        return this.type;
    }

    public final void setType(Enumerator type) {
        this.type = type;
    }

    public final void setType(String type) {
        this.type = LanguageCode.get((String)type);
    }

    public final String getZFolderName() {
        return this.zFolderName;
    }

    public final void setZFolderName(String zFolderName) {
        this.zFolderName = zFolderName;
    }

    public final String getProjectName() {
        return this.projectName;
    }

    public final void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public final IImporterProperties getProperties() {
        return this.properties;
    }

    public final void setProperties(IImporterProperties properties) {
        this.properties = properties;
    }

    public List<IImporterStep> getSteps() {
        return this.steps;
    }

    public List<IImporterTranslator> getTranslators() {
        return this.translators;
    }

    public void setCache(DatasetCache cache) {
        this.datasetCache = cache;
    }

    public DatasetCache getCache() {
        return this.datasetCache;
    }
}

