/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class Workspace {
    private static final String className = Workspace.class.getSimpleName();

    private Workspace() {
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, IWorkspaceHandle workspaceHandle) {
        return Workspace.getWorkspace(repository, workspaceHandle, null, (IDebugger)new Debugger(Workspace.class));
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) {
        return Workspace.getWorkspace(repository, workspaceHandle, monitor, (IDebugger)new Debugger(Workspace.class));
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IDebugger dbg) {
        return Workspace.getWorkspace(repository, workspaceHandle, null, dbg);
    }

    public static IWorkspace getWorkspace(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor, IDebugger dbg) {
        IWorkspace result = null;
        try {
            result = (IWorkspace)repository.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)result)});
        }
        return result;
    }

    public static List<IWorkspace> getWorkspaces(ITeamRepository repository, List<IWorkspaceHandle> workspaceHandles) {
        return Workspace.getWorkspaces(repository, workspaceHandles, null, (IDebugger)new Debugger(Workspace.class));
    }

    public static List<IWorkspace> getWorkspaces(ITeamRepository repository, List<IWorkspaceHandle> workspaceHandles, IProgressMonitor monitor) {
        return Workspace.getWorkspaces(repository, workspaceHandles, monitor, (IDebugger)new Debugger(Workspace.class));
    }

    public static List<IWorkspace> getWorkspaces(ITeamRepository repository, List<IWorkspaceHandle> workspaceHandles, IDebugger dbg) {
        return Workspace.getWorkspaces(repository, workspaceHandles, null, dbg);
    }

    public static List<IWorkspace> getWorkspaces(ITeamRepository repository, List<IWorkspaceHandle> workspaceHandles, IProgressMonitor monitor, IDebugger dbg) {
        List result = null;
        try {
            result = repository.itemManager().fetchCompleteItems(workspaceHandles, 0, monitor);
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((List)result)});
        }
        return result;
    }
}

