/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client;

import com.ibm.team.enterprise.internal.systemdefinition.client.ClientSideProjectAreaNameRetriever;
import com.ibm.team.enterprise.internal.systemdefinition.client.nls.Messages;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResultFeedParser;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionClient;
import com.ibm.team.enterprise.systemdefinition.common.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.IProjectAreaNameRetriever;
import com.ibm.team.enterprise.systemdefinition.common.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionModelService;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionParser;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionService;
import com.ibm.team.enterprise.systemdefinition.common.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.SystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.dto.ChangeLogDTO;
import com.ibm.team.enterprise.systemdefinition.common.parsers.SystemDefinitionHandleParser;
import com.ibm.team.enterprise.systemdefinition.common.parsers.SystemDefinitionParserFactory;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionQueryGenerator;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.common.validation.ISystemDefinitionValidator;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class SystemDefinitionClient
extends EventSource
implements ISystemDefinitionClient,
ITeamRepository.ILoginParticipant {
    private final IClientLibraryContext fContext;
    private Boolean smpeEnabled;

    public SystemDefinitionClient(IClientLibraryContext context) {
        this.fContext = context;
        context.teamRepository().addLoginParticipant((ITeamRepository.ILoginParticipant)this);
    }

    protected IClientLibraryContext getContext() {
        return this.fContext;
    }

    protected ITeamRepository getRepository() {
        return this.fContext.teamRepository();
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)this.getContext().getServiceInterface(clazz);
    }

    protected Object callCancelableService(IProgressMonitor progressMonitor, IClientLibraryContext.IServiceRunnable serviceRunnable) throws TeamRepositoryException {
        return this.getContext().callCancelableService(serviceRunnable, progressMonitor);
    }

    @Override
    public String runSelectQuery(final String sparql) throws TeamRepositoryException {
        return (String)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String results = SystemDefinitionClient.this.getService(ISystemDefinitionService.class).runSelectQuery(sparql);
                return results;
            }
        });
    }

    @Override
    public List<SelectResult> runSelectQuery(String sparql, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.runSelectQuery(sparql, null, monitor);
    }

    @Override
    public List<SelectResult> runSelectQuery(final String sparql, final String ifModifiedSince, IProgressMonitor monitor) throws TeamRepositoryException {
        return (List)this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public List<SelectResult> run(IProgressMonitor monitor) throws TeamRepositoryException {
                String results = SystemDefinitionClient.this.getService(ISystemDefinitionService.class).runSelectQuery2(sparql, ifModifiedSince);
                List selectResults = null;
                try {
                    SelectResultFeedParser parser = new SelectResultFeedParser();
                    selectResults = parser.parse((InputStream)new ByteArrayInputStream(results.getBytes("UTF-8")));
                }
                catch (Exception e) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.SystemDefinitionClient_QUERY_ERROR, (Object)sparql), (Throwable)e);
                }
                return selectResults;
            }
        });
    }

    @Override
    public void deleteSystemDefinition(final String systemDefinitionSlug) throws TeamRepositoryException {
        this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                SystemDefinitionClient.this.getService(ISystemDefinitionService.class).deleteSystemDefinition(systemDefinitionSlug);
                return systemDefinitionSlug;
            }
        });
    }

    @Override
    public void updateSystemDefinition(final String systemDefinitionSlug, final String systemDefinitionXML) throws TeamRepositoryException {
        this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                SystemDefinitionClient.this.getService(ISystemDefinitionService.class).updateSystemDefinition(systemDefinitionSlug, systemDefinitionXML);
                return systemDefinitionXML;
            }
        });
    }

    @Override
    public String saveSystemDefinition(final ISystemDefinition systemDefinition, IProgressMonitor monitor) throws TeamRepositoryException {
        return (String)this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public String run(IProgressMonitor monitor) throws TeamRepositoryException {
                ISystemDefinitionValidator[] validators = systemDefinition.getValidators();
                if (validators != null) {
                    ClientSideProjectAreaNameRetriever projectAreaRetriever = new ClientSideProjectAreaNameRetriever(SystemDefinitionClient.this.getRepository());
                    ISystemDefinitionValidator[] iSystemDefinitionValidatorArray = validators;
                    int n = validators.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ISystemDefinitionValidator validator = iSystemDefinitionValidatorArray[n2];
                        validator.validate(systemDefinition, SystemDefinitionClient.this.getService(ISystemDefinitionService.class), (IProjectAreaNameRetriever)projectAreaRetriever);
                        ++n2;
                    }
                }
                ISystemDefinitionParser parser = new SystemDefinitionParserFactory().getSystemDefinitionParser(systemDefinition);
                String lastModifiedTimestamp = systemDefinition.getType().equals("languagedefinition") ? SystemDefinitionClient.this.getService(ISystemDefinitionService.class).saveLanguageDefinition(SystemDefinitionUtil.createSystemDefinitionSlug((ISystemDefinition)systemDefinition), parser.convertToXml(systemDefinition), systemDefinition.getProjectAreaUuid(), systemDefinition.isNew()) : (systemDefinition.getType().equals("translator") ? SystemDefinitionClient.this.getService(ISystemDefinitionService.class).saveTranslator(SystemDefinitionUtil.createSystemDefinitionSlug((ISystemDefinition)systemDefinition), parser.convertToXml(systemDefinition), systemDefinition.getProjectAreaUuid(), systemDefinition.isNew()) : (systemDefinition.getType().equals("searchpath") ? SystemDefinitionClient.this.getService(ISystemDefinitionService.class).saveSearchPath(SystemDefinitionUtil.createSystemDefinitionSlug((ISystemDefinition)systemDefinition), parser.convertToXml(systemDefinition), systemDefinition.getProjectAreaUuid(), systemDefinition.isNew()) : (systemDefinition.getType().equals("resourcedefinition") ? SystemDefinitionClient.this.getService(ISystemDefinitionService.class).saveResourceDefinition(SystemDefinitionUtil.createSystemDefinitionSlug((ISystemDefinition)systemDefinition), parser.convertToXml(systemDefinition), systemDefinition.getProjectAreaUuid(), systemDefinition.isNew()) : (systemDefinition.getType().equals("functiondefinition") ? SystemDefinitionClient.this.getService(ISystemDefinitionService.class).saveFunctionDefinition(SystemDefinitionUtil.createSystemDefinitionSlug((ISystemDefinition)systemDefinition), parser.convertToXml(systemDefinition), systemDefinition.getProjectAreaUuid(), systemDefinition.isNew()) : (systemDefinition.getType().equals("versiondefinition") ? SystemDefinitionClient.this.getService(ISystemDefinitionService.class).saveVersionDefinition(SystemDefinitionUtil.createSystemDefinitionSlug((ISystemDefinition)systemDefinition), parser.convertToXml(systemDefinition), systemDefinition.getProjectAreaUuid(), systemDefinition.isNew()) : SystemDefinitionClient.this.getService(ISystemDefinitionService.class).updateSystemDefinition(SystemDefinitionUtil.createSystemDefinitionSlug((ISystemDefinition)systemDefinition), parser.convertToXml(systemDefinition)))))));
                if (lastModifiedTimestamp != null && !lastModifiedTimestamp.isEmpty()) {
                    systemDefinition.setIsNew(false);
                }
                return lastModifiedTimestamp;
            }
        });
    }

    @Override
    public ILanguageDefinition getLanguageDefinition(UUID languageDefinitionId, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getLanguageDefinition(languageDefinitionId, null, monitor);
    }

    @Override
    public ILanguageDefinition getLanguageDefinition(UUID languageDefinitionId, String revision, IProgressMonitor monitor) throws TeamRepositoryException {
        return (ILanguageDefinition)this.getSystemDefinition(languageDefinitionId, revision, "languagedefinition", monitor);
    }

    @Override
    public String[] getLanguageDefinitionUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getLanguageDefinitionUuids(projectAreaUuid, platform, false, monitor);
    }

    @Override
    public String[] getLanguageDefinitionUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, boolean includeArchive, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getLanguageDefinitionUuids(projectAreaUuid, platform, includeArchive, null, monitor);
    }

    @Override
    public String[] getLanguageDefinitionUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, boolean includeArchive, String ifModifiedSince, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getSystemDefinitionUuids(projectAreaUuid, "languagedefinition", platform, includeArchive, ifModifiedSince, monitor);
    }

    @Override
    public String deleteLanguageDefinition(UUID languageDefinitionId, UUID projectAreaUuid) throws TeamRepositoryException {
        return this.getService(ISystemDefinitionService.class).deleteLanguageDefinition(SystemDefinitionUtil.createSystemDefinitionSlug((String)languageDefinitionId.getUuidValue()), projectAreaUuid.getUuidValue());
    }

    @Override
    public ILanguageDefinition getDefaultLanguageDefinition(String filePath, IProgressMonitor monitor) throws TeamRepositoryException {
        String xmlContent = this.getService(ISystemDefinitionService.class).getDefaultLanguageDefinition(filePath);
        if (xmlContent == null) {
            return null;
        }
        ISystemDefinitionParser parser = new SystemDefinitionParserFactory().getSystemDefinitionParser(xmlContent);
        if (parser == null) {
            return null;
        }
        return (ILanguageDefinition)parser.parse(xmlContent);
    }

    @Override
    public ITranslator getTranslator(UUID translatorId, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getTranslator(translatorId, null, monitor);
    }

    @Override
    public ITranslator getTranslator(UUID translatorId, String revision, IProgressMonitor monitor) throws TeamRepositoryException {
        return (ITranslator)this.getSystemDefinition(translatorId, revision, "translator", monitor);
    }

    @Override
    public String[] getTranslatorUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getTranslatorUuids(projectAreaUuid, platform, false, monitor);
    }

    @Override
    public String[] getTranslatorUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, boolean includeArchive, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getTranslatorUuids(projectAreaUuid, platform, includeArchive, null, monitor);
    }

    @Override
    public String[] getTranslatorUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, boolean includeArchive, String ifModifiedSince, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getSystemDefinitionUuids(projectAreaUuid, "translator", platform, includeArchive, ifModifiedSince, monitor);
    }

    @Override
    public String deleteTranslator(UUID translatorId, UUID projectAreaUuid) throws TeamRepositoryException {
        return this.getService(ISystemDefinitionService.class).deleteTranslator(SystemDefinitionUtil.createSystemDefinitionSlug((String)translatorId.getUuidValue()), projectAreaUuid.getUuidValue());
    }

    @Override
    public IResourceDefinition getResourceDefinition(UUID resourceDefinitionId, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getResourceDefinition(resourceDefinitionId, null, monitor);
    }

    @Override
    public IResourceDefinition getResourceDefinition(final UUID resourceDefinitionId, final String revision, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IResourceDefinition)this.callCancelableService(monitor, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<ISystemDefinition>(){

            public IResourceDefinition run(IProgressMonitor monitor) throws TeamRepositoryException {
                String xmlContent = SystemDefinitionClient.this.getService(ISystemDefinitionService.class).getSystemDefinitionWithRevision(resourceDefinitionId.getUuidValue(), revision, "resourcedefinition");
                if (xmlContent == null) {
                    return null;
                }
                ISystemDefinitionParser parser = new SystemDefinitionParserFactory().getResourceDefinitionParser(xmlContent);
                if (parser == null) {
                    return null;
                }
                return (IResourceDefinition)parser.parse(xmlContent);
            }
        });
    }

    @Override
    public String[] getResourceDefinitionUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getResourceDefinitionUuids(projectAreaUuid, platform, false, monitor);
    }

    @Override
    public String[] getResourceDefinitionUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, boolean includeArchive, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getResourceDefinitionUuids(projectAreaUuid, platform, -1, includeArchive, monitor);
    }

    @Override
    public String[] getResourceDefinitionUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, int usageType, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getResourceDefinitionUuids(projectAreaUuid, platform, usageType, false, monitor);
    }

    @Override
    public String[] getResourceDefinitionUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, int usageType, boolean includeArchive, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getResourceDefinitionUuids(projectAreaUuid, platform, usageType, includeArchive, null, monitor);
    }

    @Override
    public String[] getResourceDefinitionUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, int usageType, boolean includeArchive, String ifModifiedSince, IProgressMonitor monitor) throws TeamRepositoryException {
        String query = SystemDefinitionQueryGenerator.getResourceDefinitionUuidsForProjectAreaQuery((String)projectAreaUuid.getUuidValue(), (String)platform.name(), (int)usageType, (boolean)includeArchive);
        List<SelectResult> results = this.runSelectQuery(query, ifModifiedSince, monitor);
        return this.getBindingValues(results, "uuid");
    }

    @Override
    public String deleteResourceDefinition(UUID resourceDefinitionId, UUID projectAreaUuid) throws TeamRepositoryException {
        return this.getService(ISystemDefinitionService.class).deleteResourceDefinition(SystemDefinitionUtil.createSystemDefinitionSlug((String)resourceDefinitionId.getUuidValue()), projectAreaUuid.getUuidValue());
    }

    @Override
    public ISearchPath getSearchPath(UUID searchPathId, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getSearchPath(searchPathId, null, monitor);
    }

    @Override
    public ISearchPath getSearchPath(UUID searchPathId, String revision, IProgressMonitor monitor) throws TeamRepositoryException {
        return (ISearchPath)this.getSystemDefinition(searchPathId, revision, "searchpath", monitor);
    }

    @Override
    public String[] getSearchPathUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getSearchPathUuids(projectAreaUuid, platform, false, monitor);
    }

    @Override
    public String[] getSearchPathUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, boolean includeArchive, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getSearchPathUuids(projectAreaUuid, platform, includeArchive, null, monitor);
    }

    @Override
    public String[] getSearchPathUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, boolean includeArchive, String ifModifiedSince, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getSystemDefinitionUuids(projectAreaUuid, "searchpath", platform, includeArchive, ifModifiedSince, monitor);
    }

    @Override
    public String deleteSearchPath(UUID searchPathId, UUID projectAreaUuid) throws TeamRepositoryException {
        return this.getService(ISystemDefinitionService.class).deleteSearchPath(SystemDefinitionUtil.createSystemDefinitionSlug((String)searchPathId.getUuidValue()), projectAreaUuid.getUuidValue());
    }

    @Override
    public IFunctionDefinition getFunctionDefinition(UUID functionDefinitionUuid, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getFunctionDefinition(functionDefinitionUuid, null, monitor);
    }

    @Override
    public IFunctionDefinition getFunctionDefinition(UUID functionDefinitionUuid, String revision, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IFunctionDefinition)this.getSystemDefinition(functionDefinitionUuid, revision, "functiondefinition", monitor);
    }

    @Override
    public String[] getFunctionDefinitionUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getFunctionDefinitionUuids(projectAreaUuid, platform, false, monitor);
    }

    @Override
    public String[] getFunctionDefinitionUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, boolean includeArchive, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getFunctionDefinitionUuids(projectAreaUuid, platform, includeArchive, null, monitor);
    }

    @Override
    public String[] getFunctionDefinitionUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, boolean includeArchive, String ifModifiedSince, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getSystemDefinitionUuids(projectAreaUuid, "functiondefinition", platform, includeArchive, ifModifiedSince, monitor);
    }

    @Override
    public String deleteFunctionDefinition(UUID functionDefinitionUuid, UUID projectAreaUuid) throws TeamRepositoryException {
        return this.getService(ISystemDefinitionService.class).deleteFunctionDefinition(SystemDefinitionUtil.createSystemDefinitionSlug((String)functionDefinitionUuid.getUuidValue()), projectAreaUuid.getUuidValue());
    }

    @Override
    public IVersionDefinition getVersionDefinition(UUID versionDefinitionUuid, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getVersionDefinition(versionDefinitionUuid, null, monitor);
    }

    @Override
    public IVersionDefinition getVersionDefinition(UUID versionDefinitionUuid, String revision, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IVersionDefinition)this.getSystemDefinition(versionDefinitionUuid, revision, "versiondefinition", monitor);
    }

    @Override
    public String[] getVersionDefinitionUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getVersionDefinitionUuids(projectAreaUuid, platform, false, monitor);
    }

    @Override
    public String[] getVersionDefinitionUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, boolean includeArchive, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getVersionDefinitionUuids(projectAreaUuid, platform, includeArchive, null, monitor);
    }

    @Override
    public String[] getVersionDefinitionUuids(UUID projectAreaUuid, ISystemDefinition.Platform platform, boolean includeArchive, String ifModifiedSince, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getSystemDefinitionUuids(projectAreaUuid, "versiondefinition", platform, includeArchive, ifModifiedSince, monitor);
    }

    @Override
    public String deleteVersionDefinition(UUID versionDefinitionUuid, UUID projectAreaUuid) throws TeamRepositoryException {
        return this.getService(ISystemDefinitionService.class).deleteVersionDefinition(SystemDefinitionUtil.createSystemDefinitionSlug((String)versionDefinitionUuid.getUuidValue()), projectAreaUuid.getUuidValue());
    }

    private ISystemDefinition getSystemDefinition(final UUID uuid, final String revision, final String type, IProgressMonitor monitor) throws TeamRepositoryException {
        return (ISystemDefinition)this.callCancelableService(monitor, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<ISystemDefinition>(){

            public ISystemDefinition run(IProgressMonitor monitor) throws TeamRepositoryException {
                String xmlContent = SystemDefinitionClient.this.getService(ISystemDefinitionService.class).getSystemDefinitionWithRevision(uuid.getUuidValue(), revision, type);
                if (xmlContent == null || "".equals(xmlContent)) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.SystemDefinitionClient_NOT_EXIST, (Object)uuid));
                }
                ISystemDefinitionParser parser = new SystemDefinitionParserFactory().getSystemDefinitionParser(xmlContent);
                if (parser == null) {
                    return null;
                }
                return parser.parse(xmlContent);
            }
        });
    }

    protected String[] getSystemDefinitionUuids(UUID projectAreaUuid, String type, ISystemDefinition.Platform platform, boolean includeArchive, String ifModifiedSince, IProgressMonitor monitor) throws TeamRepositoryException {
        String query = SystemDefinitionQueryGenerator.getSystemDefinitionUuidsForProjectAreaQuery((String)projectAreaUuid.getUuidValue(), (String)type, (String)platform.name(), (boolean)includeArchive);
        List<SelectResult> results = this.runSelectQuery(query, ifModifiedSince, monitor);
        return this.getBindingValues(results, "uuid");
    }

    private String[] getBindingValues(List<SelectResult> selectResults, String bindingName) throws TeamRepositoryException {
        ArrayList<String> resultStringsList = new ArrayList<String>(selectResults.size());
        block0: for (SelectResult selectResult : selectResults) {
            for (Binding binding : selectResult.getBindings()) {
                if (!binding.getName().equals(bindingName)) continue;
                resultStringsList.add(binding.getValue());
                continue block0;
            }
        }
        return resultStringsList.toArray(new String[resultStringsList.size()]);
    }

    @Override
    public List<ISystemDefinitionHandle> getSystemDefinitionHandles(UUID projectAreaUuid, String type, ISystemDefinition.Platform platform) throws TeamRepositoryException {
        ArrayList<ISystemDefinitionHandle> handles = new ArrayList<ISystemDefinitionHandle>();
        String projectAreaUuidValue = null;
        if (projectAreaUuid != null) {
            projectAreaUuidValue = projectAreaUuid.getUuidValue();
        }
        String platformValue = null;
        if (platform != null) {
            platformValue = platform.name();
        }
        String query = SystemDefinitionQueryGenerator.getSystemDefinitionHandlesQuery((String)projectAreaUuidValue, (String)type, (String)platformValue, (boolean)false);
        List<SelectResult> results = this.runSelectQuery(query, null);
        for (SelectResult result : results) {
            String nextUuid = null;
            String nextName = null;
            String nextType = null;
            ISystemDefinition.Platform nextPlatform = null;
            boolean isArchived = false;
            for (Binding binding : result.getBindings()) {
                if (binding.getName().equals("uuid")) {
                    nextUuid = binding.getValue();
                    continue;
                }
                if (binding.getName().equals("name")) {
                    nextName = binding.getValue();
                    continue;
                }
                if (binding.getName().equals("type")) {
                    nextType = binding.getValue();
                    continue;
                }
                if (binding.getName().equals("platform")) {
                    nextPlatform = ISystemDefinition.Platform.valueOf((String)binding.getValue());
                    continue;
                }
                if (!binding.getName().equals("archived")) continue;
                isArchived = Boolean.parseBoolean(binding.getValue());
            }
            if (nextType == null && type != null) {
                nextType = type;
            }
            if (nextPlatform == null && platform != null) {
                nextPlatform = platform;
            }
            if (!this.isValidUuid(nextUuid) || nextName == null || nextType == null || nextPlatform == null) continue;
            handles.add((ISystemDefinitionHandle)new SystemDefinitionHandle(UUID.valueOf((String)nextUuid), nextName, nextPlatform, nextType, projectAreaUuid, isArchived));
        }
        return handles;
    }

    private boolean isValidUuid(String uuidValue) {
        try {
            if (uuidValue != null) {
                UUID.valueOf((String)uuidValue);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public ISystemDefinitionHandle getSystemDefinitionHandle(UUID definitionUUID, String type) throws TeamRepositoryException {
        String result = this.getService(ISystemDefinitionService.class).getSystemDefinitionHandle(definitionUUID, type);
        try {
            JSONArray jsonArray = JSONArray.parse((Reader)new StringReader(result));
            ISystemDefinitionHandle handle = null;
            Iterator iterator = jsonArray.iterator();
            if (iterator.hasNext()) {
                handle = new SystemDefinitionHandleParser().parseJSON((JSONObject)iterator.next());
            }
            return handle;
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    @Override
    public List<ISystemDefinitionHandle> getAllSystemDefinitionHandles(UUID projectAreaUUID, ISystemDefinition.Platform platform, String type, String ifModifiedSince) throws TeamRepositoryException {
        return this.getAllSystemDefinitionHandles(projectAreaUUID, platform, type, false, ifModifiedSince);
    }

    @Override
    public List<ISystemDefinitionHandle> getAllSystemDefinitionHandles(UUID projectAreaUUID, ISystemDefinition.Platform platform, String type, boolean includeArchived, String ifModifiedSince) throws TeamRepositoryException {
        return this.getAllSystemDefinitionHandles(projectAreaUUID, platform, type, -1, includeArchived, ifModifiedSince);
    }

    @Override
    public List<ISystemDefinitionHandle> getAllResourceDefinitionHandles(UUID projectAreaUUID, ISystemDefinition.Platform platform, int usageType, String ifModifiedSince) throws TeamRepositoryException {
        return this.getAllResourceDefinitionHandles(projectAreaUUID, platform, usageType, false, ifModifiedSince);
    }

    @Override
    public List<ISystemDefinitionHandle> getAllResourceDefinitionHandles(UUID projectAreaUUID, ISystemDefinition.Platform platform, int usageType, boolean includeArchived, String ifModifiedSince) throws TeamRepositoryException {
        return this.getAllSystemDefinitionHandles(projectAreaUUID, platform, "resourcedefinition", usageType, includeArchived, ifModifiedSince);
    }

    private List<ISystemDefinitionHandle> getAllSystemDefinitionHandles(UUID projectAreaUUID, ISystemDefinition.Platform platform, String type, int usageType, boolean includeArchived, String ifModifiedSince) throws TeamRepositoryException {
        String platformValue = platform == null ? null : platform.name();
        String result = this.getService(ISystemDefinitionService.class).getAllSystemDefinitionHandles(projectAreaUUID, platformValue, type, usageType, includeArchived, ifModifiedSince);
        try {
            JSONArray jsonArray = JSONArray.parse((Reader)new StringReader(result));
            ArrayList<ISystemDefinitionHandle> handles = new ArrayList<ISystemDefinitionHandle>(jsonArray.size());
            Iterator iterator = jsonArray.iterator();
            SystemDefinitionHandleParser parser = new SystemDefinitionHandleParser();
            while (iterator.hasNext()) {
                handles.add(parser.parseJSON((JSONObject)iterator.next()));
            }
            return handles;
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    @Override
    public boolean hasSystemDefinitions(UUID projectAreaUUID, ISystemDefinition.Platform platform, String type, int usageType, boolean includeArchived, String ifModifiedSince) throws TeamRepositoryException {
        String platformValue = platform == null ? null : platform.name();
        return this.getService(ISystemDefinitionService.class).hasSystemDefinitions(projectAreaUUID, platformValue, type, usageType, includeArchived, ifModifiedSince);
    }

    @Override
    public void deleteQueryCache(String type) {
        this.getService(ISystemDefinitionService.class).deleteQueryCache(type);
    }

    @Override
    public List<ChangeLogDTO> computeSystemDefHistory(String sysDefUUID, String stateId, String type, IProgressMonitor monitor) throws TeamRepositoryException {
        List<ChangeLogDTO> result = null;
        try {
            ChangeLogDTO[] changeLogDTOs = this.getService(ISystemDefinitionService.class).computeHistory(sysDefUUID, stateId, type);
            result = Arrays.asList(changeLogDTOs);
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return result;
    }

    @Override
    public String getLatestStateId(String sysDefUUID, String type) {
        String result = null;
        try {
            result = this.getService(ISystemDefinitionService.class).getLatestStateId(sysDefUUID, type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Timestamp getModifiedDateByStateId(String sysDefUUID, String stateId, String type) throws TeamRepositoryException {
        Timestamp result = null;
        try {
            result = this.getService(ISystemDefinitionService.class).getModifiedDateByStateId(sysDefUUID, stateId, type);
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return result;
    }

    @Override
    public boolean isSMPEEnabled(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.smpeEnabled == null) {
            this.smpeEnabled = (Boolean)this.callCancelableService(monitor, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Boolean>(){

                public Boolean run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return SystemDefinitionClient.this.getService(ISystemDefinitionModelService.class).isSMPEEnabled();
                }
            });
        }
        return false;
    }

    public void handleLogin(ITeamRepository repository) {
        try {
            this.isSMPEEnabled((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleLogout(ITeamRepository repository) {
        this.smpeEnabled = null;
    }
}

