/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.systemdefinition.client;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProjectArea {
    private static final String className = ProjectArea.class.getSimpleName();

    private ProjectArea() {
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, IProjectAreaHandle projectArea) {
        return ProjectArea.getProjectArea(repository, projectArea, null, (IDebugger)new Debugger(ProjectArea.class));
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, IProjectAreaHandle projectArea, IProgressMonitor monitor) {
        return ProjectArea.getProjectArea(repository, projectArea, monitor, (IDebugger)new Debugger(ProjectArea.class));
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, IProjectAreaHandle projectArea, IDebugger dbg) {
        return ProjectArea.getProjectArea(repository, projectArea, null, dbg);
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, IProjectAreaHandle projectArea, IProgressMonitor monitor, IDebugger dbg) {
        IProjectArea result = null;
        try {
            result = (IProjectArea)repository.itemManager().fetchCompleteItem((IItemHandle)projectArea, 0, monitor);
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)result)});
        }
        return result;
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, String projectAreaName) {
        return ProjectArea.getProjectArea(repository, projectAreaName, null, (IDebugger)new Debugger(ProjectArea.class));
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, String projectAreaName, IProgressMonitor monitor) {
        return ProjectArea.getProjectArea(repository, projectAreaName, monitor, (IDebugger)new Debugger(ProjectArea.class));
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, String projectAreaName, IDebugger dbg) {
        return ProjectArea.getProjectArea(repository, projectAreaName, null, dbg);
    }

    public static IProjectArea getProjectArea(ITeamRepository repository, String projectAreaName, IProgressMonitor monitor, IDebugger dbg) {
        IProjectArea result = null;
        try {
            URI projectAreaUri = URI.create(projectAreaName.replaceAll(" ", "%20"));
            IProcessClientService processClient = (IProcessClientService)repository.getClientLibrary(IProcessClientService.class);
            result = (IProjectArea)processClient.findProcessArea(projectAreaUri, IProcessItemService.ALL_PROPERTIES, monitor);
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)result)});
        }
        return result;
    }
}

