/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.wizards;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainRegistry;
import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import com.ibm.team.enterprise.smpe.ui.editors.VersionDefinitionEditorInput;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.smpe.ui.wizards.NewFunctionDefinitionWizard;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionWizard;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.AbstractSystemDefinitionWizard;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.ProjectAreaSelectionPage;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class NewVersionDefinitionWizard
extends AbstractSystemDefinitionWizard
implements ISystemDefinitionWizard {
    public NewVersionDefinitionWizard() {
        this.getProjectAreaSelectionPage().setAreaSelectionValidator((ProjectAreaSelectionPage.IProcessAreaSelectionValidator)new NewFunctionDefinitionWizard.SmpeProcessAreaSelectionValidator());
    }

    protected String getDefinitionPluginID() {
        return SmpeUIPlugin.getUniqueIdentifier();
    }

    protected Action getDefinitionWizardAction(IProjectAreaHandle projectArea) {
        return this.getNewVersionDefinitionAction(projectArea);
    }

    protected String getDefinitionWizardImagePath() {
        return "icons/wizban/version_wizban.gif";
    }

    protected IWizardPage[] getDefinitionWizardPages() {
        return null;
    }

    protected String getDefinitionWizardTitle() {
        return Messages.NewVersionDefinitionWizard_Title_0;
    }

    private Action getNewVersionDefinitionAction(final IProjectAreaHandle projectArea) {
        return new Action(Messages.NewVersionDefinitionWizard_Action){

            public void run() {
                IWorkbenchPage fPage = NewVersionDefinitionWizard.this.getWorkbenchPage();
                if (NewVersionDefinitionWizard.this.getWorkbenchPage() != null) {
                    try {
                        EnterpriseExtensionsDomainRegistry eeRegistry = EnterpriseExtensionsDomainRegistry.getInstance();
                        AbstractEnterpriseExtensionsNode parentNode = (AbstractEnterpriseExtensionsNode)eeRegistry.getEnterpriseExtensionsNode(projectArea, "SystemDefinitions/ZOS35/VersionDefinitions");
                        VersionDefinitionEditorInput input = new VersionDefinitionEditorInput(null, projectArea, parentNode);
                        fPage.openEditor((IEditorInput)input, "com.ibm.team.enterprise.smpe.ui.editors.versionDefinitionEditor");
                    }
                    catch (PartInitException exception) {
                        SmpeUIPlugin.log(exception);
                    }
                    catch (TeamRepositoryException e) {
                        SmpeUIPlugin.log(e);
                    }
                }
            }

            public String getId() {
                return "new.version.definition";
            }
        };
    }
}

