/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.wizards;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainRegistry;
import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import com.ibm.team.enterprise.smpe.ui.editors.FunctionDefinitionEditorInput;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionWizard;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.AbstractSystemDefinitionWizard;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.ProjectAreaSelectionPage;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class NewFunctionDefinitionWizard
extends AbstractSystemDefinitionWizard
implements ISystemDefinitionWizard {
    public NewFunctionDefinitionWizard() {
        this.getProjectAreaSelectionPage().setAreaSelectionValidator((ProjectAreaSelectionPage.IProcessAreaSelectionValidator)new SmpeProcessAreaSelectionValidator());
    }

    protected String getDefinitionPluginID() {
        return SmpeUIPlugin.getUniqueIdentifier();
    }

    protected Action getDefinitionWizardAction(IProjectAreaHandle projectArea) {
        return this.getNewFunctionDefinitionAction(projectArea);
    }

    protected String getDefinitionWizardImagePath() {
        return "icons/wizban/function_wizban.gif";
    }

    protected IWizardPage[] getDefinitionWizardPages() {
        return null;
    }

    protected String getDefinitionWizardTitle() {
        return Messages.NewFunctionDefinitionWizard_Title_0;
    }

    private Action getNewFunctionDefinitionAction(final IProjectAreaHandle projectArea) {
        return new Action(Messages.NewFunctionDefinitionWizard_Action){

            public void run() {
                IWorkbenchPage fPage = NewFunctionDefinitionWizard.this.getWorkbenchPage();
                if (NewFunctionDefinitionWizard.this.getWorkbenchPage() != null) {
                    try {
                        EnterpriseExtensionsDomainRegistry eeRegistry = EnterpriseExtensionsDomainRegistry.getInstance();
                        AbstractEnterpriseExtensionsNode parentNode = (AbstractEnterpriseExtensionsNode)eeRegistry.getEnterpriseExtensionsNode(projectArea, "SystemDefinitions/ZOS35/VersionDefinitions");
                        FunctionDefinitionEditorInput input = new FunctionDefinitionEditorInput(null, projectArea, parentNode);
                        fPage.openEditor((IEditorInput)input, "com.ibm.team.enterprise.smpe.ui.editors.functionDefinitionEditor");
                    }
                    catch (PartInitException exception) {
                        SmpeUIPlugin.log(exception);
                    }
                    catch (TeamRepositoryException e) {
                        SmpeUIPlugin.log(e);
                    }
                }
            }

            public String getId() {
                return "new.function.definition";
            }
        };
    }

    public static class SmpeProcessAreaSelectionValidator
    implements ProjectAreaSelectionPage.IProcessAreaSelectionValidator {
        public String validate(IProcessArea selection) {
            ITeamRepository repository = (ITeamRepository)selection.getOrigin();
            try {
                ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)repository);
                if (!client.isSMPEEnabled(null)) {
                    return Messages.NewFunctionDefinitionWizard_SmpeNotEnabled;
                }
            }
            catch (TeamRepositoryException e) {
                SmpeUIPlugin.log(e);
            }
            return null;
        }
    }
}

