/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.utils;

import com.ibm.team.build.extensions.client.debug.ClientLogString;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TeamRepository {
    private static final String className = TeamRepository.class.getSimpleName();

    public static ITeamRepository getRepository(String projectAreaName) {
        return TeamRepository.getRepository(projectAreaName, (IDebugger)new Debugger(TeamRepository.class));
    }

    public static ITeamRepository getRepository(String projectAreaName, IDebugger dbg) {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ITeamRepository teamRepository = null;
        ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        Set<ITeamRepository> teamRepositoryList = TeamRepository.getRepositoryList(registry, dbg);
        block0: for (ITeamRepository repository : teamRepositoryList) {
            List projectAreaHandleList;
            if (!repository.loggedIn() || (projectAreaHandleList = registry.getConnectedProjectAreas(repository, false)) == null) continue;
            for (IProjectAreaHandle projectAreaHandle : projectAreaHandleList) {
                if (!projectAreaName.equals(registry.getProjectAreaName(projectAreaHandle))) continue;
                teamRepository = repository;
                continue block0;
            }
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), ClientLogString.valueOf(teamRepository)});
        }
        return teamRepository;
    }

    public static Set<ITeamRepository> getRepositoryList(ConnectedProjectAreaRegistry registry) {
        return TeamRepository.getRepositoryList(registry, (IDebugger)new Debugger(TeamRepository.class));
    }

    public static Set<ITeamRepository> getRepositoryList(ConnectedProjectAreaRegistry registry, IDebugger dbg) {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        HashSet<ITeamRepository> teamRepositoryList = new HashSet<ITeamRepository>();
        List projectAreaHandleList = registry.getConnectedProjectAreas(null);
        for (IProjectAreaHandle projectAreaHandle : projectAreaHandleList) {
            Object origin = projectAreaHandle.getOrigin();
            if (!(origin instanceof ITeamRepository)) continue;
            teamRepositoryList.add((ITeamRepository)origin);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(teamRepositoryList.size())});
        }
        return teamRepositoryList;
    }

    public static Set<ITeamRepository> getRepositoryList() {
        return TeamRepository.getRepositoryList((IDebugger)new Debugger(TeamRepository.class));
    }

    public static Set<ITeamRepository> getRepositoryList(IDebugger dbg) {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        HashSet<ITeamRepository> teamRepositoryList = new HashSet<ITeamRepository>();
        ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        List projectAreaHandleList = registry.getConnectedProjectAreas(null);
        for (IProjectAreaHandle projectAreaHandle : projectAreaHandleList) {
            Object origin = projectAreaHandle.getOrigin();
            if (!(origin instanceof ITeamRepository)) continue;
            teamRepositoryList.add((ITeamRepository)origin);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(teamRepositoryList.size())});
        }
        return teamRepositoryList;
    }

    public static IProjectAreaHandle getProjectAreaHandle(String projectAreaName) {
        return TeamRepository.getProjectAreaHandle(projectAreaName, (IDebugger)new Debugger(TeamRepository.class));
    }

    public static IProjectAreaHandle getProjectAreaHandle(String projectAreaName, IDebugger dbg) {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IProjectAreaHandle projectAreaHandle = null;
        ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        List projectAreaHandleList = registry.getConnectedProjectAreas(null);
        if (projectAreaHandleList != null) {
            for (IProjectAreaHandle thisProjectAreaHandle : projectAreaHandleList) {
                if (!projectAreaName.equals(registry.getProjectAreaName(thisProjectAreaHandle))) continue;
                projectAreaHandle = thisProjectAreaHandle;
                break;
            }
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)projectAreaHandle)});
        }
        return projectAreaHandle;
    }
}

