/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.utils;

import com.ibm.team.build.extensions.common.util.BooleanUtil;
import com.ibm.team.build.extensions.common.util.StringUtil;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.build.ui.metadata.api.IMetadata;
import com.ibm.team.enterprise.build.ui.metadata.core.api.Metadata;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheFactory;
import com.ibm.team.enterprise.systemdefinition.client.packaging.PackagingFactory;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterPropertyKey;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingItemFile;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingItemFolder;
import com.ibm.team.enterprise.systemdefinition.common.model.Disttype;
import com.ibm.team.enterprise.systemdefinition.common.model.Hfsdata;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingDetailDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.Id;
import com.ibm.team.enterprise.systemdefinition.common.model.Mcstype;
import com.ibm.team.enterprise.systemdefinition.common.model.Processor;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingDetail;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingItem;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IResource;

public class PackagingTools {
    public final IPackagingItem createPackagingFileItem(IResource resource, IMetadata metadata, ITeamRepository repository, IPackagingItem packagingFolder) {
        IProjectAreaHandle projectArea = packagingFolder.getProjectArea();
        Map propertyMap = ((Metadata)metadata).getVersionableProperties().getCurrentProperties();
        ArrayList<String> addUuids = null;
        ArrayList<String> orderUuids = null;
        ArrayList<String> removeUuids = null;
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.tableAdd") && Verification.isNonBlank((String)((String)propertyMap.get("team.enterprise.smpe.packagingdetail.file.tableAdd")))) {
            addUuids = new ArrayList<String>(Arrays.asList(((String)propertyMap.get("team.enterprise.smpe.packagingdetail.file.tableAdd")).split(",")));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.tableOrder") && Verification.isNonBlank((String)((String)propertyMap.get("team.enterprise.smpe.packagingdetail.file.tableOrder")))) {
            orderUuids = new ArrayList<String>(Arrays.asList(((String)propertyMap.get("team.enterprise.smpe.packagingdetail.file.tableOrder")).split(",")));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.tableRemove") && Verification.isNonBlank((String)((String)propertyMap.get("team.enterprise.smpe.packagingdetail.file.tableRemove")))) {
            removeUuids = new ArrayList<String>(Arrays.asList(((String)propertyMap.get("team.enterprise.smpe.packagingdetail.file.tableRemove")).split(",")));
        }
        PackagingItemFile packagingFile = new PackagingItemFile(packagingFolder);
        packagingFile.init(addUuids, removeUuids, orderUuids);
        packagingFile.setName(resource.getName());
        packagingFile.setNonImpacting(packagingFolder.isNonImpacting());
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.alias") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.alias"))) {
            packagingFile.setAlias((String)propertyMap.get("team.enterprise.smpe.packaging.file.alias"));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.class") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.class"))) {
            packagingFile.setClazz((String)propertyMap.get("team.enterprise.smpe.packaging.file.class"));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.csect") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.csect"))) {
            packagingFile.setCsect((String)propertyMap.get("team.enterprise.smpe.packaging.file.csect"));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.deleted") && Verification.isTrueFalse((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.deleted")))) {
            packagingFile.setDeleted(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get("team.enterprise.smpe.packaging.file.deleted"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.description") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.description"))) {
            packagingFile.setDescription((String)propertyMap.get("team.enterprise.smpe.packaging.file.description"));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.disttype") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.disttype"))) {
            packagingFile.setDisttype(Disttype.get((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.disttype"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.fmid") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.fmid"))) {
            packagingFile.setFmid((IFunctionDefinitionHandle)this.getFunction(repository, projectArea, (String)propertyMap.get("team.enterprise.smpe.packaging.file.fmid")));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.ignore") && Verification.isTrueFalse((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.ignore")))) {
            packagingFile.setIgnore(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get("team.enterprise.smpe.packaging.file.ignore"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.jclin") && Verification.isTrueFalse((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.jclin")))) {
            packagingFile.setJclin(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get("team.enterprise.smpe.packaging.file.jclin"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.hfsdata") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.hfsdata"))) {
            packagingFile.setHfsdata(Hfsdata.get((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.hfsdata"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.hfspath") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.hfspath"))) {
            packagingFile.setHfspath((String)propertyMap.get("team.enterprise.smpe.packaging.file.hfspath"));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.leparm") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.leparm"))) {
            packagingFile.setLeparm((String)propertyMap.get("team.enterprise.smpe.packaging.file.leparm"));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.mcsclass") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.mcsclass"))) {
            packagingFile.setMcsclass(Mcstype.get((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.mcsclass"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.module") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.module"))) {
            packagingFile.setModule((String)propertyMap.get("team.enterprise.smpe.packaging.file.module"));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.originalfmid") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.originalfmid"))) {
            packagingFile.setOriginalFmid((IFunctionDefinitionHandle)this.getFunction(repository, projectArea, (String)propertyMap.get("team.enterprise.smpe.packaging.file.originalfmid")));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.originalstateid") && Verification.isNonNull(propertyMap.get("team.enterprise.smpe.packaging.file.originalstateid"))) {
            packagingFile.setOriginalStateId(UUID.valueOf((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.originalstateid"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.updated") && Verification.isTrueFalse((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.updated")))) {
            packagingFile.setUpdated(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get("team.enterprise.smpe.packaging.file.updated"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.transform") && Verification.isTrueFalse((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.transform")))) {
            packagingFile.setTransform(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get("team.enterprise.smpe.packaging.file.transform"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packaging.file.vpl") && Verification.isTrueFalse((String)((String)propertyMap.get("team.enterprise.smpe.packaging.file.vpl")))) {
            packagingFile.setVpl(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get("team.enterprise.smpe.packaging.file.vpl"))));
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.binary")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.binary", new CommandBinary());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.description")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.description", new CommandDescription());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.distlib")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.distlib", new CommandDistlib());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.distname")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.distname", new CommandDistname());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.extension")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.extension", new CommandExtension());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.fmidoverride")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.fmidoverride", new CommandFmidoverride());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.folder")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.folder", new CommandFolder());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.id")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.id", new CommandId());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.location")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.location", new CommandLocation());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.mcstype")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.mcstype", new CommandMcstype());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.originaldistlib")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.originaldistlib", new CommandOriginalDistlib());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.originalfmidoverride")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.originalfmidoverride", new CommandOriginalFmidoverride());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.originalsyslib")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.originalsyslib", new CommandOriginalSyslib());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.name")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.name", new CommandName());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.processor")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.processor", new CommandProcessor());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.relfileOverride")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.relfileOverride", new CommandRelfileOverride());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.shipalias")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.shipalias", new CommandShipalias());
        }
        if (propertyMap.containsKey("team.enterprise.smpe.packagingdetail.file.syslib")) {
            this.setPackagingDetailValues((IPackagingItem)packagingFile, propertyMap, "team.enterprise.smpe.packagingdetail.file.syslib", new CommandSyslib());
        }
        return packagingFile;
    }

    public final IPackagingItem createPackagingFolderItem(IResource resource, IMetadata metadata, ITeamRepository repository, IPackagingItem packagingLanguage) {
        IProjectAreaHandle projectArea = packagingLanguage.getProjectArea();
        String propertySuffix = packagingLanguage.getLanguage().getItemId().getUuidValue();
        if (Verification.isNonEmpty((List)packagingLanguage.getLanguage().getDefaultPatterns()) && ((IStringHelper)packagingLanguage.getLanguage().getDefaultPatterns().get(0)).getValue().equalsIgnoreCase(resource.getName())) {
            propertySuffix = "";
        }
        IImporterPropertyKey propertyKey = PackagingFactory.createPropertyKey((String)propertySuffix);
        Map propertyMap = ((Metadata)metadata).getVersionableProperties().getCurrentProperties();
        ArrayList<String> addUuids = null;
        ArrayList<String> orderUuids = null;
        ArrayList<String> removeUuids = null;
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableAdd")) && Verification.isNonBlank((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableAdd"))))) {
            addUuids = new ArrayList<String>(Arrays.asList(((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableAdd"))).split(",")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableOrder")) && Verification.isNonBlank((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableOrder"))))) {
            orderUuids = new ArrayList<String>(Arrays.asList(((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableOrder"))).split(",")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableRemove")) && Verification.isNonBlank((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableRemove"))))) {
            removeUuids = new ArrayList<String>(Arrays.asList(((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableRemove"))).split(",")));
        }
        PackagingItemFolder packagingFolder = new PackagingItemFolder(packagingLanguage);
        packagingFolder.init(addUuids, removeUuids, orderUuids);
        packagingFolder.setName(resource.getName());
        packagingFolder.setNonImpacting(packagingLanguage.isNonImpacting());
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.alias")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.alias")))) {
            packagingFolder.setAlias((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.alias")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.class")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.class")))) {
            packagingFolder.setClazz((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.class")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.csect")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.csect")))) {
            packagingFolder.setCsect((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.csect")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.deleted")) && Verification.isTrueFalse((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.deleted"))))) {
            packagingFolder.setDeleted(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.deleted")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.description")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.description")))) {
            packagingFolder.setDescription((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.description")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.disttype")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.disttype")))) {
            packagingFolder.setDisttype(Disttype.get((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.disttype")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.fmid")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.fmid")))) {
            packagingFolder.setFmid((IFunctionDefinitionHandle)this.getFunction(repository, projectArea, (String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.fmid"))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.ignore")) && Verification.isTrueFalse((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.ignore"))))) {
            packagingFolder.setIgnore(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.ignore")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.hfsdata")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.hfsdata")))) {
            packagingFolder.setHfsdata(Hfsdata.get((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.hfsdata")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.hfspath")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.hfspath")))) {
            packagingFolder.setHfspath((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.hfspath")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.leparm")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.leparm")))) {
            packagingFolder.setLeparm((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.leparm")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.mcsclass")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.mcsclass")))) {
            packagingFolder.setMcsclass(Mcstype.get((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.mcsclass")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.module")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.module")))) {
            packagingFolder.setModule((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.module")));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.originalfmid")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.originalfmid")))) {
            packagingFolder.setOriginalFmid((IFunctionDefinitionHandle)this.getFunction(repository, projectArea, (String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.originalfmid"))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.originalstateid")) && Verification.isNonNull(propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.originalstateid")))) {
            packagingFolder.setOriginalStateId(UUID.valueOf((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.originalstateid")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.updated")) && Verification.isTrueFalse((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.updated"))))) {
            packagingFolder.setUpdated(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.updated")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.transform")) && Verification.isTrueFalse((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.transform"))))) {
            packagingFolder.setTransform(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.transform")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packaging.folder.vpl")) && Verification.isTrueFalse((String)((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.vpl"))))) {
            packagingFolder.setVpl(Boolean.valueOf(Boolean.parseBoolean((String)propertyMap.get(propertyKey.get("team.enterprise.smpe.packaging.folder.vpl")))));
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.binary"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.binary"), new CommandBinary());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.description"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.description"), new CommandDescription());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.distlib"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.distlib"), new CommandDistlib());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.distname"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.distname"), new CommandDistname());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.extension"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.extension"), new CommandExtension());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.fmidoverride"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.fmidoverride"), new CommandFmidoverride());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.folder"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.folder"), new CommandFolder());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.id"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.id"), new CommandId());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.location"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.location"), new CommandLocation());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.mcstype"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.mcstype"), new CommandMcstype());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.originaldistlib"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.originaldistlib"), new CommandOriginalDistlib());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.originalfmidoverride"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.originalfmidoverride"), new CommandOriginalFmidoverride());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.originalsyslib"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.originalsyslib"), new CommandOriginalSyslib());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.name"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.name"), new CommandName());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.processor"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.processor"), new CommandProcessor());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.shipalias"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.shipalias"), new CommandShipalias());
        }
        if (propertyMap.containsKey(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.syslib"))) {
            this.setPackagingDetailValues((IPackagingItem)packagingFolder, propertyMap, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.syslib"), new CommandSyslib());
        }
        return packagingFolder;
    }

    public final void resolveFileItemProperties(IPackagingItem packagingFolder, IPackagingItem packagingFile, Properties properties, List<String> removedProperties) {
        if (packagingFile.hasAlias(true)) {
            properties.put("team.enterprise.smpe.packaging.file.alias", StringUtil.toCondensed((String)packagingFile.getAlias(true)));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.alias");
        }
        if (packagingFile.hasClazz(true)) {
            properties.put("team.enterprise.smpe.packaging.file.class", packagingFile.getClazz(true));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.class");
        }
        if (packagingFile.hasCsect(true)) {
            properties.put("team.enterprise.smpe.packaging.file.csect", StringUtil.toCondensed((String)packagingFile.getCsect(true)));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.csect");
        }
        if (packagingFile.hasDeleted(true)) {
            properties.put("team.enterprise.smpe.packaging.file.deleted", BooleanUtil.toString((Boolean)packagingFile.getDeleted(true)));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.deleted");
        }
        if (packagingFile.hasDescription(true)) {
            properties.put("team.enterprise.smpe.packaging.file.description", packagingFile.getDescription(true));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.description");
        }
        if (packagingFile.hasDisttype(true)) {
            properties.put("team.enterprise.smpe.packaging.file.disttype", Disttype.toString((Disttype)packagingFile.getDisttype(true)));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.disttype");
        }
        if (packagingFile.hasFmid(true)) {
            properties.put("team.enterprise.smpe.packaging.file.fmid", StringUtil.toString((String)this.getFunctionUuid(packagingFile.getFmid(true))));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.fmid");
        }
        if (packagingFile.hasHfsdata(true)) {
            properties.put("team.enterprise.smpe.packaging.file.hfsdata", Hfsdata.toString((Hfsdata)packagingFile.getHfsdata(true)));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.hfsdata");
        }
        if (packagingFile.hasHfspath(true)) {
            properties.put("team.enterprise.smpe.packaging.file.hfspath", packagingFile.getHfspath(true));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.hfspath");
        }
        if (packagingFile.hasIgnore(true)) {
            properties.put("team.enterprise.smpe.packaging.file.ignore", BooleanUtil.toString((Boolean)packagingFile.getIgnore(true)));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.ignore");
        }
        if (packagingFile.hasJclin(true) && !packagingFile.getJclin(true).equals(Verification.toBoolean((String)"false"))) {
            properties.put("team.enterprise.smpe.packaging.file.jclin", BooleanUtil.toString((Boolean)packagingFile.getJclin(true)));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.jclin");
        }
        if (packagingFile.hasLeparm(true)) {
            properties.put("team.enterprise.smpe.packaging.file.leparm", packagingFile.getLeparm(true));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.leparm");
        }
        if (packagingFile.hasMcsclass(true)) {
            properties.put("team.enterprise.smpe.packaging.file.mcsclass", Mcstype.toString((Mcstype)packagingFile.getMcsclass(true)));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.mcsclass");
        }
        if (packagingFile.hasModule(true)) {
            properties.put("team.enterprise.smpe.packaging.file.module", packagingFile.getModule(true));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.module");
        }
        if (packagingFile.hasOriginalFmid(true)) {
            properties.put("team.enterprise.smpe.packaging.file.originalfmid", StringUtil.toString((String)this.getFunctionUuid(packagingFile.getOriginalFmid(true))));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.originalfmid");
        }
        if (packagingFile.hasOriginalStateId(true)) {
            properties.put("team.enterprise.smpe.packaging.file.originalstateid", packagingFile.getOriginalStateId(true).getUuidValue());
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.originalstateid");
        }
        if (packagingFile.hasUpdated(true)) {
            properties.put("team.enterprise.smpe.packaging.file.updated", BooleanUtil.toString((Boolean)packagingFile.getUpdated(true)));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.updated");
        }
        if (packagingFile.hasTransform(true)) {
            properties.put("team.enterprise.smpe.packaging.file.transform", BooleanUtil.toString((Boolean)packagingFile.getTransform(true)));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.transform");
        }
        if (packagingFile.hasVpl(true)) {
            properties.put("team.enterprise.smpe.packaging.file.vpl", BooleanUtil.toString((Boolean)packagingFile.getVpl(true)));
        } else {
            removedProperties.add("team.enterprise.smpe.packaging.file.vpl");
        }
        ArrayList<String> localAddUuids = new ArrayList<String>();
        ArrayList<String> localOrderUuids = new ArrayList<String>();
        ArrayList<String> localRemoveUuids = new ArrayList<String>();
        for (IPackagingDetail packagingDetail : packagingFile.getDetails(true)) {
            if (packagingDetail == null) continue;
            if (packagingDetail.isAdded()) {
                localAddUuids.add(packagingDetail.getUuid());
            }
            localOrderUuids.add(packagingDetail.getUuid());
            localRemoveUuids.add(packagingDetail.getUuid());
        }
        ArrayList<String> superOrderUuids = new ArrayList<String>();
        ArrayList<String> superRemoveUuids = new ArrayList<String>();
        for (IPackagingDetail packagingDetail : packagingFolder.getDetails()) {
            if (packagingDetail == null) continue;
            superOrderUuids.add(packagingDetail.getUuid());
            superRemoveUuids.add(packagingDetail.getUuid());
        }
        if (((Object)localOrderUuids).toString().equals(((Object)superOrderUuids).toString())) {
            localOrderUuids.clear();
        }
        localRemoveUuids.removeAll(localAddUuids);
        localRemoveUuids.removeAll(superRemoveUuids);
        if (localAddUuids.size() > 0) {
            properties.put("team.enterprise.smpe.packagingdetail.file.tableAdd", StringUtil.toCsv(localAddUuids));
        } else {
            removedProperties.add("team.enterprise.smpe.packagingdetail.file.tableAdd");
        }
        if (localOrderUuids.size() > 0) {
            properties.put("team.enterprise.smpe.packagingdetail.file.tableOrder", StringUtil.toCsv(localOrderUuids));
        } else {
            removedProperties.add("team.enterprise.smpe.packagingdetail.file.tableOrder");
        }
        if (localRemoveUuids.size() > 0) {
            properties.put("team.enterprise.smpe.packagingdetail.file.tableRemove", StringUtil.toCsv(localRemoveUuids));
        } else {
            removedProperties.add("team.enterprise.smpe.packagingdetail.file.tableRemove");
        }
        HashMap<String, String> binaryMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        HashMap<String, String> descriptionMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        HashMap<String, String> distlibMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        HashMap<String, String> distnameMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        HashMap<String, String> extensionMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        HashMap<String, String> fmidoverrideMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        HashMap<String, String> folderMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        HashMap<String, String> idMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        HashMap<String, String> locationMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        HashMap<String, String> nameMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        HashMap<String, String> mcstypeMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        HashMap<String, String> originalDistlibMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        HashMap<String, String> originalFmidoverrideMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        HashMap<String, String> originalSyslibMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        HashMap<String, String> processMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        HashMap<String, String> relfileOverrideMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        HashMap<String, String> shipaliasMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        HashMap<String, String> syslibMap = new HashMap<String, String>(packagingFile.getPackagingDetails().size());
        for (IPackagingDetail packagingDetail : packagingFile.getDetails(true)) {
            if (packagingDetail.hasBinary(true)) {
                binaryMap.put(packagingDetail.getUuid(), BooleanUtil.toString((Boolean)packagingDetail.getBinary(true), null));
            } else {
                binaryMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasDescription(true)) {
                descriptionMap.put(packagingDetail.getUuid(), packagingDetail.getDescription(true));
            } else {
                descriptionMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasDistlib(true)) {
                distlibMap.put(packagingDetail.getUuid(), this.getDatasetUuid(packagingDetail.getDistlib(true)));
            } else {
                distlibMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasDistname(true)) {
                distnameMap.put(packagingDetail.getUuid(), packagingDetail.getDistname(true));
            } else {
                distnameMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasExtension(true)) {
                extensionMap.put(packagingDetail.getUuid(), packagingDetail.getExtension(true));
            } else {
                extensionMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasFmidoverride(true)) {
                fmidoverrideMap.put(packagingDetail.getUuid(), this.getFunctionUuid(packagingDetail.getFmidoverride(true)));
            } else {
                fmidoverrideMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasFolder(true)) {
                folderMap.put(packagingDetail.getUuid(), packagingDetail.getFolder(true));
            } else {
                folderMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasId(true)) {
                idMap.put(packagingDetail.getUuid(), Id.toString((Id)packagingDetail.getId(true)));
            } else {
                idMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasLocation(true)) {
                locationMap.put(packagingDetail.getUuid(), this.getDatasetUuid(packagingDetail.getLocation(true)));
            } else {
                locationMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasName(true)) {
                nameMap.put(packagingDetail.getUuid(), packagingDetail.getName(true));
            } else {
                nameMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasMcstype(true)) {
                mcstypeMap.put(packagingDetail.getUuid(), Mcstype.toString((Mcstype)packagingDetail.getMcstype(true)));
            } else {
                mcstypeMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasOriginalDistlib(true)) {
                originalDistlibMap.put(packagingDetail.getUuid(), this.getDatasetUuid(packagingDetail.getOriginalDistlib(true)));
            } else {
                originalDistlibMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasOriginalFmidoverride(true)) {
                originalFmidoverrideMap.put(packagingDetail.getUuid(), this.getFunctionUuid(packagingDetail.getOriginalFmidoverride(true)));
            } else {
                originalFmidoverrideMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasOriginalSyslib(true)) {
                originalSyslibMap.put(packagingDetail.getUuid(), this.getDatasetUuid(packagingDetail.getOriginalSyslib(true)));
            } else {
                originalSyslibMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasProcessor(true)) {
                processMap.put(packagingDetail.getUuid(), Processor.toString((Processor)packagingDetail.getProcessor(true)));
            } else {
                processMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasRelfileOverride(true)) {
                relfileOverrideMap.put(packagingDetail.getUuid(), packagingDetail.getRelfileOverride(true).toString());
            } else {
                relfileOverrideMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasShipalias(true)) {
                shipaliasMap.put(packagingDetail.getUuid(), packagingDetail.getShipalias(true));
            } else {
                shipaliasMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasSyslib(true)) {
                syslibMap.put(packagingDetail.getUuid(), this.getDatasetUuid(packagingDetail.getSyslib(true)));
                continue;
            }
            syslibMap.put(packagingDetail.getUuid(), null);
        }
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.binary", binaryMap, removedProperties);
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.description", descriptionMap, removedProperties);
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.distlib", distlibMap, removedProperties);
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.distname", distnameMap, removedProperties);
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.extension", extensionMap, removedProperties);
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.fmidoverride", fmidoverrideMap, removedProperties);
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.folder", folderMap, removedProperties);
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.id", idMap, removedProperties);
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.location", locationMap, removedProperties);
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.name", nameMap, removedProperties);
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.mcstype", mcstypeMap, removedProperties);
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.originaldistlib", originalDistlibMap, removedProperties);
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.originalfmidoverride", originalFmidoverrideMap, removedProperties);
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.originalsyslib", originalSyslibMap, removedProperties);
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.processor", processMap, removedProperties);
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.relfileOverride", relfileOverrideMap, removedProperties);
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.shipalias", shipaliasMap, removedProperties);
        this.setPackagingDetailProperty(properties, "team.enterprise.smpe.packagingdetail.file.syslib", syslibMap, removedProperties);
    }

    public final void resolveFolderItemProperties(IPackagingItem packagingLanguage, IPackagingItem packagingFolder, Properties properties, List<String> removedProperties) {
        String propertySuffix = packagingLanguage.getLanguage().getItemId().getUuidValue();
        if (Verification.isNonEmpty((List)packagingLanguage.getLanguage().getDefaultPatterns()) && ((IStringHelper)packagingLanguage.getLanguage().getDefaultPatterns().get(0)).getValue().equalsIgnoreCase(packagingFolder.getName())) {
            propertySuffix = "";
        }
        IImporterPropertyKey propertyKey = PackagingFactory.createPropertyKey((String)propertySuffix);
        if (packagingFolder.hasAlias(true)) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.alias"), StringUtil.toCondensed((String)packagingFolder.getAlias(true)));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.alias"));
        }
        if (packagingFolder.hasClazz(true)) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.class"), packagingFolder.getClazz(true));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.class"));
        }
        if (packagingFolder.hasCsect(true)) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.csect"), StringUtil.toCondensed((String)packagingFolder.getCsect(true)));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.csect"));
        }
        if (packagingFolder.hasDeleted(true)) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.deleted"), BooleanUtil.toString((Boolean)packagingFolder.getDeleted(true)));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.deleted"));
        }
        if (packagingFolder.hasDescription(true)) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.description"), packagingFolder.getDescription(true));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.description"));
        }
        if (packagingFolder.hasDisttype(true)) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.disttype"), Disttype.toString((Disttype)packagingFolder.getDisttype(true)));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.disttype"));
        }
        if (packagingFolder.hasFmid(true)) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.fmid"), StringUtil.toString((String)this.getFunctionUuid(packagingFolder.getFmid(true))));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.fmid"));
        }
        if (packagingFolder.hasHfsdata(true)) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.hfsdata"), Hfsdata.toString((Hfsdata)packagingFolder.getHfsdata(true)));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.hfsdata"));
        }
        if (packagingFolder.hasHfspath(true)) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.hfspath"), packagingFolder.getHfspath(true));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.hfspath"));
        }
        if (packagingFolder.hasIgnore(true) && !packagingFolder.getIgnore(true).equals(Verification.toBoolean((String)propertyKey.get("false")))) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.ignore"), BooleanUtil.toString((Boolean)packagingFolder.getIgnore(true)));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.ignore"));
        }
        if (packagingFolder.hasLeparm(true)) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.leparm"), packagingFolder.getLeparm(true));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.leparm"));
        }
        if (packagingFolder.hasMcsclass(true)) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.mcsclass"), Mcstype.toString((Mcstype)packagingFolder.getMcsclass(true)));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.mcsclass"));
        }
        if (packagingFolder.hasModule(true)) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.module"), packagingFolder.getModule(true));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.module"));
        }
        if (packagingFolder.hasOriginalFmid(true)) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.originalfmid"), StringUtil.toString((String)this.getFunctionUuid(packagingFolder.getOriginalFmid(true))));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.originalfmid"));
        }
        if (packagingFolder.hasOriginalStateId(true)) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.originalstateid"), packagingFolder.getOriginalStateId(true).getUuidValue());
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.originalstateid"));
        }
        if (packagingFolder.hasUpdated(true)) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.updated"), BooleanUtil.toString((Boolean)packagingFolder.getUpdated(true)));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.updated"));
        }
        if (packagingFolder.hasTransform(true)) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.transform"), BooleanUtil.toString((Boolean)packagingFolder.getTransform(true)));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.transform"));
        }
        if (packagingFolder.hasVpl(true)) {
            properties.put(propertyKey.get("team.enterprise.smpe.packaging.folder.vpl"), BooleanUtil.toString((Boolean)packagingFolder.getVpl(true)));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packaging.folder.vpl"));
        }
        ArrayList<String> localAddUuids = new ArrayList<String>();
        ArrayList<String> localOrderUuids = new ArrayList<String>();
        ArrayList<String> localRemoveUuids = new ArrayList<String>();
        for (IPackagingDetail packagingDetail : packagingFolder.getDetails(true)) {
            if (packagingDetail == null) continue;
            if (packagingDetail.isAdded()) {
                localAddUuids.add(packagingDetail.getUuid());
            }
            localOrderUuids.add(packagingDetail.getUuid());
            localRemoveUuids.add(packagingDetail.getUuid());
        }
        ArrayList<String> superOrderUuids = new ArrayList<String>();
        ArrayList<String> superRemoveUuids = new ArrayList<String>();
        for (IPackagingDetail packagingDetail : packagingLanguage.getDetails()) {
            if (packagingDetail == null) continue;
            superOrderUuids.add(packagingDetail.getUuid());
            superRemoveUuids.add(packagingDetail.getUuid());
        }
        if (((Object)localOrderUuids).toString().equals(((Object)superOrderUuids).toString())) {
            localOrderUuids.clear();
        }
        localRemoveUuids.removeAll(localAddUuids);
        localRemoveUuids.removeAll(superRemoveUuids);
        if (localAddUuids.size() > 0) {
            properties.put(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableAdd"), StringUtil.toCsv(localAddUuids));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableAdd"));
        }
        if (localOrderUuids.size() > 0) {
            properties.put(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableOrder"), StringUtil.toCsv(localOrderUuids));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableOrder"));
        }
        if (localRemoveUuids.size() > 0) {
            properties.put(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableRemove"), StringUtil.toCsv(localRemoveUuids));
        } else {
            removedProperties.add(propertyKey.get("team.enterprise.smpe.packagingdetail.folder.tableRemove"));
        }
        HashMap<String, String> binaryMap = new HashMap<String, String>(packagingFolder.getPackagingDetails().size());
        HashMap<String, String> descriptionMap = new HashMap<String, String>(packagingFolder.getPackagingDetails().size());
        HashMap<String, String> distlibMap = new HashMap<String, String>(packagingFolder.getPackagingDetails().size());
        HashMap<String, String> distnameMap = new HashMap<String, String>(packagingFolder.getPackagingDetails().size());
        HashMap<String, String> extensionMap = new HashMap<String, String>(packagingFolder.getPackagingDetails().size());
        HashMap<String, String> fmidoverrideMap = new HashMap<String, String>(packagingFolder.getPackagingDetails().size());
        HashMap<String, String> idMap = new HashMap<String, String>(packagingFolder.getPackagingDetails().size());
        HashMap<String, String> folderMap = new HashMap<String, String>(packagingFolder.getPackagingDetails().size());
        HashMap<String, String> locationMap = new HashMap<String, String>(packagingFolder.getPackagingDetails().size());
        HashMap<String, String> nameMap = new HashMap<String, String>(packagingFolder.getPackagingDetails().size());
        HashMap<String, String> mcstypeMap = new HashMap<String, String>(packagingFolder.getPackagingDetails().size());
        HashMap<String, String> originalDistlibMap = new HashMap<String, String>(packagingFolder.getPackagingDetails().size());
        HashMap<String, String> originalFmidoverrideMap = new HashMap<String, String>(packagingFolder.getPackagingDetails().size());
        HashMap<String, String> originalSyslibMap = new HashMap<String, String>(packagingFolder.getPackagingDetails().size());
        HashMap<String, String> processMap = new HashMap<String, String>(packagingFolder.getPackagingDetails().size());
        HashMap<String, String> shipaliasMap = new HashMap<String, String>(packagingFolder.getPackagingDetails().size());
        HashMap<String, String> syslibMap = new HashMap<String, String>(packagingFolder.getPackagingDetails().size());
        for (IPackagingDetail packagingDetail : packagingFolder.getDetails(true)) {
            if (packagingDetail.hasBinary(true)) {
                binaryMap.put(packagingDetail.getUuid(), BooleanUtil.toString((Boolean)packagingDetail.getBinary(true), null));
            } else {
                binaryMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasDescription(true)) {
                descriptionMap.put(packagingDetail.getUuid(), packagingDetail.getDescription(true));
            } else {
                descriptionMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasDistlib(true)) {
                distlibMap.put(packagingDetail.getUuid(), this.getDatasetUuid(packagingDetail.getDistlib(true)));
            } else {
                distlibMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasDistname(true)) {
                distnameMap.put(packagingDetail.getUuid(), packagingDetail.getDistname(true));
            } else {
                distnameMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasExtension(true)) {
                extensionMap.put(packagingDetail.getUuid(), packagingDetail.getExtension(true));
            } else {
                extensionMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasFmidoverride(true)) {
                fmidoverrideMap.put(packagingDetail.getUuid(), this.getFunctionUuid(packagingDetail.getFmidoverride(true)));
            } else {
                fmidoverrideMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasFolder(true)) {
                folderMap.put(packagingDetail.getUuid(), packagingDetail.getFolder(true));
            } else {
                folderMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasId(true)) {
                idMap.put(packagingDetail.getUuid(), Id.toString((Id)packagingDetail.getId(true)));
            } else {
                idMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasLocation(true)) {
                locationMap.put(packagingDetail.getUuid(), this.getDatasetUuid(packagingDetail.getLocation(true)));
            } else {
                locationMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasName(true)) {
                nameMap.put(packagingDetail.getUuid(), packagingDetail.getName(true));
            } else {
                nameMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasMcstype(true)) {
                mcstypeMap.put(packagingDetail.getUuid(), Mcstype.toString((Mcstype)packagingDetail.getMcstype(true)));
            } else {
                mcstypeMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasOriginalDistlib(true)) {
                originalDistlibMap.put(packagingDetail.getUuid(), this.getDatasetUuid(packagingDetail.getOriginalDistlib(true)));
            } else {
                originalDistlibMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasOriginalFmidoverride(true)) {
                originalFmidoverrideMap.put(packagingDetail.getUuid(), this.getFunctionUuid(packagingDetail.getOriginalFmidoverride(true)));
            } else {
                originalFmidoverrideMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasOriginalSyslib(true)) {
                originalSyslibMap.put(packagingDetail.getUuid(), this.getDatasetUuid(packagingDetail.getOriginalSyslib(true)));
            } else {
                originalSyslibMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasProcessor(true)) {
                processMap.put(packagingDetail.getUuid(), Processor.toString((Processor)packagingDetail.getProcessor(true)));
            } else {
                processMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasShipalias(true)) {
                shipaliasMap.put(packagingDetail.getUuid(), packagingDetail.getShipalias(true));
            } else {
                shipaliasMap.put(packagingDetail.getUuid(), null);
            }
            if (packagingDetail.hasSyslib(true)) {
                syslibMap.put(packagingDetail.getUuid(), this.getDatasetUuid(packagingDetail.getSyslib(true)));
                continue;
            }
            syslibMap.put(packagingDetail.getUuid(), null);
        }
        this.setPackagingDetailProperty(properties, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.binary"), binaryMap, removedProperties);
        this.setPackagingDetailProperty(properties, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.description"), descriptionMap, removedProperties);
        this.setPackagingDetailProperty(properties, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.distlib"), distlibMap, removedProperties);
        this.setPackagingDetailProperty(properties, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.distname"), distnameMap, removedProperties);
        this.setPackagingDetailProperty(properties, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.extension"), extensionMap, removedProperties);
        this.setPackagingDetailProperty(properties, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.fmidoverride"), fmidoverrideMap, removedProperties);
        this.setPackagingDetailProperty(properties, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.folder"), folderMap, removedProperties);
        this.setPackagingDetailProperty(properties, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.id"), idMap, removedProperties);
        this.setPackagingDetailProperty(properties, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.location"), locationMap, removedProperties);
        this.setPackagingDetailProperty(properties, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.name"), nameMap, removedProperties);
        this.setPackagingDetailProperty(properties, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.mcstype"), mcstypeMap, removedProperties);
        this.setPackagingDetailProperty(properties, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.originaldistlib"), originalDistlibMap, removedProperties);
        this.setPackagingDetailProperty(properties, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.originalfmidoverride"), originalFmidoverrideMap, removedProperties);
        this.setPackagingDetailProperty(properties, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.originalsyslib"), originalSyslibMap, removedProperties);
        this.setPackagingDetailProperty(properties, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.processor"), processMap, removedProperties);
        this.setPackagingDetailProperty(properties, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.shipalias"), shipaliasMap, removedProperties);
        this.setPackagingDetailProperty(properties, propertyKey.get("team.enterprise.smpe.packagingdetail.folder.syslib"), syslibMap, removedProperties);
    }

    private IDataSetDefinitionHandle getDataset(ITeamRepository repository, IProjectAreaHandle projectArea, String uuid) {
        return (IDataSetDefinitionHandle)ItemCacheFactory.getDatasetHandle((ITeamRepository)repository, (IProjectAreaHandle)projectArea).getUuid(uuid);
    }

    private String getDatasetUuid(IDataSetDefinitionHandle dataset) {
        return dataset == null ? null : dataset.getItemId().getUuidValue();
    }

    private IFunctionDefinition getFunction(ITeamRepository repository, IProjectAreaHandle projectArea, String uuid) {
        return (IFunctionDefinition)ItemCacheFactory.getFunction((ITeamRepository)repository, (IProjectAreaHandle)projectArea).getUuid(uuid);
    }

    private String getFunctionUuid(IFunctionDefinitionHandle function) {
        return function == null ? null : function.getItemId().getUuidValue();
    }

    private JSONObject getJsonObject(String jsonString) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = JSONObject.parse((Reader)new StringReader(jsonString));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    private void setPackagingDetailProperty(Properties properties, String propertyKey, Map<String, String> detailMap, List<String> removedProperties) {
        JSONObject jsonObject = new JSONObject();
        for (String key : detailMap.keySet()) {
            if (detailMap.get(key) == null) continue;
            jsonObject.put((Object)key, (Object)detailMap.get(key).replaceAll(" ", "%20"));
        }
        if (!jsonObject.isEmpty()) {
            properties.put(propertyKey, jsonObject.toString().replaceAll("\\s", ""));
        } else {
            removedProperties.add(propertyKey);
        }
    }

    private void setPackagingDetailValues(IPackagingItem packagingItem, Map<String, String> propertyMap, String propertyKey, Command command) {
        JSONObject jsonObject = this.getJsonObject(propertyMap.get(propertyKey));
        for (Object key : jsonObject.keySet()) {
            if (!(key instanceof String)) continue;
            String uuid = (String)key;
            String value = (String)jsonObject.get(key);
            if (!packagingItem.hasPackagingDetail(uuid)) continue;
            command.execute(packagingItem, uuid, value.replaceAll("%20", " "));
        }
    }

    public static interface Command {
        public void execute(IPackagingItem var1, String var2, String var3);
    }

    public class CommandBinary
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setBinary(uuid, Verification.toBoolean((String)value));
        }
    }

    public class CommandDescription
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setDescription(uuid, value);
        }
    }

    public class CommandDistlib
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setDistlib(uuid, PackagingTools.this.getDataset((ITeamRepository)packagingItem.getOrigin(), packagingItem.getProjectArea(), value));
        }
    }

    public class CommandDistname
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setDistname(uuid, value);
        }
    }

    public class CommandExtension
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setExtension(uuid, value);
        }
    }

    public class CommandFmidoverride
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setFmidoverride(uuid, (IFunctionDefinitionHandle)PackagingTools.this.getFunction((ITeamRepository)packagingItem.getOrigin(), packagingItem.getProjectArea(), value));
        }
    }

    public class CommandFolder
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setFolder(uuid, value);
        }
    }

    public class CommandId
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setId(uuid, Id.get((String)value));
        }
    }

    public class CommandLocation
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setLocation(uuid, PackagingTools.this.getDataset((ITeamRepository)packagingItem.getOrigin(), packagingItem.getProjectArea(), value));
        }
    }

    public class CommandMcstype
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setMcstype(uuid, Mcstype.get((String)value));
        }
    }

    public class CommandName
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setName(uuid, value);
        }
    }

    public class CommandOriginalDistlib
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setOriginalDistlib(uuid, PackagingTools.this.getDataset((ITeamRepository)packagingItem.getOrigin(), packagingItem.getProjectArea(), value));
        }
    }

    public class CommandOriginalFmidoverride
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setOriginalFmidoverride(uuid, (IFunctionDefinitionHandle)PackagingTools.this.getFunction((ITeamRepository)packagingItem.getOrigin(), packagingItem.getProjectArea(), value));
        }
    }

    public class CommandOriginalSyslib
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setOriginalSyslib(uuid, PackagingTools.this.getDataset((ITeamRepository)packagingItem.getOrigin(), packagingItem.getProjectArea(), value));
        }
    }

    public class CommandProcessor
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setProcessor(uuid, Processor.get((String)value));
        }
    }

    public class CommandRelfileOverride
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            IPackagingDetailDefinition detailDefinition = packagingItem.getDetail(uuid);
            if (detailDefinition != null && detailDefinition instanceof IPackagingDetail) {
                IPackagingDetail detail = (IPackagingDetail)detailDefinition;
                detail.setRelfileOverride(Integer.valueOf(value));
            }
        }
    }

    public class CommandShipalias
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setShipalias(uuid, value);
        }
    }

    public class CommandSyslib
    implements Command {
        @Override
        public void execute(IPackagingItem packagingItem, String uuid, String value) {
            packagingItem.setSyslib(uuid, PackagingTools.this.getDataset((ITeamRepository)packagingItem.getOrigin(), packagingItem.getProjectArea(), value));
        }
    }
}

