/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.utils;

import com.ibm.team.enterprise.common.common.ZPackagingNature;
import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;

public class PackagingProperty
extends PropertyTester {
    public static final String IsSmpeEnabled = "isSmpeEnabled";
    public static final String IsZPackagingFile = "isZPackagingFile";
    public static final String IsZPackagingFolder = "isZPackagingFolder";
    public static final String IsZPackagingProject = "isZPackagingProject";
    public static final String IsZPackagingTesting = "isZPackagingTesting";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = false;
        try {
            if (IsSmpeEnabled.equals(property)) {
                return PackagingProperty.isSmpeEnabled();
            }
            if (IsZPackagingFile.equals(property)) {
                return PackagingProperty.isZPackagingFile(receiver);
            }
            if (IsZPackagingFolder.equals(property)) {
                return PackagingProperty.isZPackagingFolder(receiver);
            }
            if (IsZPackagingProject.equals(property)) {
                return PackagingProperty.isZPackagingProject(receiver);
            }
            if (IsZPackagingTesting.equals(property)) {
                return PackagingProperty.isZPackagingTesting();
            }
        }
        catch (Exception e) {
            SmpeUIPlugin.log(e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean isSmpeEnabled() {
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        try {
            ITeamRepository[] iTeamRepositoryArray = repositories;
            int n = repositories.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ITeamRepository repository = iTeamRepositoryArray[n2];
                if (repository.loggedIn() && ClientFactory.getSystemDefinitionModelClient((ITeamRepository)repository).isSMPEEnabled(null)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (TeamRepositoryException e) {
            SmpeUIPlugin.log(e);
        }
        return false;
    }

    public static final boolean isZPackagingFile(Object receiver) {
        IFile file;
        return receiver != null && receiver instanceof IFile && (file = (IFile)receiver).getParent() instanceof IFolder && PackagingProperty.isZPackagingFolder(file.getParent());
    }

    public static final boolean isZPackagingFolder(Object receiver) {
        IFolder folder;
        return receiver != null && receiver instanceof IFolder && (folder = (IFolder)receiver).getParent() == folder.getProject() && PackagingProperty.isZPackagingProject(folder.getProject());
    }

    public static final boolean isZPackagingProject(Object receiver) {
        if (receiver instanceof IResource) {
            IResource resource = (IResource)receiver;
            try {
                if (resource.getProject().hasNature(ZPackagingNature.ID)) {
                    return true;
                }
            }
            catch (Exception e) {
                SmpeUIPlugin.log(e);
            }
        }
        return false;
    }

    public static final boolean isZPackagingTesting() {
        return Boolean.getBoolean("com.ibm.team.enterprise.smpe.ui.system.zPackagingTesting");
    }
}

