/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.utils;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.extensions.common.IFetchItem;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheFactory;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.IBMiResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinitionHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class EditorItemFetch
implements IFetchItem {
    private final IDebugger dbg;
    private final String simpleName;
    private final ITeamRepository repository;
    private final IProgressMonitor monitor;
    private final IProjectAreaHandle projectArea;
    private final String dialog;
    private final boolean fetch;
    private final List<IItemHandle> itemsToFetch = new ArrayList<IItemHandle>();

    public EditorItemFetch(ITeamRepository repository, IProjectAreaHandle projectArea, IProgressMonitor monitor, String dialog, boolean fetch) {
        this.repository = repository;
        this.projectArea = projectArea;
        this.monitor = monitor;
        this.dialog = dialog;
        this.fetch = fetch;
        this.dbg = new Debugger(this.getClass());
        this.simpleName = this.getClass().getSimpleName();
        if (this.dbg.isDebug()) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
    }

    public final IItem execute(IItemHandle handle) {
        if (handle == null) {
            return null;
        }
        IItem item = null;
        String uuid = handle.getItemId().getUuidValue();
        if (handle instanceof IBuildDefinitionHandle) {
            if (ItemCacheFactory.containsBuildDefinition((ITeamRepository)this.repository, (IProcessAreaHandle)this.projectArea) && ItemCacheFactory.getBuildDefinition((ITeamRepository)this.repository, (IProcessAreaHandle)this.projectArea).containsUuid(uuid)) {
                item = (IItem)ItemCacheFactory.getBuildDefinition((ITeamRepository)this.repository, (IProcessAreaHandle)this.projectArea).getUuid(uuid);
            }
        } else if (handle instanceof IBuildEngineHandle) {
            if (ItemCacheFactory.containsBuildEngine((ITeamRepository)this.repository, (IProcessAreaHandle)this.projectArea) && ItemCacheFactory.getBuildEngine((ITeamRepository)this.repository, (IProcessAreaHandle)this.projectArea).containsUuid(uuid)) {
                item = (IItem)ItemCacheFactory.getBuildEngine((ITeamRepository)this.repository, (IProcessAreaHandle)this.projectArea).getUuid(uuid);
            }
        } else if (handle instanceof IResourceDefinitionHandle) {
            if (ItemCacheFactory.containsDataset((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea) && ItemCacheFactory.getDataset((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea).containsUuid(uuid)) {
                item = (IItem)ItemCacheFactory.getDataset((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea).getUuid(uuid);
            } else if (ItemCacheFactory.containsLibrary((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea) && ItemCacheFactory.getLibrary((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea).containsUuid(uuid)) {
                item = (IItem)ItemCacheFactory.getLibrary((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea).getUuid(uuid);
            }
        }
        if (item == null && this.fetch) {
            try {
                item = this.repository.itemManager().fetchCompleteItem(handle, 0, this.monitor);
                if (item != null) {
                    if (item instanceof IBuildDefinition) {
                        ItemCacheFactory.addBuildDefinition((ITeamRepository)this.repository, (IProcessAreaHandle)this.projectArea, (IBuildDefinition)((IBuildDefinition)item));
                    } else if (item instanceof IBuildEngine) {
                        ItemCacheFactory.addBuildEngine((ITeamRepository)this.repository, (IProcessAreaHandle)this.projectArea, (IBuildEngine)((IBuildEngine)item));
                    } else if (item instanceof IDataSetDefinition) {
                        ItemCacheFactory.addDataset((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, (IResourceDefinition)((IDataSetDefinition)item));
                    } else if (item instanceof IResourceDefinition) {
                        ItemCacheFactory.addLibrary((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, (IResourceDefinition)((IResourceDefinition)item));
                    }
                }
            }
            catch (TeamRepositoryException e) {
                Status errorStatus = new Status(4, SmpeUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), (Throwable)e);
                SmpeUIPlugin.openErrorDialog(NLS.bind((String)Messages.EditorItemFetch_Failed_Title, (Object)this.dialog, (Object[])new Object[0]), NLS.bind((String)Messages.EditorItemFetch_Failed_Item, (Object)handle.getItemId().getUuidValue(), (Object[])new Object[0]), (IStatus)errorStatus);
                SmpeUIPlugin.log(e);
            }
        }
        if (item == null && !this.fetch) {
            this.itemsToFetch.add(handle);
        }
        return item;
    }

    public final void fetchItems(IProgressMonitor monitor) {
        try {
            List items = this.repository.itemManager().fetchCompleteItems(this.itemsToFetch, 0, monitor);
            for (IItem item : items) {
                if (item == null) continue;
                if (item instanceof IBuildDefinition) {
                    ItemCacheFactory.addBuildDefinition((ITeamRepository)this.repository, (IProcessAreaHandle)this.projectArea, (IBuildDefinition)((IBuildDefinition)item));
                    continue;
                }
                if (item instanceof IBuildEngine) {
                    ItemCacheFactory.addBuildEngine((ITeamRepository)this.repository, (IProcessAreaHandle)this.projectArea, (IBuildEngine)((IBuildEngine)item));
                    continue;
                }
                if (item instanceof IDataSetDefinition) {
                    ItemCacheFactory.addDataset((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, (IResourceDefinition)((IDataSetDefinition)item));
                    continue;
                }
                if (!(item instanceof IBMiResourceDefinition)) continue;
                ItemCacheFactory.addLibrary((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, (IResourceDefinition)((IResourceDefinition)item));
            }
        }
        catch (TeamRepositoryException e) {
            Status errorStatus = new Status(4, SmpeUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), (Throwable)e);
            SmpeUIPlugin.openErrorDialog(NLS.bind((String)Messages.EditorItemFetch_Failed_Title, (Object)this.dialog, (Object[])new Object[0]), NLS.bind((String)Messages.EditorItemFetch_Failed_Items, (Object)this.itemsToFetch.size(), (Object[])new Object[0]), (IStatus)errorStatus);
            SmpeUIPlugin.log(e);
        }
    }

    public final boolean hasItemsToFetch() {
        return Verification.isNonEmpty(this.itemsToFetch);
    }
}

