/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.utils;

import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheFactory;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPathHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class EditorItemCache
implements ISystemDefinitionCache {
    private final IDebugger dbg;
    private final ITeamRepository repository;
    private final IProjectAreaHandle projectArea;

    public EditorItemCache(ITeamRepository repository, IProjectAreaHandle processArea, IDebugger dbg) {
        this.dbg = dbg;
        this.repository = repository;
        this.projectArea = processArea;
    }

    public void clear() {
        ItemCacheFactory.clearDataset((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea);
        ItemCacheFactory.clearFunction((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea);
        ItemCacheFactory.clearLanguage((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea);
        ItemCacheFactory.clearLibrary((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea);
        ItemCacheFactory.clearSearchPath((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea);
        ItemCacheFactory.clearTranslator((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea);
        ItemCacheFactory.clearVersion((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea);
    }

    public ISystemDefinition getSystemDefinition(ISystemDefinitionHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        IResourceDefinition definition = null;
        if (handle instanceof IDataSetDefinitionHandle) {
            definition = this.getDatasetDefinition(handle, monitor);
        } else if (handle instanceof IFunctionDefinitionHandle) {
            definition = this.getFunctionDefinition(handle, monitor);
        } else if (handle instanceof ILanguageDefinitionHandle) {
            definition = this.getLanguageDefinition(handle, monitor);
        } else if (handle instanceof IResourceDefinitionHandle) {
            definition = this.getLibraryDefinition(handle, monitor);
        } else if (handle instanceof ISearchPathHandle) {
            definition = this.getSearchPath(handle, monitor);
        } else if (handle instanceof ITranslatorHandle) {
            definition = this.getTranslator(handle, monitor);
        } else if (handle instanceof IVersionDefinitionHandle) {
            definition = this.getVersionDefinition(handle, monitor);
        }
        return definition;
    }

    public List<ISystemDefinition> getSystemDefinitions(List<ISystemDefinitionHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IResourceDefinition> definitions = null;
        if (handles.size() == 0) {
            return definitions;
        }
        if (handles.get(0) instanceof IDataSetDefinitionHandle) {
            definitions = new ArrayList<IResourceDefinition>(this.getDatasetDefinitions(handles, monitor));
        } else if (handles.get(0) instanceof IFunctionDefinitionHandle) {
            definitions = new ArrayList<IFunctionDefinition>(this.getFunctionDefinitions(handles, monitor));
        } else if (handles.get(0) instanceof ILanguageDefinitionHandle) {
            definitions = new ArrayList<ILanguageDefinition>(this.getLanguageDefinitions(handles, monitor));
        } else if (handles.get(0) instanceof IResourceDefinitionHandle) {
            definitions = new ArrayList<IResourceDefinition>(this.getLibraryDefinitions(handles, monitor));
        } else if (handles.get(0) instanceof ISearchPathHandle) {
            definitions = new ArrayList<ISearchPath>(this.getSearchPaths(handles, monitor));
        } else if (handles.get(0) instanceof ITranslatorHandle) {
            definitions = new ArrayList<ITranslator>(this.getTranslators(handles, monitor));
        } else if (handles.get(0) instanceof IVersionDefinitionHandle) {
            definitions = new ArrayList<IVersionDefinition>(this.getVersionDefinitions(handles, monitor));
        }
        return definitions;
    }

    public IResourceDefinition getDatasetDefinition(ISystemDefinitionHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemCacheFactory.addDataset((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, (ISystemDefinitionHandle)handle, (IDebugger)this.dbg);
    }

    public List<IResourceDefinition> getDatasetDefinitions(List<ISystemDefinitionHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemCacheFactory.addDataset((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, handles, (IDebugger)this.dbg);
    }

    public IFunctionDefinition getFunctionDefinition(ISystemDefinitionHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemCacheFactory.addFunction((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, (ISystemDefinitionHandle)handle, (IDebugger)this.dbg);
    }

    public List<IFunctionDefinition> getFunctionDefinitions(List<ISystemDefinitionHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemCacheFactory.addFunction((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, handles, (IDebugger)this.dbg);
    }

    public ILanguageDefinition getLanguageDefinition(ISystemDefinitionHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemCacheFactory.addLanguage((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, (ISystemDefinitionHandle)handle, (IDebugger)this.dbg);
    }

    public List<ILanguageDefinition> getLanguageDefinitions(List<ISystemDefinitionHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemCacheFactory.addLanguage((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, handles, (IDebugger)this.dbg);
    }

    public IResourceDefinition getLibraryDefinition(ISystemDefinitionHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemCacheFactory.addLibrary((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, (ISystemDefinitionHandle)handle, (IDebugger)this.dbg);
    }

    public List<IResourceDefinition> getLibraryDefinitions(List<ISystemDefinitionHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemCacheFactory.addLibrary((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, handles, (IDebugger)this.dbg);
    }

    public ISearchPath getSearchPath(ISystemDefinitionHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemCacheFactory.addSearchPath((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, (ISystemDefinitionHandle)handle, (IDebugger)this.dbg);
    }

    public List<ISearchPath> getSearchPaths(List<ISystemDefinitionHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemCacheFactory.addSearchPath((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, handles, (IDebugger)this.dbg);
    }

    public ITranslator getTranslator(ISystemDefinitionHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemCacheFactory.addTranslator((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, (ISystemDefinitionHandle)handle, (IDebugger)this.dbg);
    }

    public List<ITranslator> getTranslators(List<ISystemDefinitionHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemCacheFactory.addTranslator((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, handles, (IDebugger)this.dbg);
    }

    public IVersionDefinition getVersionDefinition(ISystemDefinitionHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemCacheFactory.addVersion((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, (ISystemDefinitionHandle)handle, (IDebugger)this.dbg);
    }

    public List<IVersionDefinition> getVersionDefinitions(List<ISystemDefinitionHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemCacheFactory.addVersion((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, handles, (IDebugger)this.dbg);
    }
}

