/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.references;

import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.ref.integrity.internal.Utils;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceResolver;
import com.ibm.team.enterprise.ref.integrity.internal.search.ITreeNodeLoader;
import com.ibm.team.enterprise.ref.integrity.internal.search.ReferenceTreeNode;
import com.ibm.team.enterprise.ref.integrity.internal.search.TreeNodeLoaderRegistry;
import com.ibm.team.enterprise.ref.integrity.nodes.FileTreeNode;
import com.ibm.team.enterprise.ref.integrity.nodes.FolderTreeNode;
import com.ibm.team.enterprise.ref.integrity.nodes.ProjectTreeNode;
import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.smpe.ui.references.FunctionDefinitionTreeNode;
import com.ibm.team.enterprise.smpe.ui.references.VersionDefinitionTreeNode;
import com.ibm.team.enterprise.smpe.ui.utils.MessagingTools;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.Packaging;
import com.ibm.team.enterprise.systemdefinition.common.model.IFmidItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingDetailDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingItemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.widgets.Display;

public class ReferenceResolverFunctionDefinition
implements IReferenceResolver {
    public String getLoglabel() {
        return Messages.FunctionDefinition_References_Resolver;
    }

    private List<ISystemDefinition> getLanguageDefinitions(ITeamRepository repository, ISystemDefinitionModelClient client) {
        ArrayList<ISystemDefinition> languageDefinitions = new ArrayList<ISystemDefinition>();
        List projectAreas = new ArrayList();
        try {
            projectAreas = Utils.getProjectAreas((ITeamRepository)repository);
        }
        catch (TeamRepositoryException e) {
            MessagingTools.openErrorDialog(Display.getCurrent().getActiveShell(), Messages.FunctionDefinition_References_Resolver, Messages.FunctionDefinition_References_Resolver_Projects, (IStatus)new Status(4, "com.ibm.team.enterprise.smpe.ui", e.getLocalizedMessage()));
            SmpeUIPlugin.log(Messages.FunctionDefinition_References_Resolver_Projects, e);
        }
        try {
            for (IProjectArea projectArea : projectAreas) {
                List definitions;
                if (projectArea == null || (definitions = client.findSystemDefinitionsComplete(IZosLanguageDefinition.ITEM_TYPE, (IProjectAreaHandle)projectArea, -1, false, (IProgressMonitor)new NullProgressMonitor())) == null) continue;
                languageDefinitions.addAll(definitions);
            }
        }
        catch (TeamRepositoryException e) {
            MessagingTools.openErrorDialog(Display.getCurrent().getActiveShell(), Messages.FunctionDefinition_References_Resolver, Messages.FunctionDefinition_References_Resolver_Languages, (IStatus)new Status(4, "com.ibm.team.enterprise.smpe.ui", e.getLocalizedMessage()));
            SmpeUIPlugin.log(Messages.FunctionDefinition_References_Resolver_Languages, e);
        }
        return languageDefinitions;
    }

    private List<ISystemDefinition> getVersionDefinitions(ITeamRepository repository, ISystemDefinitionModelClient client) {
        ArrayList<ISystemDefinition> versionDefinitions = new ArrayList<ISystemDefinition>();
        List projectAreas = new ArrayList();
        try {
            projectAreas = Utils.getProjectAreas((ITeamRepository)repository);
        }
        catch (TeamRepositoryException e) {
            MessagingTools.openErrorDialog(Display.getCurrent().getActiveShell(), Messages.FunctionDefinition_References_Resolver, Messages.FunctionDefinition_References_Resolver_Projects, (IStatus)new Status(4, "com.ibm.team.enterprise.smpe.ui", e.getLocalizedMessage()));
            SmpeUIPlugin.log(Messages.FunctionDefinition_References_Resolver_Projects, e);
        }
        try {
            for (IProjectArea projectArea : projectAreas) {
                List definitions;
                if (projectArea == null || (definitions = client.findSystemDefinitionsComplete(IVersionDefinition.ITEM_TYPE, (IProjectAreaHandle)projectArea, -1, false, (IProgressMonitor)new NullProgressMonitor())) == null) continue;
                versionDefinitions.addAll(definitions);
            }
        }
        catch (TeamRepositoryException e) {
            MessagingTools.openErrorDialog(Display.getCurrent().getActiveShell(), Messages.FunctionDefinition_References_Resolver, Messages.FunctionDefinition_References_Resolver_Versions, (IStatus)new Status(4, "com.ibm.team.enterprise.smpe.ui", e.getLocalizedMessage()));
            SmpeUIPlugin.log(Messages.FunctionDefinition_References_Resolver_Versions, e);
        }
        return versionDefinitions;
    }

    public List<ReferenceTreeNode> referencesTo(List<ISystemDefinition> jazzObjects, ITeamRepository repository) throws Exception {
        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)repository);
        ArrayList<ReferenceTreeNode> results = new ArrayList<ReferenceTreeNode>();
        List projects = Utils.buildProjectList((ITeamRepository)repository);
        List<ISystemDefinition> languageDefinitions = this.getLanguageDefinitions(repository, client);
        List<ISystemDefinition> versionDefinitions = this.getVersionDefinitions(repository, client);
        for (ISystemDefinition jazzObject : jazzObjects) {
            if (!(jazzObject instanceof IFunctionDefinition)) continue;
            IFunctionDefinition functionDefinition = (IFunctionDefinition)jazzObject;
            String functionDefinitionUuid = functionDefinition.getItemId().getUuidValue();
            FunctionDefinitionTreeNode functionDefinitionTreeNode = new FunctionDefinitionTreeNode(functionDefinition);
            for (IProject project : projects) {
                ProjectTreeNode projectTreeNode = null;
                List folders = Utils.getZFolderList((String)project.getName());
                for (IFolder folder : folders) {
                    FolderTreeNode folderTreeNode = null;
                    IResource[] folderChildren = folder.members();
                    if (!(folder instanceof IFolder)) continue;
                    String folderFmid = Utils.getArtifactVersionableProperty((IResource)folder, (String)"team.enterprise.smpe.packaging.folder.fmid");
                    String folderFmidOverride = Utils.getArtifactVersionableProperty((IResource)folder, (String)"team.enterprise.smpe.packagingdetail.folder.fmidoverride");
                    JSONObject folderFmidJsonObject = Packaging.getJsonObject((String)folderFmidOverride);
                    boolean foundFolderReference = false;
                    if (functionDefinitionUuid.equals(folderFmid)) {
                        foundFolderReference = true;
                    } else if (folderFmidJsonObject.containsValue((Object)functionDefinitionUuid)) {
                        foundFolderReference = true;
                    }
                    if (foundFolderReference) {
                        if (projectTreeNode == null) {
                            projectTreeNode = new ProjectTreeNode((Object)project);
                            Utils.addChildTreeNode((TreeNode)projectTreeNode, (TreeNode)functionDefinitionTreeNode);
                        }
                        folderTreeNode = new FolderTreeNode((Object)folder);
                        Utils.addChildTreeNode((TreeNode)folderTreeNode, (TreeNode)projectTreeNode);
                    }
                    for (IResource resource : Arrays.asList(folderChildren)) {
                        if (!(resource instanceof IFile)) continue;
                        String fileFmid = Utils.getArtifactVersionableProperty((IResource)resource, (String)"team.enterprise.smpe.packaging.file.fmid");
                        String fileFmidOverride = Utils.getArtifactVersionableProperty((IResource)resource, (String)"team.enterprise.smpe.packagingdetail.file.fmidoverride");
                        JSONObject fileFmidJsonObject = Packaging.getJsonObject((String)fileFmidOverride);
                        boolean foundFileReference = false;
                        if (functionDefinitionUuid.equals(fileFmid)) {
                            foundFileReference = true;
                        } else if (fileFmidJsonObject.containsValue((Object)functionDefinitionUuid)) {
                            foundFileReference = true;
                        }
                        if (!foundFileReference) continue;
                        if (projectTreeNode == null) {
                            projectTreeNode = new ProjectTreeNode((Object)project);
                            Utils.addChildTreeNode((TreeNode)projectTreeNode, (TreeNode)functionDefinitionTreeNode);
                        }
                        if (folderTreeNode == null) {
                            folderTreeNode = new FolderTreeNode((Object)folder);
                            Utils.addChildTreeNode((TreeNode)folderTreeNode, (TreeNode)projectTreeNode);
                        }
                        FileTreeNode fileTreeNode = new FileTreeNode((Object)resource);
                        Utils.addChildTreeNode((TreeNode)fileTreeNode, (TreeNode)folderTreeNode);
                    }
                }
            }
            for (ISystemDefinition systemDefinition : languageDefinitions) {
                IZosLanguageDefinition zosLanguageDefinition;
                ILanguageDefinition languageDefinition = (ILanguageDefinition)systemDefinition;
                if (!(languageDefinition instanceof IZosLanguageDefinition) || !(zosLanguageDefinition = (IZosLanguageDefinition)systemDefinition).hasSmpePackaging()) continue;
                IPackagingItemDefinition packagingItemDefinition = (IPackagingItemDefinition)zosLanguageDefinition.getSmpePackaging();
                boolean foundReference = false;
                if (functionDefinition.sameItemId((IItemHandle)packagingItemDefinition.getFmid())) {
                    foundReference = true;
                } else if (Verification.isNonEmpty((List)packagingItemDefinition.getDetails())) {
                    for (IPackagingDetailDefinition packagingDetailDefinition : packagingItemDefinition.getDetails()) {
                        if (!functionDefinition.sameItemId((IItemHandle)packagingDetailDefinition.getFmidoverride())) continue;
                        foundReference = true;
                        break;
                    }
                }
                if (!foundReference) continue;
                TreeNodeLoaderRegistry instance = TreeNodeLoaderRegistry.getInstance();
                ITreeNodeLoader treeNodeLoader = instance.getLoader("LanguageDefinitionTreeNode");
                TreeNode languageDefinitionTreeNode = (TreeNode)treeNodeLoader.getTreeNode((Object)languageDefinition);
                Utils.addChildTreeNode((TreeNode)languageDefinitionTreeNode, (TreeNode)functionDefinitionTreeNode);
            }
            for (ISystemDefinition systemDefinition : versionDefinitions) {
                IVersionDefinition versionDefinition = (IVersionDefinition)systemDefinition;
                boolean foundReference = false;
                if (functionDefinition.sameItemId((IItemHandle)versionDefinition.getBaseFunction())) {
                    foundReference = true;
                } else if (functionDefinition.sameItemId((IItemHandle)versionDefinition.getDefaultFunction())) {
                    foundReference = true;
                } else if (Verification.isNonEmpty((List)versionDefinition.getFmidItems())) {
                    for (IFmidItemDefinition fmidItemDefinition : versionDefinition.getFmidItems()) {
                        if (!functionDefinition.sameItemId((IItemHandle)fmidItemDefinition.getFunction())) continue;
                        foundReference = true;
                        break;
                    }
                }
                if (!foundReference) continue;
                VersionDefinitionTreeNode versionDefinitionTreeNode = new VersionDefinitionTreeNode(versionDefinition);
                Utils.addChildTreeNode((TreeNode)versionDefinitionTreeNode, (TreeNode)functionDefinitionTreeNode);
            }
            if (!functionDefinitionTreeNode.hasChildren()) continue;
            results.add((ReferenceTreeNode)functionDefinitionTreeNode);
        }
        return results;
    }

    public List<String> reReference(ArrayList<ReferenceTreeNode> currentReferences, ISystemDefinition newTarget, ISystemDefinition oldTarget, ITeamRepository repository) {
        Status status;
        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)repository);
        ArrayList<String> log = new ArrayList<String>();
        TreeNode languageTreeNodeInstance = null;
        try {
            TreeNodeLoaderRegistry instance = TreeNodeLoaderRegistry.getInstance();
            ITreeNodeLoader treeNodeLoader = instance.getLoader("LanguageDefinitionTreeNode");
            languageTreeNodeInstance = (TreeNode)treeNodeLoader.getTreeNode(null);
        }
        catch (Exception e) {
            Status status2 = new Status(4, "com.ibm.team.enterprise.smpe.ui", Messages.FunctionDefinition_References_ReReference_Error_Language);
            SmpeUIPlugin.log((IStatus)status2);
            SmpeUIPlugin.log(e);
            log.add(Messages.FunctionDefinition_References_ReReference_Error_Internal);
            return log;
        }
        if (!(oldTarget instanceof IFunctionDefinition)) {
            status = new Status(4, "com.ibm.team.enterprise.smpe.ui", Messages.FunctionDefinition_References_ReReference_Error_TargetOld);
            SmpeUIPlugin.log((IStatus)status);
            log.add(Messages.FunctionDefinition_References_ReReference_Error_Internal);
            return log;
        }
        IFunctionDefinition oldFunctionDefinition = (IFunctionDefinition)oldTarget;
        if (!(newTarget instanceof IFunctionDefinition)) {
            status = new Status(4, "com.ibm.team.enterprise.smpe.ui", Messages.FunctionDefinition_References_ReReference_Error_TargetNew);
            SmpeUIPlugin.log((IStatus)status);
            log.add(Messages.FunctionDefinition_References_ReReference_Error_Internal);
            return log;
        }
        IFunctionDefinition newFunctionDefinition = (IFunctionDefinition)newTarget;
        String oldFunctionDefinitionUuid = oldFunctionDefinition.getItemId().getUuidValue();
        String newFunctionDefinitionUuid = newFunctionDefinition.getItemId().getUuidValue();
        for (ReferenceTreeNode referenceTreeNode : currentReferences) {
            IStatus status3;
            JSONObject fmidJsonObject;
            String fmidOverride;
            String fmid;
            IResource resource;
            if (referenceTreeNode instanceof FolderTreeNode) {
                resource = (IResource)referenceTreeNode.getValue();
                fmid = Utils.getArtifactVersionableProperty((IResource)resource, (String)"team.enterprise.smpe.packaging.folder.fmid");
                fmidOverride = Utils.getArtifactVersionableProperty((IResource)resource, (String)"team.enterprise.smpe.packagingdetail.folder.fmidoverride");
                fmidJsonObject = Packaging.getJsonObject((String)fmidOverride);
                if (oldFunctionDefinitionUuid.equals(fmid)) {
                    status3 = Utils.setArtifactVersionableProperty((IResource)resource, (String)newFunctionDefinitionUuid, (String)"team.enterprise.smpe.packaging.folder.fmid");
                    if (status3.getSeverity() == 0) {
                        log.add(NLS.bind((String)Messages.FunctionDefinition_References_ReReference_Success_IFolder, (Object)resource.getName(), (Object[])new Object[]{oldFunctionDefinition.getName(), newFunctionDefinition.getName()}));
                    } else {
                        log.add(NLS.bind((String)Messages.FunctionDefinition_References_ReReference_Failure_IFolder, (Object)resource.getName(), (Object[])new Object[]{oldFunctionDefinition.getName()}));
                        SmpeUIPlugin.log(status3);
                    }
                }
                if (!fmidJsonObject.containsValue((Object)oldFunctionDefinitionUuid)) continue;
                for (Object key : fmidJsonObject.keySet()) {
                    if (!fmidJsonObject.get(key).equals(oldFunctionDefinitionUuid)) continue;
                    fmidJsonObject.put(key, (Object)newFunctionDefinitionUuid);
                }
                status3 = Utils.setArtifactVersionableProperty((IResource)resource, (String)fmidJsonObject.toString().replaceAll("\\s", ""), (String)"team.enterprise.smpe.packagingdetail.folder.fmidoverride");
                if (status3.getSeverity() == 0) {
                    log.add(NLS.bind((String)Messages.FunctionDefinition_References_ReReference_Success_IFolders, (Object)resource.getName(), (Object[])new Object[]{oldFunctionDefinition.getName(), newFunctionDefinition.getName()}));
                    continue;
                }
                log.add(NLS.bind((String)Messages.FunctionDefinition_References_ReReference_Failure_IFolders, (Object)resource.getName(), (Object[])new Object[]{oldFunctionDefinition.getName()}));
                SmpeUIPlugin.log(status3);
                continue;
            }
            if (referenceTreeNode instanceof FileTreeNode) {
                resource = (IResource)referenceTreeNode.getValue();
                fmid = Utils.getArtifactVersionableProperty((IResource)resource, (String)"team.enterprise.smpe.packaging.file.fmid");
                fmidOverride = Utils.getArtifactVersionableProperty((IResource)resource, (String)"team.enterprise.smpe.packagingdetail.file.fmidoverride");
                fmidJsonObject = Packaging.getJsonObject((String)fmidOverride);
                if (oldFunctionDefinitionUuid.equals(fmid)) {
                    status3 = Utils.setArtifactVersionableProperty((IResource)resource, (String)newFunctionDefinitionUuid, (String)"team.enterprise.smpe.packaging.file.fmid");
                    if (status3.getSeverity() == 0) {
                        log.add(NLS.bind((String)Messages.FunctionDefinition_References_ReReference_Success_IFile, (Object)resource.getName(), (Object[])new Object[]{oldFunctionDefinition.getName(), newFunctionDefinition.getName()}));
                    } else {
                        log.add(NLS.bind((String)Messages.FunctionDefinition_References_ReReference_Failure_IFile, (Object)resource.getName(), (Object[])new Object[]{oldFunctionDefinition.getName()}));
                        SmpeUIPlugin.log(status3);
                    }
                }
                if (!fmidJsonObject.containsValue((Object)oldFunctionDefinitionUuid)) continue;
                for (Object key : fmidJsonObject.keySet()) {
                    if (!fmidJsonObject.get(key).equals(oldFunctionDefinitionUuid)) continue;
                    fmidJsonObject.put(key, (Object)newFunctionDefinitionUuid);
                }
                status3 = Utils.setArtifactVersionableProperty((IResource)resource, (String)fmidJsonObject.toString().replaceAll("\\s", ""), (String)"team.enterprise.smpe.packagingdetail.file.fmidoverride");
                if (status3.getSeverity() == 0) {
                    log.add(NLS.bind((String)Messages.FunctionDefinition_References_ReReference_Success_IFiles, (Object)resource.getName(), (Object[])new Object[]{oldFunctionDefinition.getName(), newFunctionDefinition.getName()}));
                    continue;
                }
                log.add(NLS.bind((String)Messages.FunctionDefinition_References_ReReference_Failure_IFiles, (Object)resource.getName(), (Object[])new Object[]{oldFunctionDefinition.getName()}));
                SmpeUIPlugin.log(status3);
                continue;
            }
            if (referenceTreeNode.getClass().isInstance(languageTreeNodeInstance)) {
                IZosLanguageDefinition languageDefinition = (IZosLanguageDefinition)referenceTreeNode.getValue();
                IZosLanguageDefinition languageWorkingCopy = (IZosLanguageDefinition)languageDefinition.getWorkingCopy();
                IPackagingItemDefinition packagingItemDefinition = (IPackagingItemDefinition)languageWorkingCopy.getSmpePackaging();
                IPackagingItemDefinition packagingItemWorkingCopy = (IPackagingItemDefinition)packagingItemDefinition.getWorkingCopy();
                if (oldFunctionDefinition.sameItemId((IItemHandle)packagingItemWorkingCopy.getFmid())) {
                    languageWorkingCopy.setSmpePackaging((IPackagingItemDefinitionHandle)packagingItemWorkingCopy);
                    packagingItemWorkingCopy.setFmid((IFunctionDefinitionHandle)newFunctionDefinition);
                } else {
                    languageWorkingCopy.setSmpePackaging((IPackagingItemDefinitionHandle)packagingItemWorkingCopy);
                }
                if (Verification.isNonEmpty((List)packagingItemWorkingCopy.getDetails())) {
                    ArrayList<IPackagingDetailDefinition> details = new ArrayList<IPackagingDetailDefinition>(packagingItemWorkingCopy.getDetails().size());
                    for (IPackagingDetailDefinition packagingDetailDefinition : packagingItemWorkingCopy.getDetails()) {
                        IPackagingDetailDefinition packagingDetailWorkingCopy = (IPackagingDetailDefinition)packagingDetailDefinition.getWorkingCopy();
                        if (oldFunctionDefinition.sameItemId((IItemHandle)packagingDetailWorkingCopy.getFmidoverride())) {
                            packagingDetailWorkingCopy.setFmidoverride((IFunctionDefinitionHandle)newFunctionDefinition);
                        }
                        details.add(packagingDetailWorkingCopy);
                    }
                    packagingItemWorkingCopy.getPackagingDetails().clear();
                    packagingItemWorkingCopy.getPackagingDetails().addAll(details);
                }
                try {
                    ISystemDefinitionHandle saveHandle = client.saveSystemDefinition((ISystemDefinition)languageWorkingCopy, (IProgressMonitor)new NullProgressMonitor());
                    IZosLanguageDefinition language = (IZosLanguageDefinition)client.fetchSystemDefinitionComplete(saveHandle, false, (IProgressMonitor)new NullProgressMonitor());
                    referenceTreeNode.setValue((Object)language);
                    log.add(NLS.bind((String)Messages.FunctionDefinition_References_ReReference_Success_ILanguage, (Object)languageDefinition.getName(), (Object[])new Object[]{oldFunctionDefinition.getName(), newFunctionDefinition.getName()}));
                }
                catch (TeamRepositoryException e) {
                    log.add(NLS.bind((String)Messages.FunctionDefinition_References_ReReference_Failure_ILanguage, (Object)languageDefinition.getName(), (Object[])new Object[]{oldFunctionDefinition.getName()}));
                    SmpeUIPlugin.log(e);
                }
                continue;
            }
            if (!(referenceTreeNode instanceof VersionDefinitionTreeNode)) continue;
            IVersionDefinition versionDefinition = (IVersionDefinition)referenceTreeNode.getValue();
            IVersionDefinition versionWorkingCopy = (IVersionDefinition)versionDefinition.getWorkingCopy();
            if (oldFunctionDefinition.sameItemId((IItemHandle)versionWorkingCopy.getBaseFunction())) {
                versionWorkingCopy.setBaseFunction((IFunctionDefinitionHandle)newFunctionDefinition);
            }
            if (oldFunctionDefinition.sameItemId((IItemHandle)versionWorkingCopy.getDefaultFunction())) {
                versionWorkingCopy.setDefaultFunction((IFunctionDefinitionHandle)newFunctionDefinition);
            }
            if (Verification.isNonEmpty((List)versionWorkingCopy.getFmidItems())) {
                ArrayList<IFmidItemDefinition> fmidItems = new ArrayList<IFmidItemDefinition>(versionWorkingCopy.getFmidItems().size());
                for (IFmidItemDefinition fmidItemDefinition : versionWorkingCopy.getFmidItems()) {
                    IFmidItemDefinition fmidItemWorkingCopy = (IFmidItemDefinition)fmidItemDefinition.getWorkingCopy();
                    if (oldFunctionDefinition.sameItemId((IItemHandle)fmidItemWorkingCopy.getFunction())) {
                        fmidItemWorkingCopy.setFunction((IFunctionDefinitionHandle)newFunctionDefinition);
                    }
                    fmidItems.add(fmidItemWorkingCopy);
                }
                versionWorkingCopy.getFmidItemDefinitions().clear();
                versionWorkingCopy.getFmidItemDefinitions().addAll(fmidItems);
            }
            try {
                ISystemDefinitionHandle savedHandle = client.saveSystemDefinition((ISystemDefinition)versionWorkingCopy, (IProgressMonitor)new NullProgressMonitor());
                IVersionDefinition version = (IVersionDefinition)client.fetchSystemDefinitionComplete(savedHandle, false, (IProgressMonitor)new NullProgressMonitor());
                referenceTreeNode.setValue((Object)version);
                log.add(NLS.bind((String)Messages.FunctionDefinition_References_ReReference_Success_IVersion, (Object)versionDefinition.getName(), (Object[])new Object[]{oldFunctionDefinition.getName(), newFunctionDefinition.getName()}));
            }
            catch (TeamRepositoryException e) {
                log.add(NLS.bind((String)Messages.FunctionDefinition_References_ReReference_Failure_IVersion, (Object)versionDefinition.getName(), (Object[])new Object[]{oldFunctionDefinition.getName()}));
                SmpeUIPlugin.log(e);
            }
        }
        return log;
    }
}

