/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.elements;

import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.smpe.ui.IDetailsDataProvider;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.cache.ICacheItem;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheFactory;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.Packaging;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.Id;
import com.ibm.team.enterprise.systemdefinition.common.model.Mcstype;
import com.ibm.team.enterprise.systemdefinition.common.model.Processor;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingDetail;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class PackagingDetailsLanguageLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final IDetailsDataProvider detailsDataProvider;
    private final IProjectAreaHandle projectAreaHandle;
    private final ITeamRepository teamRepository;

    public PackagingDetailsLanguageLabelProvider(ITeamRepository teamRepository, IProjectAreaHandle projectAreaHandle, IDetailsDataProvider detailsDataProvider) {
        this.teamRepository = teamRepository;
        this.projectAreaHandle = projectAreaHandle;
        this.detailsDataProvider = detailsDataProvider;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IPackagingDetail) {
            IPackagingDetail packagingDetails = (IPackagingDetail)element;
            switch (columnIndex) {
                case 0: {
                    return packagingDetails.getName();
                }
                case 1: {
                    return packagingDetails.getDescription();
                }
                case 2: {
                    return Id.toString((Id)packagingDetails.getId(), (String)"");
                }
                case 3: {
                    return Mcstype.toString((Mcstype)packagingDetails.getMcstype(), (String)"");
                }
                case 4: {
                    return Processor.toString((Processor)packagingDetails.getProcessor(), (String)"");
                }
                case 5: {
                    return Verification.toTrueFalse((Boolean)packagingDetails.getBinary());
                }
                case 6: {
                    return Packaging.getFunctionName(this.detailsDataProvider.getFunctionList(), (IFunctionDefinitionHandle)packagingDetails.getFmidoverride());
                }
                case 7: {
                    return this.getDatasetName(packagingDetails.getLocation());
                }
                case 8: {
                    return this.getDatasetName(packagingDetails.getDistlib());
                }
                case 9: {
                    return this.getDatasetName(packagingDetails.getSyslib());
                }
            }
        }
        return null;
    }

    private String getDatasetName(IDataSetDefinitionHandle dataSetDefinitionHandle) {
        if (!Verification.isNonNull((Object)dataSetDefinitionHandle)) {
            return "";
        }
        String uuid = dataSetDefinitionHandle.getItemId().getUuidValue();
        ICacheItem datasetHandleCacheItem = ItemCacheFactory.getDatasetHandle((ITeamRepository)this.teamRepository, (IProjectAreaHandle)this.projectAreaHandle);
        if (datasetHandleCacheItem != null && datasetHandleCacheItem.containsUuid(uuid)) {
            return ((ISystemDefinition)datasetHandleCacheItem.getUuid(uuid)).getName();
        }
        ICacheItem datasetCacheItem = ItemCacheFactory.getDataset((ITeamRepository)this.teamRepository, (IProjectAreaHandle)this.projectAreaHandle);
        if (datasetCacheItem != null && datasetCacheItem.containsUuid(uuid)) {
            return ((IResourceDefinition)datasetCacheItem.getUuid(uuid)).getName();
        }
        try {
            UUID.valueOf((String)uuid);
        }
        catch (Exception e) {
            return Messages.PackagingDetails_LabelProvider_Error_Invalid;
        }
        try {
            IResourceDefinition resourceDefinition = ItemCacheFactory.addDataset((ITeamRepository)this.teamRepository, (IProjectAreaHandle)this.projectAreaHandle, (String)uuid);
            if (resourceDefinition != null) {
                return resourceDefinition.getName();
            }
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        return uuid;
    }
}

