/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.elements;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.common.helper.BuildEngineHelper;
import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;

public class OrchestratorEnginePaintProvider
extends OwnerDrawLabelProvider {
    protected void measure(Event event, Object element) {
    }

    protected void paint(Event event, Object element) {
        if (element instanceof IBuildEngine) {
            IBuildEngine buildEngine = (IBuildEngine)element;
            IBuildConfigurationElement configElement = buildEngine.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorEngineConfigElement");
            switch (event.index) {
                case 0: {
                    TableItem item = (TableItem)event.item;
                    this.paintIcon(event, element, SmpeUIPlugin.getImage("icons/obj16/build_engine_obj.gif"), buildEngine.getId());
                    break;
                }
                case 1: {
                    TableItem item = (TableItem)event.item;
                    if (BuildEngineHelper.isBuildAgentEngine((IBuildEngine)buildEngine)) {
                        item.setText(event.index, "RBA");
                        break;
                    }
                    if (BuildEngineHelper.isBuildForgeEngine((IBuildEngine)buildEngine)) {
                        item.setText(event.index, "RBF");
                        break;
                    }
                    if (BuildEngineHelper.isHudsonEngine((IBuildEngine)buildEngine)) {
                        item.setText(event.index, "HDN");
                        break;
                    }
                    item.setText(event.index, "JBE");
                    break;
                }
                case 2: {
                    IConfigurationProperty property;
                    if (configElement == null || (property = configElement.getConfigurationProperty("team.enterprise.smpe.build.orchestrator.engine.general")) == null || !Boolean.parseBoolean(property.getValue())) break;
                    this.paintCheckbox(event, element, SmpeUIPlugin.getImage("icons/obj16/ok_obj.gif"));
                    break;
                }
                case 3: {
                    IConfigurationProperty property;
                    if (configElement == null || (property = configElement.getConfigurationProperty("team.enterprise.smpe.build.orchestrator.engine.dedicated")) == null || !Boolean.parseBoolean(property.getValue())) break;
                    this.paintCheckbox(event, element, SmpeUIPlugin.getImage("icons/obj16/ok_obj.gif"));
                    break;
                }
            }
        }
    }

    private void paintCheckbox(Event event, Object element, Image image) {
        TableItem item = (TableItem)event.item;
        Rectangle cellBounds = item.getBounds(event.index);
        Rectangle imageBounds = image.getBounds();
        int x = cellBounds.x + (cellBounds.width - imageBounds.width) / 2;
        int y = cellBounds.y + (cellBounds.height - imageBounds.height) / 2;
        event.gc.drawImage(image, x, y);
    }

    private void paintIcon(Event event, Object element, Image image, String text) {
        TableItem item = (TableItem)event.item;
        Rectangle cellBounds = item.getBounds(event.index);
        Rectangle imageBounds = image.getBounds();
        int x = cellBounds.x;
        int y = cellBounds.y;
        event.gc.drawImage(image, x, y);
        event.gc.drawText(text, x + imageBounds.width + 4, y);
    }
}

