/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.elements;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.smpe.common.IOrchestratorBuild;
import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import java.util.List;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;

public class OrchestratorBuildPaintProvider
extends OwnerDrawLabelProvider {
    protected void measure(Event event, Object element) {
    }

    protected void paint(Event event, Object element) {
        if (element instanceof IOrchestratorBuild) {
            IOrchestratorBuild build = (IOrchestratorBuild)element;
            switch (event.index) {
                case 0: {
                    if (build.getBuildDefinition() == null) break;
                    this.paintIcon(event, element, SmpeUIPlugin.getImage("icons/obj16/build.gif"), build.getBuildDefinition().getId());
                    break;
                }
                case 1: {
                    if (!Verification.isNonEmpty((List)build.getBuildEngines())) break;
                    StringBuilder sb = new StringBuilder();
                    String separator = "";
                    for (IBuildEngine engine : build.getBuildEngines()) {
                        sb.append(separator).append(engine.getId());
                        separator = ", ";
                    }
                    this.paintIcon(event, element, SmpeUIPlugin.getImage("icons/obj16/build_engine_obj.gif"), sb.toString());
                    break;
                }
                case 2: {
                    if (!build.isEnabled()) break;
                    this.paintCheckbox(event, element, SmpeUIPlugin.getImage("icons/obj16/ok_obj.gif"));
                    break;
                }
                case 3: {
                    if (!build.isPrimary()) break;
                    this.paintCheckbox(event, element, SmpeUIPlugin.getImage("icons/obj16/ok_obj.gif"));
                    break;
                }
                case 4: {
                    if (!build.isSecondary()) break;
                    this.paintCheckbox(event, element, SmpeUIPlugin.getImage("icons/obj16/ok_obj.gif"));
                    break;
                }
                case 5: {
                    if (!build.isDependent()) break;
                    this.paintCheckbox(event, element, SmpeUIPlugin.getImage("icons/obj16/ok_obj.gif"));
                    break;
                }
                case 6: {
                    if (!build.isHousekeeping()) break;
                    this.paintCheckbox(event, element, SmpeUIPlugin.getImage("icons/obj16/ok_obj.gif"));
                    break;
                }
                case 7: {
                    if (!Verification.isNonEmpty((List)build.getDependsOn())) break;
                    StringBuilder sb = new StringBuilder();
                    String separator = "";
                    for (IBuildDefinition definition : build.getDependsOn()) {
                        sb.append(separator).append(definition.getId());
                        separator = ", ";
                    }
                    this.paintIcon(event, element, SmpeUIPlugin.getImage("icons/obj16/build.gif"), sb.toString());
                    break;
                }
            }
        }
    }

    private void paintCheckbox(Event event, Object element, Image image) {
        TableItem item = (TableItem)event.item;
        Rectangle cellBounds = item.getBounds(event.index);
        Rectangle imageBounds = image.getBounds();
        int x = cellBounds.x + (cellBounds.width - imageBounds.width) / 2;
        int y = cellBounds.y + (cellBounds.height - imageBounds.height) / 2;
        event.gc.drawImage(image, x, y);
    }

    private void paintIcon(Event event, Object element, Image image, String text) {
        TableItem item = (TableItem)event.item;
        Rectangle cellBounds = item.getBounds(event.index);
        Rectangle imageBounds = image.getBounds();
        int x = cellBounds.x;
        int y = cellBounds.y;
        event.gc.drawImage(image, x, y);
        event.gc.drawText(text, x + imageBounds.width + 4, y);
    }
}

