/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.elements;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.smpe.common.IOrchestratorBuild;
import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import java.util.List;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class OrchestratorBuildLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof IOrchestratorBuild) {
            IOrchestratorBuild build = (IOrchestratorBuild)element;
            switch (columnIndex) {
                case 0: {
                    if (build.getBuildDefinition() != null) {
                        return SmpeUIPlugin.getImage("icons/obj16/build.gif");
                    }
                    return null;
                }
                case 1: {
                    if (Verification.isNonEmpty((List)build.getBuildEngines())) {
                        return SmpeUIPlugin.getImage("icons/obj16/build_engine_obj.gif");
                    }
                    return null;
                }
                case 2: {
                    return null;
                }
                case 3: {
                    return null;
                }
                case 4: {
                    return null;
                }
                case 5: {
                    return null;
                }
                case 6: {
                    if (Verification.isNonEmpty((List)build.getDependsOn())) {
                        return SmpeUIPlugin.getImage("icons/obj16/build.gif");
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IOrchestratorBuild) {
            IOrchestratorBuild build = (IOrchestratorBuild)element;
            switch (columnIndex) {
                case 0: {
                    return build.getBuildDefinition().getId();
                }
                case 1: {
                    if (Verification.isNonEmpty((List)build.getBuildEngines())) {
                        StringBuilder sb = new StringBuilder();
                        String separator = "";
                        for (IBuildEngine engine : build.getBuildEngines()) {
                            sb.append(separator).append(engine.getId());
                            separator = ", ";
                        }
                        return sb.toString();
                    }
                    return null;
                }
                case 2: {
                    return Boolean.toString(build.isPrimary());
                }
                case 3: {
                    return Boolean.toString(build.isSecondary());
                }
                case 4: {
                    return Boolean.toString(build.isDependent());
                }
                case 5: {
                    return Boolean.toString(build.isHousekeeping());
                }
                case 6: {
                    if (Verification.isNonEmpty((List)build.getDependsOn())) {
                        StringBuilder sb = new StringBuilder();
                        String separator = "";
                        for (IBuildDefinition definition : build.getDependsOn()) {
                            sb.append(separator).append(definition.getId());
                            separator = ", ";
                        }
                        return sb.toString();
                    }
                    return null;
                }
            }
        }
        return null;
    }
}

