/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.elements;

import com.ibm.team.enterprise.smpe.ui.TableTextProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class NumberListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final boolean centered;
    private final List<Object> labelList;
    private final TableTextProvider textProvider;

    public NumberListLabelProvider(List<?> labelList) {
        this(labelList, false, null);
    }

    public NumberListLabelProvider(List<?> labelList, boolean centered) {
        this(labelList, centered, null);
    }

    public NumberListLabelProvider(List<?> labelList, TableTextProvider textProvider) {
        this(labelList, false, textProvider);
    }

    public NumberListLabelProvider(List<?> labelList, boolean centered, TableTextProvider textProvider) {
        this.labelList = new ArrayList(labelList);
        this.centered = centered;
        this.textProvider = textProvider;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element != null && this.labelList.contains(element)) {
            if (this.centered) {
                switch (columnIndex) {
                    case 0: {
                        if (this.textProvider == null) {
                            return element.toString();
                        }
                        return this.textProvider.getText(element);
                    }
                    case 1: {
                        return Integer.toString(this.labelList.indexOf(element) + 1);
                    }
                }
            } else {
                switch (columnIndex) {
                    case 0: {
                        return Integer.toString(this.labelList.indexOf(element) + 1);
                    }
                    case 1: {
                        if (this.textProvider == null) {
                            return element.toString();
                        }
                        return this.textProvider.getText(element);
                    }
                }
            }
        }
        return null;
    }

    public void setLabelList(List<?> labelList) {
        this.labelList.clear();
        this.labelList.addAll(labelList);
    }
}

