/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.elements;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainContentProvider;
import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.FunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFmidItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFmidItemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.ui.node.AbstractEnterpriseExtensionsSystemDefinitionNode;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Helper;
import com.ibm.team.repository.common.model.Item;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class DuplicateSystemDefinitionJob
extends Job
implements IJobChangeListener {
    private final AbstractEnterpriseExtensionsSystemDefinitionNode node;
    private final IProjectAreaHandle projectAreaHandle;
    private final String name;
    private final String id;

    public DuplicateSystemDefinitionJob(AbstractEnterpriseExtensionsSystemDefinitionNode node, IProjectAreaHandle projectAreaHandle, String name, String id) {
        super(Messages.DuplicateSystemDefinitionAction_Dialog_Label_Job);
        this.node = node;
        this.projectAreaHandle = projectAreaHandle;
        this.name = name;
        this.id = id;
        this.setUser(true);
    }

    public void scheduleAndUpdateUI() {
        this.addJobChangeListener(this);
        this.schedule();
    }

    protected IStatus run(IProgressMonitor monitor) {
        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)((ITeamRepository)this.projectAreaHandle.getOrigin()));
        monitor.beginTask(Messages.DuplicateSystemDefinitionAction_Dialog_Label_Job, 2);
        try {
            ISystemDefinition workingCopy;
            ISystemDefinition simpleDefinition = this.node.getSystemDefinition();
            ISystemDefinition systemDefinition = client.fetchSystemDefinitionComplete((ISystemDefinitionHandle)simpleDefinition, true, monitor);
            FunctionDefinition newSystemDefinition = null;
            if (!SystemDefinitionUtil.isTypeOf((IItemType)systemDefinition.getItemType(), (IItemType)IFunctionDefinition.ITEM_TYPE) && !SystemDefinitionUtil.isTypeOf((IItemType)systemDefinition.getItemType(), (IItemType)IVersionDefinition.ITEM_TYPE)) {
                Status status = new Status(4, SmpeUIPlugin.getUniqueIdentifier(), Messages.DuplicateSystemDefinitionAction_Dialog_Error_Invalid, (Throwable)new TeamRepositoryException(Messages.DuplicateSystemDefinitionAction_Dialog_Error_Invalid));
                return status;
            }
            if (systemDefinition instanceof IFunctionDefinition) {
                newSystemDefinition = ModelFactory.eINSTANCE.createFunctionDefinition();
                if (newSystemDefinition == null) {
                    Status status = new Status(4, SmpeUIPlugin.getUniqueIdentifier(), Messages.DuplicateSystemDefinitionAction_Dialog_Error_Failed);
                    return status;
                }
                IFunctionDefinition functionDefinition = (IFunctionDefinition)systemDefinition;
                IFunctionDefinition newFunctionDefinition = (IFunctionDefinition)newSystemDefinition;
                newFunctionDefinition.copy(functionDefinition);
                newFunctionDefinition.setName(this.name);
                newFunctionDefinition.setId(this.id);
            }
            if (systemDefinition instanceof IVersionDefinition) {
                newSystemDefinition = ModelFactory.eINSTANCE.createVersionDefinition();
                if (newSystemDefinition == null) {
                    Status status = new Status(4, SmpeUIPlugin.getUniqueIdentifier(), Messages.DuplicateSystemDefinitionAction_Dialog_Error_Failed);
                    return status;
                }
                IVersionDefinition versionDefinition = (IVersionDefinition)systemDefinition;
                IVersionDefinition newVersionDefinition = (IVersionDefinition)newSystemDefinition;
                newVersionDefinition.copy(versionDefinition);
                newVersionDefinition.setName(this.name);
                newVersionDefinition.setId(this.id);
                for (IFmidItemDefinitionHandle fmidItemDefinitionHandle : newVersionDefinition.getFmidItemDefinitions()) {
                    if (!fmidItemDefinitionHandle.hasFullState()) continue;
                    IFmidItemDefinition fmidItemDefinition = (IFmidItemDefinition)fmidItemDefinitionHandle;
                    fmidItemDefinition.setName(NLS.bind((String)Messages.DuplicateSystemDefinitionDialog_Dialog_Prefix, (Object)fmidItemDefinition.getName()));
                }
            }
            if ((workingCopy = (ISystemDefinition)newSystemDefinition.getWorkingCopy()) instanceof Item) {
                this.updateUUIDs((Item)workingCopy);
            }
            client.saveSystemDefinition(workingCopy, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (TeamRepositoryException e) {
            Status status = new Status(4, SmpeUIPlugin.getUniqueIdentifier(), Messages.DuplicateSystemDefinitionAction_Dialog_Error_Failed, (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    private void updateUUIDs(Item item) {
        item.setItemId(UUID.generate());
        if (item instanceof EObject) {
            EObject eobject = (EObject)item;
            EClass eclass = eobject.eClass();
            for (EReference reference : eclass.getEAllContainments()) {
                Object currentItem = eobject.eGet((EStructuralFeature)reference, true);
                if (currentItem instanceof Helper) {
                    ((Helper)currentItem).setInternalId(UUID.generate());
                    continue;
                }
                if (!(currentItem instanceof Collection) || ((Collection)currentItem).isEmpty()) continue;
                for (Object listItem : (Collection)currentItem) {
                    if (!(listItem instanceof Helper)) continue;
                    ((Helper)listItem).setInternalId(UUID.generate());
                }
            }
        }
    }

    public void done(IJobChangeEvent event) {
        if (this.getResult().isOK()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ((EnterpriseExtensionsDomainContentProvider)DuplicateSystemDefinitionJob.this.node.getDomain().getContentProvider()).updateTreeViewer((AbstractEnterpriseExtensionsNode)DuplicateSystemDefinitionJob.this.node.getParent());
                }
            });
        }
        this.removeJobChangeListener(this);
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }
}

