/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.editors;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import com.ibm.team.enterprise.smpe.ui.dialogs.VersionDefinitionAddFunctionDialog;
import com.ibm.team.enterprise.smpe.ui.dialogs.VersionDefinitionDeleteFunctionDialog;
import com.ibm.team.enterprise.smpe.ui.domain.VersionDefinitionsNodeEE;
import com.ibm.team.enterprise.smpe.ui.editors.AbstractSystemDefinitionEditorSmpe;
import com.ibm.team.enterprise.smpe.ui.editors.AbstractVersionDefinitionEditorPageItem;
import com.ibm.team.enterprise.smpe.ui.editors.VersionDefinitionEditorInput;
import com.ibm.team.enterprise.smpe.ui.editors.VersionDefinitionEditorPageFmidItem;
import com.ibm.team.enterprise.smpe.ui.editors.VersionDefinitionEditorPageGeneral;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.smpe.ui.utils.EditorItemCache;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingFactory;
import com.ibm.team.enterprise.systemdefinition.common.model.IFmidItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFmidItemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingFmidItem;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingVersion;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractEditorInput;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class VersionDefinitionEditor
extends AbstractSystemDefinitionEditorSmpe {
    private boolean idChanged;
    private ScrolledForm form;
    private IVersionDefinition packagingVersion;
    private ISystemDefinitionCache systemDefinitionCache;
    private VersionDefinitionEditorInput editorInput;
    private VersionDefinitionEditorPageGeneral pageGeneral;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.editorInput = (VersionDefinitionEditorInput)input;
        this.fTeamRepository = this.editorInput.getTeamRepository();
        this.fIsNewSystemDefinition = this.editorInput.isNewSystemDefinition();
        this.fSystemDefinition = this.editorInput.getSystemDefinition();
        this.packagingVersion = (IVersionDefinition)this.fSystemDefinition;
        IProjectAreaHandle projectAreaHandle = this.fSystemDefinition.getProjectArea();
        this.systemDefinitionCache = new EditorItemCache(this.fTeamRepository, projectAreaHandle, this.editorInput.getDebugger());
        this.handleSaveRequired();
    }

    protected void addPages() {
        try {
            this.pageGeneral = new VersionDefinitionEditorPageGeneral(Messages.VersionDefinition_EditorGeneralPage_TabId, Messages.VersionDefinition_EditorGeneralPage_Title);
            this.pageGeneral.initialize(this);
            this.pageGeneral.setWorkingCopy(this.fSystemDefinition);
            this.addPage((IFormPage)this.pageGeneral);
            for (IFmidItemDefinition packagingFmidItem : this.packagingVersion.getFmidItems()) {
                this.addPageFmidItem((IPackagingFmidItem)packagingFmidItem, false);
            }
        }
        catch (PartInitException exception) {
            SmpeUIPlugin.log(exception);
        }
        this.addHistoryPage();
    }

    protected void addPageFmidItem(IPackagingFmidItem packagingFmidItem, boolean activate) {
        try {
            StringBuilder tabid = new StringBuilder();
            tabid.append(Messages.VersionDefinition_EditorFmidItemPage_TabId);
            tabid.append(".");
            tabid.append(packagingFmidItem.getFunctionId());
            StringBuilder title = new StringBuilder();
            title.append(Messages.VersionDefinition_EditorFmidItemPage_Title);
            title.append(" ");
            title.append(packagingFmidItem.getFunctionId());
            title.append(" - ");
            title.append(packagingFmidItem.getFunctionName());
            VersionDefinitionEditorPageFmidItem fmidItemEditorPage = new VersionDefinitionEditorPageFmidItem(tabid.toString(), title.toString());
            fmidItemEditorPage.initialize(this);
            fmidItemEditorPage.setWorkingCopy(this.fSystemDefinition);
            fmidItemEditorPage.setWorkingCopyFmidItem((IFmidItemDefinition)packagingFmidItem);
            this.addPage((IFormPage)fmidItemEditorPage);
            if (activate) {
                this.setActivePage(tabid.toString());
                this.setFocus();
            }
        }
        catch (PartInitException exception) {
            SmpeUIPlugin.log(exception);
        }
    }

    protected void createContextMenu(Form form) {
        IMenuManager menuMgr = form.getMenuManager();
        menuMgr.add((IContributionItem)new Separator("additions"));
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this.getMenuListener());
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        this.createContextMenu(headerForm.getForm().getForm());
        super.createHeaderContents(headerForm);
    }

    protected Image getHeaderTitleImage() {
        if (this.fSystemDefinition.isArchived()) {
            return SmpeUIPlugin.getImage("icons/obj16/version_arch_obj.gif");
        }
        return SmpeUIPlugin.getImage("icons/obj16/version_obj.gif");
    }

    protected String getHeaderTitleText() {
        return Messages.VersionDefinition_Editor_Title;
    }

    protected String getHelpId() {
        return "com.ibm.team.enterprise.smpe.ui.editor_versiondefinitiongeneral";
    }

    protected IAction getMenuActionAddFmidItem() {
        return new Action(Messages.VersionDefinition_Editor_Action_Add_FmidItem){

            public void runWithEvent(Event event) {
                VersionDefinitionAddFunctionDialog dialog = VersionDefinitionEditor.this.getMenuActionAddFmidItemDialog();
                if (dialog.open() == 0) {
                    IFunctionDefinition packagingFunction = dialog.getFunctionSelected();
                    if (packagingFunction != null) {
                        IFmidItemDefinition packagingFmidItem = PackagingFactory.createFmidItemDefinition();
                        packagingFmidItem.setFunction((IFunctionDefinitionHandle)packagingFunction);
                        packagingFmidItem.setProjectArea(VersionDefinitionEditor.this.packagingVersion.getProjectArea());
                        PackagingFactory.addFmidItemDefinition((IVersionDefinition)VersionDefinitionEditor.this.packagingVersion, (IFmidItemDefinition)packagingFmidItem);
                        VersionDefinitionEditor.this.addPageFmidItem((IPackagingFmidItem)packagingFmidItem, true);
                    }
                    VersionDefinitionEditor.this.fDirty = true;
                    VersionDefinitionEditor.this.fireDirtyPropertyChangeEvent();
                }
            }

            public void run() {
                this.runWithEvent(null);
            }
        };
    }

    protected VersionDefinitionAddFunctionDialog getMenuActionAddFmidItemDialog() {
        return new VersionDefinitionAddFunctionDialog(this.getSite().getShell(), new FormToolkit(Display.getDefault()), this.packagingVersion, this.editorInput.getPackagingFunctions());
    }

    protected IAction getMenuActionDeleteFmidItem() {
        return new Action(Messages.VersionDefinition_Editor_Action_Delete_FmidItem){

            public void runWithEvent(Event event) {
                VersionDefinitionDeleteFunctionDialog dialog = VersionDefinitionEditor.this.getMenuActionDeleteFmidItemDialog();
                if (dialog.open() == 0) {
                    IFunctionDefinition packagingFunction = dialog.getFunctionSelected();
                    if (packagingFunction != null && VersionDefinitionEditor.this.getMenuActionDeleteFmidItemConfirm(packagingFunction)) {
                        for (IFmidItemDefinition packagingFmidItem : VersionDefinitionEditor.this.packagingVersion.getFmidItems()) {
                            if (!packagingFmidItem.getFunction().sameItemId((IItemHandle)packagingFunction)) continue;
                            VersionDefinitionEditor.this.removePageFmidItem((IPackagingFmidItem)packagingFmidItem);
                            PackagingFactory.removeFmidItemDefinition((IVersionDefinition)VersionDefinitionEditor.this.packagingVersion, (IFmidItemDefinition)packagingFmidItem);
                            break;
                        }
                    }
                    VersionDefinitionEditor.this.fDirty = true;
                    VersionDefinitionEditor.this.fireDirtyPropertyChangeEvent();
                }
            }

            public void run() {
                this.runWithEvent(null);
            }
        };
    }

    protected boolean getMenuActionDeleteFmidItemConfirm(IFunctionDefinition packagingFunction) {
        return MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)Messages.VersionDefinition_Editor_Action_Delete_FmidItem_Confirm_Title, (String)NLS.bind((String)Messages.VersionDefinition_Editor_Action_Delete_FmidItem_Confirm_Text, (Object)packagingFunction.getId(), (Object)packagingFunction.getName()));
    }

    protected VersionDefinitionDeleteFunctionDialog getMenuActionDeleteFmidItemDialog() {
        return new VersionDefinitionDeleteFunctionDialog(this.getSite().getShell(), new FormToolkit(Display.getDefault()), this.packagingVersion, this.editorInput.getPackagingFunctions());
    }

    protected IMenuListener getMenuListener() {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add(VersionDefinitionEditor.this.getMenuActionAddFmidItem());
                manager.add(VersionDefinitionEditor.this.getMenuActionDeleteFmidItem());
            }
        };
    }

    protected IVersionDefinition getOriginalDefinition() {
        return this.editorInput.getOriginalDefinition();
    }

    public String[] getPackagingFunctionItems() {
        return this.editorInput.getPackagingFunctionItems();
    }

    public List<IFunctionDefinition> getPackagingFunctions() {
        return this.editorInput.getPackagingFunctions();
    }

    protected Set<String> getPackagingVersionIds() {
        return this.editorInput.getPackagingVersionIds();
    }

    protected Set<String> getPackagingVersionNames() {
        return this.editorInput.getPackagingVersionNames();
    }

    public ISystemDefinitionCache getSystemDefinitionCache() {
        return this.systemDefinitionCache;
    }

    protected void handleRefreshComplete() {
        this.fSystemDefinitionIdText.removeModifyListener(this.fIdModifiedListener);
        this.fSystemDefinitionIdText.setText(this.fSystemDefinition.getName());
        this.fSystemDefinitionIdText.addModifyListener(this.fIdModifiedListener);
        this.setErrorMessage((Control)this.fSystemDefinitionIdText, null);
        this.removeUnsavedFmidItemPages();
        this.updatePageWorkingCopies((IVersionDefinition)this.fSystemDefinition);
        this.handleArchived();
        this.setPartName();
        for (Object page : this.pages) {
            AbstractVersionDefinitionEditorPageItem editorPage = (AbstractVersionDefinitionEditorPageItem)((Object)page);
            editorPage.refresh();
            IManagedForm managedForm = editorPage.getManagedForm();
            if (managedForm == null) continue;
            managedForm.reflow(true);
        }
        if (this.form != null) {
            this.form.reflow(true);
        }
        if (!this.handleSaveRequired()) {
            this.fDirty = false;
            this.fireDirtyPropertyChangeEvent();
        }
    }

    protected boolean handleSaveRequired() {
        IPackagingVersion packagingVersion = (IPackagingVersion)this.packagingVersion;
        if (packagingVersion.isSaveRequired()) {
            this.setDirty(true);
            packagingVersion.setSaveRequired(false);
            return true;
        }
        return false;
    }

    protected boolean isIdChanged() {
        return this.idChanged;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
    }

    protected void performSave(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.VersionDefinition_Editor_Action_Save, 2);
        try {
            ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)this.getTeamRepository().getClientLibrary(ISystemDefinitionModelClient.class);
            ISystemDefinitionHandle systemDefinitionHandle = client.saveSystemDefinition(this.fSystemDefinition, monitor);
            ISystemDefinition systemDefinition = client.fetchSystemDefinitionComplete(systemDefinitionHandle, true, monitor);
            this.editorInput.initializeEditorInput(systemDefinition);
            this.fSystemDefinition = this.editorInput.getSystemDefinition();
            this.packagingVersion = (IVersionDefinition)this.fSystemDefinition;
            this.updatePageWorkingCopies((IVersionDefinition)this.fSystemDefinition);
            this.setWorkingCopyForHistory();
            if (this.fIsNewSystemDefinition || this.fNameChanged || this.idChanged) {
                AbstractEnterpriseExtensionsNode node = ((AbstractEditorInput)this.getEditorInput()).getNode();
                this.refreshSystemDefinitionNode(node);
            } else {
                AbstractEnterpriseExtensionsNode node = ((AbstractEditorInput)this.getEditorInput()).getNode();
                if (node instanceof VersionDefinitionsNodeEE) {
                    VersionDefinitionsNodeEE nodeEE = (VersionDefinitionsNodeEE)node;
                    nodeEE.refreshNode(systemDefinition);
                }
            }
            this.idChanged = false;
            this.fNameChanged = false;
            this.fIsNewSystemDefinition = false;
        }
        finally {
            monitor.done();
        }
    }

    protected void postSave(boolean saveSucceeded) {
        if (saveSucceeded) {
            this.setPartName();
            this.setDirty(false);
        }
    }

    public void refreshSystemDefinitionItem(IProgressMonitor monitor) {
        if (!this.fIsNewSystemDefinition) {
            this.fSystemDefinition = this.editorInput.getSystemDefinition();
            try {
                ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)this.getTeamRepository().getClientLibrary(ISystemDefinitionModelClient.class);
                ISystemDefinition systemDefinition = client.fetchSystemDefinitionComplete((ISystemDefinitionHandle)this.fSystemDefinition, true, monitor);
                this.editorInput.initializeEditorInput(systemDefinition);
                this.fSystemDefinition = this.editorInput.getSystemDefinition();
                this.packagingVersion = (IVersionDefinition)this.fSystemDefinition;
                this.updatePageWorkingCopies((IVersionDefinition)this.fSystemDefinition);
                this.setWorkingCopyForHistory();
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
        }
    }

    protected void removePageFmidItem(IPackagingFmidItem packagingFmidItem) {
        try {
            StringBuilder tabid = new StringBuilder();
            tabid.append(Messages.VersionDefinition_EditorFmidItemPage_TabId);
            tabid.append(".");
            tabid.append(packagingFmidItem.getFunctionId());
            IFormPage page = this.findPage(tabid.toString());
            if (page != null) {
                this.removePage(page.getIndex());
                this.setActivePage(0);
                this.setFocus();
            }
        }
        catch (Exception exception) {
            SmpeUIPlugin.log(exception);
        }
    }

    protected void removeUnsavedFmidItemPages() {
        Vector pages = new Vector(this.pages);
        ArrayList<String> pageIds = new ArrayList<String>();
        pageIds.add(Messages.VersionDefinition_EditorGeneralPage_TabId);
        pageIds.add(Messages.VersionDefinition_EditorHistoryPage_TabId);
        for (IFmidItemDefinition packagingFmidItem : this.packagingVersion.getFmidItems()) {
            StringBuilder tabid = new StringBuilder();
            tabid.append(Messages.VersionDefinition_EditorFmidItemPage_TabId);
            tabid.append(".");
            tabid.append(((IPackagingFmidItem)packagingFmidItem).getFunctionId());
            pageIds.add(tabid.toString());
        }
        for (IFormPage page : pages) {
            if (pageIds.contains(page.getId())) continue;
            if (page.getIndex() == this.getCurrentPage()) {
                this.setActivePage(0);
                this.setFocus();
            }
            this.removePage(page.getIndex());
        }
    }

    protected boolean setErrorMessage(Control control, String message) {
        if (control != null) {
            if (message != null) {
                this.addErrorMessage(control, message, control);
                return false;
            }
            this.removeErrorMessage(control, control);
            return true;
        }
        if (message != null) {
            this.addErrorMessage(this.fSystemDefinitionIdText, message, (Control)this.fSystemDefinitionIdText);
            return false;
        }
        return true;
    }

    protected void setIdChanged(boolean idChanged) {
        this.idChanged = idChanged;
    }

    protected void updatePageWorkingCopies(IVersionDefinition definition) {
        for (Object page : this.pages) {
            AbstractVersionDefinitionEditorPageItem editorPage = (AbstractVersionDefinitionEditorPageItem)((Object)page);
            editorPage.setWorkingCopy((ISystemDefinition)definition);
            if (!(page instanceof VersionDefinitionEditorPageFmidItem)) continue;
            VersionDefinitionEditorPageFmidItem fmidPage = (VersionDefinitionEditorPageFmidItem)((Object)page);
            fmidPage.setWorkingCopyFmidItem(definition.getFmidItem((IFmidItemDefinitionHandle)fmidPage.getWorkingCopyFmidItem()));
        }
    }

    protected boolean validate() {
        boolean ok;
        block9: {
            ok = true;
            IPackagingVersion packagingVersion = (IPackagingVersion)this.packagingVersion;
            if (!packagingVersion.hasName()) {
                ok = this.setErrorMessage((Control)this.fSystemDefinitionIdText, Messages.VersionDefinition_Validation_Required_Name);
            } else if (this.fNameChanged && !this.fSystemDefinition.getName().equals(this.editorInput.getOriginalDefinition().getName()) && this.editorInput.getPackagingVersionNames().contains(this.fSystemDefinition.getName())) {
                ok = this.setErrorMessage((Control)this.fSystemDefinitionIdText, Messages.VersionDefinition_Validation_Original_Name);
            } else {
                this.setErrorMessage((Control)this.fSystemDefinitionIdText, null);
            }
            for (Object page : this.pages) {
                if (((AbstractVersionDefinitionEditorPageItem)((Object)page)).validate()) continue;
                ok = false;
            }
            if (!ok) break block9;
            if (packagingVersion.hasBaseFunction()) {
                for (IFmidItemDefinition fmidItem : packagingVersion.getFmidItems()) {
                    if (!fmidItem.getFunction().sameItemId((IItemHandle)packagingVersion.getBaseFunction())) continue;
                    packagingVersion.setBaseFmid((IFmidItemDefinitionHandle)fmidItem);
                    break;
                }
            } else {
                for (IFmidItemDefinition fmidItem : packagingVersion.getFmidItems()) {
                    if (!fmidItem.isBase()) continue;
                    packagingVersion.setBaseFmid((IFmidItemDefinitionHandle)fmidItem);
                    break;
                }
            }
        }
        return ok;
    }
}

