/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.editors;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import com.ibm.team.enterprise.smpe.ui.domain.FunctionDefinitionsNodeEE;
import com.ibm.team.enterprise.smpe.ui.domain.VersionDefinitionsNodeEE;
import com.ibm.team.enterprise.smpe.ui.editors.AbstractFunctionDefinitionEditorPageItem;
import com.ibm.team.enterprise.smpe.ui.editors.AbstractSystemDefinitionEditorSmpe;
import com.ibm.team.enterprise.smpe.ui.editors.FunctionDefinitionEditorInput;
import com.ibm.team.enterprise.smpe.ui.editors.FunctionDefinitionEditorPageGeneral;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheFactory;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingFunction;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractEditorInput;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class FunctionDefinitionEditor
extends AbstractSystemDefinitionEditorSmpe {
    private boolean idChanged;
    private ScrolledForm form;
    private IFunctionDefinition packagingFunction;
    private FunctionDefinitionEditorInput editorInput;
    private FunctionDefinitionEditorPageGeneral pageGeneral;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.editorInput = (FunctionDefinitionEditorInput)input;
        this.fTeamRepository = this.editorInput.getTeamRepository();
        this.fIsNewSystemDefinition = this.editorInput.isNewSystemDefinition();
        this.fSystemDefinition = this.editorInput.getSystemDefinition();
        this.packagingFunction = (IFunctionDefinition)this.fSystemDefinition;
    }

    protected void addPages() {
        try {
            this.pageGeneral = new FunctionDefinitionEditorPageGeneral(Messages.FunctionDefinition_EditorGeneralPage_TabId, Messages.FunctionDefinition_EditorGeneralPage_Title);
            this.pageGeneral.initialize(this);
            this.pageGeneral.setWorkingCopy(this.fSystemDefinition);
            this.addPage((IFormPage)this.pageGeneral);
        }
        catch (PartInitException exception) {
            SmpeUIPlugin.log(exception);
        }
        this.addHistoryPage();
    }

    protected Image getHeaderTitleImage() {
        if (this.fSystemDefinition.isArchived()) {
            return SmpeUIPlugin.getImage("icons/obj16/function_arch_obj.gif");
        }
        return SmpeUIPlugin.getImage("icons/obj16/function_obj.gif");
    }

    protected String getHeaderTitleText() {
        return Messages.FunctionDefinition_Editor_Title;
    }

    protected String getHelpId() {
        return "com.ibm.team.enterprise.smpe.ui.editor_functiondefinitiongeneral";
    }

    protected IFunctionDefinition getOriginalDefinition() {
        return this.editorInput.getOriginalDefinition();
    }

    protected Set<String> getPackagingFunctionIds() {
        return this.editorInput.getPackagingFunctionIds();
    }

    protected Set<String> getPackagingFunctionNames() {
        return this.editorInput.getPackagingFunctionNames();
    }

    protected void handleRefreshComplete() {
        this.fSystemDefinitionIdText.removeModifyListener(this.fIdModifiedListener);
        this.fSystemDefinitionIdText.setText(this.fSystemDefinition.getName());
        this.fSystemDefinitionIdText.addModifyListener(this.fIdModifiedListener);
        this.setErrorMessage((Control)this.fSystemDefinitionIdText, null);
        this.updatePageWorkingCopies((IFunctionDefinition)this.fSystemDefinition);
        this.handleArchived();
        this.setPartName();
        for (Object page : this.pages) {
            AbstractFunctionDefinitionEditorPageItem editorPage = (AbstractFunctionDefinitionEditorPageItem)((Object)page);
            editorPage.refresh();
            IManagedForm managedForm = editorPage.getManagedForm();
            if (managedForm == null) continue;
            managedForm.reflow(true);
        }
        if (this.form != null) {
            this.form.reflow(true);
        }
        this.fDirty = false;
        this.fireDirtyPropertyChangeEvent();
    }

    protected boolean isIdChanged() {
        return this.idChanged;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
    }

    protected void performSave(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.FunctionDefinition_Editor_Action_Save, 2);
        try {
            ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)this.getTeamRepository().getClientLibrary(ISystemDefinitionModelClient.class);
            ISystemDefinitionHandle systemDefinitionHandle = client.saveSystemDefinition(this.fSystemDefinition, monitor);
            ISystemDefinition systemDefinition = client.fetchSystemDefinitionComplete(systemDefinitionHandle, true, monitor);
            this.editorInput.initializeEditorInput(systemDefinition);
            this.fSystemDefinition = this.editorInput.getSystemDefinition();
            this.packagingFunction = (IFunctionDefinition)this.fSystemDefinition;
            this.updatePageWorkingCopies((IFunctionDefinition)this.fSystemDefinition);
            this.setWorkingCopyForHistory();
            if (this.fIsNewSystemDefinition || this.fNameChanged || this.idChanged) {
                AbstractEnterpriseExtensionsNode node = ((AbstractEditorInput)this.getEditorInput()).getNode();
                if (node instanceof VersionDefinitionsNodeEE) {
                    this.refreshSystemDefinitionNode(((VersionDefinitionsNodeEE)node).getFunctionsNode());
                } else {
                    this.refreshSystemDefinitionNode(node);
                }
                List<IFunctionDefinition> oldPackagingFunctions = this.editorInput.getPackagingFunctions();
                ArrayList<IFunctionDefinition> newPackagingFunctions = new ArrayList<IFunctionDefinition>(oldPackagingFunctions);
                for (IFunctionDefinition packagingFunction : oldPackagingFunctions) {
                    if (!this.fSystemDefinition.sameItemId((IItemHandle)packagingFunction)) continue;
                    newPackagingFunctions.remove(packagingFunction);
                    break;
                }
                newPackagingFunctions.add((IFunctionDefinition)((IPackagingFunction)this.fSystemDefinition));
                this.editorInput.setPackagingFunctions(newPackagingFunctions);
                if (ItemCacheFactory.containsFunction((ITeamRepository)this.getTeamRepository(), (IProjectAreaHandle)this.fSystemDefinition.getProjectArea())) {
                    ItemCacheFactory.deleteFunction((ITeamRepository)this.getTeamRepository(), (IProjectAreaHandle)this.fSystemDefinition.getProjectArea());
                }
            } else {
                AbstractEnterpriseExtensionsNode node = ((AbstractEditorInput)this.getEditorInput()).getNode();
                if (node instanceof FunctionDefinitionsNodeEE) {
                    FunctionDefinitionsNodeEE nodeEE = (FunctionDefinitionsNodeEE)node;
                    nodeEE.refreshNode(systemDefinition);
                }
            }
            this.idChanged = false;
            this.fNameChanged = false;
            this.fIsNewSystemDefinition = false;
        }
        finally {
            monitor.done();
        }
    }

    protected void postSave(boolean saveSucceeded) {
        if (saveSucceeded) {
            this.setPartName();
            this.setDirty(false);
        }
    }

    public void refreshSystemDefinitionItem(IProgressMonitor monitor) {
        if (!this.fIsNewSystemDefinition) {
            this.fSystemDefinition = this.editorInput.getSystemDefinition();
            try {
                ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)this.getTeamRepository().getClientLibrary(ISystemDefinitionModelClient.class);
                ISystemDefinition systemDefinition = client.fetchSystemDefinitionComplete((ISystemDefinitionHandle)this.fSystemDefinition, true, monitor);
                this.editorInput.initializeEditorInput(systemDefinition);
                this.fSystemDefinition = this.editorInput.getSystemDefinition();
                this.packagingFunction = (IFunctionDefinition)this.fSystemDefinition;
                this.updatePageWorkingCopies((IFunctionDefinition)this.fSystemDefinition);
                this.setWorkingCopyForHistory();
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean setErrorMessage(Control control, String message) {
        if (control != null) {
            if (message != null) {
                this.addErrorMessage(control, message, control);
                return false;
            }
            this.removeErrorMessage(control, control);
            return true;
        }
        if (message != null) {
            this.addErrorMessage(this.fSystemDefinitionIdText, message, (Control)this.fSystemDefinitionIdText);
            return false;
        }
        return true;
    }

    protected void setIdChanged(boolean idChanged) {
        this.idChanged = idChanged;
    }

    protected void updatePageWorkingCopies(IFunctionDefinition definition) {
        for (Object page : this.pages) {
            AbstractFunctionDefinitionEditorPageItem editorPage = (AbstractFunctionDefinitionEditorPageItem)((Object)page);
            editorPage.setWorkingCopy((ISystemDefinition)definition);
        }
    }

    protected boolean validate() {
        boolean ok = true;
        IPackagingFunction packagingFunction = (IPackagingFunction)this.packagingFunction;
        if (!packagingFunction.hasName()) {
            ok = this.setErrorMessage((Control)this.fSystemDefinitionIdText, Messages.FunctionDefinition_Validation_Required_Name);
        } else if (this.fNameChanged && !this.fSystemDefinition.getName().equals(this.editorInput.getOriginalDefinition().getName()) && this.editorInput.getPackagingFunctionNames().contains(this.fSystemDefinition.getName())) {
            ok = this.setErrorMessage((Control)this.fSystemDefinitionIdText, Messages.FunctionDefinition_Validation_Original_Name);
        } else {
            this.setErrorMessage((Control)this.fSystemDefinitionIdText, null);
        }
        for (Object page : this.pages) {
            if (((AbstractFunctionDefinitionEditorPageItem)((Object)page)).validate()) continue;
            ok = false;
        }
        return ok;
    }
}

