/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.editors;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.builddefinition.BuildConfigurationRegistry;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.extensions.common.IFetchItem;
import com.ibm.team.build.extensions.common.ItemArrayList;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.build.internal.common.helper.BuildEngineHelper;
import com.ibm.team.build.internal.common.model.query.BaseBuildDefinitionQueryModel;
import com.ibm.team.build.internal.ui.actions.EditBuildDefinitionActionDelegate;
import com.ibm.team.build.internal.ui.actions.EditBuildEngineActionDelegate;
import com.ibm.team.build.internal.ui.dialogs.AddBuildEnginesDialog;
import com.ibm.team.build.internal.ui.editors.BuildItemEditor;
import com.ibm.team.build.internal.ui.editors.BuildItemEditorJob;
import com.ibm.team.build.internal.ui.editors.builddefinition.BasicConfigurationElementEditor;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditor;
import com.ibm.team.enterprise.common.ui.elements.DialogButtonItem;
import com.ibm.team.enterprise.common.ui.util.GridTools;
import com.ibm.team.enterprise.smpe.common.IOrchestratorAction;
import com.ibm.team.enterprise.smpe.common.IOrchestratorBuild;
import com.ibm.team.enterprise.smpe.common.build.BuildOrchestratorEngineConfigElementFactory;
import com.ibm.team.enterprise.smpe.internal.common.OrchestratorAction;
import com.ibm.team.enterprise.smpe.internal.common.OrchestratorBuild;
import com.ibm.team.enterprise.smpe.ui.dialogs.OrchestratedActionDialog;
import com.ibm.team.enterprise.smpe.ui.dialogs.OrchestratedBuildDialog;
import com.ibm.team.enterprise.smpe.ui.elements.OrchestratorActionLabelProvider;
import com.ibm.team.enterprise.smpe.ui.elements.OrchestratorBuildPaintProvider;
import com.ibm.team.enterprise.smpe.ui.elements.OrchestratorEngineComparator;
import com.ibm.team.enterprise.smpe.ui.elements.OrchestratorEnginePaintProvider;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.smpe.ui.utils.EditorItemCache;
import com.ibm.team.enterprise.smpe.ui.utils.EditorItemFetch;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheFactory;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.enterprise.systemdefinition.ui.util.ListContentProvider;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class BuildOrchestratorConfigurationEditor
extends BasicConfigurationElementEditor
implements EventHandler {
    private static final int actionTableItemMinimum = 4;
    private static final int buildTableItemMinimum = 18;
    private static final int engineTableItemMinimum = 14;
    private final IDebugger dbg;
    private final String simpleName;
    private BuildDefinitionEditor buildDefinitionEditor;
    private Composite parent;
    private FormToolkit toolkit;
    private IProcessArea processArea;
    private IProjectAreaHandle projectAreaHandle;
    private ITeamRepository repository;
    private ISystemDefinitionCache systemDefinitionCache;
    private boolean disposed;
    private Map<String, IBuildEngine> buildEngineIds;
    private Map<String, IBuildEngine> buildEngines;
    protected Section detailsSection;
    protected Section enginesSection;
    protected Section generalSection;
    protected Button buildAddButton;
    protected Button buildDownButton;
    protected Button buildEditButton;
    protected Button buildRemoveButton;
    protected Button buildUpButton;
    protected Table buildTable;
    protected TableViewer buildTableViewer;
    protected Button engineAddButton;
    protected Button engineRemoveButton;
    protected Table engineTable;
    protected TableViewer engineTableViewer;
    protected final DialogButtonItem enabledItem = new DialogButtonItem();
    protected Button actionAddButton;
    protected Button actionDownButton;
    protected Button actionEditButton;
    protected Button actionRemoveButton;
    protected Button actionUpButton;
    protected Table actionTable;
    protected TableViewer actionTableViewer;
    protected List<IOrchestratorAction> orchestratorActions = new ArrayList<IOrchestratorAction>();
    protected List<IOrchestratorBuild> orchestratorBuilds = new ArrayList<IOrchestratorBuild>();
    protected List<IBuildEngine> orchestratorEngines = new ItemArrayList();
    protected Map<String, IBuildEngine> updatedOrchestratorEngines = new HashMap<String, IBuildEngine>();
    protected Map<String, IBuildDefinition> buildDefinitionIds = new HashMap<String, IBuildDefinition>();
    protected Map<String, IBuildDefinition> buildDefinitions = new HashMap<String, IBuildDefinition>();

    public BuildOrchestratorConfigurationEditor(String elementId, String title) {
        super(elementId, title);
        this.dbg = new Debugger(((Object)((Object)this)).getClass());
        this.simpleName = ((Object)((Object)this)).getClass().getSimpleName();
        if (this.dbg.isDebug()) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
    }

    public final void initialize(BuildDefinitionEditor editor) {
        super.initialize(editor);
        this.buildDefinitionEditor = editor;
        this.repository = this.buildDefinitionEditor.getTeamRepository();
        this.processArea = this.buildDefinitionEditor.getProcessArea();
        this.projectAreaHandle = this.processArea.getProjectArea();
        this.systemDefinitionCache = new EditorItemCache(this.repository, this.projectAreaHandle, this.dbg);
        this.buildEngineIds = this.buildDefinitionEditor.getBuildEngines();
        this.buildEngines = new HashMap<String, IBuildEngine>();
        if (Verification.isNonEmpty(this.buildEngineIds)) {
            for (IBuildEngine engine : this.buildEngineIds.values()) {
                this.buildEngines.put(engine.getItemId().getUuidValue(), engine);
            }
        }
        if (Verification.isNonEmpty(this.buildEngineIds)) {
            try {
                ItemCacheFactory.clearBuildEngine((ITeamRepository)this.repository, (IProcessAreaHandle)this.processArea);
                ItemCacheFactory.addBuildEngine((ITeamRepository)this.repository, (IProcessAreaHandle)this.processArea, new ArrayList<IBuildEngine>(this.buildEngineIds.values()));
            }
            catch (TeamRepositoryException engine) {
                // empty catch block
            }
        }
        IEventBroker service = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
        service.subscribe("com/ibm/team/build/internal/ui/editors/builddefinition/BuildDefinitionEditor/AsyncBuildEngineFetchSuccessful", (EventHandler)this);
        this.fetchBuildDefinitions();
    }

    public final void createContent(Composite parent, FormToolkit toolkit) {
        this.parent = parent;
        this.toolkit = toolkit;
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 15;
        parent.setLayout((Layout)layout);
        this.orchestratorActions = this.getActionItems();
        this.orchestratorBuilds = this.getBuildItems();
        this.orchestratorEngines = this.getEngineItems();
        this.createContentGeneralSection(parent);
        this.createContentEnginesSection(parent);
        this.createContentDetailsSection(parent);
    }

    private final void createContentGeneralSection(Composite parent) {
        this.generalSection = super.createSection(parent, Messages.BuildOrchestratorConfigurationEditor_GeneralSection_Title, Messages.BuildOrchestratorConfigurationEditor_GeneralSection_Description, false, 3);
        Composite composite = (Composite)this.generalSection.getClient();
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(5, 5, 5, 5).spacing(5, 5).applyTo(composite);
        this.enabledItem.create(composite, Messages.BuildOrchestratorConfigurationEditor_GeneralSection_Label_Enabled, Messages.BuildOrchestratorConfigurationEditor_GeneralSection_Tooltip_Enabled, (Object)Boolean.parseBoolean(this.getConfigurationPropertyValue("team.enterprise.smpe.build.orchestrator.enabled")), Messages.BuildOrchestratorConfigurationEditor_GeneralSection_HelpLbl_Enabled, Messages.BuildOrchestratorConfigurationEditor_GeneralSection_HelpTxt_Enabled);
        this.enabledItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrchestratorConfigurationEditor.this.setConfigurationPropertyValue("team.enterprise.smpe.build.orchestrator.enabled", Boolean.toString(BuildOrchestratorConfigurationEditor.this.enabledItem.item.getSelection()));
                BuildOrchestratorConfigurationEditor.this.removeMessage(BuildOrchestratorConfigurationEditor.this.enabledItem.item, (Control)BuildOrchestratorConfigurationEditor.this.enabledItem.item);
                BuildOrchestratorConfigurationEditor.this.setDirty(true);
                BuildOrchestratorConfigurationEditor.this.validate();
            }
        });
        GridTools.createPlaceholder((Composite)composite);
        GridTools.createSpacer((FormToolkit)this.toolkit, (Composite)composite, (int)2, (int)3);
        Composite tableComposite = this.toolkit.createComposite(composite);
        GridData tableGrid = new GridData(4, 4, true, true);
        this.actionTable = this.toolkit.createTable(tableComposite, 66304);
        this.actionTable.setHeaderVisible(true);
        this.actionTable.setLinesVisible(true);
        this.toolkit.setBorderStyle(2048);
        tableGrid.widthHint = 1;
        tableGrid.heightHint = this.actionTable.getItemHeight() * 4;
        tableGrid.horizontalSpan = 2;
        tableComposite.setLayoutData((Object)tableGrid);
        tableComposite.setLayout((Layout)new FillLayout());
        TableColumnLayout tableLayout = new TableColumnLayout();
        TableColumn tableColumn = new TableColumn(this.actionTable, 0);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(20, true));
        tableColumn.setText(Messages.BuildOrchestratorConfigurationEditor_GeneralSection_Table_Column_Action);
        tableColumn = new TableColumn(this.actionTable, 0);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(40, true));
        tableColumn.setText(Messages.BuildOrchestratorConfigurationEditor_GeneralSection_Table_Column_Argument1);
        tableColumn = new TableColumn(this.actionTable, 0);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(40, true));
        tableColumn.setText(Messages.BuildOrchestratorConfigurationEditor_GeneralSection_Table_Column_Argument2);
        tableComposite.setLayout((Layout)tableLayout);
        this.actionTableViewer = new TableViewer(this.actionTable);
        this.actionTableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.actionTableViewer.setLabelProvider((IBaseLabelProvider)new OrchestratorActionLabelProvider());
        this.actionTableViewer.setInput(this.orchestratorActions);
        this.actionTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BuildOrchestratorConfigurationEditor.this.updateActionEnablement();
            }
        });
        this.actionTableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (BuildOrchestratorConfigurationEditor.this.actionEditButton.isEnabled()) {
                    BuildOrchestratorConfigurationEditor.this.editAction();
                }
            }
        });
        Composite buttonComposite = this.toolkit.createComposite(composite);
        buttonComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.actionAddButton = this.toolkit.createButton(buttonComposite, DialogButtonItem.AddLabel, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.actionAddButton);
        this.actionAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrchestratorConfigurationEditor.this.addAction();
            }
        });
        this.actionEditButton = this.toolkit.createButton(buttonComposite, DialogButtonItem.EditLabel, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.actionEditButton);
        this.actionEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrchestratorConfigurationEditor.this.editAction();
            }
        });
        this.actionRemoveButton = this.toolkit.createButton(buttonComposite, DialogButtonItem.RemoveLabel, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.actionRemoveButton);
        this.actionRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrchestratorConfigurationEditor.this.removeAction();
            }
        });
        this.actionUpButton = this.toolkit.createButton(buttonComposite, DialogButtonItem.UpLabel, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.actionUpButton);
        this.actionUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrchestratorConfigurationEditor.this.moveUpAction();
            }
        });
        this.actionDownButton = this.toolkit.createButton(buttonComposite, DialogButtonItem.DownLabel, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.actionDownButton);
        this.actionDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrchestratorConfigurationEditor.this.moveDownAction();
            }
        });
        this.updateActionEnablement();
    }

    private final void addAction() {
        IOrchestratorAction action;
        OrchestratedActionDialog dialog = new OrchestratedActionDialog(this.actionAddButton.getShell(), this.repository, this.projectAreaHandle, this.systemDefinitionCache, (IOrchestratorAction)new OrchestratorAction(), Messages.OrchestratedAction_Dialog_Title_Add);
        if (dialog.open() == 0 && (action = dialog.getDialogObject()) != null) {
            action.setFetch(true);
            this.orchestratorActions.add(action);
            this.actionTableViewer.setInput(this.orchestratorActions);
            this.actionTableViewer.refresh();
            this.updateActionEnablement();
            this.setActionItems(this.orchestratorActions);
            this.setDirty(true);
            this.validate();
        }
    }

    private final void editAction() {
        IOrchestratorAction updated;
        IStructuredSelection selection = (IStructuredSelection)this.actionTableViewer.getSelection();
        IOrchestratorAction original = (IOrchestratorAction)selection.getFirstElement();
        OrchestratedActionDialog dialog = new OrchestratedActionDialog(this.actionAddButton.getShell(), this.repository, this.projectAreaHandle, this.systemDefinitionCache, original, Messages.OrchestratedAction_Dialog_Title_Edit);
        if (dialog.open() == 0 && (updated = dialog.getDialogObject()) != null) {
            original.update(updated);
            original.setFetch(true);
            this.actionTableViewer.setInput(this.orchestratorActions);
            this.actionTableViewer.refresh();
            this.updateActionEnablement();
            this.setActionItems(this.orchestratorActions);
            this.setDirty(true);
            this.validate();
        }
    }

    private final void moveDownAction() {
        IStructuredSelection selection = (IStructuredSelection)this.actionTableViewer.getSelection();
        IOrchestratorAction action = (IOrchestratorAction)selection.getFirstElement();
        int index = this.orchestratorActions.indexOf(action);
        this.orchestratorActions.remove(action);
        this.orchestratorActions.add(index + 1, action);
        this.actionTableViewer.setInput(this.orchestratorActions);
        this.actionTableViewer.refresh();
        this.actionTableViewer.setSelection((ISelection)selection);
        this.updateActionEnablement();
        this.setActionItems(this.orchestratorActions);
        this.setDirty(true);
        this.validate();
    }

    private final void moveUpAction() {
        IStructuredSelection selection = (IStructuredSelection)this.actionTableViewer.getSelection();
        IOrchestratorAction action = (IOrchestratorAction)selection.getFirstElement();
        int index = this.orchestratorActions.indexOf(action);
        this.orchestratorActions.remove(action);
        this.orchestratorActions.add(index - 1, action);
        this.actionTableViewer.setInput(this.orchestratorActions);
        this.actionTableViewer.refresh();
        this.actionTableViewer.setSelection((ISelection)selection);
        this.updateActionEnablement();
        this.setActionItems(this.orchestratorActions);
        this.setDirty(true);
        this.validate();
    }

    private final void removeAction() {
        IStructuredSelection selection = (IStructuredSelection)this.actionTableViewer.getSelection();
        IOrchestratorAction action = (IOrchestratorAction)selection.getFirstElement();
        this.orchestratorActions.remove(action);
        this.actionTableViewer.remove((Object)action);
        this.setActionItems(this.orchestratorActions);
        this.setDirty(true);
        this.validate();
    }

    private final void updateActionEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.actionTableViewer.getSelection();
        boolean haveData = !this.orchestratorActions.isEmpty();
        this.actionAddButton.setEnabled(true);
        this.actionEditButton.setEnabled(haveData && selection.size() == 1);
        this.actionRemoveButton.setEnabled(haveData && selection.size() == 1 && !selection.isEmpty());
        if (selection.isEmpty()) {
            this.actionUpButton.setEnabled(false);
            this.actionDownButton.setEnabled(false);
        } else {
            Object first = selection.getFirstElement();
            int size = this.orchestratorActions.size();
            int index = this.orchestratorActions.indexOf(first);
            if (size == 0 || index == 0) {
                this.actionUpButton.setEnabled(false);
            } else {
                this.actionUpButton.setEnabled(true);
            }
            if (size == 0 || index == size - 1) {
                this.actionDownButton.setEnabled(false);
            } else {
                this.actionDownButton.setEnabled(true);
            }
        }
    }

    private final void createContentEnginesSection(Composite parent) {
        this.enginesSection = super.createSection(parent, Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Title, Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Description, false, 2);
        Composite composite = (Composite)this.enginesSection.getClient();
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(5, 5, 5, 5).spacing(7, 5).applyTo(composite);
        Composite tableComposite = this.toolkit.createComposite(composite);
        GridData tableGrid = new GridData(4, 4, true, true);
        this.engineTable = this.toolkit.createTable(tableComposite, 66306);
        this.engineTable.setHeaderVisible(true);
        this.engineTable.setLinesVisible(true);
        this.toolkit.setBorderStyle(2048);
        tableGrid.widthHint = 1;
        tableGrid.heightHint = this.engineTable.getItemHeight() * 14;
        tableComposite.setLayoutData((Object)tableGrid);
        tableComposite.setLayout((Layout)new FillLayout());
        TableColumnLayout tableLayout = new TableColumnLayout();
        TableColumn tableColumn = new TableColumn(this.engineTable, 0);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(58, true));
        tableColumn.setText(Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Table_Column_Engine);
        tableColumn = new TableColumn(this.engineTable, 0x1000000);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(14, true));
        tableColumn.setText(Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Table_Column_EngineType);
        tableColumn = new TableColumn(this.engineTable, 0x1000000);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(14, true));
        tableColumn.setText(Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Table_Column_EngineTypeG);
        tableColumn = new TableColumn(this.engineTable, 0x1000000);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(14, true));
        tableColumn.setText(Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Table_Column_EngineTypeD);
        tableComposite.setLayout((Layout)tableLayout);
        this.engineTableViewer = new TableViewer(this.engineTable);
        this.engineTableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.engineTableViewer.setLabelProvider((IBaseLabelProvider)new OrchestratorEnginePaintProvider());
        this.engineTableViewer.setComparator((ViewerComparator)new OrchestratorEngineComparator());
        this.engineTableViewer.setInput(this.orchestratorEngines);
        this.engineTableViewer.addOpenListener(this.getEngineOpenListener());
        this.engineTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BuildOrchestratorConfigurationEditor.this.updateEngineEnablement();
            }
        });
        Composite buttonComposite = this.toolkit.createComposite(composite);
        buttonComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.engineAddButton = this.toolkit.createButton(buttonComposite, DialogButtonItem.AddLabel, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.engineAddButton);
        this.engineAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrchestratorConfigurationEditor.this.addEngines();
            }
        });
        this.engineRemoveButton = this.toolkit.createButton(buttonComposite, DialogButtonItem.RemoveLabel, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.engineRemoveButton);
        this.engineRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrchestratorConfigurationEditor.this.removeEngines();
            }
        });
        this.updateEngineEnablement();
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(this.getEngineMenuListener());
        this.engineTableViewer.getTable().setMenu(menuManager.createContextMenu((Control)this.engineTableViewer.getTable()));
    }

    private final void addEngines() {
        if (this.buildEngineIds.size() <= 0) {
            MessageDialog.openWarning((Shell)this.parent.getShell(), (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_NoEngines_Title, (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_NoEngines_Message);
        } else if (this.buildEngineIds.size() == this.orchestratorEngines.size()) {
            MessageDialog.openWarning((Shell)this.parent.getShell(), (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_AllChosen_Title, (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_AllChosen_Message);
        } else {
            AddBuildEnginesDialog dialog = new AddBuildEnginesDialog(this.parent.getShell(), this.buildDefinitionEditor.getEngineIdToProject(), this.getEngineIds(this.orchestratorEngines), this.buildDefinitionEditor.getProjectAreaName(), this.buildEngineIds);
            if (dialog.open() == 0) {
                for (String engineId : dialog.getChangedBuildEngineIds()) {
                    if (this.orchestratorEngines.contains(this.buildEngineIds.get(engineId))) {
                        this.orchestratorEngines.remove(this.buildEngineIds.get(engineId));
                        continue;
                    }
                    this.orchestratorEngines.add(this.buildEngineIds.get(engineId));
                }
                this.engineTableViewer.setInput(this.orchestratorEngines);
                this.engineTableViewer.refresh();
                this.updateEngineEnablement();
                this.setEngineItems(this.orchestratorEngines);
                this.setDirty(true);
                this.validate();
            }
        }
    }

    private final void removeEngines() {
        IStructuredSelection selection = (IStructuredSelection)this.engineTableViewer.getSelection();
        if (selection != null && selection.size() > 0) {
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object engine = objectArray[n2];
                this.orchestratorEngines.remove(engine);
                ++n2;
            }
        }
        this.engineTableViewer.setInput(this.orchestratorEngines);
        this.engineTableViewer.refresh();
        this.updateEngineEnablement();
        this.setEngineItems(this.orchestratorEngines);
        this.setDirty(true);
        this.validate();
    }

    private final void updateEngineEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.engineTableViewer.getSelection();
        boolean haveData = this.haveEngineItems();
        this.engineAddButton.setEnabled(this.haveEngineData());
        this.engineRemoveButton.setEnabled(haveData && !selection.isEmpty());
    }

    private final void createContentDetailsSection(Composite parent) {
        this.detailsSection = super.createSection(parent, Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Title, Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Description, false, 2);
        this.detailsSection.setLayoutData((Object)new TableWrapData(256, 256, 1, 2));
        Composite composite = (Composite)this.detailsSection.getClient();
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(5, 5, 5, 5).spacing(7, 5).applyTo(composite);
        Composite tableComposite = this.toolkit.createComposite(composite);
        GridData tableGrid = new GridData(4, 4, true, true);
        this.buildTable = this.toolkit.createTable(tableComposite, 66304);
        this.buildTable.setHeaderVisible(true);
        this.buildTable.setLinesVisible(true);
        this.toolkit.setBorderStyle(2048);
        tableGrid.widthHint = 1;
        tableGrid.heightHint = this.buildTable.getItemHeight() * 18;
        tableComposite.setLayoutData((Object)tableGrid);
        tableComposite.setLayout((Layout)new FillLayout());
        TableColumnLayout tableLayout = new TableColumnLayout();
        TableColumn tableColumn = new TableColumn(this.buildTable, 0);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(24, true));
        tableColumn.setText(Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Table_Column_Build);
        tableColumn = new TableColumn(this.buildTable, 0);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(23, true));
        tableColumn.setText(Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Table_Column_Engines);
        tableColumn = new TableColumn(this.buildTable, 0x1000000);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(6, true));
        tableColumn.setText(Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Table_Column_Enabled);
        tableColumn = new TableColumn(this.buildTable, 0x1000000);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(6, true));
        tableColumn.setText(Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Table_Column_Primary);
        tableColumn = new TableColumn(this.buildTable, 0x1000000);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(6, true));
        tableColumn.setText(Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Table_Column_Secondary);
        tableColumn = new TableColumn(this.buildTable, 0x1000000);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(6, true));
        tableColumn.setText(Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Table_Column_Dependent);
        tableColumn = new TableColumn(this.buildTable, 0x1000000);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(6, true));
        tableColumn.setText(Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Table_Column_Housekeeping);
        tableColumn = new TableColumn(this.buildTable, 0);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(23, true));
        tableColumn.setText(Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Table_Column_DependsOn);
        tableComposite.setLayout((Layout)tableLayout);
        this.buildTableViewer = new TableViewer(this.buildTable);
        this.buildTableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.buildTableViewer.setLabelProvider((IBaseLabelProvider)new OrchestratorBuildPaintProvider());
        this.buildTableViewer.setInput(this.orchestratorBuilds);
        this.buildTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BuildOrchestratorConfigurationEditor.this.updateBuildEnablement();
            }
        });
        this.buildTableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (BuildOrchestratorConfigurationEditor.this.buildEditButton.isEnabled()) {
                    BuildOrchestratorConfigurationEditor.this.editBuild();
                }
            }
        });
        Composite buttonComposite = this.toolkit.createComposite(composite);
        buttonComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.buildAddButton = this.toolkit.createButton(buttonComposite, DialogButtonItem.AddLabel, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.buildAddButton);
        this.buildAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrchestratorConfigurationEditor.this.addBuild();
            }
        });
        this.buildEditButton = this.toolkit.createButton(buttonComposite, DialogButtonItem.EditLabel, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.buildEditButton);
        this.buildEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrchestratorConfigurationEditor.this.editBuild();
            }
        });
        this.buildRemoveButton = this.toolkit.createButton(buttonComposite, DialogButtonItem.RemoveLabel, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.buildRemoveButton);
        this.buildRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrchestratorConfigurationEditor.this.removeBuild();
            }
        });
        this.buildUpButton = this.toolkit.createButton(buttonComposite, DialogButtonItem.UpLabel, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.buildUpButton);
        this.buildUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrchestratorConfigurationEditor.this.moveUpBuild();
            }
        });
        this.buildDownButton = this.toolkit.createButton(buttonComposite, DialogButtonItem.DownLabel, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.buildDownButton);
        this.buildDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrchestratorConfigurationEditor.this.moveDownBuild();
            }
        });
        this.updateBuildEnablement();
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(this.getBuildMenuListener());
        this.buildTableViewer.getTable().setMenu(menuManager.createContextMenu((Control)this.buildTableViewer.getTable()));
    }

    private final void addBuild() {
        IOrchestratorBuild orchestratorBuild;
        OrchestratedBuildDialog dialog = new OrchestratedBuildDialog(this.buildAddButton.getShell(), this.buildDefinitionIds, this.buildEngineIds, this.orchestratorBuilds, (IOrchestratorBuild)new OrchestratorBuild(), Messages.OrchestratedBuild_Dialog_Title_Add);
        if (dialog.open() == 0 && (orchestratorBuild = dialog.getDialogObject()) != null) {
            this.orchestratorBuilds.add(orchestratorBuild);
            this.buildTableViewer.setInput(this.orchestratorBuilds);
            this.buildTableViewer.refresh();
            this.updateBuildEnablement();
            this.setBuildItems(this.orchestratorBuilds);
            this.setDirty(true);
            this.validate();
        }
    }

    private final void editBuild() {
        IOrchestratorBuild updated;
        IStructuredSelection selection = (IStructuredSelection)this.buildTableViewer.getSelection();
        IOrchestratorBuild original = (IOrchestratorBuild)selection.getFirstElement();
        OrchestratedBuildDialog dialog = new OrchestratedBuildDialog(this.buildEditButton.getShell(), this.buildDefinitionIds, this.buildEngineIds, this.orchestratorBuilds, original, Messages.OrchestratedBuild_Dialog_Title_Edit);
        if (dialog.open() == 0 && (updated = dialog.getDialogObject()) != null) {
            original.update(updated);
            this.buildTableViewer.setInput(this.orchestratorBuilds);
            this.buildTableViewer.refresh();
            this.updateBuildEnablement();
            this.setBuildItems(this.orchestratorBuilds);
            this.setDirty(true);
            this.validate();
        }
    }

    private final void moveDownBuild() {
        IStructuredSelection selection = (IStructuredSelection)this.buildTableViewer.getSelection();
        IOrchestratorBuild build = (IOrchestratorBuild)selection.getFirstElement();
        int index = this.orchestratorBuilds.indexOf(build);
        this.orchestratorBuilds.remove(build);
        this.orchestratorBuilds.add(index + 1, build);
        this.buildTableViewer.setInput(this.orchestratorBuilds);
        this.buildTableViewer.refresh();
        this.buildTableViewer.setSelection((ISelection)selection);
        this.updateBuildEnablement();
        this.setBuildItems(this.orchestratorBuilds);
        this.setDirty(true);
        this.validate();
    }

    private final void moveUpBuild() {
        IStructuredSelection selection = (IStructuredSelection)this.buildTableViewer.getSelection();
        IOrchestratorBuild build = (IOrchestratorBuild)selection.getFirstElement();
        int index = this.orchestratorBuilds.indexOf(build);
        this.orchestratorBuilds.remove(build);
        this.orchestratorBuilds.add(index - 1, build);
        this.buildTableViewer.setInput(this.orchestratorBuilds);
        this.buildTableViewer.refresh();
        this.buildTableViewer.setSelection((ISelection)selection);
        this.updateBuildEnablement();
        this.setBuildItems(this.orchestratorBuilds);
        this.setDirty(true);
        this.validate();
    }

    private final void removeBuild() {
        IStructuredSelection selection = (IStructuredSelection)this.buildTableViewer.getSelection();
        IOrchestratorBuild build = (IOrchestratorBuild)selection.getFirstElement();
        if (!this.isDependsOn(build)) {
            this.orchestratorBuilds.remove(build);
            this.buildTableViewer.remove((Object)build);
            this.setBuildItems(this.orchestratorBuilds);
            this.setDirty(true);
            this.validate();
        } else {
            MessageDialog.openWarning((Shell)this.parent.getShell(), (String)Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Error_DependsOn_Title, (String)Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Error_DependsOn_Message);
        }
    }

    private final void updateBuildEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.buildTableViewer.getSelection();
        boolean haveData = this.haveBuildItems();
        this.buildAddButton.setEnabled(this.haveBuildData());
        this.buildEditButton.setEnabled(haveData && selection.size() == 1);
        this.buildRemoveButton.setEnabled(haveData && selection.size() == 1 && !selection.isEmpty());
        if (selection.isEmpty()) {
            this.buildUpButton.setEnabled(false);
            this.buildDownButton.setEnabled(false);
        } else {
            Object first = selection.getFirstElement();
            int size = this.orchestratorBuilds.size();
            int index = this.orchestratorBuilds.indexOf(first);
            if (size == 0 || index == 0) {
                this.buildUpButton.setEnabled(false);
            } else {
                this.buildUpButton.setEnabled(true);
            }
            if (size == 0 || index == size - 1) {
                this.buildDownButton.setEnabled(false);
            } else {
                this.buildDownButton.setEnabled(true);
            }
        }
    }

    public final void dispose() {
        this.disposed = true;
        IEventBroker service = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
        service.unsubscribe((EventHandler)this);
    }

    private final void fetchActionArguments(IFetchItem fetchItem) {
        BuildItemEditorJob job = this.getFetchActionArgumentJob(fetchItem);
        job.setWarnOnError();
        job.schedule();
    }

    private final void fetchBuildDefinitions() {
        BuildItemEditorJob job = this.getFetchBuildDefinitionsJob();
        job.setWarnOnError();
        job.schedule();
    }

    private final JSONArray getActionItemArray(List<IOrchestratorAction> actions) {
        JSONArray jsonArray = new JSONArray();
        for (IOrchestratorAction action : actions) {
            jsonArray.add((Object)action.toJson());
        }
        return jsonArray;
    }

    private final List<IOrchestratorAction> getActionItems() {
        IConfigurationProperty property;
        ArrayList<IOrchestratorAction> result = new ArrayList<IOrchestratorAction>();
        IBuildConfigurationElement element = this.fWorkingCopy.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorConfigurationElement");
        if (element != null && (property = element.getConfigurationProperty("team.enterprise.smpe.build.orchestrator.actions")) != null && Verification.isNonBlank((String)property.getValue())) {
            JSONArray jsonArray = null;
            EditorItemFetch fetchItem = new EditorItemFetch(this.repository, this.projectAreaHandle, null, Messages.BuildOrchestratorConfigurationEditor_Initialization_Error_Fetch_Action, false);
            try {
                jsonArray = JSONArray.parse((Reader)new StringReader(property.getValue()));
            }
            catch (IOException e) {
                MessageDialog.openWarning((Shell)this.parent.getShell(), (String)Messages.BuildOrchestratorConfigurationEditor_Initialization_Error, (String)Messages.BuildOrchestratorConfigurationEditor_Initialization_Error_Parse_Action);
                return Collections.emptyList();
            }
            for (Object jsonObject : jsonArray) {
                result.add((IOrchestratorAction)new OrchestratorAction((JSONObject)jsonObject, (IFetchItem)fetchItem));
            }
            if (fetchItem.hasItemsToFetch()) {
                this.fetchActionArguments(fetchItem);
            }
        }
        return result;
    }

    private final List<IBuildDefinition> getBuildDefinitions(IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamBuildClient buildClient = (ITeamBuildClient)this.repository.getClientLibrary(ITeamBuildClient.class);
        ArrayList handles = new ArrayList();
        String idPrefix = String.valueOf(this.fWorkingCopy.getId()) + ".";
        BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel queryModel = BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        IPredicate idStartWith = queryModel.id()._substring(Integer.valueOf(1), Integer.valueOf(idPrefix.length()))._eq(idPrefix);
        IPredicate projectArea = queryModel.processArea()._eq((IItemHandle)this.fWorkingCopy.getProcessArea());
        query.filter(idStartWith._and(projectArea));
        int options = 512;
        IItemQueryPage resultPage = buildClient.queryItems(query, IQueryService.EMPTY_PARAMETERS, options, monitor);
        if (resultPage.getSize() > 0) {
            handles.addAll(resultPage.getItemHandles());
            while (resultPage.hasNext()) {
                resultPage = (IItemQueryPage)buildClient.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize(), monitor);
                handles.addAll(resultPage.getItemHandles());
            }
        }
        List result = this.repository.itemManager().fetchCompleteItems(handles, 0, monitor);
        return result;
    }

    private final JSONArray getBuildItemArray(List<IOrchestratorBuild> builds) {
        JSONArray jsonArray = new JSONArray();
        for (IOrchestratorBuild build : builds) {
            jsonArray.add((Object)build.toJson());
        }
        return jsonArray;
    }

    private final List<IOrchestratorBuild> getBuildItems() {
        IConfigurationProperty property;
        ArrayList<IOrchestratorBuild> result = new ArrayList<IOrchestratorBuild>();
        IBuildConfigurationElement element = this.fWorkingCopy.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorConfigurationElement");
        if (element != null && (property = element.getConfigurationProperty("team.enterprise.smpe.build.orchestrator.builds")) != null && Verification.isNonBlank((String)property.getValue())) {
            JSONArray jsonArray = null;
            EditorItemFetch itemFetch = new EditorItemFetch(this.repository, this.projectAreaHandle, null, Messages.BuildOrchestratorConfigurationEditor_Initialization_Error_Fetch_Build, false);
            try {
                jsonArray = JSONArray.parse((Reader)new StringReader(property.getValue()));
            }
            catch (IOException e) {
                MessageDialog.openWarning((Shell)this.parent.getShell(), (String)Messages.BuildOrchestratorConfigurationEditor_Initialization_Error, (String)Messages.BuildOrchestratorConfigurationEditor_Initialization_Error_Parse_Build);
                return Collections.emptyList();
            }
            for (Object jsonObject : jsonArray) {
                result.add((IOrchestratorBuild)new OrchestratorBuild((JSONObject)jsonObject, (IFetchItem)itemFetch));
            }
        }
        return result;
    }

    private final IAction getBuildMenuActionEdit() {
        return new Action(Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Action_Edit){
            boolean enabled;
            {
                this.enabled = true;
            }

            public void runWithEvent(org.eclipse.swt.widgets.Event event) {
                BuildOrchestratorConfigurationEditor.this.editBuild();
            }

            public void run() {
                this.runWithEvent(null);
            }

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        };
    }

    private final IAction getBuildMenuActionOpen() {
        return new Action(Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Action_Open){
            boolean enabled;
            {
                this.enabled = true;
            }

            public void runWithEvent(org.eclipse.swt.widgets.Event event) {
                IBuildDefinition buildDefinition;
                IOrchestratorBuild orchestratedBuild;
                IStructuredSelection selection = (IStructuredSelection)BuildOrchestratorConfigurationEditor.this.buildTableViewer.getSelection();
                if (selection.size() == 1 && (orchestratedBuild = (IOrchestratorBuild)selection.getFirstElement()) != null && (buildDefinition = orchestratedBuild.getBuildDefinition()) != null && !buildDefinition.isNewItem()) {
                    EditBuildDefinitionActionDelegate.run((IBuildDefinition)buildDefinition, (IWorkbenchPage)BuildOrchestratorConfigurationEditor.this.getSite().getPage());
                }
            }

            public void run() {
                this.runWithEvent(null);
            }

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        };
    }

    private final IMenuListener getBuildMenuListener() {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add(BuildOrchestratorConfigurationEditor.this.getBuildMenuActionEdit());
                manager.add(BuildOrchestratorConfigurationEditor.this.getBuildMenuActionOpen());
            }
        };
    }

    private final String getConfigurationPropertyValue(String name) {
        IConfigurationProperty property;
        IBuildConfigurationElement element = this.fWorkingCopy.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorConfigurationElement");
        String result = "";
        if (element != null && (property = element.getConfigurationProperty(name)) != null) {
            result = property.getValue();
        }
        return result;
    }

    protected String getContextHelpId() {
        return "com.ibm.team.enterprise.smpe.ui.editor_builddefinitionorchestrator";
    }

    private final List<String> getEngineIds(List<IBuildEngine> engines) {
        ArrayList<String> result = new ArrayList<String>(engines.size());
        for (IBuildEngine engine : engines) {
            result.add(engine.getId());
        }
        return result;
    }

    private final String getEngineItemIds(List<IBuildEngine> engines) {
        StringBuilder result = new StringBuilder();
        String separator = "";
        for (IBuildEngine engine : engines) {
            result.append(separator).append(engine.getItemId().getUuidValue());
            separator = ",";
        }
        return result.toString();
    }

    private final List<IBuildEngine> getEngineItems() {
        IConfigurationProperty property;
        ArrayList<IBuildEngine> result = new ArrayList<IBuildEngine>();
        IBuildConfigurationElement element = this.fWorkingCopy.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorConfigurationElement");
        if (element != null && (property = element.getConfigurationProperty("team.enterprise.smpe.build.orchestrator.engines")) != null) {
            String[] stringArray = property.getValue().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String uuid = stringArray[n2];
                if (!uuid.equals("")) {
                    for (IBuildEngine buildEngine : this.buildEngineIds.values()) {
                        if (!buildEngine.getItemId().getUuidValue().equals(uuid)) continue;
                        result.add(buildEngine);
                        break;
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private final IAction getEngineMenuActionAdd() {
        return new Action(Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Action_Add){
            boolean enabled;
            {
                this.enabled = true;
            }

            public void runWithEvent(org.eclipse.swt.widgets.Event event) {
                IStructuredSelection selection = (IStructuredSelection)BuildOrchestratorConfigurationEditor.this.engineTableViewer.getSelection();
                if (selection.size() == 1) {
                    IBuildEngine buildEngine = (IBuildEngine)selection.getFirstElement();
                    if (buildEngine != null) {
                        if (buildEngine.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorEngineConfigElement") == null) {
                            IBuildEngine workingCopy = (IBuildEngine)((IBuildEngine)BuildOrchestratorConfigurationEditor.this.buildEngineIds.get(buildEngine.getId())).getWorkingCopy();
                            IBuildConfigurationElement element = BuildOrchestratorEngineConfigElementFactory.create();
                            workingCopy.getConfigurationElements().add(element);
                            BuildOrchestratorConfigurationEditor.this.orchestratorEngines.remove(buildEngine);
                            BuildOrchestratorConfigurationEditor.this.orchestratorEngines.add(workingCopy);
                            BuildOrchestratorConfigurationEditor.this.updatedOrchestratorEngines.put(workingCopy.getId(), workingCopy);
                            BuildOrchestratorConfigurationEditor.this.buildEngineIds.put(workingCopy.getId(), workingCopy);
                            BuildOrchestratorConfigurationEditor.this.buildDefinitionEditor.getChangedBuildEngines().put(workingCopy.getId(), workingCopy);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    (this).BuildOrchestratorConfigurationEditor.this.engineTableViewer.setInput((this).BuildOrchestratorConfigurationEditor.this.orchestratorEngines);
                                    (this).BuildOrchestratorConfigurationEditor.this.engineTableViewer.refresh();
                                    BuildOrchestratorConfigurationEditor.this.setDirty(true);
                                    BuildOrchestratorConfigurationEditor.this.validate();
                                }
                            });
                        } else {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openWarning((Shell)BuildOrchestratorConfigurationEditor.this.parent.getShell(), (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu, (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu_IsDefined);
                                }
                            });
                        }
                    }
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openWarning((Shell)BuildOrchestratorConfigurationEditor.this.parent.getShell(), (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu, (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu_SelectOne);
                        }
                    });
                }
            }

            public void run() {
                this.runWithEvent(null);
            }

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        };
    }

    private final IAction getEngineMenuActionRemove() {
        return new Action(Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Action_Remove){
            boolean enabled;
            {
                this.enabled = true;
            }

            public void runWithEvent(org.eclipse.swt.widgets.Event event) {
                IStructuredSelection selection = (IStructuredSelection)BuildOrchestratorConfigurationEditor.this.engineTableViewer.getSelection();
                if (selection.size() == 1) {
                    IBuildEngine buildEngine = (IBuildEngine)selection.getFirstElement();
                    if (buildEngine != null) {
                        if (buildEngine.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorEngineConfigElement") != null) {
                            IBuildEngine workingCopy = (IBuildEngine)((IBuildEngine)BuildOrchestratorConfigurationEditor.this.buildEngineIds.get(buildEngine.getId())).getWorkingCopy();
                            IBuildConfigurationElement element = workingCopy.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorEngineConfigElement");
                            workingCopy.getConfigurationElements().remove(element);
                            BuildOrchestratorConfigurationEditor.this.orchestratorEngines.remove(buildEngine);
                            BuildOrchestratorConfigurationEditor.this.orchestratorEngines.add(workingCopy);
                            BuildOrchestratorConfigurationEditor.this.updatedOrchestratorEngines.put(workingCopy.getId(), workingCopy);
                            BuildOrchestratorConfigurationEditor.this.buildEngineIds.put(workingCopy.getId(), workingCopy);
                            BuildOrchestratorConfigurationEditor.this.buildDefinitionEditor.getChangedBuildEngines().put(workingCopy.getId(), workingCopy);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    (this).BuildOrchestratorConfigurationEditor.this.engineTableViewer.setInput((this).BuildOrchestratorConfigurationEditor.this.orchestratorEngines);
                                    (this).BuildOrchestratorConfigurationEditor.this.engineTableViewer.refresh();
                                    BuildOrchestratorConfigurationEditor.this.setDirty(true);
                                    BuildOrchestratorConfigurationEditor.this.validate();
                                }
                            });
                        } else {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openWarning((Shell)BuildOrchestratorConfigurationEditor.this.parent.getShell(), (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu, (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu_Undefined);
                                }
                            });
                        }
                    }
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openWarning((Shell)BuildOrchestratorConfigurationEditor.this.parent.getShell(), (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu, (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu_SelectOne);
                        }
                    });
                }
            }

            public void run() {
                this.runWithEvent(null);
            }

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        };
    }

    private final IAction getEngineMenuActionSetTypeD() {
        return new Action(Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Action_Set_EngineTypeD){
            boolean enabled;
            {
                this.enabled = true;
            }

            public void runWithEvent(org.eclipse.swt.widgets.Event event) {
                IStructuredSelection selection = (IStructuredSelection)BuildOrchestratorConfigurationEditor.this.engineTableViewer.getSelection();
                if (selection.size() == 1) {
                    IBuildEngine buildEngine = (IBuildEngine)selection.getFirstElement();
                    if (buildEngine != null) {
                        if (!BuildEngineHelper.isBuildAgentEngine((IBuildEngine)buildEngine)) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openWarning((Shell)BuildOrchestratorConfigurationEditor.this.parent.getShell(), (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu, (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu_NoBfagent);
                                }
                            });
                        } else if (buildEngine.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorEngineConfigElement") == null) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openWarning((Shell)BuildOrchestratorConfigurationEditor.this.parent.getShell(), (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu, (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu_Undefined);
                                }
                            });
                        } else {
                            IBuildEngine workingCopy = (IBuildEngine)((IBuildEngine)BuildOrchestratorConfigurationEditor.this.buildEngineIds.get(buildEngine.getId())).getWorkingCopy();
                            IBuildConfigurationElement element = workingCopy.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorEngineConfigElement");
                            IConfigurationProperty dedicatedProperty = element.getConfigurationProperty("team.enterprise.smpe.build.orchestrator.engine.dedicated");
                            IConfigurationProperty generalProperty = element.getConfigurationProperty("team.enterprise.smpe.build.orchestrator.engine.general");
                            if (dedicatedProperty == null) {
                                dedicatedProperty = BuildItemFactory.createConfigurationProperty();
                                dedicatedProperty.setName("team.enterprise.smpe.build.orchestrator.engine.dedicated");
                                dedicatedProperty.setValue("true");
                                element.getConfigurationProperties().add(dedicatedProperty);
                            } else {
                                dedicatedProperty.setValue("true");
                            }
                            if (generalProperty == null) {
                                generalProperty = BuildItemFactory.createConfigurationProperty();
                                generalProperty.setName("team.enterprise.smpe.build.orchestrator.engine.general");
                                generalProperty.setValue("false");
                            } else {
                                generalProperty.setValue("false");
                            }
                            BuildOrchestratorConfigurationEditor.this.orchestratorEngines.remove(buildEngine);
                            BuildOrchestratorConfigurationEditor.this.orchestratorEngines.add(workingCopy);
                            BuildOrchestratorConfigurationEditor.this.updatedOrchestratorEngines.put(workingCopy.getId(), workingCopy);
                            BuildOrchestratorConfigurationEditor.this.buildEngineIds.put(workingCopy.getId(), workingCopy);
                            BuildOrchestratorConfigurationEditor.this.buildDefinitionEditor.getChangedBuildEngines().put(workingCopy.getId(), workingCopy);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    (this).BuildOrchestratorConfigurationEditor.this.engineTableViewer.setInput((this).BuildOrchestratorConfigurationEditor.this.orchestratorEngines);
                                    (this).BuildOrchestratorConfigurationEditor.this.engineTableViewer.refresh();
                                    BuildOrchestratorConfigurationEditor.this.setDirty(true);
                                    BuildOrchestratorConfigurationEditor.this.validate();
                                }
                            });
                        }
                    }
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openWarning((Shell)BuildOrchestratorConfigurationEditor.this.parent.getShell(), (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu, (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu_SelectOne);
                        }
                    });
                }
            }

            public void run() {
                this.runWithEvent(null);
            }

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        };
    }

    private final IAction getEngineMenuActionSetTypeG() {
        return new Action(Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Action_Set_EngineTypeG){
            boolean enabled;
            {
                this.enabled = true;
            }

            public void runWithEvent(org.eclipse.swt.widgets.Event event) {
                IStructuredSelection selection = (IStructuredSelection)BuildOrchestratorConfigurationEditor.this.engineTableViewer.getSelection();
                if (selection.size() == 1) {
                    IBuildEngine buildEngine = (IBuildEngine)selection.getFirstElement();
                    if (buildEngine != null) {
                        if (buildEngine.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorEngineConfigElement") != null) {
                            IBuildEngine workingCopy = (IBuildEngine)((IBuildEngine)BuildOrchestratorConfigurationEditor.this.buildEngineIds.get(buildEngine.getId())).getWorkingCopy();
                            IBuildConfigurationElement element = workingCopy.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorEngineConfigElement");
                            IConfigurationProperty dedicatedProperty = element.getConfigurationProperty("team.enterprise.smpe.build.orchestrator.engine.dedicated");
                            IConfigurationProperty generalProperty = element.getConfigurationProperty("team.enterprise.smpe.build.orchestrator.engine.general");
                            if (dedicatedProperty == null) {
                                dedicatedProperty = BuildItemFactory.createConfigurationProperty();
                                dedicatedProperty.setName("team.enterprise.smpe.build.orchestrator.engine.dedicated");
                                dedicatedProperty.setValue("false");
                                element.getConfigurationProperties().add(dedicatedProperty);
                            } else {
                                dedicatedProperty.setValue("false");
                            }
                            if (generalProperty == null) {
                                generalProperty = BuildItemFactory.createConfigurationProperty();
                                generalProperty.setName("team.enterprise.smpe.build.orchestrator.engine.general");
                                generalProperty.setValue("true");
                            } else {
                                generalProperty.setValue("true");
                            }
                            BuildOrchestratorConfigurationEditor.this.orchestratorEngines.remove(buildEngine);
                            BuildOrchestratorConfigurationEditor.this.orchestratorEngines.add(workingCopy);
                            BuildOrchestratorConfigurationEditor.this.updatedOrchestratorEngines.put(workingCopy.getId(), workingCopy);
                            BuildOrchestratorConfigurationEditor.this.buildEngineIds.put(workingCopy.getId(), workingCopy);
                            BuildOrchestratorConfigurationEditor.this.buildDefinitionEditor.getChangedBuildEngines().put(workingCopy.getId(), workingCopy);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    (this).BuildOrchestratorConfigurationEditor.this.engineTableViewer.setInput((this).BuildOrchestratorConfigurationEditor.this.orchestratorEngines);
                                    (this).BuildOrchestratorConfigurationEditor.this.engineTableViewer.refresh();
                                    BuildOrchestratorConfigurationEditor.this.setDirty(true);
                                    BuildOrchestratorConfigurationEditor.this.validate();
                                }
                            });
                        } else {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openWarning((Shell)BuildOrchestratorConfigurationEditor.this.parent.getShell(), (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu, (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu_Undefined);
                                }
                            });
                        }
                    }
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openWarning((Shell)BuildOrchestratorConfigurationEditor.this.parent.getShell(), (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu, (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ActionMenu_SelectOne);
                        }
                    });
                }
            }

            public void run() {
                this.runWithEvent(null);
            }

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        };
    }

    private final IMenuListener getEngineMenuListener() {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IBuildEngine buildEngine;
                IBuildConfigurationElement element;
                IStructuredSelection selection = (IStructuredSelection)BuildOrchestratorConfigurationEditor.this.engineTableViewer.getSelection();
                boolean elementAdded = false;
                boolean dedicatedSet = false;
                boolean generalSet = false;
                if (selection.size() == 1 && (element = (buildEngine = (IBuildEngine)selection.getFirstElement()).getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorEngineConfigElement")) != null) {
                    IConfigurationProperty generalProperty;
                    elementAdded = true;
                    IConfigurationProperty dedicatedProperty = element.getConfigurationProperty("team.enterprise.smpe.build.orchestrator.engine.dedicated");
                    if (dedicatedProperty != null) {
                        dedicatedSet = Boolean.parseBoolean(dedicatedProperty.getValue());
                    }
                    if ((generalProperty = element.getConfigurationProperty("team.enterprise.smpe.build.orchestrator.engine.general")) != null) {
                        generalSet = Boolean.parseBoolean(generalProperty.getValue());
                    }
                }
                IAction actionAdd = BuildOrchestratorConfigurationEditor.this.getEngineMenuActionAdd();
                IAction actionRemove = BuildOrchestratorConfigurationEditor.this.getEngineMenuActionRemove();
                IAction actionSetTypeG = BuildOrchestratorConfigurationEditor.this.getEngineMenuActionSetTypeG();
                IAction actionSetTypeD = BuildOrchestratorConfigurationEditor.this.getEngineMenuActionSetTypeD();
                actionAdd.setEnabled(!elementAdded);
                actionRemove.setEnabled(elementAdded);
                actionSetTypeD.setEnabled(elementAdded && (!dedicatedSet && !generalSet || generalSet));
                actionSetTypeG.setEnabled(elementAdded && (!dedicatedSet && !generalSet || dedicatedSet));
                manager.add(actionAdd);
                manager.add(actionRemove);
                manager.add(actionSetTypeD);
                manager.add(actionSetTypeG);
            }
        };
    }

    private final IOpenListener getEngineOpenListener() {
        return new IOpenListener(){

            public void open(OpenEvent event) {
                IBuildEngine buildEngine;
                IStructuredSelection selection = (IStructuredSelection)BuildOrchestratorConfigurationEditor.this.engineTableViewer.getSelection();
                if (selection.size() == 1 && (buildEngine = (IBuildEngine)selection.getFirstElement()) != null && !buildEngine.isNewItem()) {
                    EditBuildEngineActionDelegate.run((IBuildEngine)buildEngine, (IWorkbenchPage)BuildOrchestratorConfigurationEditor.this.getSite().getPage());
                }
            }
        };
    }

    private final BuildItemEditorJob getFetchActionArgumentJob(final IFetchItem fetchItem) {
        String jobname = Messages.BuildOrchestratorConfigurationEditor_Initialization_Fetch_ActionArguments;
        return new BuildItemEditorJob(jobname, true, (BuildItemEditor)this.buildDefinitionEditor){

            protected void internalRunProtected(IProgressMonitor monitor) throws Exception {
                fetchItem.fetchItems((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!BuildOrchestratorConfigurationEditor.this.isDisposed()) {
                            BuildOrchestratorConfigurationEditor.this.handleActionArguments();
                        }
                    }
                });
            }
        };
    }

    private final BuildItemEditorJob getFetchBuildDefinitionsJob() {
        String jobname = Messages.BuildOrchestratorConfigurationEditor_Initialization_Fetch_BuildDefinitions;
        return new BuildItemEditorJob(jobname, true, (BuildItemEditor)this.buildDefinitionEditor){

            protected void internalRunProtected(IProgressMonitor monitor) throws Exception {
                final List definitions = BuildOrchestratorConfigurationEditor.this.getBuildDefinitions((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!BuildOrchestratorConfigurationEditor.this.isDisposed()) {
                            BuildOrchestratorConfigurationEditor.this.handleBuildDefinitions(definitions);
                        }
                    }
                });
            }
        };
    }

    private final void handleActionArguments() {
        this.orchestratorActions = this.getActionItems();
        this.actionTableViewer.setInput(this.orchestratorActions);
        this.actionTableViewer.refresh();
    }

    private final void handleBuildDefinitions(List<IBuildDefinition> definitions) {
        this.buildDefinitionIds.clear();
        this.buildDefinitions.clear();
        for (IBuildDefinition definition : definitions) {
            this.buildDefinitionIds.put(definition.getId(), definition);
            this.buildDefinitions.put(definition.getItemId().getUuidValue(), definition);
        }
        try {
            ItemCacheFactory.clearBuildDefinition((ITeamRepository)this.repository, (IProcessAreaHandle)this.processArea);
            ItemCacheFactory.addBuildDefinition((ITeamRepository)this.repository, (IProcessAreaHandle)this.processArea, definitions);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        this.orchestratorBuilds = this.getBuildItems();
        this.buildTableViewer.setInput(this.orchestratorBuilds);
        this.buildTableViewer.refresh();
        this.updateBuildEnablement();
    }

    public final void handleEvent(Event arg0) {
        this.buildEngineIds = this.buildDefinitionEditor.getBuildEngines();
        this.buildEngines.clear();
        for (IBuildEngine engine : this.buildEngineIds.values()) {
            this.buildEngines.put(engine.getItemId().getUuidValue(), engine);
        }
        try {
            ItemCacheFactory.clearBuildEngine((ITeamRepository)this.repository, (IProcessAreaHandle)this.processArea);
            ItemCacheFactory.addBuildEngine((ITeamRepository)this.repository, (IProcessAreaHandle)this.processArea, new ArrayList<IBuildEngine>(this.buildEngineIds.values()));
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        this.orchestratorEngines = this.getEngineItems();
        this.engineTableViewer.setInput(this.orchestratorEngines);
        this.engineTableViewer.refresh();
        this.updateEngineEnablement();
        this.orchestratorBuilds = this.getBuildItems();
        this.buildTableViewer.setInput(this.orchestratorBuilds);
        this.buildTableViewer.refresh();
        this.updateBuildEnablement();
    }

    private final boolean haveBuildData() {
        return !this.buildDefinitions.isEmpty() && !this.buildEngines.isEmpty();
    }

    private final boolean haveBuildItems() {
        return !this.orchestratorBuilds.isEmpty() && !this.buildDefinitions.isEmpty() && !this.buildEngines.isEmpty();
    }

    private final boolean haveEngineData() {
        return !this.buildEngines.isEmpty();
    }

    private final boolean haveEngineItems() {
        return !this.orchestratorEngines.isEmpty() && !this.buildEngines.isEmpty();
    }

    private final boolean isDependsOn(IOrchestratorBuild build) {
        if (build.getBuildDefinition() != null) {
            for (IOrchestratorBuild orchestratorBuild : this.orchestratorBuilds) {
                for (IBuildDefinition dependsOn : orchestratorBuild.getDependsOn()) {
                    if (!dependsOn.sameItemId((IItemHandle)build.getBuildDefinition())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public final boolean isDisposed() {
        return this.disposed;
    }

    public final void performExtraSave(IItem[] savedItems, IProgressMonitor monitor) {
        IBuildDefinition buildDefinition;
        String messageBinding;
        Object engineBinding;
        ITeamBuildClient buildClient = (ITeamBuildClient)this.repository.getClientLibrary(ITeamBuildClient.class);
        int i = 0;
        while (i < savedItems.length) {
            IItem item = savedItems[i];
            if (item instanceof IBuildEngine) {
                boolean save = true;
                IBuildEngine engine = (IBuildEngine)item;
                IBuildConfigurationElement element = engine.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorEngineConfigElement");
                if (this.updatedOrchestratorEngines.containsKey(engine.getId())) {
                    engine = (IBuildEngine)engine.getWorkingCopy();
                    element = engine.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorEngineConfigElement");
                    IBuildEngine updatedEngine = this.updatedOrchestratorEngines.get(engine.getId());
                    IBuildConfigurationElement updatedElement = updatedEngine.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorEngineConfigElement");
                    if (element == null && updatedElement != null) {
                        engine.getConfigurationElements().add(updatedElement);
                    } else if (element != null && updatedElement == null) {
                        engine.getConfigurationElements().remove(element);
                    } else if (element != null && updatedElement != null) {
                        engine.getConfigurationElements().remove(element);
                        engine.getConfigurationElements().add(updatedElement);
                    } else {
                        save = false;
                    }
                } else {
                    save = false;
                }
                if (save) {
                    try {
                        engine = buildClient.save(engine, monitor);
                        savedItems[i] = engine;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        engineBinding = engine.getId();
                        messageBinding = e.getMessage();
                        Display.getDefault().asyncExec(new Runnable((String)engineBinding, messageBinding){
                            private final /* synthetic */ String val$engineBinding;
                            private final /* synthetic */ String val$messageBinding;
                            {
                                this.val$engineBinding = string;
                                this.val$messageBinding = string2;
                            }

                            @Override
                            public void run() {
                                MessageDialog.openWarning((Shell)BuildOrchestratorConfigurationEditor.this.parent.getShell(), (String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ExtraSave_Title, (String)NLS.bind((String)Messages.BuildOrchestratorConfigurationEditor_EnginesSection_Error_ExtraSave_Message, (Object)this.val$engineBinding, (Object[])new Object[]{this.val$messageBinding}));
                            }
                        });
                    }
                }
                for (IBuildEngine orchestratorEngine : this.orchestratorEngines) {
                    if (!orchestratorEngine.sameItemId((IItemHandle)engine)) continue;
                    this.orchestratorEngines.remove(orchestratorEngine);
                    this.orchestratorEngines.add(engine);
                    break;
                }
            }
            ++i;
        }
        this.updatedOrchestratorEngines.clear();
        HashMap<String, IBuildDefinition> availableBuilds = new HashMap<String, IBuildDefinition>(this.buildDefinitions);
        for (IOrchestratorBuild orchestratorBuild : this.orchestratorBuilds) {
            IConfigurationProperty property;
            if (!orchestratorBuild.hasBuildDefinition()) continue;
            boolean save = false;
            buildDefinition = (IBuildDefinition)orchestratorBuild.getBuildDefinition().getWorkingCopy();
            IBuildConfigurationElement element = buildDefinition.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IOrchestratedBuildConfigurationElement");
            if (element == null) {
                element = BuildConfigurationRegistry.getInstance().getBuildConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IOrchestratedBuildConfigurationElement");
                buildDefinition.initializeConfiguration(element);
                save = true;
            }
            if ((property = element.getConfigurationProperty("team.enterprise.smpe.build.orchestrated.build.orchestrator")) == null) {
                property = BuildItemFactory.createConfigurationProperty();
                property.setName("team.enterprise.smpe.build.orchestrated.build.orchestrator");
                element.getConfigurationProperties().add(property);
                save = true;
            }
            if (!buildDefinition.getItemId().getUuidValue().equals(property.getValue())) {
                property.setValue(buildDefinition.getItemId().getUuidValue());
                save = true;
            }
            if (save) {
                try {
                    buildDefinition = buildClient.save(buildDefinition, monitor);
                    orchestratorBuild.setBuildDefinition(buildDefinition);
                    this.buildDefinitionIds.put(buildDefinition.getId(), buildDefinition);
                    this.buildDefinitions.put(buildDefinition.getItemId().getUuidValue(), buildDefinition);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    final String engineBinding2 = buildDefinition.getId();
                    final String messageBinding2 = e.getMessage();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openWarning((Shell)BuildOrchestratorConfigurationEditor.this.parent.getShell(), (String)Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Error_ExtraSave_Title, (String)NLS.bind((String)Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Error_ExtraSave_Message, (Object)engineBinding2, (Object[])new Object[]{messageBinding2}));
                        }
                    });
                }
            }
            availableBuilds.remove(buildDefinition.getItemId().getUuidValue());
        }
        for (IBuildDefinition availableBuild : availableBuilds.values()) {
            IBuildConfigurationElement element = availableBuild.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IOrchestratedBuildConfigurationElement");
            if (element == null) continue;
            buildDefinition = (IBuildDefinition)availableBuild.getWorkingCopy();
            buildDefinition.getConfigurationElements().remove(element);
            try {
                buildDefinition = buildClient.save(buildDefinition, monitor);
                this.buildDefinitionIds.put(buildDefinition.getId(), buildDefinition);
                this.buildDefinitions.put(buildDefinition.getItemId().getUuidValue(), buildDefinition);
            }
            catch (Exception e) {
                e.printStackTrace();
                engineBinding = buildDefinition.getId();
                messageBinding = e.getMessage();
                Display.getDefault().asyncExec(new Runnable((String)engineBinding, messageBinding){
                    private final /* synthetic */ String val$engineBinding;
                    private final /* synthetic */ String val$messageBinding;
                    {
                        this.val$engineBinding = string;
                        this.val$messageBinding = string2;
                    }

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)BuildOrchestratorConfigurationEditor.this.parent.getShell(), (String)Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Error_ExtraSave_Title, (String)NLS.bind((String)Messages.BuildOrchestratorConfigurationEditor_DetailsSection_Error_ExtraSave_Message, (Object)this.val$engineBinding, (Object[])new Object[]{this.val$messageBinding}));
                    }
                });
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BuildOrchestratorConfigurationEditor.this.engineTableViewer.setInput(BuildOrchestratorConfigurationEditor.this.orchestratorEngines);
                BuildOrchestratorConfigurationEditor.this.engineTableViewer.refresh();
            }
        });
    }

    private final void setActionItems(List<IOrchestratorAction> actions) {
        this.fWorkingCopy.setConfigurationProperty("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorConfigurationElement", "team.enterprise.smpe.build.orchestrator.actions", this.getActionItemArray(actions).toString());
    }

    private final void setBuildItems(List<IOrchestratorBuild> builds) {
        this.fWorkingCopy.setConfigurationProperty("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorConfigurationElement", "team.enterprise.smpe.build.orchestrator.builds", this.getBuildItemArray(builds).toString());
    }

    private final void setConfigurationPropertyValue(String name, String value) {
        this.fWorkingCopy.setConfigurationProperty("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorConfigurationElement", name, value);
    }

    private final void setEngineItems(List<IBuildEngine> engines) {
        this.fWorkingCopy.setConfigurationProperty("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorConfigurationElement", "team.enterprise.smpe.build.orchestrator.engines", this.getEngineItemIds(engines));
    }

    public final void setWorkingCopy(IBuildDefinition definition) {
        this.fWorkingCopy = definition;
    }

    public final boolean validate() {
        boolean ok = true;
        if (this.enabledItem.item != null && this.enabledItem.item.getSelection() && !Verification.isNonEmpty(this.orchestratorBuilds)) {
            this.addErrorMessage(this.enabledItem.item, Messages.BuildOrchestratorConfigurationEditor_Validation_Required_BuildDefintion, (Control)this.enabledItem.item);
        }
        return ok;
    }
}

