/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.editors;

import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import com.ibm.team.enterprise.smpe.ui.editors.AbstractSystemDefinitionEditorPage;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractSystemDefinitionEditor;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class AbstractFunctionDefinitionEditorPageItem
extends AbstractSystemDefinitionEditorPage {
    private AbstractSystemDefinitionEditor editor;
    private Composite contentContainer;
    private IManagedForm managedForm;
    private ITeamRepository teamRepository;
    private boolean dirty;

    public AbstractFunctionDefinitionEditorPageItem(String elementId, String title) {
        super(elementId, title);
    }

    public abstract void createContent(Composite var1, FormToolkit var2);

    protected Text createLabeledText(FormToolkit toolkit, Composite parent, String label, String tooltip, String textValue) {
        return this.createLabeledText(toolkit, parent, label, tooltip, textValue, 1);
    }

    protected Text createLabeledText(FormToolkit toolkit, Composite parent, String label, String tooltip, String textValue, int horizontalSpan) {
        Label textLabel = toolkit.createLabel(parent, label);
        textLabel.setToolTipText(tooltip);
        Text text = toolkit.createText(parent, textValue);
        text.setLayoutData((Object)new TableWrapData(256, 128, 1, horizontalSpan));
        return text;
    }

    protected void createSpacer(FormToolkit toolkit, Composite parent, int height, int horizontalSpan) {
        Label label = toolkit.createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    protected abstract String getContextHelpId();

    @Override
    public abstract void setWorkingCopy(ISystemDefinition var1);

    public abstract boolean validate();

    public void addErrorMessage(Object id, String message, Control control) {
        this.editor.addErrorMessage(id, message, control, this.getIndex());
    }

    public void addErrorMessage(Object id, String message, IStatus status) {
        this.editor.addErrorMessage(id, message, status);
    }

    public void addErrorMessageForRequiredField(Object id, String message, Control control) {
        if (this.editor.isSaveAttempted()) {
            this.editor.addErrorMessage(id, message, control, this.getIndex());
        }
    }

    public void addWarningMessage(Object id, String message, Control control) {
        this.editor.addWarningMessage(id, message, control, this.getIndex());
    }

    private Composite createContentContainer(IManagedForm managedForm) {
        Composite container = managedForm.getToolkit().createComposite(managedForm.getForm().getBody());
        TableWrapData layoutData = new TableWrapData(256, 256);
        container.setLayoutData((Object)layoutData);
        return container;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.managedForm = managedForm;
        managedForm.getToolkit().setBorderStyle(2048);
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        TableWrapLayout layout = new TableWrapLayout();
        body.setLayout((Layout)layout);
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        this.contentContainer = this.createContentContainer(this.managedForm);
        this.createContent(this.contentContainer, this.managedForm.getToolkit());
        this.handleReadOnlyMode(this.contentContainer);
    }

    public Control getFocusControl() {
        return null;
    }

    protected IProjectAreaHandle getProjectAreaHandle(ISystemDefinition systemDefinition) {
        return this.resolveProjectArea(systemDefinition.getProjectArea(), (IProgressMonitor)new NullProgressMonitor());
    }

    protected ITeamRepository getTeamRepository() {
        return this.teamRepository;
    }

    public void initialize(AbstractSystemDefinitionEditor editor) {
        super.initialize((FormEditor)editor);
        this.editor = editor;
        this.teamRepository = editor.getTeamRepository();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void refresh() {
        if (this.contentContainer != null && !this.contentContainer.isDisposed()) {
            this.contentContainer.dispose();
            this.contentContainer = this.createContentContainer(this.managedForm);
            this.createContent(this.contentContainer, this.managedForm.getToolkit());
        }
        this.setDirty(false);
    }

    public void removeErrorMessage(Object id) {
        this.editor.removeErrorMessage(id);
    }

    public void removeErrorMessage(Object id, Control control) {
        this.editor.removeErrorMessage(id, control);
    }

    protected IProjectAreaHandle resolveProjectArea(IProjectAreaHandle processArea, IProgressMonitor monitor) {
        IProjectArea projectArea = null;
        try {
            projectArea = (IProjectArea)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)processArea, 0, monitor);
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        return projectArea != null ? projectArea.getProjectArea() : null;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.managedForm.getForm(), this.getContextHelpId());
        }
    }

    public void setDirty(boolean isDirty) {
        this.dirty = isDirty;
        this.editor.setDirty(isDirty);
        this.editor.fireDirtyPropertyChangeEvent();
    }

    public void setFocus() {
        if (this.getFocusControl() != null) {
            this.getFocusControl().setFocus();
        } else {
            ((AbstractSystemDefinitionEditor)this.getEditor()).setFocusInHeader();
        }
    }

    protected void setPageErrorIndicator(boolean isError) {
        Image image = null;
        if (isError && this.editor.isSaveAttempted()) {
            image = SmpeUIPlugin.getImage("icons/ovr16/failed_ovr.gif");
        }
        this.editor.setPageImage(this.getIndex(), image);
    }
}

