/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.domain;

import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainRegistry;
import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import com.ibm.team.enterprise.smpe.ui.actions.VersionDefinitionDomainActionHelper;
import com.ibm.team.enterprise.smpe.ui.domain.FunctionDefinitionsNodeEE;
import com.ibm.team.enterprise.smpe.ui.domain.VersionDefinitionNodeEE;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheFactory;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.Packaging;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class VersionDefinitionsNodeEE
extends AbstractEnterpriseExtensionsNode {
    private boolean fetchInProgress;
    private boolean fetchedVersions;
    private final IDebugger dbg = new Debugger(((Object)((Object)this)).getClass());
    private final Set<String> packagingFunctionIds = new HashSet<String>();
    private final Set<String> packagingFunctionNames = new HashSet<String>();
    private final Set<String> packagingVersionIds = new HashSet<String>();
    private final Set<String> packagingVersionNames = new HashSet<String>();
    private final List<IFunctionDefinition> packagingFunctions = new ArrayList<IFunctionDefinition>();
    private final List<IVersionDefinition> packagingVersions = new ArrayList<IVersionDefinition>();
    private FunctionDefinitionsNodeEE functionDefinitionsNodeEE;
    private String[] packagingFunctionItems = new String[]{""};
    private ViewerSorter viewerSorter;
    private List<VersionDefinitionNodeEE> elements = Collections.emptyList();

    public final void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        VersionDefinitionDomainActionHelper actionHelper = new VersionDefinitionDomainActionHelper(manager, selection, this.getDomainSubtreeRoot().getDomain().getWorkbenchPart().getSite());
        actionHelper.contributeActions();
        super.contributeContextMenuActions(manager, selection);
        if (!this.fetchedVersions) {
            this.refreshVersions();
        }
    }

    public final boolean fetchAndUpdate(VersionDefinitionNodeEE element) {
        SystemDefinitionJob job = this.getFetchVersionDefinitionJob(element);
        job.schedule();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fetchDeferredChildren(IElementCollector collector, IProgressMonitor monitor) {
        VersionDefinitionsNodeEE versionDefinitionsNodeEE = this;
        synchronized (versionDefinitionsNodeEE) {
            if (this.fetchInProgress) {
                return;
            }
            this.fetchInProgress = true;
        }
        try {
            monitor.beginTask("", -1);
            this.getChildrenOfVersionDefinitionsNode(this.getDomainSubtreeRoot(), collector, monitor);
            SystemDefinitionJob job = this.getGetVersionDefinitionsJob(this.getProjectAreaHandle(this.getDomainSubtreeRoot()));
            job.schedule();
        }
        finally {
            this.fetchInProgress = false;
            collector.done();
            monitor.done();
        }
    }

    public final IDebugger getDebugger() {
        return this.dbg;
    }

    private final void getChildrenOfVersionDefinitionsNode(DomainSubtreeRoot parent, IElementCollector collector, IProgressMonitor monitor) {
        Object category = parent.getCategoryElement();
        if (category instanceof ITeamArea) {
            category = ((ITeamArea)category).getProjectArea();
        }
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)category;
        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)teamRepository);
        List systemDefinitions = null;
        ArrayList<VersionDefinitionNodeEE> nodes = new ArrayList<VersionDefinitionNodeEE>();
        collector.add((Object)this.getFunctionsNode(parent), monitor);
        try {
            DomainSubtreeRoot treeRoot = this.getDomainSubtreeRoot();
            boolean showArchived = EnterpriseExtensionsDomainRegistry.getInstance().getArchivefilterListener().isShowArchived();
            systemDefinitions = client.findSystemDefinitions(IVersionDefinition.ITEM_TYPE, projectAreaHandle, -1, showArchived, Arrays.asList(ISystemDefinition.SMALL_PROFILE), monitor);
            for (ISystemDefinition systemDefinition : systemDefinitions) {
                nodes.add(new VersionDefinitionNodeEE(projectAreaHandle, systemDefinition, treeRoot, this));
            }
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        this.setElements(nodes);
        collector.add(nodes.toArray(), monitor);
    }

    private final SystemDefinitionJob getGetVersionDefinitionsJob(final IProjectAreaHandle projectAreaHandle) {
        return new SystemDefinitionJob(Messages.VersionDefinitionsNodeEE_Action_GetIds, true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                ItemCacheFactory.loadDatasetHandle((ITeamRepository)VersionDefinitionsNodeEE.this.getTeamRepository(), (IProjectAreaHandle)projectAreaHandle, (ISystemDefinition.Platform)ISystemDefinition.Platform.zos, (Integer)0, (IDebugger)VersionDefinitionsNodeEE.this.dbg);
                ItemCacheFactory.loadDatasetHandle((ITeamRepository)VersionDefinitionsNodeEE.this.getTeamRepository(), (IProjectAreaHandle)projectAreaHandle, (ISystemDefinition.Platform)ISystemDefinition.Platform.zos, (Integer)1, (IDebugger)VersionDefinitionsNodeEE.this.dbg);
                ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)VersionDefinitionsNodeEE.this.getTeamRepository());
                ArrayList<IVersionDefinition> packagingVersions = new ArrayList<IVersionDefinition>(client.findSystemDefinitionsComplete(IVersionDefinition.ITEM_TYPE, projectAreaHandle, -1, false, monitor));
                VersionDefinitionsNodeEE.this.setPackagingVersions(packagingVersions);
                ArrayList<IFunctionDefinition> packagingFunctions = new ArrayList<IFunctionDefinition>(client.findSystemDefinitionsComplete(IFunctionDefinition.ITEM_TYPE, projectAreaHandle, -1, false, monitor));
                VersionDefinitionsNodeEE.this.setPackagingFunctions(packagingFunctions);
                VersionDefinitionsNodeEE.this.fetchedVersions = true;
                return Status.OK_STATUS;
            }
        };
    }

    private final SystemDefinitionJob getFetchVersionDefinitionJob(final VersionDefinitionNodeEE element) {
        return new SystemDefinitionJob(NLS.bind((String)Messages.VersionDefinitionsNodeEE_Action_Refresh, (Object)element.getLabel()), true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)VersionDefinitionsNodeEE.this.getTeamRepository());
                ISystemDefinition systemDefinition = client.fetchSystemDefinition((ISystemDefinitionHandle)element.getSystemDefinition(), Arrays.asList(ISystemDefinition.SMALL_PROFILE), monitor);
                if (systemDefinition != null) {
                    element.setVersionDefinition(systemDefinition);
                    VersionDefinitionsNodeEE.this.refreshNode(element);
                }
                return Status.OK_STATUS;
            }
        };
    }

    public List<VersionDefinitionNodeEE> getElements() {
        return this.elements;
    }

    public final FunctionDefinitionsNodeEE getFunctionsNode() {
        return this.getFunctionsNode(this.getDomainSubtreeRoot());
    }

    private final FunctionDefinitionsNodeEE getFunctionsNode(DomainSubtreeRoot parent) {
        if (this.functionDefinitionsNodeEE == null) {
            this.functionDefinitionsNodeEE = new FunctionDefinitionsNodeEE(this.getProjectAreaHandle(), this.getDomainSubtreeRoot(), this, this.getViewer());
        }
        return this.functionDefinitionsNodeEE;
    }

    public final Image getIcon() {
        return SmpeUIPlugin.getImage("icons/obj16/versions_obj.gif");
    }

    public final String getLabel() {
        return Messages.VersionDefinitionsNodeEE_Label_VersionDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<String> getPackagingFunctionIds() {
        List<IFunctionDefinition> list = this.packagingFunctions;
        synchronized (list) {
            return this.packagingFunctionIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getPackagingFunctionItems() {
        List<IFunctionDefinition> list = this.packagingFunctions;
        synchronized (list) {
            return this.packagingFunctionItems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<String> getPackagingFunctionNames() {
        List<IFunctionDefinition> list = this.packagingFunctions;
        synchronized (list) {
            return this.packagingFunctionNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<IFunctionDefinition> getPackagingFunctions() {
        List<IFunctionDefinition> list = this.packagingFunctions;
        synchronized (list) {
            return this.packagingFunctions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<String> getPackagingVersionIds() {
        List<IVersionDefinition> list = this.packagingVersions;
        synchronized (list) {
            return this.packagingVersionIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<String> getPackagingVersionNames() {
        List<IVersionDefinition> list = this.packagingVersions;
        synchronized (list) {
            return this.packagingVersionNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<IVersionDefinition> getPackagingVersions() {
        List<IVersionDefinition> list = this.packagingVersions;
        synchronized (list) {
            return this.packagingVersions;
        }
    }

    private final IProjectAreaHandle getProjectAreaHandle(DomainSubtreeRoot parent) {
        Object category = parent.getCategoryElement();
        if (category instanceof ITeamArea) {
            category = ((ITeamArea)category).getProjectArea();
        }
        return (IProjectAreaHandle)category;
    }

    public final ViewerSorter getSorter() {
        if (this.viewerSorter == null) {
            this.viewerSorter = new VersionDefinitionDomainViewerSorter();
        }
        return this.viewerSorter;
    }

    public final boolean hasChildren() {
        return true;
    }

    public final boolean isVisible() {
        try {
            if (!ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getTeamRepository()).isSMPEEnabled(null)) {
                return false;
            }
        }
        catch (TeamRepositoryException e) {
            SmpeUIPlugin.log(e);
            return false;
        }
        return super.isVisible();
    }

    public final boolean refresh() {
        return super.refresh();
    }

    public final void refreshVersions() {
        SystemDefinitionJob job = this.getGetVersionDefinitionsJob(this.getProjectAreaHandle(this.getDomainSubtreeRoot()));
        job.schedule();
    }

    private final void refreshNode(final VersionDefinitionNodeEE element) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (VersionDefinitionsNodeEE.this.getViewer() != null && !VersionDefinitionsNodeEE.this.getViewer().getControl().isDisposed()) {
                    ((TreeViewer)VersionDefinitionsNodeEE.this.getViewer()).refresh((Object)element);
                }
            }
        });
    }

    public void refreshNode(ISystemDefinition systemDefinition) {
        for (VersionDefinitionNodeEE element : this.getElements()) {
            if (!element.getSystemDefinition().sameItemId((IItemHandle)systemDefinition)) continue;
            element.setVersionDefinition(systemDefinition);
            this.refreshNode(element);
            break;
        }
    }

    public void setElements(List<VersionDefinitionNodeEE> elements) {
        this.elements = elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPackagingFunctions(List<IFunctionDefinition> packagingFunctions) {
        List<IFunctionDefinition> list = this.packagingFunctions;
        synchronized (list) {
            this.packagingFunctions.clear();
            this.packagingFunctions.addAll(packagingFunctions);
            this.packagingFunctionIds.clear();
            this.packagingFunctionNames.clear();
            for (IFunctionDefinition packagingFunction : this.packagingFunctions) {
                this.packagingFunctionIds.add(packagingFunction.getId());
                this.packagingFunctionNames.add(packagingFunction.getName());
            }
            this.packagingFunctionItems = Packaging.getFunctionArray(this.packagingFunctions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPackagingVersions(List<IVersionDefinition> packagingVersions) {
        List<IVersionDefinition> list = this.packagingVersions;
        synchronized (list) {
            this.packagingVersions.clear();
            this.packagingVersions.addAll(packagingVersions);
            this.packagingVersionIds.clear();
            this.packagingVersionNames.clear();
            for (IVersionDefinition packagingVersion : this.packagingVersions) {
                this.packagingVersionIds.add(packagingVersion.getId());
                this.packagingVersionNames.add(packagingVersion.getName());
            }
        }
    }

    public static final class VersionDefinitionDomainViewerSorter
    extends ViewerSorter {
        public int compare(Viewer viewer, Object element1, Object element2) {
            if (element1 instanceof PendingUpdateAdapter && element2 instanceof PendingUpdateAdapter) {
                return 0;
            }
            if (element1 instanceof PendingUpdateAdapter) {
                return -1;
            }
            if (element2 instanceof PendingUpdateAdapter) {
                return 1;
            }
            if (element1 instanceof VersionDefinitionNodeEE && element2 instanceof FunctionDefinitionsNodeEE) {
                return 1;
            }
            if (element1 instanceof FunctionDefinitionsNodeEE && element2 instanceof VersionDefinitionNodeEE) {
                return -1;
            }
            if (element1 instanceof VersionDefinitionNodeEE && element2 instanceof VersionDefinitionNodeEE) {
                VersionDefinitionNodeEE node1 = (VersionDefinitionNodeEE)((Object)element1);
                VersionDefinitionNodeEE node2 = (VersionDefinitionNodeEE)((Object)element2);
                return node1.getLabel().compareTo(node2.getLabel());
            }
            if (element1 instanceof FunctionDefinitionsNodeEE && element2 instanceof FunctionDefinitionsNodeEE) {
                FunctionDefinitionsNodeEE node1 = (FunctionDefinitionsNodeEE)((Object)element1);
                FunctionDefinitionsNodeEE node2 = (FunctionDefinitionsNodeEE)((Object)element2);
                return node1.getLabel().compareTo(node2.getLabel());
            }
            return 0;
        }
    }
}

