/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.domain;

import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainRegistry;
import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import com.ibm.team.enterprise.smpe.ui.actions.FunctionDefinitionDomainActionHelper;
import com.ibm.team.enterprise.smpe.ui.domain.FunctionDefinitionNodeEE;
import com.ibm.team.enterprise.smpe.ui.domain.VersionDefinitionsNodeEE;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IElementCollector;

public class FunctionDefinitionsNodeEE
extends AbstractEnterpriseExtensionsNode {
    private boolean fetchInProgress;
    private final VersionDefinitionsNodeEE versionDefinitionsNodeEE;
    private List<FunctionDefinitionNodeEE> elements = Collections.emptyList();

    public FunctionDefinitionsNodeEE(IProjectAreaHandle projectAreaHandle, DomainSubtreeRoot domainSubtreeRoot, VersionDefinitionsNodeEE versionsNode, Viewer viewer) {
        this.setProjectAreaHandle(projectAreaHandle);
        this.setDomainSubtreeRoot(domainSubtreeRoot);
        this.setParent((IEnterpriseExtensionsNode)versionsNode);
        this.setViewer(viewer);
        this.versionDefinitionsNodeEE = versionsNode;
    }

    public final void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        FunctionDefinitionDomainActionHelper actionHelper = new FunctionDefinitionDomainActionHelper(manager, selection, this.getDomainSubtreeRoot().getDomain().getWorkbenchPart().getSite());
        actionHelper.contributeActions();
        super.contributeContextMenuActions(manager, selection);
    }

    public final boolean fetchAndUpdate(FunctionDefinitionNodeEE element) {
        SystemDefinitionJob job = this.getFetchFunctionDefinitionJob(element);
        job.schedule();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fetchDeferredChildren(IElementCollector collector, IProgressMonitor monitor) {
        FunctionDefinitionsNodeEE functionDefinitionsNodeEE = this;
        synchronized (functionDefinitionsNodeEE) {
            if (this.fetchInProgress) {
                return;
            }
            this.fetchInProgress = true;
        }
        try {
            monitor.beginTask("", -1);
            this.getChildrenOfFunctionDefinitionsNode(this.getDomainSubtreeRoot(), collector, monitor);
            this.versionDefinitionsNodeEE.refreshVersions();
        }
        finally {
            this.fetchInProgress = false;
            collector.done();
            monitor.done();
        }
    }

    private final void getChildrenOfFunctionDefinitionsNode(DomainSubtreeRoot parent, IElementCollector collector, IProgressMonitor monitor) {
        Object category = parent.getCategoryElement();
        if (category instanceof ITeamArea) {
            category = ((ITeamArea)category).getProjectArea();
        }
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)category;
        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)teamRepository);
        List systemDefinitions = null;
        ArrayList<FunctionDefinitionNodeEE> nodes = new ArrayList<FunctionDefinitionNodeEE>();
        try {
            DomainSubtreeRoot treeRoot = this.getDomainSubtreeRoot();
            boolean showArchived = EnterpriseExtensionsDomainRegistry.getInstance().getArchivefilterListener().isShowArchived();
            systemDefinitions = client.findSystemDefinitions(IFunctionDefinition.ITEM_TYPE, projectAreaHandle, -1, showArchived, Arrays.asList(ISystemDefinition.SMALL_PROFILE), monitor);
            for (ISystemDefinition systemDefinition : systemDefinitions) {
                nodes.add(new FunctionDefinitionNodeEE(projectAreaHandle, systemDefinition, treeRoot, this));
            }
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        this.setElements(nodes);
        collector.add(nodes.toArray(), monitor);
    }

    private final SystemDefinitionJob getFetchFunctionDefinitionJob(final FunctionDefinitionNodeEE element) {
        return new SystemDefinitionJob(NLS.bind((String)Messages.FunctionDefinitionsNodeEE_Action_Refresh, (Object)element.getLabel()), true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)FunctionDefinitionsNodeEE.this.getTeamRepository());
                ISystemDefinition systemDefinition = client.fetchSystemDefinition((ISystemDefinitionHandle)element.getSystemDefinition(), Arrays.asList(ISystemDefinition.SMALL_PROFILE), monitor);
                if (systemDefinition != null) {
                    element.setFunctionDefinition(systemDefinition);
                    FunctionDefinitionsNodeEE.this.refreshNode(element);
                }
                return Status.OK_STATUS;
            }
        };
    }

    public List<FunctionDefinitionNodeEE> getElements() {
        return this.elements;
    }

    public final Image getIcon() {
        return SmpeUIPlugin.getImage("icons/obj16/functions_obj.gif");
    }

    public final String getLabel() {
        return Messages.FunctionDefinitionsNodeEE_Label_FunctionDefinitions;
    }

    public final Set<String> getPackagingFunctionIds() {
        return this.versionDefinitionsNodeEE.getPackagingFunctionIds();
    }

    public final Set<String> getPackagingFunctionNames() {
        return this.versionDefinitionsNodeEE.getPackagingFunctionNames();
    }

    public final List<IFunctionDefinition> getPackagingFunctions() {
        return this.versionDefinitionsNodeEE.getPackagingFunctions();
    }

    public final boolean hasChildren() {
        return true;
    }

    public final boolean isVisible() {
        try {
            if (!ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getTeamRepository()).isSMPEEnabled(null)) {
                return false;
            }
        }
        catch (TeamRepositoryException e) {
            SmpeUIPlugin.log(e);
            return false;
        }
        return super.isVisible();
    }

    public final boolean refresh() {
        return super.refresh();
    }

    private final void refreshNode(final FunctionDefinitionNodeEE element) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (FunctionDefinitionsNodeEE.this.getViewer() != null && !FunctionDefinitionsNodeEE.this.getViewer().getControl().isDisposed()) {
                    ((TreeViewer)FunctionDefinitionsNodeEE.this.getViewer()).refresh((Object)element);
                }
            }
        });
    }

    public void refreshNode(ISystemDefinition systemDefinition) {
        for (FunctionDefinitionNodeEE element : this.getElements()) {
            if (!element.getSystemDefinition().sameItemId((IItemHandle)systemDefinition)) continue;
            element.setFunctionDefinition(systemDefinition);
            this.refreshNode(element);
            break;
        }
    }

    public void setElements(List<FunctionDefinitionNodeEE> elements) {
        this.elements = elements;
    }

    public final void setPackagingFunctions(List<IFunctionDefinition> packagingFunctions) {
        this.versionDefinitionsNodeEE.setPackagingFunctions(packagingFunctions);
    }
}

