/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.dialogs;

import com.ibm.team.enterprise.smpe.ui.elements.FunctionDefinitionLabelProvider;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.common.model.IFmidItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.util.ListContentProvider;
import com.ibm.team.repository.common.IItemHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class VersionDefinitionAddFunctionDialog
extends TrayDialog {
    private static final int tableItemMinimum = 10;
    private final FormToolkit toolkit;
    private final IVersionDefinition packagingVersion;
    private IFunctionDefinition packagingFunction;
    private final List<IFunctionDefinition> filteredFunctions;
    private final List<IFunctionDefinition> packagingFunctions;
    protected Table table;
    protected TableColumn idColumn;
    protected TableColumn nameColumn;
    protected TableViewer tableViewerProperties;

    public VersionDefinitionAddFunctionDialog(Shell parent, FormToolkit toolkit, IVersionDefinition packagingVersion, List<IFunctionDefinition> packagingFunctions) {
        super(parent);
        this.toolkit = toolkit;
        this.packagingVersion = packagingVersion;
        this.packagingFunctions = packagingFunctions;
        this.filteredFunctions = new ArrayList<IFunctionDefinition>(this.packagingFunctions);
        this.setFilteredFunctions();
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.VersionDefinition_AddFunctionDialog_Title);
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        Button button = this.getButton(0);
        button.setEnabled(false);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 64);
        GridData gridData = new GridData(768);
        gridData.widthHint = 400;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.VersionDefinition_AddFunctionDialog_Description);
        Composite tableComposite = this.toolkit.createComposite(composite);
        GridData tableGrid = new GridData(4, 4, true, true);
        this.table = this.toolkit.createTable(tableComposite, 66304);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.toolkit.setBorderStyle(2048);
        tableGrid.heightHint = this.table.getItemHeight() * 10;
        tableComposite.setLayoutData((Object)tableGrid);
        tableComposite.setLayout((Layout)new FillLayout());
        TableColumnLayout tableLayout = new TableColumnLayout();
        this.idColumn = new TableColumn(this.table, 0);
        this.idColumn.setText(Messages.VersionDefinition_AddFunctionDialog_Table_Column_Id);
        tableLayout.setColumnData((Widget)this.idColumn, (ColumnLayoutData)new ColumnWeightData(20, true));
        this.nameColumn = new TableColumn(this.table, 0);
        this.nameColumn.setText(Messages.VersionDefinition_AddFunctionDialog_Table_Column_Name);
        tableLayout.setColumnData((Widget)this.nameColumn, (ColumnLayoutData)new ColumnWeightData(80, true));
        tableComposite.setLayout((Layout)tableLayout);
        Listener sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn column = (TableColumn)event.widget;
                if (column == VersionDefinitionAddFunctionDialog.this.idColumn) {
                    Collections.sort(VersionDefinitionAddFunctionDialog.this.filteredFunctions, new Comparator<IFunctionDefinition>(){

                        @Override
                        public int compare(IFunctionDefinition o1, IFunctionDefinition o2) {
                            String label1 = o1.getId();
                            String label2 = o2.getId();
                            return label1.compareTo(label2);
                        }
                    });
                }
                if (column == VersionDefinitionAddFunctionDialog.this.nameColumn) {
                    Collections.sort(VersionDefinitionAddFunctionDialog.this.filteredFunctions, new Comparator<IFunctionDefinition>(){

                        @Override
                        public int compare(IFunctionDefinition o1, IFunctionDefinition o2) {
                            String label1 = o1.getName();
                            String label2 = o2.getName();
                            return label1.compareTo(label2);
                        }
                    });
                }
                VersionDefinitionAddFunctionDialog.this.table.setSortColumn(column);
                VersionDefinitionAddFunctionDialog.this.tableViewerProperties.refresh();
            }
        };
        this.idColumn.addListener(13, sortListener);
        this.nameColumn.addListener(13, sortListener);
        this.tableViewerProperties = new TableViewer(this.table);
        this.tableViewerProperties.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewerProperties.setLabelProvider((IBaseLabelProvider)new FunctionDefinitionLabelProvider());
        this.tableViewerProperties.setInput(this.filteredFunctions);
        this.tableViewerProperties.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VersionDefinitionAddFunctionDialog.this.setFunctionSelected();
            }
        });
        this.tableViewerProperties.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                VersionDefinitionAddFunctionDialog.this.setFunctionSelected();
                VersionDefinitionAddFunctionDialog.this.buttonPressed(0);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.enterprise.smpe.ui.dialog_versiondefinitionaddfunction");
        return composite;
    }

    public IFunctionDefinition getFunctionSelected() {
        return this.packagingFunction;
    }

    private void setFilteredFunctions() {
        block0: for (IFmidItemDefinition packagingFmidItem : this.packagingVersion.getFmidItems()) {
            for (IFunctionDefinition packagingFunction : this.filteredFunctions) {
                if (!packagingFmidItem.getFunction().sameItemId((IItemHandle)packagingFunction)) continue;
                this.filteredFunctions.remove(packagingFunction);
                continue block0;
            }
        }
    }

    private void setFunctionSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewerProperties.getSelection();
        this.packagingFunction = (IFunctionDefinition)selection.getFirstElement();
        Button button = this.getButton(0);
        if (this.packagingFunction != null) {
            button.setEnabled(true);
        } else {
            button.setEnabled(false);
        }
    }
}

