/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.dialogs;

import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.common.ui.IDialogItem;
import com.ibm.team.enterprise.common.ui.elements.DialogButtonItemClear;
import com.ibm.team.enterprise.common.ui.elements.DialogComboItemClear;
import com.ibm.team.enterprise.common.ui.elements.DialogSpinnerItemClear;
import com.ibm.team.enterprise.common.ui.elements.DialogTextItem;
import com.ibm.team.enterprise.common.ui.elements.DialogTextItemBandC;
import com.ibm.team.enterprise.common.ui.elements.DialogTextItemClear;
import com.ibm.team.enterprise.common.ui.util.GridTools;
import com.ibm.team.enterprise.smpe.ui.dialogs.DataSetDefinitionSelectionDialog;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.cache.ICacheItem;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheFactory;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.Packaging;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingDetailLanguage;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.Id;
import com.ibm.team.enterprise.systemdefinition.common.model.Mcstype;
import com.ibm.team.enterprise.systemdefinition.common.model.Processor;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingDetail;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingProperties;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.NarrowTitleAreaDialog;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PackagingDetailsDialog
extends NarrowTitleAreaDialog {
    private static final int MinimumDialogW = 324;
    private static final int MinimumDialogH = 150;
    private static final int SWG_WIDTH_COMBO = 160;
    private static final int SWG_WIDTH_FIELD = 175;
    private static final int SWG_WIDTH_LABEL = 160;
    private static final int SWG_HEIGHT = 20;
    private static final int Relfile_Minimum = 0;
    private static final int Relfile_Maximum = 999;
    private static final int Relfile_Increment = 1;
    private static final int Relfile_TextLimit = 4;
    private static final String binaryLabel = Messages.PackagingDetails_Dialog_Label_Binary;
    private static final String descriptionLabel = Messages.PackagingDetails_Dialog_Label_Description;
    private static final String distlibLabel = Messages.PackagingDetails_Dialog_Label_Distlib;
    private static final String distnameLabel = Messages.PackagingDetails_Dialog_Label_Distname;
    private static final String extensionLabel = Messages.PackagingDetails_Dialog_Label_Extension;
    private static final String fmidoverrideLabel = Messages.PackagingDetails_Dialog_Label_Fmidoverride;
    private static final String folderLabel = Messages.PackagingDetails_Dialog_Label_Folder;
    private static final String idLabel = Messages.PackagingDetails_Dialog_Label_Id;
    private static final String locationLabel = Messages.PackagingDetails_Dialog_Label_Location;
    private static final String nameLabel = Messages.PackagingDetails_Dialog_Label_Name;
    private static final String mcstypeLabel = Messages.PackagingDetails_Dialog_Label_Mcstype;
    private static final String processLabel = Messages.PackagingDetails_Dialog_Label_Process;
    private static final String relfileOverrideLabel = Messages.PackagingDetails_Dialog_Label_RelfileOverride;
    private static final String shipaliasLabel = Messages.PackagingDetails_Dialog_Label_Shipalias;
    private static final String syslibLabel = Messages.PackagingDetails_Dialog_Label_Syslib;
    private final boolean allowNameUpdate;
    private final boolean includeFileData;
    private final Shell parentShell;
    private final ITeamRepository teamRepository;
    private final IProjectArea projectArea;
    private final ILanguageDefinition languageDefinition;
    private final ISystemDefinitionCache systemDefinitionCache;
    private final List<IFunctionDefinition> packagingFunctions;
    private final String[] packagingFunctionItems;
    private final IPackagingDetail packagingDetail;
    private final List<String> packagingDetailNames;
    private final String title;
    private Composite parent;
    private DialogTextItemBandC distlibItem;
    private DialogTextItemBandC locationItem;
    private DialogTextItemBandC syslibItem;
    private DialogButtonItemClear binaryItem;
    private DialogComboItemClear fmidoverrideItem;
    private DialogComboItemClear idItem;
    private DialogComboItemClear mcstypeItem;
    private DialogComboItemClear processItem;
    private DialogSpinnerItemClear relfileOverrideItem;
    private DialogTextItem nameItem;
    private DialogTextItemClear descriptionItem;
    private DialogTextItemClear distnameItem;
    private DialogTextItemClear extensionItem;
    private DialogTextItemClear folderItem;
    private DialogTextItemClear shipaliasItem;

    public PackagingDetailsDialog(Shell parentShell, ITeamRepository teamRepository, IProjectArea projectArea, ILanguageDefinition languageDefinition, ISystemDefinitionCache systemDefinitionCache, List<IFunctionDefinition> packagingFunctions, String[] packagingFunctionItems, IPackagingDetail original, List<String> packagingDetailNames, String title) {
        super(parentShell, 324, 150);
        this.parentShell = parentShell;
        this.teamRepository = teamRepository;
        this.projectArea = projectArea;
        this.languageDefinition = languageDefinition;
        this.systemDefinitionCache = systemDefinitionCache;
        this.packagingFunctions = packagingFunctions;
        this.packagingFunctionItems = packagingFunctionItems;
        this.packagingDetail = original.newCopy();
        this.packagingDetailNames = packagingDetailNames;
        this.title = title;
        this.includeFileData = false;
        this.allowNameUpdate = original instanceof PackagingDetailLanguage || original.isNewItem();
    }

    public PackagingDetailsDialog(Shell parentShell, ITeamRepository teamRepository, IProjectArea projectArea, ILanguageDefinition languageDefinition, ISystemDefinitionCache systemDefinitionCache, List<IFunctionDefinition> packagingFunctions, String[] packagingFunctionItems, IPackagingDetail original, List<String> packagingDetailNames, String title, boolean includeFileData) {
        super(parentShell, 324, 150);
        this.parentShell = parentShell;
        this.teamRepository = teamRepository;
        this.projectArea = projectArea;
        this.languageDefinition = languageDefinition;
        this.systemDefinitionCache = systemDefinitionCache;
        this.packagingFunctions = packagingFunctions;
        this.packagingFunctionItems = packagingFunctionItems;
        this.packagingDetail = original.newCopy();
        this.packagingDetailNames = packagingDetailNames;
        this.title = title;
        this.includeFileData = includeFileData;
        this.allowNameUpdate = original instanceof PackagingDetailLanguage || original.isNewItem();
    }

    protected Control createDialogArea(Composite parent) {
        FormToolkit toolkit = new FormToolkit(Display.getDefault());
        toolkit.setBackground(null);
        this.parent = parent;
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(4, false));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        composite.setLayoutData((Object)gridData);
        this.setTitle(this.title);
        this.setMessage(Messages.PackagingDetails_Dialog_Title_Message);
        Composite itemComposite = new Composite(composite, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        itemComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginTop = 5;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 8;
        gridLayout.verticalSpacing = 5;
        itemComposite.setLayout((Layout)gridLayout);
        this.nameItem = this.createTextItem(itemComposite, nameLabel, this.packagingDetail.getName());
        this.descriptionItem = this.createTextItemClear(itemComposite, descriptionLabel, this.packagingDetail.getDescription());
        this.idItem = this.createComboboxItem(itemComposite, idLabel, Id.getLabels(), Id.getIndex((Id)this.packagingDetail.getId()));
        this.mcstypeItem = this.createComboboxItem(itemComposite, mcstypeLabel, Mcstype.getLabels(), Mcstype.getIndex((Mcstype)this.packagingDetail.getMcstype()));
        this.processItem = this.createComboboxItem(itemComposite, processLabel, Processor.getLabels(), Processor.getIndex((Processor)this.packagingDetail.getProcessor()));
        this.binaryItem = this.createCheckboxItem(itemComposite, binaryLabel, this.packagingDetail.isBinary());
        if (this.includeFileData) {
            this.relfileOverrideItem = this.createSpinnerItemClear(itemComposite, relfileOverrideLabel, 0, 999, 1, 4, this.packagingDetail.getRelfileOverride());
        }
        this.fmidoverrideItem = this.createComboboxItem(itemComposite, fmidoverrideLabel, this.packagingFunctionItems, Packaging.getFunctionIndex(this.packagingFunctions, (IFunctionDefinitionHandle)this.packagingDetail.getFmidoverride()));
        this.extensionItem = this.createTextItemClear(itemComposite, extensionLabel, this.packagingDetail.getExtension());
        this.folderItem = this.createTextItemClear(itemComposite, folderLabel, this.packagingDetail.getFolder());
        if (this.includeFileData) {
            this.distnameItem = this.createTextItemClear(itemComposite, distnameLabel, this.packagingDetail.getDistname());
            this.shipaliasItem = this.createTextItemClear(itemComposite, shipaliasLabel, this.packagingDetail.getShipalias());
        }
        Composite browseComposite = new Composite(composite, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        browseComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(4, false);
        gridLayout.marginBottom = 5;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 8;
        gridLayout.verticalSpacing = 5;
        browseComposite.setLayout((Layout)gridLayout);
        this.locationItem = this.createBrowseItem(browseComposite, locationLabel, this.getDatasetName(this.packagingDetail.getLocation()));
        this.distlibItem = this.createBrowseItem(browseComposite, distlibLabel, this.getDatasetName(this.packagingDetail.getDistlib()));
        this.syslibItem = this.createBrowseItem(browseComposite, syslibLabel, this.getDatasetName(this.packagingDetail.getSyslib()));
        if (this.allowNameUpdate) {
            this.nameItem.item.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    PackagingDetailsDialog.this.packagingDetail.setName(((PackagingDetailsDialog)PackagingDetailsDialog.this).nameItem.item.getText().trim());
                    PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).nameItem.deco, null);
                }
            });
        } else {
            this.nameItem.item.setEditable(false);
        }
        this.descriptionItem.mlnr = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PackagingDetailsDialog.this.packagingDetail.setDescription(((PackagingDetailsDialog)PackagingDetailsDialog.this).descriptionItem.item.getText().trim());
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).descriptionItem.deco, null);
            }
        };
        this.descriptionItem.item.addModifyListener(this.descriptionItem.mlnr);
        this.descriptionItem.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingDetailsDialog.this.packagingDetail.unsetDescription();
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).descriptionItem.item.removeModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).descriptionItem.mlnr);
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).descriptionItem.item.setText(PackagingDetailsDialog.this.packagingDetail.getDescription());
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).descriptionItem.item.addModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).descriptionItem.mlnr);
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).descriptionItem.deco, null);
            }
        });
        this.idItem.mlnr = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PackagingDetailsDialog.this.packagingDetail.setId(Id.getArray()[((PackagingDetailsDialog)PackagingDetailsDialog.this).idItem.item.getSelectionIndex()]);
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).idItem.deco, null);
            }
        };
        this.idItem.item.addModifyListener(this.idItem.mlnr);
        this.idItem.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingDetailsDialog.this.packagingDetail.unsetId();
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).idItem.item.removeModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).idItem.mlnr);
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).idItem.item.select(Id.getIndex((Id)PackagingDetailsDialog.this.packagingDetail.getId()));
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).idItem.item.addModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).idItem.mlnr);
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).idItem.deco, null);
            }
        });
        this.mcstypeItem.mlnr = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PackagingDetailsDialog.this.packagingDetail.setMcstype(Mcstype.getArray()[((PackagingDetailsDialog)PackagingDetailsDialog.this).mcstypeItem.item.getSelectionIndex()]);
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).mcstypeItem.deco, null);
            }
        };
        this.mcstypeItem.item.addModifyListener(this.mcstypeItem.mlnr);
        this.mcstypeItem.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingDetailsDialog.this.packagingDetail.unsetMcstype();
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).mcstypeItem.item.removeModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).mcstypeItem.mlnr);
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).mcstypeItem.item.select(Mcstype.getIndex((Mcstype)PackagingDetailsDialog.this.packagingDetail.getMcstype()));
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).mcstypeItem.item.addModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).mcstypeItem.mlnr);
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).mcstypeItem.deco, null);
            }
        });
        this.processItem.mlnr = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PackagingDetailsDialog.this.packagingDetail.setProcessor(Processor.getArray()[((PackagingDetailsDialog)PackagingDetailsDialog.this).processItem.item.getSelectionIndex()]);
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).processItem.deco, null);
            }
        };
        this.processItem.item.addModifyListener(this.processItem.mlnr);
        this.processItem.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingDetailsDialog.this.packagingDetail.unsetProcessor();
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).processItem.item.removeModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).processItem.mlnr);
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).processItem.item.select(Processor.getIndex((Processor)PackagingDetailsDialog.this.packagingDetail.getProcessor()));
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).processItem.item.addModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).processItem.mlnr);
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).processItem.deco, null);
            }
        });
        this.binaryItem.slnr = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingDetailsDialog.this.packagingDetail.setBinary(Boolean.valueOf(((PackagingDetailsDialog)PackagingDetailsDialog.this).binaryItem.item.getSelection()));
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).binaryItem.deco, null);
            }
        };
        this.binaryItem.item.addSelectionListener(this.binaryItem.slnr);
        this.binaryItem.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingDetailsDialog.this.packagingDetail.unsetBinary();
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).binaryItem.item.removeSelectionListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).binaryItem.slnr);
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).binaryItem.item.setSelection(PackagingDetailsDialog.this.packagingDetail.isBinary());
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).binaryItem.item.addSelectionListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).binaryItem.slnr);
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).binaryItem.deco, null);
            }
        });
        if (this.includeFileData) {
            this.relfileOverrideItem.mlnr = new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    if (((PackagingDetailsDialog)PackagingDetailsDialog.this).relfileOverrideItem.item.getSelection() > 0) {
                        PackagingDetailsDialog.this.packagingDetail.setRelfileOverride(Integer.valueOf(((PackagingDetailsDialog)PackagingDetailsDialog.this).relfileOverrideItem.item.getSelection()));
                    } else {
                        PackagingDetailsDialog.this.packagingDetail.setRelfileOverride(IPackagingProperties.EDEFAULT_FILEDETAIL_RELFILEOVERRIDE);
                    }
                    PackagingDetailsDialog.this.setRelfileOverrideItemForeGround();
                    PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).relfileOverrideItem.deco, null);
                }
            };
            this.relfileOverrideItem.item.addModifyListener(this.relfileOverrideItem.mlnr);
            this.relfileOverrideItem.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PackagingDetailsDialog.this.packagingDetail.setRelfileOverride(IPackagingProperties.EDEFAULT_FILEDETAIL_RELFILEOVERRIDE);
                    ((PackagingDetailsDialog)PackagingDetailsDialog.this).relfileOverrideItem.item.removeModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).relfileOverrideItem.mlnr);
                    ((PackagingDetailsDialog)PackagingDetailsDialog.this).relfileOverrideItem.item.setSelection(0);
                    ((PackagingDetailsDialog)PackagingDetailsDialog.this).relfileOverrideItem.item.addModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).relfileOverrideItem.mlnr);
                    PackagingDetailsDialog.this.setRelfileOverrideItemForeGround();
                    PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).relfileOverrideItem.deco, null);
                }
            });
        }
        this.fmidoverrideItem.mlnr = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PackagingDetailsDialog.this.packagingDetail.setFmidoverride(Packaging.getFunctionValue((List)PackagingDetailsDialog.this.packagingFunctions, (int)((PackagingDetailsDialog)PackagingDetailsDialog.this).fmidoverrideItem.item.getSelectionIndex()));
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).fmidoverrideItem.deco, null);
            }
        };
        this.fmidoverrideItem.item.addModifyListener(this.fmidoverrideItem.mlnr);
        this.fmidoverrideItem.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingDetailsDialog.this.packagingDetail.unsetFmidoverride();
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).fmidoverrideItem.item.removeModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).fmidoverrideItem.mlnr);
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).fmidoverrideItem.item.select(Packaging.getFunctionIndex((List)PackagingDetailsDialog.this.packagingFunctions, (IFunctionDefinitionHandle)PackagingDetailsDialog.this.packagingDetail.getFmidoverride()));
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).fmidoverrideItem.item.addModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).fmidoverrideItem.mlnr);
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).fmidoverrideItem.deco, null);
            }
        });
        this.extensionItem.mlnr = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PackagingDetailsDialog.this.packagingDetail.setExtension(((PackagingDetailsDialog)PackagingDetailsDialog.this).extensionItem.item.getText().trim());
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).extensionItem.deco, null);
            }
        };
        this.extensionItem.item.addModifyListener(this.extensionItem.mlnr);
        this.extensionItem.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingDetailsDialog.this.packagingDetail.unsetExtension();
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).extensionItem.item.removeModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).extensionItem.mlnr);
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).extensionItem.item.setText(PackagingDetailsDialog.this.packagingDetail.getExtension());
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).extensionItem.item.addModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).extensionItem.mlnr);
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).extensionItem.deco, null);
            }
        });
        this.folderItem.mlnr = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PackagingDetailsDialog.this.packagingDetail.setFolder(((PackagingDetailsDialog)PackagingDetailsDialog.this).folderItem.item.getText().trim());
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).folderItem.deco, null);
            }
        };
        this.folderItem.item.addModifyListener(this.folderItem.mlnr);
        this.folderItem.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingDetailsDialog.this.packagingDetail.unsetFolder();
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).folderItem.item.removeModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).folderItem.mlnr);
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).folderItem.item.setText(PackagingDetailsDialog.this.packagingDetail.getFolder());
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).folderItem.item.addModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).folderItem.mlnr);
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).folderItem.deco, null);
            }
        });
        if (this.includeFileData) {
            this.distnameItem.mlnr = new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    PackagingDetailsDialog.this.packagingDetail.setDistname(((PackagingDetailsDialog)PackagingDetailsDialog.this).distnameItem.item.getText().trim());
                    PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).distnameItem.deco, null);
                }
            };
            this.distnameItem.item.addModifyListener(this.distnameItem.mlnr);
            this.distnameItem.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PackagingDetailsDialog.this.packagingDetail.unsetDistname();
                    ((PackagingDetailsDialog)PackagingDetailsDialog.this).distnameItem.item.removeModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).distnameItem.mlnr);
                    ((PackagingDetailsDialog)PackagingDetailsDialog.this).distnameItem.item.setText(PackagingDetailsDialog.this.packagingDetail.getDistname());
                    ((PackagingDetailsDialog)PackagingDetailsDialog.this).distnameItem.item.addModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).distnameItem.mlnr);
                    PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).distnameItem.deco, null);
                }
            });
            this.shipaliasItem.mlnr = new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    PackagingDetailsDialog.this.packagingDetail.setShipalias(((PackagingDetailsDialog)PackagingDetailsDialog.this).shipaliasItem.item.getText().trim());
                    PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).shipaliasItem.deco, null);
                }
            };
            this.shipaliasItem.item.addModifyListener(this.shipaliasItem.mlnr);
            this.shipaliasItem.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PackagingDetailsDialog.this.packagingDetail.unsetShipalias();
                    ((PackagingDetailsDialog)PackagingDetailsDialog.this).shipaliasItem.item.removeModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).shipaliasItem.mlnr);
                    ((PackagingDetailsDialog)PackagingDetailsDialog.this).shipaliasItem.item.setText(PackagingDetailsDialog.this.packagingDetail.getShipalias());
                    ((PackagingDetailsDialog)PackagingDetailsDialog.this).shipaliasItem.item.addModifyListener(((PackagingDetailsDialog)PackagingDetailsDialog.this).shipaliasItem.mlnr);
                    PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).shipaliasItem.deco, null);
                }
            });
        }
        this.locationItem.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingDetailsDialog.this.editDsDefLocation();
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).locationItem.deco, null);
            }
        });
        this.locationItem.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingDetailsDialog.this.packagingDetail.unsetLocation();
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).locationItem.item.setText(PackagingDetailsDialog.this.getDatasetName(PackagingDetailsDialog.this.packagingDetail.getLocation()));
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).locationItem.deco, null);
            }
        });
        this.distlibItem.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingDetailsDialog.this.editDsDefDistlib();
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).distlibItem.deco, null);
            }
        });
        this.distlibItem.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingDetailsDialog.this.packagingDetail.unsetDistlib();
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).distlibItem.item.setText(PackagingDetailsDialog.this.getDatasetName(PackagingDetailsDialog.this.packagingDetail.getDistlib()));
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).distlibItem.deco, null);
            }
        });
        this.syslibItem.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingDetailsDialog.this.editDsDefSyslib();
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).syslibItem.deco, null);
            }
        });
        this.syslibItem.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingDetailsDialog.this.packagingDetail.unsetSyslib();
                ((PackagingDetailsDialog)PackagingDetailsDialog.this).syslibItem.item.setText(PackagingDetailsDialog.this.getDatasetName(PackagingDetailsDialog.this.packagingDetail.getSyslib()));
                PackagingDetailsDialog.this.setItemMessage(((PackagingDetailsDialog)PackagingDetailsDialog.this).syslibItem.deco, null);
            }
        });
        this.nameItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(PackagingDetailsDialog.this.parentShell, 36);
                helpDialog.setText(Messages.PackagingDetails_Dialog_HelpLbl_Name);
                helpDialog.setMessage(Messages.PackagingDetails_Dialog_HelpTxt_Name);
                helpDialog.open();
            }
        });
        this.descriptionItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(PackagingDetailsDialog.this.parentShell, 36);
                helpDialog.setText(Messages.PackagingDetails_Dialog_HelpLbl_Description);
                helpDialog.setMessage(Messages.PackagingDetails_Dialog_HelpTxt_Description);
                helpDialog.open();
            }
        });
        this.idItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(PackagingDetailsDialog.this.parentShell, 36);
                helpDialog.setText(Messages.PackagingDetails_Dialog_HelpLbl_Id);
                helpDialog.setMessage(Messages.PackagingDetails_Dialog_HelpTxt_Id);
                helpDialog.open();
            }
        });
        this.mcstypeItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(PackagingDetailsDialog.this.parentShell, 36);
                helpDialog.setText(Messages.PackagingDetails_Dialog_HelpLbl_Parttype);
                helpDialog.setMessage(Messages.PackagingDetails_Dialog_HelpTxt_Parttype);
                helpDialog.open();
            }
        });
        this.processItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(PackagingDetailsDialog.this.parentShell, 36);
                helpDialog.setText(Messages.PackagingDetails_Dialog_HelpLbl_Process);
                helpDialog.setMessage(Messages.PackagingDetails_Dialog_HelpTxt_Process);
                helpDialog.open();
            }
        });
        this.binaryItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(PackagingDetailsDialog.this.parentShell, 36);
                helpDialog.setText(Messages.PackagingDetails_Dialog_HelpLbl_Binary);
                helpDialog.setMessage(Messages.PackagingDetails_Dialog_HelpTxt_Binary);
                helpDialog.open();
            }
        });
        if (this.includeFileData) {
            this.relfileOverrideItem.item.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent event) {
                    MessageBox helpDialog = new MessageBox(PackagingDetailsDialog.this.parentShell, 36);
                    helpDialog.setText(Messages.PackagingDetails_Dialog_HelpLbl_RelfileOverride);
                    helpDialog.setMessage(Messages.PackagingDetails_Dialog_HelpTxt_RelfileOverride);
                    helpDialog.open();
                }
            });
        }
        this.fmidoverrideItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(PackagingDetailsDialog.this.parentShell, 36);
                helpDialog.setText(Messages.PackagingDetails_Dialog_HelpLbl_Fmidoverride);
                helpDialog.setMessage(Messages.PackagingDetails_Dialog_HelpTxt_Fmidoverride);
                helpDialog.open();
            }
        });
        this.extensionItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(PackagingDetailsDialog.this.parentShell, 36);
                helpDialog.setText(Messages.PackagingDetails_Dialog_HelpLbl_Extension);
                helpDialog.setMessage(Messages.PackagingDetails_Dialog_HelpTxt_Extension);
                helpDialog.open();
            }
        });
        this.folderItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(PackagingDetailsDialog.this.parentShell, 36);
                helpDialog.setText(Messages.PackagingDetails_Dialog_HelpLbl_Folder);
                helpDialog.setMessage(Messages.PackagingDetails_Dialog_HelpTxt_Folder);
                helpDialog.open();
            }
        });
        if (this.includeFileData) {
            this.distnameItem.item.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent event) {
                    MessageBox helpDialog = new MessageBox(PackagingDetailsDialog.this.parentShell, 36);
                    helpDialog.setText(Messages.PackagingDetails_Dialog_HelpLbl_Distname);
                    helpDialog.setMessage(Messages.PackagingDetails_Dialog_HelpTxt_Distname);
                    helpDialog.open();
                }
            });
            this.shipaliasItem.item.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent event) {
                    MessageBox helpDialog = new MessageBox(PackagingDetailsDialog.this.parentShell, 36);
                    helpDialog.setText(Messages.PackagingDetails_Dialog_HelpLbl_Shipalias);
                    helpDialog.setMessage(Messages.PackagingDetails_Dialog_HelpTxt_Shipalias);
                    helpDialog.open();
                }
            });
        }
        this.locationItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(PackagingDetailsDialog.this.parentShell, 36);
                helpDialog.setText(Messages.PackagingDetails_Dialog_HelpLbl_Location);
                helpDialog.setMessage(Messages.PackagingDetails_Dialog_HelpTxt_Location);
                helpDialog.open();
            }
        });
        this.distlibItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(PackagingDetailsDialog.this.parentShell, 36);
                helpDialog.setText(Messages.PackagingDetails_Dialog_HelpLbl_Distlib);
                helpDialog.setMessage(Messages.PackagingDetails_Dialog_HelpTxt_Distlib);
                helpDialog.open();
            }
        });
        this.syslibItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(PackagingDetailsDialog.this.parentShell, 36);
                helpDialog.setText(Messages.PackagingDetails_Dialog_HelpLbl_Syslib);
                helpDialog.setMessage(Messages.PackagingDetails_Dialog_HelpTxt_Syslib);
                helpDialog.open();
            }
        });
        PackagingDetailsDialog.applyDialogFont((Control)itemComposite);
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.PackagingDetails_Dialog_Title);
    }

    protected DialogTextItemBandC createBrowseItem(Composite composite, String label, String value) {
        DialogTextItemBandC dialogItem = new DialogTextItemBandC();
        dialogItem.label = new Label(composite, 0);
        dialogItem.label.setText(label);
        GridDataFactory.fillDefaults().hint(160, -1).align(1, 0x1000000).applyTo((Control)dialogItem.label);
        dialogItem.item = new Text(composite, 18436);
        dialogItem.item.setText(value);
        dialogItem.item.setEditable(false);
        dialogItem.item.setBackground(Display.getCurrent().getSystemColor(1));
        GridDataFactory.fillDefaults().hint(175, -1).applyTo((Control)dialogItem.item);
        dialogItem.browse = new Button(composite, 0x800008);
        dialogItem.browse.setText(DialogTextItemBandC.BrowseLabel);
        GridDataFactory.fillDefaults().hint(-1, dialogItem.browse.computeSize((int)10, (int)10).y).applyTo((Control)dialogItem.browse);
        dialogItem.clear = new Button(composite, 0x800008);
        dialogItem.clear.setImage(DialogTextItemBandC.ClearImage);
        GridDataFactory.fillDefaults().hint(-1, dialogItem.clear.computeSize((int)10, (int)10).y).applyTo((Control)dialogItem.clear);
        dialogItem.deco = new ControlDecoration((Control)dialogItem.item, 16512, composite);
        return dialogItem;
    }

    protected DialogButtonItemClear createCheckboxItem(Composite composite, String itemLabel, Boolean value) {
        DialogButtonItemClear dialogItem = new DialogButtonItemClear();
        dialogItem.label = new Label(composite, 0);
        dialogItem.label.setText(itemLabel);
        GridDataFactory.fillDefaults().hint(160, 22).applyTo((Control)dialogItem.label);
        dialogItem.item = new Button(composite, 0x800020);
        dialogItem.item.setSelection(value.booleanValue());
        GridDataFactory.fillDefaults().hint(160, 22).applyTo((Control)dialogItem.item);
        dialogItem.clear = new Button(composite, 0x800008);
        dialogItem.clear.setImage(IDialogItem.ClearImage);
        GridDataFactory.fillDefaults().hint(-1, 22).applyTo((Control)dialogItem.clear);
        GridTools.createPlaceholder((Composite)composite);
        dialogItem.deco = new ControlDecoration((Control)dialogItem.item, 16512, composite);
        return dialogItem;
    }

    protected DialogComboItemClear createComboboxItem(Composite composite, String itemLabel, String[] values, Integer index) {
        DialogComboItemClear dialogItem = new DialogComboItemClear();
        dialogItem.label = new Label(composite, 0);
        dialogItem.label.setText(itemLabel);
        GridDataFactory.fillDefaults().hint(160, 20).align(1, 0x1000000).applyTo((Control)dialogItem.label);
        dialogItem.item = new Combo(composite, 8);
        dialogItem.item.setItems(values);
        dialogItem.item.select(index.intValue());
        GridDataFactory.fillDefaults().hint(160, 20).applyTo((Control)dialogItem.item);
        dialogItem.clear = new Button(composite, 0x800008);
        dialogItem.clear.setImage(IDialogItem.ClearImage);
        GridDataFactory.fillDefaults().hint(-1, dialogItem.clear.computeSize((int)10, (int)10).y).applyTo((Control)dialogItem.clear);
        GridTools.createPlaceholder((Composite)composite);
        dialogItem.deco = new ControlDecoration((Control)dialogItem.item, 16512, composite);
        return dialogItem;
    }

    protected DialogSpinnerItemClear createSpinnerItemClear(Composite composite, String label, int min, int max, int increment, Integer textLimit, Integer value) {
        DialogSpinnerItemClear dialogItem = new DialogSpinnerItemClear();
        dialogItem.label = new Label(composite, 0);
        dialogItem.label.setText(label);
        GridDataFactory.fillDefaults().hint(160, -1).applyTo((Control)dialogItem.label);
        dialogItem.item = new Spinner(composite, 2048);
        dialogItem.item.setMinimum(min);
        dialogItem.item.setMaximum(max);
        dialogItem.item.setIncrement(increment);
        if (value != null) {
            dialogItem.item.setSelection(value.intValue());
        }
        if (textLimit != null) {
            dialogItem.item.setTextLimit(textLimit.intValue());
        }
        if (dialogItem.item.getSelection() == min) {
            dialogItem.item.setForeground(dialogItem.item.getBackground());
        }
        dialogItem.clear = new Button(composite, 0x800008);
        dialogItem.clear.setImage(IDialogItem.ClearImage);
        GridDataFactory.fillDefaults().hint(-1, dialogItem.clear.computeSize((int)10, (int)10).y).applyTo((Control)dialogItem.clear);
        GridTools.createPlaceholder((Composite)composite);
        dialogItem.deco = new ControlDecoration((Control)dialogItem.item, 16512, composite);
        return dialogItem;
    }

    protected DialogTextItem createTextItem(Composite composite, String label, String value) {
        DialogTextItem dialogItem = new DialogTextItem();
        dialogItem.label = new Label(composite, 0);
        dialogItem.label.setText(label);
        GridDataFactory.fillDefaults().hint(160, -1).applyTo((Control)dialogItem.label);
        dialogItem.item = new Text(composite, 18436);
        dialogItem.item.setText(Verification.toNonNull((String)value));
        GridDataFactory.fillDefaults().hint(175, -1).applyTo((Control)dialogItem.item);
        GridTools.createPlaceholder((Composite)composite);
        GridTools.createPlaceholder((Composite)composite);
        dialogItem.deco = new ControlDecoration((Control)dialogItem.item, 16512, composite);
        return dialogItem;
    }

    protected DialogTextItemClear createTextItemClear(Composite composite, String label, String value) {
        DialogTextItemClear dialogItem = new DialogTextItemClear();
        dialogItem.label = new Label(composite, 0);
        dialogItem.label.setText(label);
        GridDataFactory.fillDefaults().hint(160, -1).applyTo((Control)dialogItem.label);
        dialogItem.item = new Text(composite, 18436);
        dialogItem.item.setText(Verification.toNonNull((String)value));
        GridDataFactory.fillDefaults().hint(175, -1).applyTo((Control)dialogItem.item);
        dialogItem.clear = new Button(composite, 0x800008);
        dialogItem.clear.setImage(IDialogItem.ClearImage);
        GridDataFactory.fillDefaults().hint(-1, dialogItem.clear.computeSize((int)10, (int)10).y).applyTo((Control)dialogItem.clear);
        GridTools.createPlaceholder((Composite)composite);
        dialogItem.deco = new ControlDecoration((Control)dialogItem.item, 16512, composite);
        return dialogItem;
    }

    private void editDsDefDistlib() {
        try {
            DataSetDefinitionSelectionDialog dialog = new DataSetDefinitionSelectionDialog(this.parent.getShell(), this.teamRepository, (IProjectAreaHandle)this.projectArea, this.getDataSetDefFilter(), Messages.PackagingDetails_Dialog_HelpDlg_DsDef, (List<Integer>)new ArrayList<Integer>(2){
                private static final long serialVersionUID = 1L;
                {
                    this.add(0);
                    this.add(1);
                }
            }, true, this.systemDefinitionCache);
            if (dialog.open() == 0) {
                IResourceDefinition dsdef = dialog.getSelectedDataDefinition();
                if (dsdef != null) {
                    this.packagingDetail.setDistlib((IDataSetDefinitionHandle)dsdef);
                }
                this.distlibItem.item.setText(this.getDatasetName(this.packagingDetail.getDistlib()));
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    private void editDsDefLocation() {
        try {
            DataSetDefinitionSelectionDialog dialog = new DataSetDefinitionSelectionDialog(this.parent.getShell(), this.teamRepository, (IProjectAreaHandle)this.projectArea, this.getDataSetDefFilter(), Messages.PackagingDetails_Dialog_HelpDlg_DsDef, (List<Integer>)new ArrayList<Integer>(2){
                private static final long serialVersionUID = 1L;
                {
                    this.add(0);
                    this.add(1);
                }
            }, true, this.systemDefinitionCache);
            if (dialog.open() == 0) {
                IResourceDefinition dsdef = dialog.getSelectedDataDefinition();
                if (dsdef != null) {
                    this.packagingDetail.setLocation((IDataSetDefinitionHandle)dsdef);
                }
                this.locationItem.item.setText(this.getDatasetName(this.packagingDetail.getLocation()));
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    private void editDsDefSyslib() {
        try {
            DataSetDefinitionSelectionDialog dialog = new DataSetDefinitionSelectionDialog(this.parent.getShell(), this.teamRepository, (IProjectAreaHandle)this.projectArea, this.getDataSetDefFilter(), Messages.PackagingDetails_Dialog_HelpDlg_DsDef, (List<Integer>)new ArrayList<Integer>(2){
                private static final long serialVersionUID = 1L;
                {
                    this.add(0);
                    this.add(1);
                }
            }, true, this.systemDefinitionCache);
            if (dialog.open() == 0) {
                IResourceDefinition dsdef = dialog.getSelectedDataDefinition();
                if (dsdef != null) {
                    this.packagingDetail.setSyslib((IDataSetDefinitionHandle)dsdef);
                }
                this.syslibItem.item.setText(this.getDatasetName(this.packagingDetail.getSyslib()));
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    private ViewerFilter getDataSetDefFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!(element instanceof IDataSetDefinition)) {
                    return true;
                }
                IDataSetDefinition dsd = (IDataSetDefinition)element;
                if (dsd.getUsageType() == 2) {
                    return false;
                }
                return dsd.getUsageType() != 3;
            }
        };
    }

    private String getDatasetName(IDataSetDefinitionHandle dataSetDefinitionHandle) {
        if (!Verification.isNonNull((Object)dataSetDefinitionHandle)) {
            return "";
        }
        String uuid = dataSetDefinitionHandle.getItemId().getUuidValue();
        ICacheItem datasetHandleCacheItem = ItemCacheFactory.getDatasetHandle((ITeamRepository)this.teamRepository, (IProjectAreaHandle)this.projectArea);
        if (datasetHandleCacheItem != null && datasetHandleCacheItem.containsUuid(uuid)) {
            return ((ISystemDefinition)datasetHandleCacheItem.getUuid(uuid)).getName();
        }
        ICacheItem datasetCacheItem = ItemCacheFactory.getDataset((ITeamRepository)this.teamRepository, (IProjectAreaHandle)this.projectArea);
        if (datasetCacheItem != null && datasetCacheItem.containsUuid(uuid)) {
            return ((IResourceDefinition)datasetCacheItem.getUuid(uuid)).getName();
        }
        try {
            UUID.valueOf((String)uuid);
        }
        catch (Exception e) {
            return Messages.PackagingDetails_LabelProvider_Error_Invalid;
        }
        try {
            IResourceDefinition resourceDefinition = ItemCacheFactory.addDataset((ITeamRepository)this.teamRepository, (IProjectAreaHandle)this.projectArea, (String)uuid);
            if (resourceDefinition != null) {
                return resourceDefinition.getName();
            }
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        return uuid;
    }

    public final IPackagingDetail getDialogObject() {
        return this.packagingDetail;
    }

    protected void okPressed() {
        boolean ok = true;
        if (!Verification.isNonBlank((String)this.packagingDetail.getName())) {
            this.setItemMessage(this.nameItem.deco, Messages.PackagingDetails_Dialog_Error_Required_Name);
            ok = false;
        } else if (this.packagingDetailNames.contains(this.packagingDetail.getName())) {
            this.setItemMessage(this.nameItem.deco, Messages.PackagingDetails_Dialog_Error_Original_Name);
            ok = false;
        } else {
            this.setItemMessage(this.nameItem.deco, null);
        }
        if (!Verification.isNonNull((Object)this.packagingDetail.getId())) {
            this.setItemMessage(this.idItem.deco, Messages.PackagingDetails_Dialog_Error_Required_Id);
            ok = false;
        } else {
            this.setItemMessage(this.idItem.deco, null);
        }
        if (this.packagingDetail.hasExtension()) {
            if (this.packagingDetail.getExtension().contains(",")) {
                this.setItemMessage(this.extensionItem.deco, Messages.PackagingDetails_Dialog_Error_NotValid_Extension);
                ok = false;
            } else if (!Packaging.containsExtension((ILanguageDefinition)this.languageDefinition, (String)this.packagingDetail.getExtension())) {
                this.setItemMessage(this.extensionItem.deco, Messages.PackagingDetails_Dialog_Error_NotFound_Extension);
                ok = false;
            }
        } else {
            this.setItemMessage(this.extensionItem.deco, null);
        }
        if (this.packagingDetail.hasFolder()) {
            if (this.packagingDetail.getFolder().contains(",")) {
                this.setItemMessage(this.folderItem.deco, Messages.PackagingDetails_Dialog_Error_NotValid_Folder);
                ok = false;
            } else if (!Packaging.containsFolder((ILanguageDefinition)this.languageDefinition, (String)this.packagingDetail.getFolder())) {
                this.setItemMessage(this.folderItem.deco, Messages.PackagingDetails_Dialog_Error_NotFound_Folder);
                ok = false;
            }
        } else {
            this.setItemMessage(this.folderItem.deco, null);
        }
        if (this.includeFileData) {
            if (Verification.isNonBlank((String)this.packagingDetail.getDistname()) && Verification.isNonMemberName((String)this.packagingDetail.getDistname())) {
                this.setItemMessage(this.distnameItem.deco, Messages.PackagingDetails_Dialog_Error_MemberNm_Distname);
                ok = false;
            } else {
                this.setItemMessage(this.distnameItem.deco, null);
            }
        }
        if (this.includeFileData) {
            if (Verification.isNonBlank((String)this.packagingDetail.getShipalias()) && Verification.isNonMemberName((String)this.packagingDetail.getShipalias())) {
                this.setItemMessage(this.shipaliasItem.deco, Messages.PackagingDetails_Dialog_Error_MemberNm_Shipalias);
                ok = false;
            } else {
                this.setItemMessage(this.shipaliasItem.deco, null);
            }
        }
        if (this.includeFileData) {
            if (Verification.isNonNull((Object)this.packagingDetail.getRelfileOverride()) && this.packagingDetail.getRelfileOverride() <= 0) {
                this.setItemMessage(this.relfileOverrideItem.deco, Messages.PackagingDetails_Dialog_Error_NotValid_RelfileOverride);
                ok = false;
            } else {
                this.setItemMessage(this.relfileOverrideItem.deco, null);
            }
        }
        if (ok && Id.OBJ_LITERAL.equals(this.packagingDetail.getId()) || Id.SRC_LITERAL.equals(this.packagingDetail.getId())) {
            if (!Verification.isNonNull((Object)this.packagingDetail.getMcstype())) {
                this.setItemMessage(this.mcstypeItem.deco, Messages.PackagingDetails_Dialog_Error_Required_Parttype);
                ok = false;
            } else {
                this.setItemMessage(this.mcstypeItem.deco, null);
            }
            if (!Verification.isNonNull((Object)this.packagingDetail.getProcessor())) {
                this.setItemMessage(this.processItem.deco, Messages.PackagingDetails_Dialog_Error_Required_Process);
                ok = false;
            } else {
                this.setItemMessage(this.processItem.deco, null);
            }
            if (!Verification.isNonNull((Object)this.packagingDetail.getLocation())) {
                this.setItemMessage(this.locationItem.deco, Messages.PackagingDetails_Dialog_Error_Required_Location);
                ok = false;
            } else {
                this.setItemMessage(this.locationItem.deco, null);
            }
            if (!Verification.isNonNull((Object)this.packagingDetail.getDistlib())) {
                this.setItemMessage(this.distlibItem.deco, Messages.PackagingDetails_Dialog_Error_Required_Distlib);
                ok = false;
            } else {
                this.setItemMessage(this.distlibItem.deco, null);
            }
            if (!Verification.isNonNull((Object)this.packagingDetail.getSyslib())) {
                this.setItemMessage(this.syslibItem.deco, Messages.PackagingDetails_Dialog_Error_Required_Syslib);
                ok = false;
            } else {
                this.setItemMessage(this.syslibItem.deco, null);
            }
        }
        if (ok && Id.LST_LITERAL.equals(this.packagingDetail.getId())) {
            if (Verification.isNonNull((Object)this.packagingDetail.getMcstype())) {
                this.setItemMessage(this.mcstypeItem.deco, Messages.PackagingDetails_Dialog_Error_NotAllow_Parttype);
                ok = false;
            } else {
                this.setItemMessage(this.mcstypeItem.deco, null);
            }
            if (Verification.isNonNull((Object)this.packagingDetail.getProcessor())) {
                this.setItemMessage(this.processItem.deco, Messages.PackagingDetails_Dialog_Error_NotAllow_Process);
                ok = false;
            } else {
                this.setItemMessage(this.processItem.deco, null);
            }
            if (!Verification.isNonNull((Object)this.packagingDetail.getBinary()) && this.packagingDetail.isBinary()) {
                this.setItemMessage(this.binaryItem.deco, Messages.PackagingDetails_Dialog_Error_NotAllow_Binary);
                ok = false;
            } else {
                this.setItemMessage(this.binaryItem.deco, null);
            }
            if (Verification.isNonNull((Object)this.packagingDetail.getFmidoverride())) {
                this.setItemMessage(this.fmidoverrideItem.deco, Messages.PackagingDetails_Dialog_Error_NotAllow_Fmidoverride);
                ok = false;
            } else {
                this.setItemMessage(this.fmidoverrideItem.deco, null);
            }
            if (this.includeFileData) {
                if (!Verification.isNonBlank((String)this.packagingDetail.getDistname())) {
                    this.setItemMessage(this.distnameItem.deco, Messages.PackagingDetails_Dialog_Error_NotAllow_Distname);
                    ok = false;
                } else {
                    this.setItemMessage(this.distnameItem.deco, null);
                }
            }
            if (this.includeFileData) {
                if (!Verification.isNonBlank((String)this.packagingDetail.getShipalias())) {
                    this.setItemMessage(this.shipaliasItem.deco, Messages.PackagingDetails_Dialog_Error_NotAllow_Shipalias);
                    ok = false;
                } else {
                    this.setItemMessage(this.shipaliasItem.deco, null);
                }
            }
            if (this.includeFileData) {
                if (!Verification.isNonNull((Object)this.packagingDetail.getRelfileOverride())) {
                    this.setItemMessage(this.relfileOverrideItem.deco, Messages.PackagingDetails_Dialog_Error_NotAllow_RelfileOverride);
                    ok = false;
                } else {
                    this.setItemMessage(this.relfileOverrideItem.deco, null);
                }
            }
            if (!Verification.isNonNull((Object)this.packagingDetail.getLocation())) {
                this.setItemMessage(this.locationItem.deco, Messages.PackagingDetails_Dialog_Error_Required_Location);
                ok = false;
            } else {
                this.setItemMessage(this.locationItem.deco, null);
            }
            if (Verification.isNonNull((Object)this.packagingDetail.getDistlib())) {
                this.setItemMessage(this.distlibItem.deco, Messages.PackagingDetails_Dialog_Error_NotAllow_Distlib);
                ok = false;
            } else {
                this.setItemMessage(this.distlibItem.deco, null);
            }
            if (Verification.isNonNull((Object)this.packagingDetail.getSyslib())) {
                this.setItemMessage(this.syslibItem.deco, Messages.PackagingDetails_Dialog_Error_NotAllow_Syslib);
                ok = false;
            } else {
                this.setItemMessage(this.syslibItem.deco, null);
            }
        }
        if (ok) {
            super.okPressed();
        }
    }

    private void setItemMessage(ControlDecoration controlDecoration, String message) {
        if (message != null) {
            controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
            controlDecoration.setDescriptionText(message);
        } else {
            controlDecoration.hide();
            controlDecoration.setImage(null);
            controlDecoration.show();
        }
    }

    private void setRelfileOverrideItemForeGround() {
        if (this.relfileOverrideItem != null) {
            if (this.relfileOverrideItem.item.getSelection() == 0) {
                this.relfileOverrideItem.item.setForeground(this.relfileOverrideItem.item.getBackground());
            } else {
                this.relfileOverrideItem.item.setForeground(this.nameItem.item.getForeground());
            }
        }
    }
}

