/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.dialogs;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.enterprise.common.ui.elements.DialogButtonItem;
import com.ibm.team.enterprise.common.ui.elements.DialogComboItem;
import com.ibm.team.enterprise.common.ui.elements.DialogTableItem;
import com.ibm.team.enterprise.smpe.common.IOrchestratorBuild;
import com.ibm.team.enterprise.smpe.ui.dialogs.EditPrerequisiteBuildsDialog;
import com.ibm.team.enterprise.smpe.ui.elements.BuildDefinitionLabelProvider;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.NarrowTitleAreaDialog;
import com.ibm.team.enterprise.systemdefinition.ui.util.ListContentProvider;
import com.ibm.team.repository.common.IItemHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class OrchestratedBuildDialog
extends NarrowTitleAreaDialog {
    private static final int MinimumDialogW = 255;
    private static final int MinimumDialogH = 150;
    private static final int SWG_WIDTH_COMBO = 200;
    private static final int SWG_WIDTH_LABEL = 120;
    private static final int SWG_HEIGHT = 18;
    private static final int tableItemMinimum = 9;
    private static final String buildLabel = Messages.OrchestratedBuild_Dialog_Label_Build;
    private static final String dependentLabel = Messages.OrchestratedBuild_Dialog_Label_Dependent;
    private static final String enabledLabel = Messages.OrchestratedBuild_Dialog_Label_Enabled;
    private static final String housekeepingLabel = Messages.OrchestratedBuild_Dialog_Label_Housekeeping;
    private static final String primaryLabel = Messages.OrchestratedBuild_Dialog_Label_Primary;
    private static final String secondaryLabel = Messages.OrchestratedBuild_Dialog_Label_Secondary;
    private final IOrchestratorBuild orchestratorBuild;
    private final Map<String, IBuildDefinition> buildDefinitionIds;
    private final Map<String, IBuildDefinition> availableDefinitionIds;
    private final Map<String, IBuildEngine> buildEngineIds;
    private final List<IBuildDefinition> dependsOnDefinitions;
    private final Shell parentShell;
    private final String title;
    private final String[] buildIds;
    private FormToolkit toolkit;
    private DialogButtonItem dependentItem;
    private DialogButtonItem enabledItem;
    private DialogButtonItem housekeepingItem;
    private DialogButtonItem primaryItem;
    private DialogButtonItem secondaryItem;
    private DialogComboItem buildItem;
    private DialogTableItem tableItem;

    public OrchestratedBuildDialog(Shell parentShell, Map<String, IBuildDefinition> buildDefinitionIds, Map<String, IBuildEngine> buildEngineIds, List<IOrchestratorBuild> definedBuilds, IOrchestratorBuild original, String title) {
        super(parentShell, 255, 150);
        this.parentShell = parentShell;
        this.buildDefinitionIds = buildDefinitionIds;
        this.availableDefinitionIds = new HashMap<String, IBuildDefinition>(buildDefinitionIds);
        this.buildEngineIds = buildEngineIds;
        this.orchestratorBuild = original.newCopy();
        this.title = title;
        for (IOrchestratorBuild definedBuild : definedBuilds) {
            if (this.orchestratorBuild.hasBuildDefinition() && this.orchestratorBuild.getBuildDefinition().sameItemId((IItemHandle)definedBuild.getBuildDefinition())) continue;
            this.availableDefinitionIds.remove(definedBuild.getBuildDefinition().getId());
        }
        this.buildIds = new String[this.availableDefinitionIds.size() + 1];
        this.buildIds[0] = "";
        ArrayList<String> ids = new ArrayList<String>(this.availableDefinitionIds.keySet());
        Collections.sort(ids);
        System.arraycopy(ids.toArray(), 0, this.buildIds, 1, this.availableDefinitionIds.size());
        this.dependsOnDefinitions = this.getBuilds(buildDefinitionIds.values());
    }

    protected Control createDialogArea(Composite parent) {
        this.toolkit = new FormToolkit(Display.getDefault());
        this.toolkit.setBackground(null);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        this.setTitle(this.title);
        this.setMessage(Messages.OrchestratedBuild_Dialog_Title_Message);
        this.setHelpAvailable(true);
        Composite itemComposite = new Composite(composite, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        itemComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginTop = 5;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 8;
        gridLayout.verticalSpacing = 5;
        itemComposite.setLayout((Layout)gridLayout);
        this.buildItem = this.createComboboxItem(itemComposite, buildLabel, this.buildIds, this.getBuildIndex(this.orchestratorBuild.getBuildDefinitionId()));
        this.enabledItem = this.createCheckboxItem(itemComposite, enabledLabel, this.orchestratorBuild.isEnabled());
        this.primaryItem = this.createCheckboxItem(itemComposite, primaryLabel, this.orchestratorBuild.isPrimary());
        this.secondaryItem = this.createCheckboxItem(itemComposite, secondaryLabel, this.orchestratorBuild.isSecondary());
        this.dependentItem = this.createCheckboxItem(itemComposite, dependentLabel, this.orchestratorBuild.isDependent());
        this.housekeepingItem = this.createCheckboxItem(itemComposite, housekeepingLabel, this.orchestratorBuild.isHousekeeping());
        Composite tableComposite = new Composite(composite, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        tableComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginTop = 5;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 5;
        tableComposite.setLayout((Layout)gridLayout);
        this.tableItem = this.createTableItem(tableComposite, this.orchestratorBuild.getDependsOn());
        this.buildItem.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                OrchestratedBuildDialog.this.orchestratorBuild.setBuildDefinition((IBuildDefinition)OrchestratedBuildDialog.this.buildDefinitionIds.get(OrchestratedBuildDialog.this.buildIds[((OrchestratedBuildDialog)OrchestratedBuildDialog.this).buildItem.item.getSelectionIndex()]));
                OrchestratedBuildDialog.this.orchestratorBuild.setBuildEngines(OrchestratedBuildDialog.this.getEngines(OrchestratedBuildDialog.this.orchestratorBuild.getBuildDefinition(), OrchestratedBuildDialog.this.buildEngineIds.values()));
                OrchestratedBuildDialog.this.setItemMessage(((OrchestratedBuildDialog)OrchestratedBuildDialog.this).buildItem.deco, null);
                OrchestratedBuildDialog.this.dependsOnDefinitions.clear();
                OrchestratedBuildDialog.this.dependsOnDefinitions.addAll(OrchestratedBuildDialog.this.getBuilds(OrchestratedBuildDialog.this.buildDefinitionIds.values()));
                OrchestratedBuildDialog.this.dependsOnDefinitions.remove(OrchestratedBuildDialog.this.orchestratorBuild.getBuildDefinition());
            }
        });
        this.enabledItem.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrchestratedBuildDialog.this.orchestratorBuild.setEnabled(((OrchestratedBuildDialog)OrchestratedBuildDialog.this).enabledItem.item.getSelection());
                OrchestratedBuildDialog.this.setItemMessage(((OrchestratedBuildDialog)OrchestratedBuildDialog.this).enabledItem.deco, null);
            }
        });
        this.primaryItem.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrchestratedBuildDialog.this.orchestratorBuild.setPrimary(((OrchestratedBuildDialog)OrchestratedBuildDialog.this).primaryItem.item.getSelection());
                OrchestratedBuildDialog.this.setItemMessage(((OrchestratedBuildDialog)OrchestratedBuildDialog.this).primaryItem.deco, null);
                if (OrchestratedBuildDialog.this.orchestratorBuild.isPrimary()) {
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).secondaryItem.item.setEnabled(false);
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).dependentItem.item.setEnabled(false);
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).housekeepingItem.item.setEnabled(false);
                } else {
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).secondaryItem.item.setEnabled(true);
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).dependentItem.item.setEnabled(true);
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).housekeepingItem.item.setEnabled(true);
                }
            }
        });
        this.secondaryItem.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrchestratedBuildDialog.this.orchestratorBuild.setSecondary(((OrchestratedBuildDialog)OrchestratedBuildDialog.this).secondaryItem.item.getSelection());
                OrchestratedBuildDialog.this.setItemMessage(((OrchestratedBuildDialog)OrchestratedBuildDialog.this).secondaryItem.deco, null);
                if (OrchestratedBuildDialog.this.orchestratorBuild.isSecondary()) {
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).primaryItem.item.setEnabled(false);
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).dependentItem.item.setEnabled(false);
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).housekeepingItem.item.setEnabled(false);
                } else {
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).primaryItem.item.setEnabled(true);
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).dependentItem.item.setEnabled(true);
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).housekeepingItem.item.setEnabled(true);
                }
            }
        });
        this.dependentItem.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrchestratedBuildDialog.this.orchestratorBuild.setDependent(((OrchestratedBuildDialog)OrchestratedBuildDialog.this).dependentItem.item.getSelection());
                OrchestratedBuildDialog.this.setItemMessage(((OrchestratedBuildDialog)OrchestratedBuildDialog.this).dependentItem.deco, null);
                if (OrchestratedBuildDialog.this.orchestratorBuild.isDependent()) {
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).primaryItem.item.setEnabled(false);
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).secondaryItem.item.setEnabled(false);
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).housekeepingItem.item.setEnabled(false);
                    OrchestratedBuildDialog.this.setTableItemEnabled(true);
                } else {
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).primaryItem.item.setEnabled(true);
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).secondaryItem.item.setEnabled(true);
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).housekeepingItem.item.setEnabled(true);
                    OrchestratedBuildDialog.this.setTableItemEnabled(false);
                }
            }
        });
        this.housekeepingItem.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrchestratedBuildDialog.this.orchestratorBuild.setHousekeeping(((OrchestratedBuildDialog)OrchestratedBuildDialog.this).housekeepingItem.item.getSelection());
                OrchestratedBuildDialog.this.setItemMessage(((OrchestratedBuildDialog)OrchestratedBuildDialog.this).housekeepingItem.deco, null);
                if (OrchestratedBuildDialog.this.orchestratorBuild.isHousekeeping()) {
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).primaryItem.item.setEnabled(false);
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).secondaryItem.item.setEnabled(false);
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).dependentItem.item.setEnabled(false);
                    OrchestratedBuildDialog.this.setTableItemEnabled(true);
                } else {
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).primaryItem.item.setEnabled(true);
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).secondaryItem.item.setEnabled(true);
                    ((OrchestratedBuildDialog)OrchestratedBuildDialog.this).dependentItem.item.setEnabled(true);
                    OrchestratedBuildDialog.this.setTableItemEnabled(false);
                }
            }
        });
        this.buildItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(OrchestratedBuildDialog.this.parentShell, 36);
                helpDialog.setText(Messages.OrchestratedBuild_Dialog_HelpLbl_Build);
                helpDialog.setMessage(Messages.OrchestratedBuild_Dialog_HelpTxt_Build);
                helpDialog.open();
            }
        });
        this.enabledItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(OrchestratedBuildDialog.this.parentShell, 36);
                helpDialog.setText(Messages.OrchestratedBuild_Dialog_HelpLbl_Enabled);
                helpDialog.setMessage(Messages.OrchestratedBuild_Dialog_HelpTxt_Enabled);
                helpDialog.open();
            }
        });
        this.primaryItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(OrchestratedBuildDialog.this.parentShell, 36);
                helpDialog.setText(Messages.OrchestratedBuild_Dialog_HelpLbl_Primary);
                helpDialog.setMessage(Messages.OrchestratedBuild_Dialog_HelpTxt_Primary);
                helpDialog.open();
            }
        });
        this.secondaryItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(OrchestratedBuildDialog.this.parentShell, 36);
                helpDialog.setText(Messages.OrchestratedBuild_Dialog_HelpLbl_Secondary);
                helpDialog.setMessage(Messages.OrchestratedBuild_Dialog_HelpTxt_Secondary);
                helpDialog.open();
            }
        });
        this.dependentItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(OrchestratedBuildDialog.this.parentShell, 36);
                helpDialog.setText(Messages.OrchestratedBuild_Dialog_HelpLbl_Dependent);
                helpDialog.setMessage(Messages.OrchestratedBuild_Dialog_HelpTxt_Dependent);
                helpDialog.open();
            }
        });
        this.housekeepingItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(OrchestratedBuildDialog.this.parentShell, 36);
                helpDialog.setText(Messages.OrchestratedBuild_Dialog_HelpLbl_Housekeeping);
                helpDialog.setMessage(Messages.OrchestratedBuild_Dialog_HelpTxt_Housekeeping);
                helpDialog.open();
            }
        });
        OrchestratedBuildDialog.applyDialogFont((Control)itemComposite);
        if (this.orchestratorBuild.hasBuildDefinition()) {
            this.buildItem.item.setEnabled(false);
        }
        if (this.orchestratorBuild.isDependent() || this.orchestratorBuild.isHousekeeping()) {
            this.setTableItemEnabled(true);
        } else {
            this.setTableItemEnabled(false);
        }
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.OrchestratedBuild_Dialog_Title);
    }

    private final DialogButtonItem createCheckboxItem(Composite composite, String itemLabel, Boolean value) {
        DialogButtonItem dialogItem = new DialogButtonItem();
        dialogItem.label = new Label(composite, 0);
        dialogItem.label.setText(itemLabel);
        GridDataFactory.fillDefaults().hint(120, 18).applyTo((Control)dialogItem.label);
        dialogItem.item = new Button(composite, 0x800020);
        dialogItem.item.setSelection(value.booleanValue());
        GridDataFactory.fillDefaults().hint(120, 18).applyTo((Control)dialogItem.item);
        dialogItem.deco = new ControlDecoration((Control)dialogItem.item, 16512, composite);
        return dialogItem;
    }

    private final DialogComboItem createComboboxItem(Composite composite, String itemLabel, String[] values, Integer index) {
        DialogComboItem dialogItem = new DialogComboItem();
        dialogItem.label = new Label(composite, 0);
        dialogItem.label.setText(itemLabel);
        GridDataFactory.fillDefaults().hint(120, 18).align(1, 0x1000000).applyTo((Control)dialogItem.label);
        dialogItem.item = new Combo(composite, 8);
        dialogItem.item.setItems(values);
        dialogItem.item.select(index.intValue());
        GridDataFactory.fillDefaults().hint(200, 18).applyTo((Control)dialogItem.item);
        dialogItem.deco = new ControlDecoration((Control)dialogItem.item, 16512, composite);
        return dialogItem;
    }

    private final DialogTableItem createTableItem(Composite composite, List values) {
        final DialogTableItem dialogItem = new DialogTableItem();
        Composite tableComposite = this.toolkit.createComposite(composite);
        dialogItem.item = this.toolkit.createTable(tableComposite, 768);
        dialogItem.item.setHeaderVisible(true);
        this.toolkit.setBorderStyle(2048);
        dialogItem.grid = new GridData(4, 4, true, true);
        dialogItem.grid.widthHint = 1;
        dialogItem.grid.heightHint = dialogItem.item.getItemHeight() * 9;
        tableComposite.setLayoutData((Object)dialogItem.grid);
        tableComposite.setLayout((Layout)new FillLayout());
        dialogItem.deco = new ControlDecoration((Control)dialogItem.item, 16512, composite);
        TableColumnLayout tableLayout = new TableColumnLayout();
        TableColumn tableColumn = new TableColumn(dialogItem.item, 0);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(100, true));
        tableColumn.setText(Messages.OrchestratedBuild_Dialog_Table_Header);
        tableComposite.setLayout((Layout)tableLayout);
        dialogItem.viewer = new TableViewer(dialogItem.item);
        dialogItem.viewer.setContentProvider((IContentProvider)new ListContentProvider());
        dialogItem.viewer.setLabelProvider((IBaseLabelProvider)new BuildDefinitionLabelProvider());
        dialogItem.viewer.setInput((Object)values);
        Composite buttonComposite = this.toolkit.createComposite(composite);
        buttonComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        dialogItem.edit = this.toolkit.createButton(buttonComposite, DialogTableItem.EditLabel, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)dialogItem.edit);
        dialogItem.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPrerequisiteBuildsDialog dialog = new EditPrerequisiteBuildsDialog(OrchestratedBuildDialog.this.parentShell, OrchestratedBuildDialog.this.dependsOnDefinitions, OrchestratedBuildDialog.this.orchestratorBuild.getDependsOn());
                if (dialog.open() == 0) {
                    OrchestratedBuildDialog.this.orchestratorBuild.setDependsOn(OrchestratedBuildDialog.this.getBuilds(dialog.getChosenDefinitions()));
                    dialogItem.viewer.setInput((Object)OrchestratedBuildDialog.this.orchestratorBuild.getDependsOn());
                    dialogItem.viewer.refresh();
                }
            }
        });
        return dialogItem;
    }

    private final int getBuildIndex(String id) {
        int i = 0;
        while (i < this.buildIds.length) {
            if (this.buildIds[i].equals(id)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private final List<IBuildDefinition> getBuilds(Collection<IBuildDefinition> builds) {
        ArrayList<IBuildDefinition> result = new ArrayList<IBuildDefinition>(builds);
        Collections.sort(result, new Comparator<IBuildDefinition>(){

            @Override
            public int compare(IBuildDefinition o1, IBuildDefinition o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        return result;
    }

    public final IOrchestratorBuild getDialogObject() {
        return this.orchestratorBuild;
    }

    private final List<IBuildEngine> getEngines(IBuildDefinition definition, Collection<IBuildEngine> engines) {
        ArrayList<IBuildEngine> result = new ArrayList<IBuildEngine>();
        for (IBuildEngine engine : engines) {
            if (!engine.supportsBuildDefinition((IBuildDefinitionHandle)definition)) continue;
            result.add(engine);
        }
        Collections.sort(result, new Comparator<IBuildEngine>(){

            @Override
            public int compare(IBuildEngine o1, IBuildEngine o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        return result;
    }

    private final boolean isAnyEngineDedicated(List<IBuildEngine> engines) {
        for (IBuildEngine engine : engines) {
            if (!this.isEngineDedicated(engine)) continue;
            return true;
        }
        return false;
    }

    private final boolean isEngineDedicated(List<IBuildEngine> engines) {
        for (IBuildEngine engine : engines) {
            if (this.isEngineDedicated(engine)) continue;
            return false;
        }
        return true;
    }

    private final boolean isEngineDedicated(IBuildEngine engine) {
        IBuildConfigurationElement element = engine.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorEngineConfigElement");
        if (element == null) {
            return false;
        }
        IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.smpe.build.orchestrator.engine.dedicated");
        if (property == null) {
            return false;
        }
        return Boolean.valueOf(property.getValue());
    }

    private final boolean isEngineGeneral(List<IBuildEngine> engines) {
        for (IBuildEngine engine : engines) {
            if (this.isEngineGeneral(engine)) continue;
            return false;
        }
        return true;
    }

    private final boolean isEngineGeneral(IBuildEngine engine) {
        IBuildConfigurationElement element = engine.getConfigurationElement("com.ibm.team.enterprise.smpe.common.build.IBuildOrchestratorEngineConfigElement");
        if (element == null) {
            return false;
        }
        IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.smpe.build.orchestrator.engine.general");
        if (property == null) {
            return false;
        }
        return Boolean.valueOf(property.getValue());
    }

    protected void okPressed() {
        boolean ok = true;
        if (this.buildItem != null && !this.orchestratorBuild.hasBuildDefinition()) {
            this.setItemMessage(this.buildItem.deco, Messages.OrchestratedBuild_Dialog_Error_Required_Build);
            ok = false;
        } else {
            this.setItemMessage(this.buildItem.deco, null);
        }
        if (this.primaryItem != null && this.orchestratorBuild.isPrimary()) {
            if (this.orchestratorBuild.getBuildEngines().isEmpty()) {
                this.setItemMessage(this.primaryItem.deco, Messages.OrchestratedBuild_Dialog_Error_Required_Engine_Primary);
                ok = false;
            } else if (this.orchestratorBuild.getBuildEngines().size() != 1) {
                this.setItemMessage(this.primaryItem.deco, Messages.OrchestratedBuild_Dialog_Error_NotValid_Engine_Primary_One);
                ok = false;
            } else if (!this.isEngineDedicated((IBuildEngine)this.orchestratorBuild.getBuildEngines().get(0))) {
                this.setItemMessage(this.primaryItem.deco, Messages.OrchestratedBuild_Dialog_Error_NotValid_Engine_Primary);
                ok = false;
            } else if (this.orchestratorBuild.isSecondary() || this.orchestratorBuild.isDependent() || this.orchestratorBuild.isHousekeeping()) {
                this.setItemMessage(this.primaryItem.deco, Messages.OrchestratedBuild_Dialog_Error_NotValid_Build_Options);
                ok = false;
            } else {
                this.setItemMessage(this.primaryItem.deco, null);
            }
        } else {
            this.setItemMessage(this.primaryItem.deco, null);
        }
        if (this.secondaryItem != null && this.orchestratorBuild.isSecondary()) {
            if (this.orchestratorBuild.getBuildEngines().isEmpty()) {
                this.setItemMessage(this.secondaryItem.deco, Messages.OrchestratedBuild_Dialog_Error_Required_Engine_Secondary);
                ok = false;
            } else if (!this.isEngineDedicated(this.orchestratorBuild.getBuildEngines())) {
                this.setItemMessage(this.secondaryItem.deco, Messages.OrchestratedBuild_Dialog_Error_NotValid_Engine_Secondary);
                ok = false;
            } else if (this.orchestratorBuild.isPrimary() || this.orchestratorBuild.isDependent() || this.orchestratorBuild.isHousekeeping()) {
                this.setItemMessage(this.secondaryItem.deco, Messages.OrchestratedBuild_Dialog_Error_NotValid_Build_Options);
                ok = false;
            } else {
                this.setItemMessage(this.secondaryItem.deco, null);
            }
        } else {
            this.setItemMessage(this.secondaryItem.deco, null);
        }
        if (this.dependentItem != null && this.orchestratorBuild.isDependent()) {
            if (this.orchestratorBuild.getDependsOn().isEmpty()) {
                this.setItemMessage(this.dependentItem.deco, Messages.OrchestratedBuild_Dialog_Error_Required_Dependent);
                ok = false;
            } else if (this.orchestratorBuild.getBuildEngines().isEmpty()) {
                this.setItemMessage(this.dependentItem.deco, Messages.OrchestratedBuild_Dialog_Error_Required_Engine_Dependent);
                ok = false;
            } else if (!this.isEngineGeneral(this.orchestratorBuild.getBuildEngines())) {
                this.setItemMessage(this.dependentItem.deco, Messages.OrchestratedBuild_Dialog_Error_NotValid_Engine_Dependent);
                ok = false;
            } else if (this.orchestratorBuild.isPrimary() || this.orchestratorBuild.isSecondary() || this.orchestratorBuild.isHousekeeping()) {
                this.setItemMessage(this.dependentItem.deco, Messages.OrchestratedBuild_Dialog_Error_NotValid_Build_Options);
                ok = false;
            } else {
                this.setItemMessage(this.dependentItem.deco, null);
            }
        } else {
            this.setItemMessage(this.dependentItem.deco, null);
        }
        if (this.housekeepingItem != null && this.orchestratorBuild.isHousekeeping()) {
            if (this.orchestratorBuild.getBuildEngines().isEmpty()) {
                this.setItemMessage(this.housekeepingItem.deco, Messages.OrchestratedBuild_Dialog_Error_Required_Engine_Housekeeping);
                ok = false;
            } else if (this.isAnyEngineDedicated(this.orchestratorBuild.getBuildEngines())) {
                this.setItemMessage(this.housekeepingItem.deco, Messages.OrchestratedBuild_Dialog_Error_NotValid_Engine_Housekeeping);
                ok = false;
            } else if (this.orchestratorBuild.isPrimary() || this.orchestratorBuild.isSecondary() || this.orchestratorBuild.isDependent()) {
                this.setItemMessage(this.housekeepingItem.deco, Messages.OrchestratedBuild_Dialog_Error_NotValid_Build_Options);
                ok = false;
            } else {
                this.setItemMessage(this.housekeepingItem.deco, null);
            }
        } else {
            this.setItemMessage(this.housekeepingItem.deco, null);
        }
        if (ok) {
            super.okPressed();
        }
    }

    private void setItemMessage(ControlDecoration controlDecoration, String message) {
        if (message != null) {
            controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
            controlDecoration.setDescriptionText(message);
        } else {
            controlDecoration.hide();
            controlDecoration.setImage(null);
            controlDecoration.show();
        }
    }

    private void setTableItemEnabled(boolean enabled) {
        if (enabled) {
            this.tableItem.edit.setEnabled(true);
        } else {
            this.tableItem.edit.setEnabled(false);
            this.orchestratorBuild.getDependsOn().clear();
            this.tableItem.viewer.setInput((Object)this.orchestratorBuild.getDependsOn());
            this.tableItem.viewer.refresh();
        }
    }
}

