/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.dialogs;

import com.ibm.team.enterprise.common.ui.elements.DialogComboItem;
import com.ibm.team.enterprise.common.ui.elements.DialogTextItemBandC;
import com.ibm.team.enterprise.common.ui.util.GridTools;
import com.ibm.team.enterprise.smpe.common.IOrchestratorAction;
import com.ibm.team.enterprise.smpe.internal.common.OrchestratorAction;
import com.ibm.team.enterprise.smpe.ui.dialogs.DataSetDefinitionSelectionDialog;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.NarrowTitleAreaDialog;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class OrchestratedActionDialog
extends NarrowTitleAreaDialog {
    private static final int MinimumDialogW = 300;
    private static final int MinimumDialogH = 150;
    private static final int SWG_WIDTH_COMBO = 200;
    private static final int SWG_WIDTH_FIELD = 200;
    private static final int SWG_WIDTH_LABEL = 90;
    private static final int SWG_HEIGHT = 18;
    private static final String actionLabel = Messages.OrchestratedAction_Dialog_Label_Action;
    private static final String argument1Label = Messages.OrchestratedAction_Dialog_Label_Argument1;
    private static final String argument2Label = Messages.OrchestratedAction_Dialog_Label_Argument2;
    private final IOrchestratorAction action;
    private final IProjectAreaHandle projectAreaHandle;
    private final ITeamRepository teamRepository;
    private final ISystemDefinitionCache systemDefinitionCache;
    private final Shell parentShell;
    private final String title;
    private boolean okPressed = false;
    private FormToolkit toolkit;
    private DialogComboItem actionItem;
    private DialogTextItemBandC argument1Item;
    private DialogTextItemBandC argument2Item;

    public OrchestratedActionDialog(Shell parentShell, ITeamRepository teamRepository, IProjectAreaHandle projectArea, ISystemDefinitionCache systemDefinitionCache, IOrchestratorAction original, String title) {
        super(parentShell, 300, 150);
        this.parentShell = parentShell;
        this.teamRepository = teamRepository;
        this.projectAreaHandle = projectArea;
        this.systemDefinitionCache = systemDefinitionCache;
        this.action = original.newCopy();
        this.title = title;
    }

    protected final void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.OrchestratedBuild_Dialog_Title);
    }

    protected final Control createDialogArea(Composite parent) {
        this.toolkit = new FormToolkit(Display.getDefault());
        this.toolkit.setBackground(null);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(4, false));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        composite.setLayoutData((Object)gridData);
        this.setTitle(this.title);
        this.setMessage(Messages.OrchestratedAction_Dialog_Title_Message);
        this.setHelpAvailable(true);
        Composite itemComposite = new Composite(composite, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        itemComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginTop = 5;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 7;
        gridLayout.verticalSpacing = 5;
        itemComposite.setLayout((Layout)gridLayout);
        this.actionItem = this.createComboboxItem(itemComposite, actionLabel, OrchestratorAction.Action.getLabels(), OrchestratorAction.Action.getIndex((OrchestratorAction.Action)this.action.getAction()));
        this.argument1Item = this.createBrowseItem(itemComposite, argument1Label, this.getArgument1Text(this.action));
        this.argument2Item = this.createBrowseItem(itemComposite, argument2Label, this.getArgument2Text(this.action));
        this.actionItem.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                OrchestratedActionDialog.this.action.setAction(OrchestratorAction.Action.getArray()[((OrchestratedActionDialog)OrchestratedActionDialog.this).actionItem.item.getSelectionIndex()]);
                OrchestratedActionDialog.this.action.setArgument1(null);
                ((OrchestratedActionDialog)OrchestratedActionDialog.this).argument1Item.item.setText(OrchestratedActionDialog.this.getArgument1Text(OrchestratedActionDialog.this.action));
                OrchestratedActionDialog.this.setItemMessage(((OrchestratedActionDialog)OrchestratedActionDialog.this).argument1Item.deco, null);
                OrchestratedActionDialog.this.action.setArgument2(null);
                ((OrchestratedActionDialog)OrchestratedActionDialog.this).argument2Item.item.setText(OrchestratedActionDialog.this.getArgument2Text(OrchestratedActionDialog.this.action));
                OrchestratedActionDialog.this.setItemMessage(((OrchestratedActionDialog)OrchestratedActionDialog.this).argument2Item.deco, null);
                OrchestratedActionDialog.this.setItemMessage(((OrchestratedActionDialog)OrchestratedActionDialog.this).actionItem.deco, null);
                OrchestratedActionDialog.this.setEnablement();
            }
        });
        this.argument1Item.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrchestratedActionDialog.this.setArgument1(OrchestratedActionDialog.this.action);
                ((OrchestratedActionDialog)OrchestratedActionDialog.this).argument1Item.item.setText(OrchestratedActionDialog.this.getArgument1Text(OrchestratedActionDialog.this.action));
                OrchestratedActionDialog.this.resetArgument1();
            }
        });
        this.argument1Item.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrchestratedActionDialog.this.action.setArgument1(null);
                ((OrchestratedActionDialog)OrchestratedActionDialog.this).argument1Item.item.setText(OrchestratedActionDialog.this.getArgument1Text(OrchestratedActionDialog.this.action));
                OrchestratedActionDialog.this.resetArgument1();
            }
        });
        this.argument2Item.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrchestratedActionDialog.this.setArgument2(OrchestratedActionDialog.this.action);
                ((OrchestratedActionDialog)OrchestratedActionDialog.this).argument2Item.item.setText(OrchestratedActionDialog.this.getArgument2Text(OrchestratedActionDialog.this.action));
                OrchestratedActionDialog.this.resetArgument2();
            }
        });
        this.argument2Item.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrchestratedActionDialog.this.action.setArgument2(null);
                ((OrchestratedActionDialog)OrchestratedActionDialog.this).argument2Item.item.setText(OrchestratedActionDialog.this.getArgument2Text(OrchestratedActionDialog.this.action));
                OrchestratedActionDialog.this.resetArgument2();
            }
        });
        this.actionItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(OrchestratedActionDialog.this.parentShell, 36);
                helpDialog.setText(Messages.OrchestratedAction_Dialog_HelpLbl_Action);
                helpDialog.setMessage(Messages.OrchestratedAction_Dialog_HelpTxt_Action);
                helpDialog.open();
            }
        });
        this.argument1Item.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(OrchestratedActionDialog.this.parentShell, 36);
                helpDialog.setText(Messages.OrchestratedAction_Dialog_HelpLbl_Argument1);
                helpDialog.setMessage(Messages.OrchestratedAction_Dialog_HelpTxt_Argument1);
                helpDialog.open();
            }
        });
        this.argument2Item.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(OrchestratedActionDialog.this.parentShell, 36);
                helpDialog.setText(Messages.OrchestratedAction_Dialog_HelpLbl_Argument2);
                helpDialog.setMessage(Messages.OrchestratedAction_Dialog_HelpTxt_Argument2);
                helpDialog.open();
            }
        });
        this.setEnablement();
        OrchestratedActionDialog.applyDialogFont((Control)itemComposite);
        return composite;
    }

    private final DialogTextItemBandC createBrowseItem(Composite composite, String label, String value) {
        DialogTextItemBandC dialogItem = new DialogTextItemBandC();
        dialogItem.label = new Label(composite, 0);
        dialogItem.label.setText(label);
        GridDataFactory.fillDefaults().hint(90, -1).align(1, 0x1000000).applyTo((Control)dialogItem.label);
        dialogItem.item = new Text(composite, 18436);
        dialogItem.item.setText(value);
        dialogItem.item.setEditable(false);
        dialogItem.item.setBackground(Display.getCurrent().getSystemColor(1));
        GridDataFactory.fillDefaults().hint(200, -1).applyTo((Control)dialogItem.item);
        dialogItem.browse = new Button(composite, 0x800008);
        dialogItem.browse.setText(DialogTextItemBandC.BrowseLabel);
        GridDataFactory.fillDefaults().hint(-1, dialogItem.browse.computeSize((int)10, (int)10).y).applyTo((Control)dialogItem.browse);
        dialogItem.clear = new Button(composite, 0x800008);
        dialogItem.clear.setImage(DialogTextItemBandC.ClearImage);
        GridDataFactory.fillDefaults().hint(-1, dialogItem.clear.computeSize((int)10, (int)10).y).applyTo((Control)dialogItem.clear);
        dialogItem.deco = new ControlDecoration((Control)dialogItem.item, 16512, composite);
        return dialogItem;
    }

    private final DialogComboItem createComboboxItem(Composite composite, String itemLabel, String[] values, Integer index) {
        DialogComboItem dialogItem = new DialogComboItem();
        dialogItem.label = new Label(composite, 0);
        dialogItem.label.setText(itemLabel);
        GridDataFactory.fillDefaults().hint(90, 18).align(1, 0x1000000).applyTo((Control)dialogItem.label);
        dialogItem.item = new Combo(composite, 8);
        dialogItem.item.setItems(values);
        dialogItem.item.select(index.intValue());
        GridDataFactory.fillDefaults().hint(200, 18).applyTo((Control)dialogItem.item);
        GridTools.createPlaceholder((Composite)composite);
        GridTools.createPlaceholder((Composite)composite);
        dialogItem.deco = new ControlDecoration((Control)dialogItem.item, 16512, composite);
        return dialogItem;
    }

    private final String getArgument1Text(IOrchestratorAction action) {
        String result = "";
        if (action.hasAction()) {
            switch (action.getAction()) {
                case COPY: {
                    if (action.getArgument1() == null) break;
                    result = ((IResourceDefinition)action.getArgument1()).getName();
                }
            }
        }
        return result;
    }

    private final String getArgument2Text(IOrchestratorAction orchestratorAction) {
        String result = "";
        if (this.action.hasAction()) {
            switch (this.action.getAction()) {
                case COPY: {
                    if (this.action.getArgument2() == null) break;
                    result = ((IResourceDefinition)this.action.getArgument2()).getName();
                }
            }
        }
        return result;
    }

    private final IResourceDefinition getDataSetDefinition() {
        IResourceDefinition dsdef = null;
        try {
            DataSetDefinitionSelectionDialog dialog = new DataSetDefinitionSelectionDialog(this.parentShell, this.teamRepository, this.projectAreaHandle, this.getDataSetDefinitionFilter(), Messages.PackagingDetails_Dialog_HelpDlg_DsDef, (List<Integer>)new ArrayList<Integer>(2){
                private static final long serialVersionUID = 1L;
                {
                    this.add(0);
                    this.add(1);
                }
            }, true, this.systemDefinitionCache);
            if (dialog.open() == 0) {
                dsdef = dialog.getSelectedDataDefinition();
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        return dsdef;
    }

    private final ViewerFilter getDataSetDefinitionFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!(element instanceof IDataSetDefinition)) {
                    return true;
                }
                IDataSetDefinition dsd = (IDataSetDefinition)element;
                if (dsd.getUsageType() == 2) {
                    return false;
                }
                return dsd.getUsageType() != 3;
            }
        };
    }

    public final IOrchestratorAction getDialogObject() {
        return this.action;
    }

    protected final void okPressed() {
        this.okPressed = true;
        boolean ok = true;
        if (this.action != null && !this.action.hasAction()) {
            this.setItemMessage(this.actionItem.deco, Messages.OrchestratedAction_Dialog_Error_Required_Action);
            ok = false;
        } else {
            this.setItemMessage(this.actionItem.deco, null);
        }
        if (this.action != null && this.action.hasAction()) {
            switch (this.action.getAction()) {
                case COPY: {
                    if (this.validateArgumentsCopy()) break;
                    ok = false;
                }
            }
        }
        if (ok) {
            super.okPressed();
        }
    }

    private final void resetArgument1() {
        if (this.action != null && this.action.hasAction()) {
            switch (this.action.getAction()) {
                case COPY: {
                    if (this.okPressed) {
                        this.validateArgumentsCopy();
                        break;
                    }
                    this.setItemMessage(this.argument1Item.deco, null);
                    break;
                }
                default: {
                    this.setItemMessage(this.argument1Item.deco, null);
                    break;
                }
            }
        } else if (this.argument1Item != null) {
            this.setItemMessage(this.argument1Item.deco, null);
        }
    }

    private final void resetArgument2() {
        if (this.action != null && this.action.hasAction()) {
            switch (this.action.getAction()) {
                case COPY: {
                    if (this.okPressed) {
                        this.validateArgumentsCopy();
                        break;
                    }
                    this.setItemMessage(this.argument2Item.deco, null);
                    break;
                }
                default: {
                    this.setItemMessage(this.argument2Item.deco, null);
                    break;
                }
            }
        } else if (this.argument2Item != null) {
            this.setItemMessage(this.argument2Item.deco, null);
        }
    }

    private final void setArgument1(IOrchestratorAction action) {
        if (action.hasAction()) {
            switch (action.getAction()) {
                case COPY: {
                    IResourceDefinition obj = this.getDataSetDefinition();
                    if (obj == null) break;
                    action.setArgument1((Object)obj);
                }
            }
        }
    }

    private final void setArgument2(IOrchestratorAction action) {
        if (action.hasAction()) {
            switch (action.getAction()) {
                case COPY: {
                    IResourceDefinition obj = this.getDataSetDefinition();
                    if (obj == null) break;
                    action.setArgument2((Object)obj);
                }
            }
        }
    }

    private final void setEnablement() {
        if (this.action.hasAction()) {
            switch (this.action.getAction()) {
                case COPY: {
                    this.argument1Item.browse.setEnabled(true);
                    this.argument1Item.clear.setEnabled(true);
                    this.argument2Item.browse.setEnabled(true);
                    this.argument2Item.clear.setEnabled(true);
                }
            }
        } else {
            this.argument1Item.browse.setEnabled(false);
            this.argument1Item.clear.setEnabled(false);
            this.argument2Item.browse.setEnabled(false);
            this.argument2Item.clear.setEnabled(false);
        }
    }

    private final void setItemMessage(ControlDecoration controlDecoration, String message) {
        if (message != null) {
            controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
            controlDecoration.setDescriptionText(message);
        } else {
            controlDecoration.hide();
            controlDecoration.setImage(null);
            controlDecoration.show();
        }
    }

    private final boolean validateArgumentsCopy() {
        boolean ok = true;
        if (this.argument1Item != null && !this.action.hasArgument1()) {
            this.setItemMessage(this.argument1Item.deco, Messages.OrchestratedAction_Dialog_Error_Required_CopyArg1);
            ok = false;
        } else if (this.argument1Item != null && this.argument2Item != null && ((IResourceDefinition)this.action.getArgument1()).sameItemId((IItemHandle)((IResourceDefinition)this.action.getArgument2()))) {
            this.setItemMessage(this.argument1Item.deco, Messages.OrchestratedAction_Dialog_Error_SameItem_CopyArg1);
            ok = false;
        } else {
            this.setItemMessage(this.argument1Item.deco, null);
        }
        if (this.argument2Item != null && !this.action.hasArgument2()) {
            this.setItemMessage(this.argument2Item.deco, Messages.OrchestratedAction_Dialog_Error_Required_CopyArg2);
            ok = false;
        } else if (this.argument1Item != null && this.argument2Item != null && ((IResourceDefinition)this.action.getArgument1()).sameItemId((IItemHandle)((IResourceDefinition)this.action.getArgument2()))) {
            this.setItemMessage(this.argument2Item.deco, Messages.OrchestratedAction_Dialog_Error_SameItem_CopyArg2);
            ok = false;
        } else {
            this.setItemMessage(this.argument2Item.deco, null);
        }
        return ok;
    }
}

