/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.dialogs;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.ui.AbstractBuildItemViewerComparator;
import com.ibm.team.build.internal.ui.dialogs.AbstractEditItemsDialog;
import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class EditPrerequisiteBuildsDialog
extends AbstractEditItemsDialog {
    private final Map<String, IBuildDefinition> allItems = new HashMap<String, IBuildDefinition>();
    private final Map<String, IBuildDefinition> initialItems = new HashMap<String, IBuildDefinition>();

    public EditPrerequisiteBuildsDialog(Shell parentShell, List<IBuildDefinition> buildDefinitions, List<IBuildDefinition> dependsOnDefinitions) {
        super(parentShell);
        for (IBuildDefinition buildDefinition : buildDefinitions) {
            this.allItems.put(buildDefinition.getId(), buildDefinition);
        }
        for (IBuildDefinition buildDefinition : dependsOnDefinitions) {
            this.initialItems.put(buildDefinition.getId(), buildDefinition);
        }
    }

    protected final Control createDialogArea(Composite parent) {
        Control result = super.createDialogArea(parent);
        this.fShowSubSetItemsButton.setVisible(false);
        this.fShowAllItemsButton.setSelection(true);
        this.fShowAllItemsButton.setVisible(false);
        return result;
    }

    protected String[] getAllItems() {
        return this.allItems.keySet().toArray(new String[this.allItems.size()]);
    }

    public List<IBuildDefinition> getChosenDefinitions() {
        ArrayList<IBuildDefinition> result = new ArrayList<IBuildDefinition>();
        Iterator checked = this.fCheckedItems.iterator();
        while (checked.hasNext()) {
            result.add(this.allItems.get(checked.next()));
        }
        return result;
    }

    protected String getDescription(IStructuredSelection selection) {
        String definitionId;
        IBuildDefinition definition;
        if (selection.size() == 1 && (definition = this.allItems.get(definitionId = (String)selection.getFirstElement())) != null) {
            return definition.getDescription();
        }
        return null;
    }

    protected String getDialogDescription() {
        return Messages.AddPrerequisiteBuildDialog_Description;
    }

    protected String getDialogTitle() {
        return Messages.AddPrerequisiteBuildDialog_Title;
    }

    protected String[] getInitialItems() {
        return this.initialItems.keySet().toArray(new String[this.initialItems.size()]);
    }

    protected LabelProvider getLabelProvider(boolean isSubSetDisplayed) {
        return new LabelProvider(){

            public final String getText(Object element) {
                return element.toString();
            }

            public Image getImage(Object element) {
                return SmpeUIPlugin.getImage("icons/obj16/build.gif");
            }
        };
    }

    protected String getShowAllLabel() {
        return "";
    }

    protected String getShowSubSetLabel() {
        return "";
    }

    protected Collection<String> getSubSetItems() {
        return Collections.emptyList();
    }

    protected ViewerComparator getTableViewerComparator() {
        return new AbstractBuildItemViewerComparator(){

            protected String getTopProject() {
                return "";
            }

            protected String getProject(Object element) {
                return "";
            }
        };
    }

    protected boolean isStartInSubSet() {
        return false;
    }
}

