/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.dialogs;

import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.common.ui.elements.DialogTextItem;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.NarrowTitleAreaDialog;
import com.ibm.team.enterprise.systemdefinition.ui.node.AbstractEnterpriseExtensionsSystemDefinitionNode;
import com.ibm.team.repository.common.IItemType;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DuplicateSystemDefinitionDialog
extends NarrowTitleAreaDialog {
    private static final int MinimumDialogW = 320;
    private static final int MinimumDialogH = 160;
    private static final int SWG_WIDTH_FIELD = 400;
    private static final int SWG_WIDTH_LABEL = 40;
    private static final String idLabel = Messages.DuplicateSystemDefinitionAction_Dialog_Label_Id;
    private static final String nameLabel = Messages.DuplicateSystemDefinitionAction_Dialog_Label_Name;
    private final Shell parentShell;
    private String id;
    private String idHelpLbl;
    private String idHelpTxt;
    private String name;
    private String nameHelpLbl;
    private String nameHelpTxt;
    private DialogTextItem idItem;
    private DialogTextItem nameItem;

    public DuplicateSystemDefinitionDialog(Shell parentShell, AbstractEnterpriseExtensionsSystemDefinitionNode node) {
        super(parentShell, 320, 160);
        this.parentShell = parentShell;
        this.id = "";
        this.name = NLS.bind((String)Messages.DuplicateSystemDefinitionDialog_Dialog_Prefix, (Object)node.getSystemDefinition().getName());
        if (SystemDefinitionUtil.isTypeOf((IItemType)node.getSystemDefinition().getItemType(), (IItemType)IFunctionDefinition.ITEM_TYPE)) {
            this.idHelpLbl = Messages.DuplicateSystemDefinitionAction_Dialog_HelpLbl_Function_Id;
            this.idHelpTxt = Messages.DuplicateSystemDefinitionAction_Dialog_HelpTxt_Function_Id;
            this.nameHelpLbl = Messages.DuplicateSystemDefinitionAction_Dialog_HelpLbl_Function_Name;
            this.nameHelpTxt = Messages.DuplicateSystemDefinitionAction_Dialog_HelpTxt_Function_Name;
        } else if (SystemDefinitionUtil.isTypeOf((IItemType)node.getSystemDefinition().getItemType(), (IItemType)IVersionDefinition.ITEM_TYPE)) {
            this.idHelpLbl = Messages.DuplicateSystemDefinitionAction_Dialog_HelpLbl_Version_Id;
            this.idHelpTxt = Messages.DuplicateSystemDefinitionAction_Dialog_HelpTxt_Version_Id;
            this.nameHelpLbl = Messages.DuplicateSystemDefinitionAction_Dialog_HelpLbl_Version_Name;
            this.nameHelpTxt = Messages.DuplicateSystemDefinitionAction_Dialog_HelpTxt_Version_Name;
        } else {
            this.idHelpLbl = "";
            this.idHelpTxt = "";
            this.nameHelpLbl = "";
            this.nameHelpTxt = "";
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.DuplicateSystemDefinitionDialog_Dialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        FormToolkit toolkit = new FormToolkit(Display.getDefault());
        toolkit.setBackground(null);
        this.setTitle(Messages.DuplicateSystemDefinitionDialog_Dialog_Title);
        this.setMessage(Messages.DuplicateSystemDefinitionDialog_Dialog_Title_Message);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Composite itemComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginTop = 8;
        itemComposite.setLayout((Layout)gridLayout);
        itemComposite.setLayoutData((Object)new GridData(1808));
        this.nameItem = this.createDialogItem(itemComposite, nameLabel, this.name);
        this.idItem = this.createDialogItem(itemComposite, idLabel, this.id);
        this.idItem.item.setTextLimit(4);
        this.nameItem.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DuplicateSystemDefinitionDialog.this.setName(((DuplicateSystemDefinitionDialog)DuplicateSystemDefinitionDialog.this).nameItem.item.getText().trim());
                DuplicateSystemDefinitionDialog.this.setItemMessage(((DuplicateSystemDefinitionDialog)DuplicateSystemDefinitionDialog.this).nameItem.deco, null);
            }
        });
        this.idItem.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DuplicateSystemDefinitionDialog.this.setId(((DuplicateSystemDefinitionDialog)DuplicateSystemDefinitionDialog.this).idItem.item.getText().trim());
                DuplicateSystemDefinitionDialog.this.setItemMessage(((DuplicateSystemDefinitionDialog)DuplicateSystemDefinitionDialog.this).idItem.deco, null);
            }
        });
        this.nameItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(DuplicateSystemDefinitionDialog.this.parentShell, 36);
                helpDialog.setText(DuplicateSystemDefinitionDialog.this.nameHelpLbl);
                helpDialog.setMessage(DuplicateSystemDefinitionDialog.this.nameHelpTxt);
                helpDialog.open();
            }
        });
        this.idItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(DuplicateSystemDefinitionDialog.this.parentShell, 36);
                helpDialog.setText(DuplicateSystemDefinitionDialog.this.idHelpLbl);
                helpDialog.setMessage(DuplicateSystemDefinitionDialog.this.idHelpTxt);
                helpDialog.open();
            }
        });
        DuplicateSystemDefinitionDialog.applyDialogFont((Control)itemComposite);
        return composite;
    }

    protected DialogTextItem createDialogItem(Composite composite, String label, String value) {
        DialogTextItem dialogItem = new DialogTextItem();
        dialogItem.label = new Label(composite, 0);
        dialogItem.label.setText(label);
        GridDataFactory.fillDefaults().hint(40, -1).applyTo((Control)dialogItem.label);
        dialogItem.item = new Text(composite, 18436);
        dialogItem.item.setText(Verification.toNonNull((String)value));
        GridDataFactory.fillDefaults().hint(400, -1).applyTo((Control)dialogItem.item);
        dialogItem.deco = new ControlDecoration((Control)dialogItem.item, 16512, composite);
        return dialogItem;
    }

    protected Point getInitialSize() {
        return new Point(this.convertHorizontalDLUsToPixels(320), this.convertVerticalDLUsToPixels(160));
    }

    protected void okPressed() {
        boolean ok = true;
        if (!Verification.isNonBlank((String)this.getName())) {
            this.setItemMessage(this.nameItem.deco, Messages.DuplicateSystemDefinitionDialog_Dialog_Validation_Required_Name);
            ok = false;
        } else {
            this.setItemMessage(this.nameItem.deco, null);
        }
        if (!Verification.isNonBlank((String)this.getId())) {
            this.setItemMessage(this.idItem.deco, Messages.DuplicateSystemDefinitionDialog_Dialog_Validation_Required_Id);
            ok = false;
        } else if (!Verification.isAlphaNumeric((String)this.getId())) {
            this.setItemMessage(this.idItem.deco, Messages.DuplicateSystemDefinitionDialog_Dialog_Validation_Alphanum_Id);
            ok = false;
        } else {
            this.setItemMessage(this.idItem.deco, null);
        }
        if (ok) {
            super.okPressed();
        }
    }

    private void setItemMessage(ControlDecoration controlDecoration, String message) {
        if (message != null) {
            controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
            controlDecoration.setDescriptionText(message);
        } else {
            controlDecoration.hide();
            controlDecoration.setImage(null);
            controlDecoration.show();
        }
    }

    public final String getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final void setName(String name) {
        this.name = name;
    }
}

