/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.dialogs;

import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import com.ibm.team.enterprise.smpe.ui.elements.DataSetDefinitionLabelProvider;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheFactory;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.SystemDefinitionSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.elements.SystemDefinitionHandleDeferredContentProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DataSetDefinitionSelectionDialog
extends SystemDefinitionSelectionDialog {
    private final ITeamRepository repository;
    private final IProjectAreaHandle projectArea;

    public DataSetDefinitionSelectionDialog(Shell parent, ITeamRepository repository, IProjectAreaHandle projectArea) throws TeamRepositoryException {
        this(parent, repository, projectArea, null, null, null, false, null);
    }

    public DataSetDefinitionSelectionDialog(Shell parent, ITeamRepository repository, IProjectAreaHandle projectArea, ViewerFilter filter, String extraHelp) throws TeamRepositoryException {
        this(parent, repository, projectArea, filter, extraHelp, null, false, null);
    }

    public DataSetDefinitionSelectionDialog(Shell parent, ITeamRepository repository, IProjectAreaHandle projectArea, ViewerFilter filter, String extraHelp, List<Integer> usages, boolean fullResolution, ISystemDefinitionCache cache) throws TeamRepositoryException {
        super(parent, repository, projectArea, IResourceDefinition.ITEM_TYPE, filter, false, (ILabelProvider)new DataSetDefinitionLabelProvider(), (ITreeContentProvider)new SystemDefinitionHandleDeferredContentProvider(repository, ISystemDefinition.Platform.zos, IResourceDefinition.ITEM_TYPE, usages, fullResolution, cache));
        this.repository = repository;
        this.projectArea = projectArea;
        this.setHelpAvailable(false);
        this.setTitle(Messages.DataSetDefinitionSelectionDialog_Title);
        if (extraHelp != null) {
            String lineSeparator = System.getProperty("line.separator", "\r");
            this.setMessage(String.valueOf(Messages.DataSetDefinitionSelectionDialog_Description) + lineSeparator + lineSeparator + extraHelp);
        } else {
            this.setMessage(Messages.DataSetDefinitionSelectionDialog_Description);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginRight = 0;
        gridLayout.marginWidth = 0;
        parent.setLayout((Layout)gridLayout);
        super.createButtonsForButtonBar(parent);
        Button refresh = new Button(parent, 0x800008);
        refresh.setImage(SmpeUIPlugin.getImage("icons/gen/refresh.gif"));
        refresh.setToolTipText(Messages.DataSetDefinitionSelectionDialog_Tooltip_Refresh);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IContentProvider contentProvider = DataSetDefinitionSelectionDialog.this.getTreeViewer().getContentProvider();
                if (contentProvider instanceof SystemDefinitionHandleDeferredContentProvider) {
                    ItemCacheFactory.clearDataset((ITeamRepository)DataSetDefinitionSelectionDialog.this.repository, (IProjectAreaHandle)DataSetDefinitionSelectionDialog.this.projectArea);
                    ItemCacheFactory.clearDatasetHandle((ITeamRepository)DataSetDefinitionSelectionDialog.this.repository, (IProjectAreaHandle)DataSetDefinitionSelectionDialog.this.projectArea);
                    ((SystemDefinitionHandleDeferredContentProvider)contentProvider).refresh();
                }
                DataSetDefinitionSelectionDialog.this.getTreeViewer().refresh();
            }
        });
    }

    protected void setTitleMessage(IItemType type) {
    }

    public IResourceDefinition getSelectedDataDefinition() {
        return (IResourceDefinition)super.getSelectedSystemDefinition();
    }

    public List<?> getSelectedDataDefinitions() {
        return Arrays.asList(super.getSelectedSystemDefinitions());
    }
}

