/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.actions;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import com.ibm.team.enterprise.smpe.ui.actions.DuplicateSystemDefinitionAction;
import com.ibm.team.enterprise.smpe.ui.editors.VersionDefinitionEditorInput;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.domain.AbstractSystemDefDomainActionHelper;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractEditorInput;
import com.ibm.team.enterprise.systemdefinition.ui.editors.actions.ArchiveSystemDefinitionAction;
import com.ibm.team.enterprise.systemdefinition.ui.editors.actions.UnArchiveSystemDefinitionAction;
import com.ibm.team.enterprise.systemdefinition.ui.node.AbstractEnterpriseExtensionsSystemDefinitionNode;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public class VersionDefinitionDomainActionHelper
extends AbstractSystemDefDomainActionHelper {
    public VersionDefinitionDomainActionHelper(IMenuManager menuManager, IStructuredSelection selection, IWorkbenchPartSite site) {
        super(menuManager, selection, site);
    }

    protected Action getNewSystemDefinitionAction(final IProjectAreaHandle projectAreaHandle, final AbstractEnterpriseExtensionsNode systemDefinition) {
        return new Action(Messages.NewVersionDefinitionWizard_Action){
            AbstractEditorInput input;
            {
                super($anonymous0);
                this.input = null;
            }

            public void run() {
                IWorkbenchPage page = VersionDefinitionDomainActionHelper.this.fPartSite.getPage();
                if (page != null) {
                    try {
                        this.input = new VersionDefinitionEditorInput(null, projectAreaHandle, systemDefinition);
                        if (this.input != null) {
                            page.openEditor((IEditorInput)this.input, this.input.getEditorId());
                        }
                    }
                    catch (PartInitException exception) {
                        SmpeUIPlugin.log(exception);
                    }
                    catch (TeamRepositoryException e) {
                        SmpeUIPlugin.log(e);
                    }
                }
            }

            public String getId() {
                return this.input != null ? this.input.getEditorId() : null;
            }
        };
    }

    protected Action getArchiveSystemDefinitionAction(IProjectAreaHandle projectAreaHandle, AbstractEnterpriseExtensionsNode systemDefinition) {
        if (systemDefinition instanceof AbstractEnterpriseExtensionsSystemDefinitionNode && !this.isSystemDefinitionArchived(this.fSelection)) {
            return new ArchiveSystemDefinitionAction(this.fPartSite, projectAreaHandle, (IStructuredSelection)new StructuredSelection((Object)systemDefinition));
        }
        return null;
    }

    protected Action getDuplicateSystemDefinitionAction(IProjectAreaHandle projectAreaHandle, AbstractEnterpriseExtensionsNode systemDefinition) {
        if (systemDefinition != null && systemDefinition instanceof AbstractEnterpriseExtensionsSystemDefinitionNode) {
            return new DuplicateSystemDefinitionAction((AbstractEnterpriseExtensionsSystemDefinitionNode)systemDefinition, this.fPartSite, projectAreaHandle);
        }
        return null;
    }

    protected Action getRestoreSystemDefinitionAction(IProjectAreaHandle projectAreaHandle, AbstractEnterpriseExtensionsNode systemDefinition) {
        if (systemDefinition instanceof AbstractEnterpriseExtensionsSystemDefinitionNode && !this.isSystemDefinitionUnArchived(this.fSelection)) {
            return new UnArchiveSystemDefinitionAction(this.fPartSite, projectAreaHandle, (IStructuredSelection)new StructuredSelection((Object)systemDefinition));
        }
        return null;
    }

    private boolean isSystemDefinitionArchived(IStructuredSelection selection) {
        boolean result = true;
        if (selection.size() > 0) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext() && result) {
                Object object = iterator.next();
                if (object instanceof AbstractEnterpriseExtensionsSystemDefinitionNode) {
                    ISystemDefinition systemDefinition = ((AbstractEnterpriseExtensionsSystemDefinitionNode)object).getSystemDefinition();
                    if (systemDefinition.isArchived()) continue;
                    result = false;
                    continue;
                }
                result = false;
            }
        }
        return result;
    }

    private boolean isSystemDefinitionUnArchived(IStructuredSelection selection) {
        boolean result = true;
        if (selection.size() > 0) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext() && result) {
                Object object = iterator.next();
                if (object instanceof AbstractEnterpriseExtensionsSystemDefinitionNode) {
                    ISystemDefinition systemDefinition = ((AbstractEnterpriseExtensionsSystemDefinitionNode)object).getSystemDefinition();
                    if (!systemDefinition.isArchived()) continue;
                    result = false;
                    continue;
                }
                result = false;
            }
        }
        return result;
    }
}

