/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.actions;

import com.ibm.team.enterprise.smpe.ui.SmpeUIPlugin;
import com.ibm.team.enterprise.smpe.ui.editors.SystemDefinitionEditorInputFactory;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractEditorInput;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionDelegate;

public class EditSystemDefinitionActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private IStructuredSelection selection;
    private IWorkbenchPart targetPart;

    public void run(IAction action) {
        if (this.selection.getFirstElement() instanceof ISystemDefinition) {
            ISystemDefinition systemDefinition = (ISystemDefinition)this.selection.getFirstElement();
            EditSystemDefinitionActionDelegate.run(systemDefinition, this.targetPart.getSite().getPage());
        }
    }

    public static void run(ISystemDefinition systemDefinition, IWorkbenchPage workbenchPage) {
        EditSystemDefinitionActionDelegate.run(systemDefinition, null, null, workbenchPage, false);
    }

    public static void run(final ISystemDefinition systemDefinition, final IProjectAreaHandle projectAreaHandle, final IWorkbenchPage workbenchPage, final boolean isLatest) {
        Job job = new Job(Messages.EditSystemDefinitionActionDelegate_Label_Job){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("", 2);
                try {
                    IProjectAreaHandle itemHandle = null;
                    if (projectAreaHandle == null) {
                        String projectAreaUUID = systemDefinition.getProjectArea().getItemId().getUuidValue();
                        itemHandle = IProjectArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)projectAreaUUID), null);
                    } else {
                        itemHandle = projectAreaHandle;
                    }
                    if (systemDefinition != null) {
                        AbstractEditorInput input = null;
                        try {
                            input = SystemDefinitionEditorInputFactory.getSystemDefinitionEditorInput(systemDefinition, itemHandle);
                        }
                        catch (TeamRepositoryException e) {
                            SmpeUIPlugin.log(e);
                            Status status = new Status(4, SmpeUIPlugin.getUniqueIdentifier(), Messages.EditSystemDefinitionActionDelegate_Error_ProjectArea, (Throwable)e);
                            monitor.done();
                            return status;
                        }
                        final AbstractEditorInput localInput = input;
                        localInput.setLatest(isLatest);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    workbenchPage.openEditor((IEditorInput)localInput, localInput.getEditorId());
                                }
                                catch (PartInitException exception) {
                                    SmpeUIPlugin.log(exception);
                                }
                            }
                        });
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public static void run(final ISystemDefinition systemDefinitionHandle, final IProjectAreaHandle projectAreaHandle, ITeamRepository repository, final IWorkbenchPage workbenchPage, final boolean isFullyResolved) {
        Job job = new Job(Messages.EditSystemDefinitionActionDelegate_Label_Job){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus iStatus;
                monitor.beginTask("", 2);
                ISystemDefinition systemDefinition = null;
                try {
                    SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    if (systemDefinitionHandle instanceof IFunctionDefinition || systemDefinitionHandle instanceof IVersionDefinition) {
                        if (!isFullyResolved) {
                            ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)((ITeamRepository)systemDefinitionHandle.getOrigin()));
                            systemDefinition = client.findSystemDefinitionComplete(systemDefinitionHandle.getItemId().getUuidValue(), null, systemDefinitionHandle.getItemType(), (IProgressMonitor)sm.newChild(80));
                        } else {
                            systemDefinition = systemDefinitionHandle;
                        }
                    }
                    iStatus = Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    Status status;
                    try {
                        SmpeUIPlugin.log(e);
                        status = new Status(4, SmpeUIPlugin.getUniqueIdentifier(), Messages.EditSystemDefinitionActionDelegate_Error_SystemDefinition, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        EditSystemDefinitionActionDelegate.run(systemDefinition, projectAreaHandle, workbenchPage, true);
                        monitor.done();
                        throw throwable;
                    }
                    EditSystemDefinitionActionDelegate.run(systemDefinition, projectAreaHandle, workbenchPage, true);
                    monitor.done();
                    return status;
                }
                EditSystemDefinitionActionDelegate.run(systemDefinition, projectAreaHandle, workbenchPage, true);
                monitor.done();
                return iStatus;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }
}

