/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.ui.actions;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainContentProvider;
import com.ibm.team.enterprise.smpe.ui.domain.FunctionDefinitionNodeEE;
import com.ibm.team.enterprise.smpe.ui.domain.FunctionDefinitionsNodeEE;
import com.ibm.team.enterprise.smpe.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheFactory;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.editors.actions.AbstractDeleteSystemDefinitionActionDelegate;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteSystemDefinitionActionDelegate
extends AbstractDeleteSystemDefinitionActionDelegate
implements IObjectActionDelegate {
    private ISelection selection;
    private IStructuredSelection nodeSelection;
    private final ITeamRepository teamRepository;

    public DeleteSystemDefinitionActionDelegate(ITeamRepository teamRepository) {
        this.teamRepository = teamRepository;
    }

    protected String getConfirmationMessage() {
        return Messages.DeleteSystemDefinitionActionDelegate_Confirm_Delete;
    }

    protected String getJobLabel() {
        return Messages.DeleteSystemDefinitionActionDelegate_Label_Job;
    }

    protected void performAction(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ArrayList<ISystemDefinition> selectedSystemDefinitions = new ArrayList<ISystemDefinition>();
        IStructuredSelection selection = (IStructuredSelection)this.selection;
        for (Object element : selection) {
            if (!(element instanceof ISystemDefinition)) continue;
            selectedSystemDefinitions.add((ISystemDefinition)element);
        }
        this.removeSystemDefinitions(selectedSystemDefinitions, progressMonitor);
    }

    private void removeSystemDefinitions(List<ISystemDefinition> systemDefinitions, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        progressMonitor.beginTask(Messages.DeleteSystemDefinitionActionDelegate_Label_Job, systemDefinitions.size());
        try {
            ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.teamRepository);
            for (ISystemDefinition systemDefinition : systemDefinitions) {
                try {
                    if (systemDefinition instanceof IFunctionDefinitionHandle) {
                        FunctionDefinitionNodeEE functionDefinitionNode;
                        FunctionDefinitionsNodeEE functionDefinitionsNode;
                        client.deleteSystemDefinition((ISystemDefinitionHandle)systemDefinition, progressMonitor);
                        if (this.nodeSelection.getFirstElement() instanceof FunctionDefinitionNodeEE && (functionDefinitionsNode = (FunctionDefinitionsNodeEE)(functionDefinitionNode = (FunctionDefinitionNodeEE)((Object)this.nodeSelection.getFirstElement())).getParent()) != null) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ((EnterpriseExtensionsDomainContentProvider)functionDefinitionsNode.getDomain().getContentProvider()).updateTreeViewer((AbstractEnterpriseExtensionsNode)functionDefinitionsNode);
                                }
                            });
                        }
                        if (ItemCacheFactory.containsFunction((ITeamRepository)this.teamRepository, (IProjectAreaHandle)systemDefinition.getProjectArea())) {
                            ItemCacheFactory.deleteFunction((ITeamRepository)this.teamRepository, (IProjectAreaHandle)systemDefinition.getProjectArea());
                        }
                    }
                    if (!(systemDefinition instanceof IVersionDefinitionHandle)) continue;
                    client.deleteSystemDefinition((ISystemDefinitionHandle)systemDefinition, progressMonitor);
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    // empty catch block
                }
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void setNodeSelection(IStructuredSelection selection) {
        super.setNodeSelection(selection);
        this.nodeSelection = selection;
    }
}

